package bodybuilder.viewer;

import java.util.Iterator;
import java.util.Map;

import bodybuilder.util.ObjectUtils;
import bodybuilder.viewer.handler.OutputHandler;

/**
 * マップビューア
 */
public class MapViewer extends Viewer {

    /**
     * マップの内容を出力する。
     * 
     * @param object マップ
     * @param handler 出力ハンドラ
     */
    public void output(Object object, OutputHandler handler) {
        // マップにキャスト。
        Map map = (Map) object;
        handler.print(ObjectUtils.getInfo(object) + " {");
        handler.indent();

        Iterator keys = map.keySet().iterator();

        // マップの要素を出力。
        while (keys.hasNext()) {
            String key = (String) keys.next();
            handler.print("[\"" + key + "\"]=>");
            dump(map.get(key), handler);
        }

        handler.unindent();
        handler.print("}");
    }

}