/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

#pragma once

#include "resource.h"

#include "BonDecoder_i.h"

class CTsPacketParser;
class CTsDescrambler;
class PacketSink;

//////////////////////////////////////////////////////////////
// CBonDecoder

class ATL_NO_VTABLE CBonDecoder :
	public ATL::CComObjectRootEx<ATL::CComMultiThreadModel>,
	public ATL::CComCoClass<CBonDecoder, &CLSID_BonDecoder>,
	public ATL::IDispatchImpl<IBonDecoder, &IID_IBonDecoder, &LIBID_BonDecoderLib, /*wMajor =*/ 1, /*wMinor =*/ 0>,
	public ATL::IProvideClassInfo2Impl<&CLSID_BonDecoder, &IID_IBonDecoder, &LIBID_BonDecoderLib, /*wMajor =*/ 1, /*wMinor =*/ 0>,
	public ATL::ISupportErrorInfoImpl<&IID_IBonDecoder>,
	public IRawBonDecoder
{
private:
	_CritSec cs_;

	_bstr_t winSCardPath_;
	bool emmProcess_;
	USHORT serviceID_;
	bool patGeneration_;
	USHORT transportStreamID_;

	CTsPacketParser *pPacketParser_;
	CTsDescrambler *pDescrambler_;
	PacketSink *pPacketSink_;

public:
	CBonDecoder();

	DECLARE_REGISTRY_RESOURCEID(IDR_BONDECODER)

	BEGIN_COM_MAP(CBonDecoder)
		COM_INTERFACE_ENTRY(IBonDecoder)
		COM_INTERFACE_ENTRY(IRawBonDecoder)
		COM_INTERFACE_ENTRY(IDispatch)
		COM_INTERFACE_ENTRY(IProvideClassInfo)
		COM_INTERFACE_ENTRY(IProvideClassInfo2)
		COM_INTERFACE_ENTRY(ISupportErrorInfo)
	END_COM_MAP()

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct();
	void FinalRelease();

	virtual HRESULT STDMETHODCALLTYPE InterfaceSupportsErrorInfo(REFIID riid);

public:
	virtual HRESULT STDMETHODCALLTYPE get_WinSCardPath(BSTR *pVal);
	virtual HRESULT STDMETHODCALLTYPE put_WinSCardPath(BSTR newVal);
	virtual HRESULT STDMETHODCALLTYPE get_EMMProcess(VARIANT_BOOL *pVal);
	virtual HRESULT STDMETHODCALLTYPE put_EMMProcess(VARIANT_BOOL newVal);
	virtual HRESULT STDMETHODCALLTYPE get_ServiceID(USHORT *pVal);
	virtual HRESULT STDMETHODCALLTYPE put_ServiceID(USHORT newVal);
	virtual HRESULT STDMETHODCALLTYPE get_PATGeneration(VARIANT_BOOL *pVal);
	virtual HRESULT STDMETHODCALLTYPE put_PATGeneration(VARIANT_BOOL newVal);
	virtual HRESULT STDMETHODCALLTYPE get_TransportStreamID(USHORT *pVal);
	virtual HRESULT STDMETHODCALLTYPE put_TransportStreamID(USHORT newVal);

	virtual HRESULT STDMETHODCALLTYPE get_Running(VARIANT_BOOL *pVal);
	virtual HRESULT STDMETHODCALLTYPE get_UsingInstruction(UsingInstructions *pVal);
	virtual HRESULT STDMETHODCALLTYPE get_CardID(ULONGLONG* pVal);
	virtual HRESULT STDMETHODCALLTYPE get_CardType(CardTypes* pVal);
	virtual HRESULT STDMETHODCALLTYPE get_CardManufacturerID(UCHAR* pVal);
	virtual HRESULT STDMETHODCALLTYPE get_CardVersion(UCHAR* pVal);
	virtual HRESULT STDMETHODCALLTYPE get_CardReaderName(BSTR* pVal);
	virtual HRESULT STDMETHODCALLTYPE GetEcmPIDByServiceID(USHORT serviceID, USHORT* pVal);

	virtual HRESULT STDMETHODCALLTYPE Start();
	virtual HRESULT STDMETHODCALLTYPE Decode(VARIANT sourceData, ULONG maxResultSize, VARIANT *pRetVal);
	virtual HRESULT STDMETHODCALLTYPE Decode(SAFEARRAY *pSourceData, ULONG maxResultSize, SAFEARRAY **ppRetVal);
	virtual HRESULT STDMETHODCALLTYPE DecodeDirect(
		ULONG sourceSize, UCHAR *pSourceData,
		ULONG maxResultSize, ULONG *pResultSize, UCHAR *pResultData);
	virtual HRESULT STDMETHODCALLTYPE Finish(ULONG maxResultSize, VARIANT *pRetVal);
	virtual HRESULT STDMETHODCALLTYPE Finish(ULONG maxResultSize, SAFEARRAY **ppRetVal);
	virtual HRESULT STDMETHODCALLTYPE FinishDirect(
		ULONG maxResultSize, ULONG *pResultSize, UCHAR *pResultData);
	virtual HRESULT STDMETHODCALLTYPE Flush();
	virtual HRESULT STDMETHODCALLTYPE Reset();
};

OBJECT_ENTRY_AUTO(__uuidof(BonDecoder), CBonDecoder)
