// TsPacketParser.cpp: CTsPacketParser NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "TsPacketParser.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


#define TS_HEADSYNCBYTE		(0x47U)


//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////


CTsPacketParser::CTsPacketParser(IEventHandler *pEventHandler)
	: CMediaDecoder(pEventHandler, 1UL, 1UL)
	, m_bOutputNullPacket(false)
	, m_InputPacketCount(0)
	, m_OutputPacketCount(0)
	, m_ErrorPacketCount(0)
	, m_ContinuityErrorPacketCount(0)
#ifdef BONTSENGINE_1SEG_SUPPORT
	, m_bGeneratePAT(true)
#endif
{
	// pPbgAJE^
	::FillMemory(m_abyContCounter, sizeof(m_abyContCounter), 0x10UL);
}

CTsPacketParser::~CTsPacketParser()
{
}

void CTsPacketParser::Reset(void)
{
	CBlockLock Lock(&m_DecoderLock);

	// pPbgJE^NA
	m_InputPacketCount = 0;
	m_OutputPacketCount = 0;
	m_ErrorPacketCount = 0;
	m_ContinuityErrorPacketCount = 0;

	// pPbgAJE^
	::FillMemory(m_abyContCounter, sizeof(m_abyContCounter), 0x10UL);

	// ԂZbg
	m_TsPacket.ClearSize();

#ifdef BONTSENGINE_1SEG_SUPPORT
	m_PATGenerator.Reset();
#endif
}

const bool CTsPacketParser::InputMedia(CMediaData *pMediaData, const DWORD dwInputIndex)
{
	CBlockLock Lock(&m_DecoderLock);

	/*
	if (dwInputIndex >= GetInputNum())
		return false;
	*/

	// TSpPbg
	SyncPacket(pMediaData->GetData(), pMediaData->GetSize());

	return true;
}

void CTsPacketParser::SetOutputNullPacket(const bool bEnable)
{
	// NULLpPbg̏o͗Lݒ肷
	m_bOutputNullPacket = bEnable;
}

const DWORD CTsPacketParser::GetInputPacketCount(void) const
{
	// ̓pPbgԂ
	return (DWORD)m_InputPacketCount;
}

const DWORD CTsPacketParser::GetOutputPacketCount(void) const
{
	// o̓pPbgԂ
	return (DWORD)m_OutputPacketCount;
}

const DWORD CTsPacketParser::GetErrorPacketCount(void) const
{
	// G[pPbgԂ
	return (DWORD)m_ErrorPacketCount;
}

const DWORD CTsPacketParser::GetContinuityErrorPacketCount(void) const
{
	// AG[pPbgԂ
	return (DWORD)m_ContinuityErrorPacketCount;
}

void CTsPacketParser::ResetErrorPacketCount(void)
{
	m_ErrorPacketCount=0;
	m_ContinuityErrorPacketCount=0;
}

void inline CTsPacketParser::SyncPacket(const BYTE *pData, const DWORD dwSize)
{
	// ̕@͊Sł͂ȂAꂽꍇɑOĂяõf[^܂ł̂ڂĂ͍ē͂łȂ
	DWORD dwCurSize;
	DWORD dwCurPos = 0UL;

	while (dwCurPos < dwSize) {
		dwCurSize = m_TsPacket.GetSize();

		if (dwCurSize==0) {
			// oCg҂
			do {
				if (pData[dwCurPos++] == TS_HEADSYNCBYTE) {
					// oCg
					m_TsPacket.AddByte(TS_HEADSYNCBYTE);
					break;
				}
			} while (dwCurPos < dwSize);
		} else if (dwCurSize == TS_PACKETSIZE) {
			// pPbgTCYf[^

			if (pData[dwCurPos] == TS_HEADSYNCBYTE) {
				// ̃f[^͓oCg
				ParsePacket();
			} else {
				// G[
				m_TsPacket.ClearSize();

				// ʒuɖ߂
				if (dwCurPos >= (TS_PACKETSIZE - 1UL))
					dwCurPos -= (TS_PACKETSIZE - 1UL);
				else
					dwCurPos = 0UL;
			}
		} else {
			// f[^҂
			DWORD dwRemain = (TS_PACKETSIZE - dwCurSize);
			if ((dwSize - dwCurPos) >= dwRemain) {
				m_TsPacket.AddData(&pData[dwCurPos], dwRemain);
				dwCurPos += dwRemain;
			} else {
				m_TsPacket.AddData(&pData[dwCurPos], dwSize - dwCurPos);
				break;
			}
		}
	}
}

bool inline CTsPacketParser::ParsePacket(void)
{
	bool bOK;

	// ̓JEgCNg
	m_InputPacketCount++;

	// pPbg/`FbN
	switch (m_TsPacket.ParsePacket(m_abyContCounter)) {
	case CTsPacket::EC_CONTINUITY:
		m_ContinuityErrorPacketCount++;
	case CTsPacket::EC_VALID:
		{
#ifdef BONTSENGINE_1SEG_SUPPORT
			/*
			// PAT ̖ԂV~[g
			if (m_TsPacket.GetPID() == 0) {
				bOK = true;
				break;
			}
			*/
			if (m_PATGenerator.StorePacket(&m_TsPacket) && m_bGeneratePAT) {
				if (m_PATGenerator.GetPAT(&m_PATPacket)) {
					OutputMedia(&m_PATPacket);
				}
			}
#endif

			// ̃fR[_Ƀf[^n
			if (m_bOutputNullPacket || m_TsPacket.GetPID() != 0x1FFFU) {
				// o̓JEgCNg
				OutputMedia(&m_TsPacket);

				m_OutputPacketCount++;
			}
		}
		bOK=true;
		break;
	case CTsPacket::EC_FORMAT:
	case CTsPacket::EC_TRANSPORT:
		// G[JEgCNg
		m_ErrorPacketCount++;
		bOK=false;
		break;
	}

	// TCYNÃXgAɔ
	m_TsPacket.ClearSize();

	return bOK;
}


#ifdef BONTSENGINE_1SEG_SUPPORT

bool CTsPacketParser::EnablePATGeneration(bool bEnable)
{
	m_bGeneratePAT = bEnable;
	return true;
}


bool CTsPacketParser::SetTransportStreamID(WORD TransportStreamID)
{
	return m_PATGenerator.SetTransportStreamID(TransportStreamID);
}

#endif
