/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 * http://www.gnu.org/copyleft/gpl.html
 */

#pragma once

#include "MediaDecoder.h"

//////////////////////////////////////////////////////////////
// PacketSink

class PacketSink : public CMediaDecoder
{
private:
	struct Data
	{
		CMediaData *pMediaData_;
		ULONG position_;
	};

	ATL::CAtlList<Data> bufferList_;

public:
	PacketSink()
	{
	}

	virtual ~PacketSink()
	{
		while (bufferList_.GetCount() >= 1)
		{
			Data data = bufferList_.RemoveHead();
			delete data.pMediaData_;
		}
	}

	virtual void Reset()
	{
		while (bufferList_.GetCount() >= 1)
		{
			Data data = bufferList_.RemoveHead();
			delete data.pMediaData_;
		}
	}

	virtual const bool InputMedia(CMediaData *pMediaData, const DWORD dwInputIndex)
	{
		assert(pMediaData != 0);
		assert(dwInputIndex == 0);

		Data data;
		data.pMediaData_ = new CMediaData(*pMediaData);
		data.position_ = 0;
		bufferList_.AddTail(data);

		return true;
	}

	bool Empty() const throw()
	{
		return bufferList_.GetCount() == 0;
	}

	ULONG Dequeue(UCHAR *pBuffer, const ULONG maxSize)
	{
		ULONG total = 0, remains = maxSize;

		while ((remains >= 1) && (bufferList_.GetCount() >= 1))
		{
			Data &data = bufferList_.GetHead();
			ULONG size = data.pMediaData_->GetSize() - data.position_;
			size = min(size, remains);
			memcpy(pBuffer + total, data.pMediaData_->GetData() + data.position_, size);

			data.position_ += size;
			if (data.position_ >= data.pMediaData_->GetSize())
			{
				delete data.pMediaData_;
				bufferList_.RemoveHeadNoReturn();
			}

			total += size;
			remains -= size;
		}

		return total;
	}
};
