/*
 * Decompiled with CFR 0.152.
 */
package org.tonouchi.bookshelf2;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.tonouchi.bookshelf2.Book;
import org.tonouchi.bookshelf2.BookDataHolderHolder;
import org.tonouchi.bookshelf2.BookShelfConfig;
import org.tonouchi.bookshelf2.BookShelfLibrary;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BookImporter {
    public static void importBook(File baseDirectory) {
        if (!baseDirectory.isDirectory()) {
            System.out.println("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u307f\u4f7f\u7528\u53ef\u80fd\u3067\u3059");
            return;
        }
        if (BookImporter.isV1Directory(baseDirectory)) {
            BookImporter.importV1Directory(baseDirectory);
        } else {
            BookImporter.importPlaneDirectory(baseDirectory);
        }
    }

    private static boolean isV1Directory(File baseDirectory) {
        String infoXML = baseDirectory.getAbsolutePath() + "/info/information.xml";
        String pageDir = baseDirectory.getAbsolutePath() + "/pages";
        File infoXMLFile = new File(infoXML);
        File pageDirFile = new File(pageDir);
        return infoXMLFile.exists() && pageDirFile.exists();
    }

    private static void importV1Directory(File baseDirectory) {
        String infoXML = baseDirectory.getAbsolutePath() + "/info/information.xml";
        String pageDir = baseDirectory.getAbsolutePath() + "/pages";
        File infoXMLFile = new File(infoXML);
        File pageDirFile = new File(pageDir);
        Book book = BookImporter.readBookV1(infoXMLFile);
        File[] files = pageDirFile.listFiles();
        BookImporter.makeBook(book, files);
    }

    private static Book readBookV1(File xml) {
        Book book = new Book();
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xml);
            NodeList nodeList = document.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node hon = nodeList.item(i);
                if (!hon.getNodeName().equals("hon")) continue;
                NodeList v1Props = hon.getChildNodes();
                for (int j = 0; j < v1Props.getLength(); ++j) {
                    Node prop = v1Props.item(j);
                    if (prop.getNodeName().equals("name")) {
                        book.setTitle(prop.getTextContent());
                        continue;
                    }
                    if (prop.getNodeName().equals("author")) {
                        book.setAuthor(prop.getTextContent());
                        continue;
                    }
                    if (!prop.getNodeName().equals("genre")) continue;
                    book.setCategory(prop.getTextContent());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (book.getCategory() == null || book.getCategory().length() == 0) {
            book.setCategory("\u4e0d\u660e" + new DecimalFormat("00").format(Math.random() * 50.0));
        }
        if (book.getAuthor() == null || book.getAuthor().length() == 0) {
            book.setAuthor("\u4e0d\u660e" + new DecimalFormat("00").format(Math.random() * 50.0));
        }
        if (book.getTitle() == null || book.getTitle().length() == 0) {
            book.setTitle("\u4e0d\u660e" + new DecimalFormat("00").format(Math.random() * 50.0));
        }
        book.setComment("");
        book.setId(UUID.randomUUID().toString());
        book.setRate(1);
        book.setTags(new ArrayList<String>());
        return book;
    }

    private static void makeBook(Book book, File[] files) {
        try {
            String targetFile;
            String targetDir = BookShelfConfig.getBaseDirectory() + "/books/" + book.getCategory() + "/" + book.getAuthor();
            File file = new File(targetDir);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (new File(targetFile = targetDir + "/" + book.getTitle() + ".zip").exists()) {
                targetFile = targetDir + "/" + book.getTitle() + UUID.randomUUID().toString() + ".zip";
            }
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(targetFile));
            BufferedOutputStream bos = new BufferedOutputStream(zos);
            Document bookDocument = BookImporter.toBookDocument(book);
            ZipEntry zipEntry = new ZipEntry("info/bookinfo.xml");
            zos.putNextEntry(zipEntry);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(bookDocument), new StreamResult(zos));
            int ctr = 0;
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return o1.getAbsolutePath().compareTo(o2.getAbsolutePath());
                }
            });
            for (int i = 0; i < files.length; ++i) {
                try {
                    BufferedImage image = ImageIO.read(files[i]);
                    if (image != null) {
                        ZipEntry entry = new ZipEntry("pages/" + new DecimalFormat("00000").format(ctr) + ".jpg");
                        zos.putNextEntry(entry);
                        ImageIO.write((RenderedImage)image, "JPG", bos);
                        ++ctr;
                    }
                    if (i % 20 != 0) continue;
                    System.out.println(files.length + "\u4e2d" + i + "\u679a\u5b8c\u4e86");
                    continue;
                }
                catch (Exception ex) {
                    System.out.println(files[i].getAbsolutePath() + "\u8aad\u307f\u8fbc\u307f\u5931\u6557 \uff1a " + ex.getMessage());
                }
            }
            bos.close();
            book.setPageNum(ctr);
            book.setFilePath(targetFile);
            BookDataHolderHolder.getBookDataHolder().addBook(book);
            BookShelfLibrary.write();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static Document toBookDocument(Book book) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element bookElement = document.createElement("book");
            Element authorElement = document.createElement("author");
            Element categoryElement = document.createElement("category");
            Element outlineelement = document.createElement("outline");
            Element rateElement = document.createElement("rate");
            Element titleElement = document.createElement("title");
            Element tagsElement = document.createElement("tags");
            bookElement.setAttribute("id", book.getId());
            authorElement.setTextContent(book.getAuthor());
            categoryElement.setTextContent(book.getCategory());
            outlineelement.setTextContent(book.getComment());
            rateElement.setTextContent(Integer.toString(book.getRate()));
            titleElement.setTextContent(book.getTitle());
            List<String> tags = book.getTags();
            for (String tag : tags) {
                Element tagElement = document.createElement("tag");
                tagElement.setTextContent(tag);
                tagsElement.appendChild(tagElement);
            }
            document.appendChild(bookElement);
            bookElement.appendChild(authorElement);
            bookElement.appendChild(categoryElement);
            bookElement.appendChild(outlineelement);
            bookElement.appendChild(rateElement);
            bookElement.appendChild(titleElement);
            bookElement.appendChild(tagsElement);
            return document;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static void importPlaneDirectory(File baseDirectory) {
        Book book = new Book();
        book.setTitle(baseDirectory.getName());
        book.setAuthor("\u4e0d\u660e" + (int)(Math.random() * 50.0));
        book.setCategory("\u4e0d\u660e" + (int)(Math.random() * 50.0));
        book.setComment("");
        book.setId(UUID.randomUUID().toString());
        book.setRate(1);
        book.setTags(new ArrayList<String>());
        BookImporter.makeBook(book, baseDirectory.listFiles());
    }
}

