/*
 * Decompiled with CFR 0.152.
 */
package org.tonouchi.bookshelf2;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class SlideShowPanel
extends JPanel {
    private int previousWidth = 0;
    private int previousHeight = 0;
    private Image imageToShow = null;
    private ZipFile zipFile = null;
    private List<ZipEntry> zipEntries = null;
    private BufferedImage image = null;
    int currentIndex = 0;

    public SlideShowPanel(String filePath) {
        this.setDoubleBuffered(true);
        this.setOpaque(false);
        try {
            this.zipFile = new ZipFile(filePath);
            this.zipEntries = new ArrayList<ZipEntry>();
            Enumeration<? extends ZipEntry> entryEnum = this.zipFile.entries();
            while (entryEnum.hasMoreElements()) {
                ZipEntry entry = entryEnum.nextElement();
                if (!entry.getName().startsWith("pages/")) continue;
                this.zipEntries.add(entry);
            }
            this.top();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public final void top() {
        this.currentIndex = 0;
        this.readImage();
        this.repaint();
    }

    public final void last() {
        this.currentIndex = this.zipEntries.size() - 1;
        this.readImage();
        this.repaint();
    }

    public final void forward() {
        ++this.currentIndex;
        if (this.currentIndex >= this.zipEntries.size()) {
            this.currentIndex = 0;
        }
        this.readImage();
        this.repaint();
    }

    public final void rewind() {
        --this.currentIndex;
        if (this.currentIndex < 0) {
            this.currentIndex = this.zipEntries.size() - 1;
        }
        this.readImage();
        this.repaint();
    }

    private void readImage() {
        ZipEntry entry = this.zipEntries.get(this.currentIndex);
        try {
            InputStream inputStream = this.zipFile.getInputStream(entry);
            this.image = ImageIO.read(inputStream);
            this.repaint();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void paint(Graphics g) {
        if (this.image != null) {
            double yRate;
            double rate;
            double xRate = (double)this.getWidth() / (double)this.image.getWidth();
            double d = rate = xRate < (yRate = (double)this.getHeight() / (double)this.image.getHeight()) ? xRate : yRate;
            if (rate > 3.0) {
                rate = 3.0;
            }
            int newImageWidth = (int)((double)this.image.getWidth() * rate);
            int newImageHeoght = (int)((double)this.image.getHeight() * rate);
            if (newImageWidth != this.previousWidth || newImageHeoght != this.previousHeight) {
                this.imageToShow = this.image.getScaledInstance(newImageWidth, newImageHeoght, 4);
            }
            int posX = (this.getWidth() - newImageWidth) / 2;
            int posY = (this.getHeight() - newImageHeoght) / 2;
            posX = posX < 0 ? 0 : posX;
            posY = posY < 0 ? 0 : posY;
            this.getGraphics().clearRect(0, 0, this.getWidth(), this.getHeight());
            this.getGraphics().drawImage(this.imageToShow, posX, posY, this);
            this.previousHeight = newImageHeoght;
            this.previousWidth = newImageWidth;
        }
    }
}

