using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Text.RegularExpressions;

namespace FavoriteManage
{
	public partial class EditDialog : Form
	{

		public EditDialog()
		{
			InitializeComponent();
		}



		public string UrlText
		{
			get { return this.txtUrl.Text; }
			set { this.txtUrl.Text = value; }
		}
		public string TitleText
		{
			get { return this.txtTitle.Text; }
			set { this.txtTitle.Text = value; }
		}
		public string CommentText
		{
			get { return this.txtComment.Text; }
			set { this.txtComment.Text = value; }
		}


		public bool IsForFolder
		{
			get { return !this.txtUrl.Enabled; }
			set { this.txtUrl.Enabled = !value; }
		}

		#region Accept 

		private void accept_Dialog()
		{
			if(this.txtTitle.Text.Length > 0)
			{
				if((!this.txtUrl.Enabled) || this.txtUrl.Text.Length > 0)
				{
					this.DialogResult = DialogResult.OK;
				}
				else
				{
					MessageBox.Show("URLɂ邱Ƃ͂ł܂");
				}
			}
			else
			{
				MessageBox.Show("^Cgɂ邱Ƃ͂ł܂");
			}
		}

		private void btnOK_Click(object sender, EventArgs e)
		{
			this.accept_Dialog();
		}

		private void Accept_on_EnterKeyDown(object sender, KeyEventArgs e)
		{
			if(e.KeyCode == Keys.Enter)
			{
				this.accept_Dialog();
			}
		}

		#endregion


	}
}