using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;

namespace Browser.Boon.Net
{
	/// <summary>
	/// Urlmon.dll ̃C|[gƁA상\bh̃NXłB
	/// </summary>
	public class Urlmon
	{
		[DllImport("urlmon.dll", CharSet = CharSet.Ansi)]
		private static extern int UrlMkSetSessionOption(int dwOption, IntPtr pIpi, int nLength, int dwReserved);


		public static int InternetOptionProxy(InternetOpenType nOpenType)
		{
			return InternetOptionProxy(nOpenType, "", "");
		}

		public static int InternetOptionProxy(InternetOpenType nOpenType, string proxy, string proxyBypass)
		{
			const int INTERNET_OPTION_PROXY = 38;
			INTERNET_PROXY_INFO ipi;
			ipi.dwAccessType = nOpenType;
			ipi.proxy = Marshal.StringToHGlobalAnsi(proxy);
			ipi.proxyBypass = Marshal.StringToHGlobalAnsi(proxyBypass);
			IntPtr pStruct = Marshal.AllocCoTaskMem(Marshal.SizeOf(ipi));
			Marshal.StructureToPtr(ipi, pStruct, true);
			int r = UrlMkSetSessionOption(INTERNET_OPTION_PROXY, pStruct, Marshal.SizeOf(ipi), 0);
			Marshal.FreeCoTaskMem(pStruct);
			Marshal.FreeHGlobal(ipi.proxy);
			Marshal.FreeHGlobal(ipi.proxyBypass);
			return r;
		}
	}


	public enum InternetOpenType : int
	{
		/// <summary>
		/// WXggp܂
		/// </summary>
		INTERNET_OPEN_TYPE_PRECONFIG = 0,	// use registry configuration
		/// <summary>
		/// vLVgp܂
		/// </summary>
		INTERNET_OPEN_TYPE_DIRECT = 1,		// direct to net
		/// <summary>
		/// w肵vLVgp܂
		/// </summary>
		INTERNET_OPEN_TYPE_PROXY = 3,		// via named proxy

		INTERNET_OPEN_TYPE_PRECONFIG_WITH_NO_AUTOPROXY = 4,	// prevent using java/script/INS
	}

	public struct INTERNET_PROXY_INFO
	{
		public InternetOpenType dwAccessType;
		public IntPtr proxy;
		public IntPtr proxyBypass;
	}
}
