# $Id: bos_user.rb,v 1.11 2005/03/04 01:14:44 nisi Exp $

require 'digest/md5'

class BosUser
	include BOS::PropMethods
	
	Table_name = "bos_#{BOS::Prop[:site_name]}_users"
	
	def initialize(user_id)
		@mydb = BOS::MySQLo
		@mydo = BOS::Rdb
		setup if Prop[:sitesetup] && !@mydb.list_tables.include?(Table_name)
		if user_id && user_id != "" then
			@prop = @mydo.exp({
				:command => "s",
				:target  => Table_name,
				:cols    => set_default,
				:where   => w("user_id"){|a| a == user_id } })[0]
		end
		if !@prop then
			@prop = set_default
			@newflg = true
		else
			@newflg = false
		end
		@address = BosAddress.new(@prop[:address]) if @prop[:address]
	end

	def setup
		@mydb.query("CREATE TABLE #{Table_name}(" +
			"user_id VARCHAR(20) NOT NULL PRIMARY KEY," +
			"password VARCHAR(32) NOT NULL ," +
			"mail_address VARCHAR(255)," +
			"sex CHAR(1)," +
			"birth DATE," +
			"address INT," +
			"user_level CHAR(1) NOT NULL ," +
			"created DATETIME NOT NULL ," +
			"last_login DATETIME NOT NULL ," +
			"login_count INT NOT NULL );")
		
		su = set_default
		su[:user_id]      = BOS::Prop[:user_name]
		su[:password]     = cmd5(BOS::Prop[:user_address])
		su[:mail_address] = BOS::Prop[:user_address]
		su[:user_level]   = 'a'
		@mydo.exp({
			:command => "i",
			:target  => Table_name,
			:cols    => su })
	end
	
	def login(pw)
		return false unless @prop
		if @prop[:password] == cmd5(pw) then
			BOS::Session['uid'] = @prop[:user_id]
			@prop[:last_login] = DateTime.now
			@prop[:login_count] += 1
			@mydo.exp({
				:command => "u",
				:target  => Table_name,
				:cols    => @prop,
				:where   => w("user_id"){|a| a == @prop[:user_id] } })
		end
		@prop[:user_id]
	end
	
	def logout
		BOS::Session['uid'] = nil
		@prop = set_default
	end
	
	def ==(b)
		case b
		when BosUser
			@prop[:user_level] == b[:user_level]
		when String
			@prop[:user_level] == b
		else
			false
		end
	end

	def >(b)
		case b
		when BosUser
			@prop[:user_level] < b[:user_level]
		when String
			@prop[:user_level] < b
		else
			false
		end
	end

	def <(b)
		case b
		when BosUser
			@prop[:user_level] > b[:user_level]
		when String
			@prop[:user_level] > b
		else
			false
		end
	end

	def >=(b)
		case b
		when BosUser
			@prop[:user_level] <= b[:user_level]
		when String
			@prop[:user_level] <= b
		else
			false
		end
	end

	def <=(b)
		case b
		when BosUser
			@prop[:user_level] >= b[:user_level]
		when String
			@prop[:user_level] >= b
		else
			false
		end
	end

	def set_default
		{
			:user_id      => "",
			:password     => "",
			:mail_address => "",
			:sex          => "",
			:birth        => nil,
			:address      => 0,
			:user_level   => "p",
			:created      => DateTime.now,
			:last_login   => DateTime.now,
			:login_count  => 0 }
	end

	def get_list(pg=1, pc=10, sc="")
		pg = pg || 1
		pc = pc || 10
		@mydo.exp({
			:command => "s",
			:target  => Table_name,
			:cols    => set_default,
			:order   => "user_id ASC",
			:page    => pg,
			:pagesize => pc })
	end

	def commit
		if @prop[:user_id] != "" then
			if @newflg then
				@mydo.exp({
					:command => "i",
					:target  => Table_name,
					:cols    => @prop })
			else
				@mydo.exp({
					:command => "u",
					:target  => Table_name,
					:cols    => @prop,
					:where   => w("user_id"){|a| a == @prop[:user_id]} })
			end
		end
		@prop[:user_id]
	end

	def cmd5(ist)
		Digest::MD5.hexdigest(ist)
	end	

	def self.cmd5(ist)
		Digest::MD5.hexdigest(ist)
	end	

end


class BosAddress

	Table_name = "bos_#{BOS::Prop[:site_name]}_address"
	
	def initialize(address_id)
		@mydb = BOS::MySQLo
		@mydo = BOS::Rdb
		@prop = set_default
		@region_table_name = "bos_#{BOS::Prop[:site_name]}_region"
		setup if !@mydb.list_tables.include?(Table_name)
		if address_id && address_id != "" then
			@prop = @mydo.exp({
				:command => "s",
				:target  => Table_name,
				:cols    => set_default,
				:where   => "address_id = #{address_id}" })[0]
		end
	end
	
	def setup
		@mydb.query("CREATE TABLE #{Table_name}(" +
			"address_id INT NOT NULL AUTO_INCREMENT PRIMARY KEY," +
			"registrant VARCHAR(20) ," +
			"postalcode VARCHAR(8) ," +
			"region VARCHAR(10) ," +
			"city VARCHAR(64) ," +
			"address1 VARCHAR(255) ," +
			"address2 VARCHAR(255) ," +
			"lastname VARCHAR(255) ," +
			"firstname VARCHAR(255) ," +
			"tel_no VARCHAR(13) ," +
			"fax_no VARCHAR(13) ," +
			"other_no VARCHAR(13) ," +
			"memo VARCHAR(255) );")
		@mydb.query("CREATE TABLE #{@region_table_name}(" +
			"region_id INT NOT NULL AUTO_INCREMENT PRIMARY KEY," +
			"region_code VARCHAR(2)," +
			"region_name VARCHAR(10) );")
		
		region_ar = ['̳ƻ','Ŀ','긩','ܾ븩','ĸ','','ʡ縩','븩',
			'ڸ','ϸ','̸','ո','','','㸩','ٻ','',
			'ʡ温','','Ĺ','츩','Ų','θ','Ÿ','츩','',
			'','ʼ˸','ɸ','²λ','Ļ踩','纬','','縩','',
			'縩','','ɲ','θ','ʡ','츩','Ĺ긩','ܸ','ʬ',
			'ܺ긩','縩','츩']

		region_ar.each_with_index{|v,i|
			@mydo.exp({
				:command => "i",
				:target  => @region_table_name,
				:cols    => {
					:region_code => "%02d" % i,
					:region_name => v } })
		}
	end

	def set_default
		{
			:address_id   => 0,
			:registrant   => "",
			:postalcode   => "",
			:region       => "",
			:city         => "",
			:address1     => "",
			:address2     => "",
			:lastname     => "",
			:firstname    => "",
			:tel_no       => "",
			:fax_no       => "",
			:other_no     => "",
			:memo         => "" }
	end

end

