# $Id: bos_prop.rb,v 1.3 2005/02/23 13:34:09 nisi Exp $

class BosProp
	include BOS::PropMethods
	
	Table_name = "bos_#{Prop[:site_name]}_props"
	
	def initialize
		@mydb = BOS::MySQLo
		@prop = {}
		@info = {}
		setup if !@mydb.list_tables.include?(Table_name)
		@mydb.query("SELECT prop_class,prop_name,prop_value,info_text FROM #{Table_name} ;").each_hash do |rw|
			@prop[rw["prop_class"]] = {} unless @prop[rw["prop_class"]]
			@info[rw["prop_class"]] = {} unless @info[rw["prop_class"]]
			@prop[rw["prop_class"]][rw["prop_name"]] = rw["prop_value"]
			@info[rw["prop_class"]][rw["prop_name"]] = rw["info_text"]
		end
	end
	
	def setup
		@mydb.query("CREATE TABLE #{Table_name}(" +
			"prop_class VARCHAR(255)," +
			"prop_name VARCHAR(255)," +
			"prop_value VARCHAR(255)," +
			"info_text TEXT) ;")
		set_prop("site","","")
		set_info("site","","Ȥεư˴ؤ")
		set_prop("site","plugin setup","on")
		set_info("site","plugin setup","Ƴ줿ץ饰setup¹Ԥ")
		commit
	end
	
	def info(c,p=nil)
		if p then
			@info[c][p]
		else
			@info[c]
		end
	end
	
	def prop(c,p=nil)
		if p then
			@prop[c][p]
		else
			@prop[c]
		end
	end
	
	def set_info(c,p,v)
		@info[c] = {} unless @info[c]
		@info[c][p] = v
	end
	
	def set_prop(c,p,v)
		@prop[c] = {} unless @prop[c]
		@prop[c][p] = v
	end
	
	def class_list
		@prop.keys.sort
	end
	
	def commit
		@mydb.query("DELETE FROM #{Table_name} ;")
		@prop.each do |key,val|
			val.each do |k,v|
				@mydb.query("INSERT INTO #{Table_name}(" +
					"prop_class,prop_name,prop_value,info_text) " +
					"VALUES('#{key.to_Sql}','#{k.to_Sql}','#{v.to_Sql}','#{@info[key][k].to_Sql}') ;")
			end
		end
	end
	
end
