# $Id: bos_user.rb,v 1.17 2005/06/18 01:56:29 nisi Exp $

require 'digest/md5'

class BosUser
	include BOS::PropMethods
	attr_reader :groups
	
	Table_name = "bos_#{BOS::Prop[:site_name]}_users"
	
	def initialize(user_id)
		@mydb = BOS::MySQLo
		@mydo = Rudby.new(BOS::MySQLo)
		@gro  = BOS::BosGroup.new
		setup if BOS::Prop[:sitesetup] && !@mydb.list_tables.include?(Table_name)
		if user_id && user_id != "" then
			@prop = @mydo.exp({
				:command => "s",
				:target  => Table_name,
				:cols    => set_default,
				:where   => w("user_id"){|a| a == user_id } })[0]
			@groups = @gro.get_group_list(user_id)
		end
		if !@prop then
			@prop = set_default
			@groups = []
			@newflg = true
		else
			@newflg = false
		end
		@address = BosAddress.new(@prop[:address]) if @prop[:address]
	end

	def setup
		@mydb.query("CREATE TABLE #{Table_name}(" +
			"user_id VARCHAR(20) NOT NULL PRIMARY KEY," +
			"password VARCHAR(32) NOT NULL ," +
			"mail_address VARCHAR(255)," +
			"sex CHAR(1)," +
			"birth DATE," +
			"address INT," +
			"created DATETIME NOT NULL ," +
			"last_login DATETIME NOT NULL ," +
			"login_count INT NOT NULL );")
		
		su = set_default
		su[:user_id]      = BOS::Prop[:user_name]
		su[:password]     = cmd5(BOS::Prop[:user_address])
		su[:mail_address] = BOS::Prop[:user_address]
		@mydo.exp({
			:command => "i",
			:target  => Table_name,
			:cols    => su })
		@gro.add_user(su[:user_id],1)
		
		su = set_default
		su[:user_id]      = "guest"
		su[:password]     = cmd5("guest")
		su[:mail_address] = "guest"
		@mydo.exp({
			:command => "i",
			:target  => Table_name,
			:cols    => su })
		@gro.add_user(su[:user_id],3)
	end
	
	def login(pw)
		return false unless @prop
		if @prop[:password] == cmd5(pw) then
			BOS::Session['uid'] = @prop[:user_id]
			@prop[:last_login] = DateTime.now
			@prop[:login_count] += 1
			@mydo.exp({
				:command => "u",
				:target  => Table_name,
				:cols    => @prop,
				:where   => w("user_id"){|a| a == @prop[:user_id] } })
		end
		@prop[:user_id]
	end
	
	def logout
		BOS::Session['uid'] = nil
		@prop = set_default
	end
	
	def get_group_list(h)
		@gro.get_group_list(@prop[:user_id],h)
	end
	
	def add_user(uid,pw,gid=nil)
		ret = "ERROR"
		t = @mydo.exp({
			:command => "s",
			:target  => Table_name,
			:cols    => {:user_id => ""},
			:where   => w("USER_ID"){|a| a == uid } })[0]
		if !t then
			su = set_default
			su[:user_id]      = uid
			su[:password]     = cmd5(pw)
			@mydo.exp({
				:command => "i",
				:target  => Table_name,
				:cols    => su })
			@gro.add_user(uid,gid || 2)
			ret = false
		else
			ret = "Υ桼IDϴϿƤޤIDѹƤ"
		end
		ret
	end
	
	def ==(b)
		false unless defined?(b[])
		@prop[:user_id] == b[:user_id]
	end
	
	def =~(b)
		ret = false
		if defined?(b.groups) then
			ret = @groups & b
			ret = false if ret == []
		else
			ret = @groups.include?(b)
		end
		ret
	end
	alias :=== :=~
	
	def set_default
		{
			:user_id      => "",
			:password     => "",
			:mail_address => "",
			:sex          => "o",
			:birth        => nil,
			:address      => 0,
			:created      => DateTime.now,
			:last_login   => DateTime.now,
			:login_count  => 0 }
	end

	def get_list(pg=1, pc=10, sc="", ob="created")
		pg = pg || 1
		pc = pc || 10
		@mydo.exp({
			:command => "s",
			:target  => Table_name,
			:cols    => set_default,
			:order   => "#{ob} ASC",
			:page    => pg,
			:pagesize => pc })
	end

	def commit
		if @prop[:user_id] != "" then
			if @newflg then
				@mydo.exp({
					:command => "i",
					:target  => Table_name,
					:cols    => @prop })
			else
				@mydo.exp({
					:command => "u",
					:target  => Table_name,
					:cols    => @prop,
					:where   => w("user_id"){|a| a == @prop[:user_id]} })
			end
		end
		@prop[:user_id]
	end

	def cmd5(ist)
		Digest::MD5.hexdigest(ist)
	end	

	def self.cmd5(ist)
		Digest::MD5.hexdigest(ist)
	end	

end

class BosGroup
	include BOS::PropMethods
	
	Table_name   = "bos_#{BOS::Prop[:site_name]}_group"
	Table_name_r = "bos_#{BOS::Prop[:site_name]}_user_group"
	
	def initialize(group_id=nil)
		@mydb = BOS::MySQLo
		@mydo = Rudby.new(BOS::MySQLo)
		setup if BOS::Prop[:sitesetup] && !@mydb.list_tables.include?(Table_name)
		if group_id && group_id != "" then
			@prop = @mydo.exp({
				:command => "s",
				:target  => Table_name,
				:cols    => set_default,
				:where   => w("group_id"){|a| a == group_id } })[0]
		end
		@prop = set_default unless @prop
	end
	
	def set_default
		{
			:group_id      => 0,
			:group_name    => "",
			:group_summary => "" }
	end
	
	def setup
		@mydb.query("CREATE TABLE #{Table_name}(" +
			"group_id INT NOT NULL AUTO_INCREMENT PRIMARY KEY," +
			"group_name VARCHAR(32) NOT NULL ," +
			"group_summary VARCHAR(255) );")
		@mydb.query("CREATE TABLE #{Table_name_r}(" +
			"user_id VARCHAR(20) ," +
			"group_id INT );")
		
		su = set_default
		su.delete(:group_id)
		su[:group_name]    = 'admin'
		su[:group_summary] = ''
		@mydo.exp({
			:command => "i",
			:target  => Table_name,
			:cols    => su })
			
		su.delete(:group_id)
		su[:group_name]    = 'user'
		su[:group_summary] = '桼'
		@mydo.exp({
			:command => "i",
			:target  => Table_name,
			:cols    => su })
			
		su.delete(:group_id)
		su[:group_name]    = 'guest'
		su[:group_summary] = ''
		@mydo.exp({
			:command => "i",
			:target  => Table_name,
			:cols    => su })
	end
	
	def get_user_list(group_id=nil)
		group_id = group_id || @prop[:group_id]
		ua = @mydo.exp({
				:command => "s",
				:target  => Table_name_r,
				:cols    => {:user_id => ""},
				:where   => w("group_id"){|a| a == group_id } })
		ua.collect{|a| a[:user_id] }
	end
	
	def get_group_list(user_id="guest",h=false)
 		ua = @mydo.exp({
 				:command => "s",
 				:target  => Table_name_r,
				:cols    => {:group_id => 0},
 				:where   => w("user_id"){|a| a == user_id } })
		ua.collect{|a| a[:group_id] }
		h ? ua : ua.collect{|a| a[:group_id] }
	end

#	def get_group_list(user_id="guest",h=false)
#		ua = @mydo.exp({
#				:command => "s",
#				:target  => Table_name_r,
#				:cols    => {:group_id => 0,:group_name => ""},
#				:where   => w("user_id"){|a| a == user_id } })
#		h ? ua : ua.collect{|a| a[:group_id] }
#	end
	
	def self.get_all_group_list
		BOS::Rdb.exp({
				:command => "s",
				:target  => Table_name,
				:cols    => {:group_id => 0,:group_name => ""} })
	end
	
	def add_user(user_id,group_id=nil)
		group_id = group_id || @prop[:group_id]
		return nil unless del_user(user_id,group_id)
		ua = @mydo.exp({
			:command => "i",
			:target  => Table_name_r,
			:cols    => {
				:group_id => group_id,
				:user_id => user_id } })
		return true
	end
	
	def del_user(user_id,group_id=nil)
		group_id = group_id || @prop[:group_id]
		return nil unless user_id
		return nil unless group_id
		ua = @mydo.exp({
			:command => "d",
			:target  => Table_name_r,
			:where   => w("user_id","group_id"){|a,b| (a == user_id) & (b == group_id) } })
		return true
	end
	
	def commit
		if @prop[:group_id] == 0 then
			@prop.delete(:group_id)
			@prop[:group_id] = @mydo.exp({
				:command => "i",
				:target  => Table_name,
				:cols    => @prop })[:insid]
		else
			lct = @mydo.exp({
				:command => "u",
				:target  => Table_name,
				:cols    => @prop,
				:where   => w("group_id"){|a| a == @prop[:group_id] } })
		end
		
		@prop[:product_id]
	end
	
end

class BosAddress

	Table_name = "bos_#{BOS::Prop[:site_name]}_address"
	
	def initialize(address_id)
		@mydb = BOS::MySQLo
		@mydo = BOS::Rdb
		@prop = set_default
		@region_table_name = "bos_#{BOS::Prop[:site_name]}_region"
		setup if !@mydb.list_tables.include?(Table_name)
		if address_id && address_id != "" then
			@prop = @mydo.exp({
				:command => "s",
				:target  => Table_name,
				:cols    => set_default,
				:where   => w("address_id"){|a| a == address_id } })[0]
		end
	end
	
	def setup
		@mydb.query("CREATE TABLE #{Table_name}(" +
			"address_id INT NOT NULL AUTO_INCREMENT PRIMARY KEY," +
			"registrant VARCHAR(20) ," +
			"postalcode VARCHAR(8) ," +
			"region VARCHAR(10) ," +
			"city VARCHAR(64) ," +
			"address1 VARCHAR(255) ," +
			"address2 VARCHAR(255) ," +
			"lastname VARCHAR(255) ," +
			"firstname VARCHAR(255) ," +
			"tel_no VARCHAR(13) ," +
			"fax_no VARCHAR(13) ," +
			"other_no VARCHAR(13) ," +
			"memo VARCHAR(255) );")
		@mydb.query("CREATE TABLE #{@region_table_name}(" +
			"region_id INT NOT NULL AUTO_INCREMENT PRIMARY KEY," +
			"region_code VARCHAR(2)," +
			"region_name VARCHAR(10) );")
		
		region_ar = ['̳ƻ','Ŀ','긩','ܾ븩','ĸ','','ʡ縩','븩',
			'ڸ','ϸ','̸','ո','','','㸩','ٻ','',
			'ʡ温','','Ĺ','츩','Ų','θ','Ÿ','츩','',
			'','ʼ˸','ɸ','²λ','Ļ踩','纬','','縩','',
			'縩','','ɲ','θ','ʡ','츩','Ĺ긩','ܸ','ʬ',
			'ܺ긩','縩','츩']

		region_ar.each_with_index{|v,i|
			@mydo.exp({
				:command => "i",
				:target  => Table_name,
				:cols    => {
					:region_code => "%02d" % i,
					:region_name => v } })
		}
	end

	def set_default
		{
			:address_id   => 0,
			:registrant   => "",
			:postalcode   => "",
			:region       => "",
			:city         => "",
			:address1     => "",
			:address2     => "",
			:lastname     => "",
			:firstname    => "",
			:tel_no       => "",
			:fax_no       => "",
			:other_no     => "",
			:memo         => "" }
	end

end

