/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.action;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionFormBean;
import org.apache.struts.action.ActionFormBeans;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionForwards;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMappings;
import org.apache.struts.action.PlugIn;
import org.apache.struts.action.RequestProcessor;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ApplicationConfig;
import org.apache.struts.config.ConfigRuleSet;
import org.apache.struts.config.ControllerConfig;
import org.apache.struts.config.DataSourceConfig;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.MessageResourcesConfig;
import org.apache.struts.util.GenericDataSource;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.MessageResourcesFactory;
import org.apache.struts.util.RequestUtils;
import org.apache.struts.util.ServletContextWriter;

public class ActionServlet
extends HttpServlet {
    protected String config = "/WEB-INF/struts-config.xml";
    protected Digester configDigester = null;
    protected FastHashMap dataSources = new FastHashMap();
    protected int debug = 0;
    protected int detail = 0;
    protected MessageResources internal = null;
    protected String internalName = "org.apache.struts.action.ActionResources";
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected RequestProcessor processor = null;
    protected String[] registrations = new String[]{"-//Apache Software Foundation//DTD Struts Configuration 1.0//EN", "/org/apache/struts/resources/struts-config_1_0.dtd", "-//Apache Software Foundation//DTD Struts Configuration 1.1//EN", "/org/apache/struts/resources/struts-config_1_1.dtd", "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", "/org/apache/struts/resources/web-app_2_2.dtd", "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "/org/apache/struts/resources/web-app_2_3.dtd"};
    protected String servletMapping = null;
    protected String servletName = null;
    protected boolean validating = true;

    public void destroy() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.internal.getMessage("finalizing"));
        }
        this.destroyApplications();
        this.destroyDataSources();
        this.destroyInternal();
        this.getServletContext().removeAttribute("org.apache.struts.action.ACTION_SERVLET");
    }

    public void init() throws ServletException {
        this.initInternal();
        this.initOther();
        this.initServlet();
        this.getServletContext().setAttribute("org.apache.struts.action.ACTION_SERVLET", (Object)this);
        ApplicationConfig ac = this.initApplicationConfig("", this.config);
        this.initApplicationMessageResources(ac);
        this.initApplicationDataSources(ac);
        this.initApplicationPlugIns(ac);
        Enumeration names = this.getServletConfig().getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith("config/")) continue;
            String prefix = name.substring(6);
            ac = this.initApplicationConfig(prefix, this.getServletConfig().getInitParameter(name));
            this.initApplicationMessageResources(ac);
            this.initApplicationDataSources(ac);
            this.initApplicationPlugIns(ac);
        }
        this.destroyConfigDigester();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.process(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.process(request, response);
    }

    public void addServletMapping(String servletName, String urlPattern) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Process servletName=" + servletName + ", urlPattern=" + urlPattern));
        }
        if (servletName == null) {
            return;
        }
        if (servletName.equals(this.servletName)) {
            this.servletMapping = urlPattern;
        }
    }

    public DataSource findDataSource(String key) {
        if (key == null) {
            return (DataSource)this.dataSources.get((Object)"org.apache.struts.action.DATA_SOURCE");
        }
        return (DataSource)this.dataSources.get((Object)key);
    }

    public ActionFormBean findFormBean(String name) {
        ActionFormBeans afb = (ActionFormBeans)this.getServletContext().getAttribute("org.apache.struts.action.FORM_BEANS");
        if (afb == null) {
            return null;
        }
        return afb.findFormBean(name);
    }

    public ActionForward findForward(String name) {
        ActionForwards af = (ActionForwards)this.getServletContext().getAttribute("org.apache.struts.action.FORWARDS");
        if (af == null) {
            return null;
        }
        return af.findForward(name);
    }

    public ActionMapping findMapping(String path) {
        ActionMappings am = (ActionMappings)this.getServletContext().getAttribute("org.apache.struts.action.MAPPINGS");
        if (am == null) {
            return null;
        }
        return am.findMapping(path);
    }

    public int getDebug() {
        return this.debug;
    }

    public MessageResources getInternal() {
        return this.internal;
    }

    public MessageResources getResources() {
        return (MessageResources)this.getServletContext().getAttribute("org.apache.struts.action.MESSAGE");
    }

    public void log(String message, int level) {
        if (this.debug >= level) {
            this.log(message);
        }
    }

    protected void destroyApplications() {
        ArrayList values = new ArrayList();
        Enumeration names = this.getServletContext().getAttributeNames();
        while (names.hasMoreElements()) {
            values.add(names.nextElement());
        }
        Iterator keys = ((AbstractList)values).iterator();
        while (keys.hasNext()) {
            String name = (String)keys.next();
            Object value = this.getServletContext().getAttribute(name);
            if (!(value instanceof ApplicationConfig)) continue;
            ApplicationConfig config = (ApplicationConfig)value;
            try {
                config.getProcessor().destroy();
            }
            catch (Throwable t) {
                // empty catch block
            }
            PlugIn[] plugIns = config.findPlugIns();
            int i = 0;
            while (i < plugIns.length) {
                int j = plugIns.length - (i + 1);
                plugIns[j].destroy();
                ++i;
            }
        }
    }

    protected void destroyConfigDigester() {
        this.configDigester = null;
    }

    protected void destroyDataSources() {
        FastHashMap fastHashMap = this.dataSources;
        synchronized (fastHashMap) {
            Iterator keys = this.dataSources.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                this.getServletContext().removeAttribute(key);
                DataSource dataSource = this.findDataSource(key);
                if (!(dataSource instanceof GenericDataSource)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)this.internal.getMessage("dataSource.destroy", (Object)key));
                }
                try {
                    ((GenericDataSource)dataSource).close();
                }
                catch (SQLException e) {
                    this.log.error((Object)this.internal.getMessage("destroyDataSource", (Object)key), (Throwable)e);
                }
            }
            this.dataSources.clear();
        }
    }

    protected void destroyInternal() {
        this.internal = null;
    }

    protected ApplicationConfig getApplicationConfig(HttpServletRequest request) {
        ApplicationConfig config = (ApplicationConfig)request.getAttribute("org.apache.struts.action.APPLICATION");
        if (config == null) {
            config = (ApplicationConfig)this.getServletContext().getAttribute("org.apache.struts.action.APPLICATION");
        }
        return config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ApplicationConfig initApplicationConfig(String prefix, String path) throws ServletException {
        ApplicationConfig config;
        block10: {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Initializing application path '" + prefix + "' configuration from '" + path + "'"));
            }
            config = null;
            InputStream input = null;
            String mapping = null;
            try {
                try {
                    config = new ApplicationConfig(prefix, this);
                    mapping = this.getServletConfig().getInitParameter("mapping");
                    if (mapping != null) {
                        config.setActionMappingClass(mapping);
                    }
                    Digester digester = this.initConfigDigester();
                    digester.push((Object)config);
                    input = this.getServletContext().getResourceAsStream(path);
                    digester.parse(input);
                    input.close();
                    this.getServletContext().setAttribute("org.apache.struts.action.APPLICATION" + prefix, (Object)config);
                }
                catch (Throwable t) {
                    this.log.error((Object)this.internal.getMessage("configParse", (Object)path), t);
                    throw new UnavailableException(this.internal.getMessage("configParse", (Object)path));
                }
                Object var8_8 = null;
                if (input == null) break block10;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (input == null) throw throwable;
                try {
                    input.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e) {}
            input.close();
        }
        if (prefix.length() < 1) {
            this.defaultControllerConfig(config);
            this.defaultMessageResourcesConfig(config);
            this.defaultFormBeansConfig(config);
            this.defaultForwardsConfig(config);
            this.defaultMappingsConfig(config);
        }
        config.freeze();
        return config;
    }

    protected void initApplicationDataSources(ApplicationConfig config) throws ServletException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Initializing application path '" + config.getPrefix() + "' data sources"));
        }
        ServletContextWriter scw = new ServletContextWriter(this.getServletContext());
        DataSourceConfig[] dscs = config.findDataSourceConfigs();
        if (dscs == null) {
            dscs = new DataSourceConfig[]{};
        }
        this.dataSources.setFast(false);
        int i = 0;
        while (i < dscs.length) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Initializing application path '" + config.getPrefix() + "' data source '" + dscs[i].getKey() + "'"));
            }
            DataSource ds = null;
            try {
                ds = (DataSource)RequestUtils.applicationInstance(dscs[i].getType());
                BeanUtils.populate((Object)ds, (Map)dscs[i].getProperties());
                if (ds instanceof GenericDataSource) {
                    ((GenericDataSource)ds).open();
                }
                ds.setLogWriter(scw);
            }
            catch (Throwable t) {
                this.log.error((Object)this.internal.getMessage("dataSource.init", (Object)dscs[i].getKey()), t);
                throw new UnavailableException(this.internal.getMessage("dataSource.init", (Object)dscs[i].getKey()));
            }
            this.getServletContext().setAttribute(dscs[i].getKey() + config.getPrefix(), (Object)ds);
            this.dataSources.put((Object)dscs[i].getKey(), (Object)ds);
            ++i;
        }
        this.dataSources.setFast(true);
        if ("".equals(config.getPrefix())) {
            this.initDataSources();
        }
    }

    protected void initApplicationPlugIns(ApplicationConfig config) throws ServletException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Initializing application path '" + config.getPrefix() + "' plug ins"));
        }
        PlugIn[] plugIns = config.findPlugIns();
        int i = 0;
        while (i < plugIns.length) {
            plugIns[i].init(config);
            ++i;
        }
    }

    protected void initApplicationMessageResources(ApplicationConfig config) throws ServletException {
        MessageResourcesConfig[] mrcs = config.findMessageResourcesConfigs();
        int i = 0;
        while (i < mrcs.length) {
            if (mrcs[i].getFactory() != null && mrcs[i].getParameter() != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Initializing application path '" + config.getPrefix() + "' message resources from '" + mrcs[i].getParameter() + "'"));
                }
                try {
                    String factory = mrcs[i].getFactory();
                    MessageResourcesFactory.setFactoryClass(factory);
                    MessageResourcesFactory factoryObject = MessageResourcesFactory.createFactory();
                    MessageResources resources = factoryObject.createResources(mrcs[i].getParameter());
                    resources.setReturnNull(mrcs[i].getNull());
                    this.getServletContext().setAttribute(mrcs[i].getKey() + config.getPrefix(), (Object)resources);
                }
                catch (Throwable t) {
                    this.log.error((Object)this.internal.getMessage("applicationResources", (Object)mrcs[i].getParameter()), t);
                    throw new UnavailableException(this.internal.getMessage("applicationResources", (Object)mrcs[i].getParameter()));
                }
            }
            ++i;
        }
    }

    protected Digester initConfigDigester() {
        if (this.configDigester != null) {
            return this.configDigester;
        }
        this.configDigester = new Digester();
        this.configDigester.setDebug(this.detail);
        this.configDigester.setNamespaceAware(true);
        this.configDigester.setValidating(this.validating);
        this.configDigester.setUseContextClassLoader(true);
        this.configDigester.addRuleSet((RuleSet)new ConfigRuleSet());
        int i = 0;
        while (i < this.registrations.length) {
            URL url = ((Object)((Object)this)).getClass().getResource(this.registrations[i + 1]);
            if (url != null) {
                this.configDigester.register(this.registrations[i], url.toString());
            }
            i += 2;
        }
        return this.configDigester;
    }

    protected void initDataSources() throws ServletException {
    }

    protected void initInternal() throws ServletException {
        try {
            this.internal = MessageResources.getMessageResources(this.internalName);
        }
        catch (MissingResourceException e) {
            this.log.error((Object)("Cannot load internal resources from '" + this.internalName + "'"), (Throwable)e);
            throw new UnavailableException("Cannot load internal resources from '" + this.internalName + "'");
        }
    }

    protected void initOther() throws ServletException {
        String value = null;
        value = this.getServletConfig().getInitParameter("config");
        if (value != null) {
            this.config = value;
        }
        try {
            value = this.getServletConfig().getInitParameter("debug");
            this.debug = Integer.parseInt(value);
        }
        catch (Throwable t) {
            this.debug = 0;
        }
        try {
            value = this.getServletConfig().getInitParameter("detail");
            this.detail = Integer.parseInt(value);
        }
        catch (Throwable t) {
            this.detail = 0;
        }
        value = this.getServletConfig().getInitParameter("validating");
        if (value != null) {
            this.validating = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
        }
    }

    protected void initServlet() throws ServletException {
        this.servletName = this.getServletConfig().getServletName();
        Digester digester = new Digester();
        digester.push((Object)this);
        digester.setDebug(this.debug);
        digester.setNamespaceAware(true);
        digester.setValidating(false);
        int i = 0;
        while (i < this.registrations.length) {
            URL url = ((Object)((Object)this)).getClass().getResource(this.registrations[i + 1]);
            if (url != null) {
                digester.register(this.registrations[i], url.toString());
            }
            i += 2;
        }
        digester.addCallMethod("web-app/servlet-mapping", "addServletMapping", 2);
        digester.addCallParam("web-app/servlet-mapping/servlet-name", 0);
        digester.addCallParam("web-app/servlet-mapping/url-pattern", 1);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Scanning web.xml for controller servlet mapping");
        }
        InputStream input = null;
        try {
            try {
                input = this.getServletContext().getResourceAsStream("/WEB-INF/web.xml");
                digester.parse(input);
            }
            catch (Throwable e) {
                this.log.error((Object)this.internal.getMessage("configWebXml"), e);
                Object var6_5 = null;
                if (input != null) {
                    input = null;
                }
            }
            Object var6_4 = null;
            if (input != null) {
                input = null;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (input != null) {
                input = null;
            }
            throw throwable;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Mapping for servlet '" + this.servletName + "' = '" + this.servletMapping + "'"));
        }
        if (this.servletMapping != null) {
            this.getServletContext().setAttribute("org.apache.struts.action.SERVLET_MAPPING", (Object)this.servletMapping);
        }
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        RequestUtils.selectApplication(request, this.getServletContext());
        this.getApplicationConfig(request).getProcessor().process(request, response);
    }

    private void defaultControllerConfig(ApplicationConfig config) {
        String value = null;
        ControllerConfig cc = config.getControllerConfig();
        value = this.getServletConfig().getInitParameter("bufferSize");
        if (value != null) {
            cc.setBufferSize(Integer.parseInt(value));
        }
        if ((value = this.getServletConfig().getInitParameter("content")) != null) {
            cc.setContentType(value);
        }
        if ((value = this.getServletConfig().getInitParameter("locale")) != null) {
            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes")) {
                cc.setLocale(true);
            } else {
                cc.setLocale(false);
            }
        }
        if ((value = this.getServletConfig().getInitParameter("maxFileSize")) != null) {
            cc.setMaxFileSize(value);
        }
        if ((value = this.getServletConfig().getInitParameter("nocache")) != null) {
            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes")) {
                cc.setNocache(true);
            } else {
                cc.setNocache(false);
            }
        }
        if ((value = this.getServletConfig().getInitParameter("tempDir")) != null) {
            cc.setTempDir(value);
        }
    }

    private void defaultFormBeansConfig(ApplicationConfig config) {
        FormBeanConfig[] fbcs = config.findFormBeanConfigs();
        ActionFormBeans afb = new ActionFormBeans();
        afb.setFast(false);
        int i = 0;
        while (i < fbcs.length) {
            afb.addFormBean((ActionFormBean)fbcs[i]);
            ++i;
        }
        afb.setFast(true);
        this.getServletContext().setAttribute("org.apache.struts.action.FORM_BEANS", (Object)afb);
    }

    private void defaultForwardsConfig(ApplicationConfig config) {
        ForwardConfig[] fcs = config.findForwardConfigs();
        ActionForwards af = new ActionForwards();
        af.setFast(false);
        int i = 0;
        while (i < fcs.length) {
            af.addForward((ActionForward)fcs[i]);
            ++i;
        }
        af.setFast(true);
        this.getServletContext().setAttribute("org.apache.struts.action.FORWARDS", (Object)af);
    }

    private void defaultMappingsConfig(ApplicationConfig config) {
        ActionConfig[] acs = config.findActionConfigs();
        ActionMappings am = new ActionMappings();
        am.setServlet(this);
        am.setFast(false);
        int i = 0;
        while (i < acs.length) {
            am.addMapping((ActionMapping)acs[i]);
            ++i;
        }
        am.setFast(true);
        this.getServletContext().setAttribute("org.apache.struts.action.MAPPINGS", (Object)am);
    }

    private void defaultMessageResourcesConfig(ApplicationConfig config) {
        String value = null;
        MessageResourcesConfig mrc = config.findMessageResourcesConfig("org.apache.struts.action.MESSAGE");
        if (mrc == null) {
            mrc = new MessageResourcesConfig();
            config.addMessageResourcesConfig(mrc);
        }
        if ((value = this.getServletConfig().getInitParameter("application")) != null) {
            mrc.setParameter(value);
        }
        if ((value = this.getServletConfig().getInitParameter("factory")) != null) {
            mrc.setFactory(value);
        }
        if ((value = this.getServletConfig().getInitParameter("null")) != null) {
            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes")) {
                mrc.setNull(true);
            } else {
                mrc.setNull(false);
            }
        }
    }
}

