/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.config;

import java.io.Serializable;
import java.lang.reflect.Array;
import org.apache.commons.beanutils.ConvertUtils;

public class FormPropertyConfig
implements Serializable {
    protected boolean configured = false;
    protected transient boolean initialized = false;
    protected transient Object initialValue = null;
    protected String initial = null;
    protected String name = null;
    protected String type = null;

    public String getInitial() {
        return this.initial;
    }

    public void setInitial(String initial) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.initial = initial;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.type = type;
    }

    public Class getTypeClass() {
        String baseType = this.getType();
        boolean indexed = false;
        if (baseType.endsWith("[]")) {
            baseType = baseType.substring(0, baseType.length() - 2);
            indexed = true;
        }
        Class<Comparable<Boolean>> baseClass = null;
        if ("boolean".equals(baseType)) {
            baseClass = Boolean.TYPE;
        } else if ("byte".equals(baseType)) {
            baseClass = Byte.TYPE;
        } else if ("char".equals(baseType)) {
            baseClass = Character.TYPE;
        } else if ("double".equals(baseType)) {
            baseClass = Double.TYPE;
        } else if ("float".equals(baseType)) {
            baseClass = Float.TYPE;
        } else if ("int".equals(baseType)) {
            baseClass = Integer.TYPE;
        } else if ("long".equals(baseType)) {
            baseClass = Long.TYPE;
        } else if ("short".equals(baseType)) {
            baseClass = Short.TYPE;
        } else {
            try {
                baseClass = Class.forName(baseType);
            }
            catch (Throwable t) {
                baseClass = null;
            }
        }
        if (indexed) {
            return Array.newInstance(baseClass, 0).getClass();
        }
        return baseClass;
    }

    public Object initial() {
        if (!this.initialized) {
            try {
                if (this.initial == null) {
                    this.initialValue = "boolean".equals(this.type) ? Boolean.FALSE : ("byte".equals(this.type) ? new Byte(0) : ("char".equals(this.type) ? (Serializable)new Character('\u0000') : (Serializable)("double".equals(this.type) ? (Number)new Double(0.0) : (Number)("float".equals(this.type) ? (Number)new Float(0.0f) : (Number)("int".equals(this.type) ? (Number)new Integer(0) : (Number)("long".equals(this.type) ? (Number)new Long(0L) : (Number)("short".equals(this.type) ? new Short(0) : null)))))));
                } else {
                    Class<?> clazz = Class.forName(this.type);
                    this.initialValue = ConvertUtils.convert((String)this.initial, clazz);
                }
            }
            catch (Throwable t) {
                this.initialValue = null;
            }
            this.initialized = true;
        }
        return this.initialValue;
    }

    public void freeze() {
        this.configured = true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("FormPropertyConfig[");
        sb.append("name=");
        sb.append(this.name);
        sb.append(",type=");
        sb.append(this.type);
        sb.append(",initial=");
        sb.append(this.initial);
        sb.append("]");
        return sb.toString();
    }
}

