/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.services;

import java.io.Serializable;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogSource;
import org.apache.commons.services.ConfigObject;
import org.apache.commons.services.ConfigObjectCreateRule;
import org.apache.commons.services.Event;
import org.apache.commons.services.EventModule;
import org.apache.commons.services.InitConfigRule;
import org.apache.commons.services.LogService;
import org.apache.commons.services.Queue;
import org.apache.commons.services.QueueModule;
import org.apache.commons.services.ServiceModule;

public class ServiceManager
implements Serializable,
ConfigObject {
    protected EventModule eventModule = null;
    protected ServiceModule serviceModule = null;
    protected QueueModule queueModule = null;
    protected LogService logService = null;
    protected static Log log = LogSource.getInstance((Class)(class$org$apache$commons$services$ServiceManager == null ? (class$org$apache$commons$services$ServiceManager = ServiceManager.class$("org.apache.commons.services.ServiceManager")) : class$org$apache$commons$services$ServiceManager));
    static /* synthetic */ Class class$org$apache$commons$services$ServiceManager;

    public Log getLog() {
        return log;
    }

    public EventModule getEventModule() {
        return this.eventModule;
    }

    public void setEventModule(EventModule eventModule) {
        this.eventModule = eventModule;
        this.eventModule.setServiceManager(this);
        log.debug((Object)("Set EventModule of class " + eventModule.getClass().getName()));
    }

    public ServiceModule getServiceModule() {
        return this.serviceModule;
    }

    public void setServiceModule(ServiceModule serviceModule) {
        this.serviceModule = serviceModule;
        this.serviceModule.setServiceManager(this);
        log.debug((Object)("Set ServiceModule of class " + serviceModule.getClass().getName()));
    }

    public QueueModule getQueueModule() {
        return this.queueModule;
    }

    public void setQueueModule(QueueModule queueModule) {
        this.queueModule = queueModule;
        this.queueModule.setServiceManager(this);
        log.debug((Object)("Set QueueModule of class " + queueModule.getClass().getName()));
    }

    public Digester initDigester(Digester digester, String path) {
        path = path != null ? path + "/" : "";
        String serviceManagerPath = path + "service-manager";
        String eventsRegistrationPath = serviceManagerPath + "/event-module";
        String servicesRegistrationPath = serviceManagerPath + "/service-module";
        String queuesRegistrationPath = serviceManagerPath + "/queue-module";
        digester.addRule(serviceManagerPath, (Rule)new InitConfigRule(digester, this));
        digester.addSetProperties(serviceManagerPath);
        digester.addRule(eventsRegistrationPath, (Rule)new ConfigObjectCreateRule(digester, "org.apache.commons.services.EventModule", "type", eventsRegistrationPath));
        digester.addSetNext(eventsRegistrationPath, "setEventModule", "org.apache.commons.services.EventModule");
        digester.addSetProperties(eventsRegistrationPath);
        digester.addSetProperty(eventsRegistrationPath + "/set-property", "property", "value");
        digester.addRule(servicesRegistrationPath, (Rule)new ConfigObjectCreateRule(digester, "org.apache.commons.services.ServiceModule", "type", servicesRegistrationPath));
        digester.addSetNext(servicesRegistrationPath, "setServiceModule", "org.apache.commons.services.ServiceModule");
        digester.addSetProperties(servicesRegistrationPath);
        digester.addSetProperty(servicesRegistrationPath + "/set-property", "property", "value");
        digester.addRule(queuesRegistrationPath, (Rule)new ConfigObjectCreateRule(digester, "org.apache.commons.services.QueueModule", "type", queuesRegistrationPath));
        digester.addSetNext(queuesRegistrationPath, "setQueueModule", "org.apache.commons.services.QueueModule");
        digester.addSetProperties(queuesRegistrationPath);
        digester.addSetProperty(queuesRegistrationPath + "/set-property", "property", "value");
        return digester;
    }

    public void init(String configURI) {
        Digester digester = this.initDigester(new Digester(), null);
        digester.setLogger(log);
        try {
            digester.parse(configURI);
        }
        catch (Exception e) {
            log.error((Object)"Exception at ServiceManager.init()", (Throwable)e);
        }
    }

    public void destroy() {
        if (this.eventModule != null) {
            this.eventModule.destroy();
            this.eventModule = null;
        }
        if (this.serviceModule != null) {
            this.serviceModule.destroy();
            this.serviceModule = null;
        }
        if (this.queueModule != null) {
            this.queueModule.destroy();
            this.queueModule = null;
        }
    }

    public Object execute() {
        Event event = this.eventModule.getDefaultEvent();
        return this.execute(event);
    }

    public Object execute(String queueName) {
        Event event = this.eventModule.getDefaultEvent();
        return this.execute(queueName, event);
    }

    public Object execute(Event event) {
        Queue queue = this.queueModule.getDefaultQueue();
        return this.execute(queue, event);
    }

    public Object execute(String queueName, Event event) {
        Queue queue = this.queueModule.getQueue(queueName);
        return this.execute(queue, event);
    }

    protected Object execute(Queue queue, Event event) {
        Object result = null;
        try {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"ServiceManager.execute() start");
                    log.debug((Object)("  Queue=[" + queue + "]"));
                    log.debug((Object)("  Event=[" + event + "]"));
                }
                result = queue.execute(event);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ServiceManager.execute() result = " + result));
                }
                Object object = result;
                Object var6_6 = null;
                this.eventModule.releaseEvent(event);
                return object;
            }
            catch (Exception e) {
                log.error((Object)"ServiceManager.execute() - error at call", (Throwable)e);
                Object var6_7 = null;
                this.eventModule.releaseEvent(event);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.eventModule.releaseEvent(event);
            throw throwable;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

