/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sitraka.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ClassCPInfo;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ConstantPool;

public class InterfaceList {
    protected ConstantPool constantPool;
    protected int[] interfaces;

    public InterfaceList(ConstantPool pool) {
        this.constantPool = pool;
    }

    public void read(DataInputStream dis) throws IOException {
        int count = dis.readShort();
        this.interfaces = new int[count];
        int i = 0;
        while (i < count) {
            this.interfaces[i] = dis.readShort();
            ++i;
        }
    }

    public int length() {
        return this.interfaces.length;
    }

    public String getInterface(int i) {
        int index = this.interfaces[i];
        ClassCPInfo cp = (ClassCPInfo)this.constantPool.getEntry(index);
        return cp.getClassName().replace('/', '.');
    }

    public String[] getInterfaces() {
        String[] classes = new String[this.interfaces.length];
        int i = 0;
        while (i < classes.length) {
            classes[i] = this.getInterface(i);
            ++i;
        }
        return classes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Interfaces: ");
        String[] names = this.getInterfaces();
        int i = 0;
        while (i < names.length) {
            sb.append(names[i]);
            if (i != names.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.toString();
    }
}

