/*
 * Decompiled with CFR 0.152.
 */
package gwe.sql;

import gwe.sql.gweMysql;
import gwe.sql.gweMysqlDatabaseMetaData;
import gwe.sql.gweMysqlException;
import gwe.sql.gweMysqlPacket;
import gwe.sql.gweMysqlPreparedStatement;
import gwe.sql.gweMysqlResultSetCore;
import gwe.sql.gweMysqlStatement;
import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class gweMysqlConnection
implements Connection {
    private gweMysql mysql = null;
    private Driver driver;
    private String url;
    private String username;
    private String catalog;
    private int isolation = 8;
    private Map typeMap = null;
    private String encoding = "Shift_JIS";
    private boolean add5CAfter5C = false;
    private boolean debugSQL = false;
    private boolean autocommit = true;
    private Properties prop;
    private boolean useNewIO = false;
    private gweMysqlResultSetCore curResultSet = null;

    public gweMysqlConnection(String string, int n, String string2, String string3, String string4, String string5, Properties properties, Driver driver) throws SQLException {
        String string6;
        Object object;
        Object object2;
        String string7;
        if (string2 == null || string2 == "") {
            string2 = "nobody";
        }
        this.prop = new Properties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string8 = (String)enumeration.nextElement();
            string7 = (String)properties.get(string8);
            this.prop.setProperty(string8, string7);
        }
        int n2 = string4.indexOf(63);
        if (n2 != -1) {
            string7 = string4.substring(n2 + 1);
            string4 = string4.substring(0, n2);
            while (true) {
                object2 = null;
                int n3 = string7.indexOf(38);
                object2 = n3 != -1 ? (Object)string7.substring(0, n3) : (Object)string7;
                object = null;
                String string9 = null;
                int n4 = ((String)object2).indexOf(61);
                if (n4 != -1) {
                    object = ((String)object2).substring(0, n4);
                    string9 = ((String)object2).substring(n4 + 1);
                } else {
                    object = object2;
                    string9 = "";
                }
                if (((String)object).length() > 0) {
                    this.prop.setProperty((String)object, string9);
                }
                if (n3 == -1) break;
                string7 = string7.substring(n3 + 1);
            }
        }
        if ((string7 = this.prop.getProperty("characterEncoding")) != null) {
            try {
                object2 = new byte[]{49, 0};
                String string10 = new String((byte[])object2, this.encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("mysql exception: " + unsupportedEncodingException.toString());
            }
            this.encoding = string7;
        }
        if ((object2 = (Object)this.prop.getProperty("add5CAfter5C")) != null) {
            this.add5CAfter5C = Boolean.valueOf((String)object2);
        }
        if ((string6 = this.prop.getProperty("useNewIO")) != null) {
            this.useNewIO = Boolean.valueOf(string6);
        }
        if ((object = this.prop.getProperty("debugSQL")) != null) {
            this.debugSQL = Boolean.valueOf((String)object);
        }
        try {
            this.mysql = new gweMysql(this.encoding, this.useNewIO);
            this.mysql.Connect(string, n, string4, string2, string3);
        }
        catch (gweMysqlException gweMysqlException2) {
            this.mysql = null;
            throw new SQLException("mysql exception: " + gweMysqlException2.getMessage());
        }
        this.url = string5;
        this.catalog = string4;
        this.username = string2;
        this.driver = driver;
    }

    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        throw new SQLException("mysql does not support stored procedures.");
    }

    public String nativeSQL(String string) throws SQLException {
        return string;
    }

    public boolean getAutoClose() throws SQLException {
        return true;
    }

    public void setAutoClose(boolean bl) throws SQLException {
    }

    public boolean getAutoCommit() throws SQLException {
        return this.autocommit;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        int n = this.mysql.judgeServerVersion(3, 23, 15);
        if (!bl && n < 0) {
            throw new SQLException("mysql older than Ver3.23.15 does not support transaction.");
        }
        if (n >= 0) {
            String string = "SET AUTOCOMMIT=" + (bl ? "1" : "0") + ";";
            this.executeUpdate(string);
            this.autocommit = bl;
        }
    }

    public void commit() throws SQLException {
        int n = this.mysql.judgeServerVersion(3, 23, 15);
        if (n < 0) {
            throw new SQLException("mysql older than Ver3.23.15 does not support commit.");
        }
        String string = "COMMIT;";
        this.executeUpdate(string);
    }

    public void rollback() throws SQLException {
        int n = this.mysql.judgeServerVersion(3, 23, 15);
        if (n < 0) {
            throw new SQLException("mysql older than Ver3.23.15 does not support rollback.");
        }
        String string = "ROLLBACK;";
        this.executeUpdate(string);
    }

    public void close() throws SQLException {
        try {
            this.mysql.Close();
            this.mysql = null;
        }
        catch (gweMysqlException gweMysqlException2) {
            throw new SQLException("mysql exception: " + gweMysqlException2.getMessage());
        }
    }

    public boolean isClosed() throws SQLException {
        return this.mysql == null;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return new gweMysqlDatabaseMetaData(this);
    }

    public void setReadOnly(boolean bl) throws SQLException {
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public void setCatalog(String string) throws SQLException {
        String string2 = "USE " + string + ";";
        this.executeUpdate(string2);
        this.catalog = string;
    }

    public String getCatalog() throws SQLException {
        return this.catalog;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        int n2 = this.mysql.judgeServerVersion(3, 23, 36);
        if (n2 < 0) {
            throw new SQLException("mysql older than Ver3.23.36 does not support Transaction Isolation Level.");
        }
        String string = "SET SESSION TRANSACTION ISOLATION LEVEL";
        switch (n) {
            case 0: {
                string = string + ";";
                break;
            }
            case 2: {
                string = string + " READ COMMITTED;";
                this.executeUpdate(string);
                break;
            }
            case 1: {
                string = string + " READ UNCOMMITTED;";
                this.executeUpdate(string);
                break;
            }
            case 4: {
                string = string + " REPEATABLE READ;";
                this.executeUpdate(string);
                break;
            }
            case 8: {
                string = string + " SERIALIZABLE;";
                this.executeUpdate(string);
                break;
            }
            default: {
                throw new SQLException("Unknown Transaction Isolation Level.");
            }
        }
        this.isolation = n;
    }

    public int getTransactionIsolation() throws SQLException {
        return this.isolation;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isAdd5CAfter5C() {
        return this.add5CAfter5C;
    }

    public boolean isUseNewIO() {
        return this.useNewIO;
    }

    public boolean isDebugSQL() {
        return this.debugSQL;
    }

    public void disableAutoClose() throws SQLException {
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public gweMysql executeQuery(String string) throws SQLException {
        if (this.debugSQL && DriverManager.getLogWriter() != null) {
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            DriverManager.println(timestamp.toString() + ":" + string);
        }
        try {
            return this.mysql.sqlQuery(string);
        }
        catch (gweMysqlException gweMysqlException2) {
            throw new SQLException("mysql exception: " + gweMysqlException2.getMessage());
        }
    }

    public long[] executeUpdate(String string) throws SQLException {
        if (this.debugSQL && DriverManager.getLogWriter() != null) {
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            DriverManager.println(timestamp.toString() + ":" + string);
        }
        try {
            return this.mysql.sqlUpdate(string);
        }
        catch (gweMysqlException gweMysqlException2) {
            throw new SQLException("mysql exception: " + gweMysqlException2.getMessage());
        }
    }

    gweMysqlPacket getPacket() {
        return this.mysql.getPacket();
    }

    int getServerMajorVersion() {
        return this.mysql.serverMajorVersion;
    }

    int getServerMinorVersion() {
        return this.mysql.serverMinorVersion;
    }

    int getServerSubminorVersion() {
        return this.mysql.serverSubminorVersion;
    }

    void setCurResultSet(gweMysqlResultSetCore gweMysqlResultSetCore2) {
        this.curResultSet = gweMysqlResultSetCore2;
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        if (n == 1003 && n2 == 1007) {
            return new gweMysqlStatement(this, n, n2, false);
        }
        if (n == 1004 && n2 == 1007) {
            return new gweMysqlStatement(this, n, n2, false);
        }
        throw new SQLException("mysql does not support createStatement(int, int).");
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (n == 1003 && n2 == 1007) {
            return new gweMysqlPreparedStatement(this, string, n, n2, this.encoding, this.add5CAfter5C, false);
        }
        if (n == 1004 && n2 == 1007) {
            return new gweMysqlPreparedStatement(this, string, n, n2, this.encoding, this.add5CAfter5C, false);
        }
        throw new SQLException("mysql does not support prepareStatement(String, int, int).");
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        throw new SQLException("mysql does not support prepareCall(String, int, int).");
    }

    public Map getTypeMap() throws SQLException {
        return this.typeMap;
    }

    public void setTypeMap(Map map) throws SQLException {
        this.typeMap = map;
    }

    int judgeServerVersion(int n, int n2, int n3) {
        return this.mysql.judgeServerVersion(n, n2, n3);
    }

    String getUrl() {
        return this.url;
    }

    String getUsername() {
        return this.username;
    }

    String getServerVersion() {
        return this.mysql.getServerVersion();
    }

    int getDriverMajorVersion() {
        return this.driver.getMajorVersion();
    }

    int getDriverMinorVersion() {
        return this.driver.getMinorVersion();
    }

    public void setHoldability(int n) throws SQLException {
        throw new SQLException("mysql does not support setHoldability(int).");
    }

    public int getHoldability() throws SQLException {
        throw new SQLException("mysql does not support getHoldability().");
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("mysql does not support setSavepoint().");
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        throw new SQLException("mysql does not support setSavepoint(String).");
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLException("mysql does not support rollback(Savepoint).");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLException("mysql does not support releaseSavepoint(Savepoint).");
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        throw new SQLException("mysql does not support createStatement(int, int, int).");
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        throw new SQLException("mysql does not support prepareStatement(String, int, int, int).");
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw new SQLException("mysql does not support CallableStatement(String, int, int, int).");
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        boolean bl;
        if (n == 1) {
            bl = true;
        } else if (n == 2) {
            bl = false;
        } else {
            throw new SQLException("Illegal argument at autoGeneratedKeys : prepareStatement(String, int).");
        }
        return new gweMysqlPreparedStatement(this, string, 1003, 1007, this.encoding, this.add5CAfter5C, bl);
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        if (nArray.length == 1 && nArray[0] == 1) {
            gweMysqlPreparedStatement gweMysqlPreparedStatement2 = new gweMysqlPreparedStatement(this, string, 1003, 1007, this.encoding, this.add5CAfter5C, true);
            return gweMysqlPreparedStatement2;
        }
        throw new SQLException("Illegal argument : prepareStatement(String, int[]).");
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        if (stringArray.length == 1 && stringArray[0] != null) {
            gweMysqlPreparedStatement gweMysqlPreparedStatement2 = new gweMysqlPreparedStatement(this, string, 1003, 1007, this.encoding, this.add5CAfter5C, true);
            gweMysqlPreparedStatement2.autoIncrementColName = stringArray[0];
            return gweMysqlPreparedStatement2;
        }
        throw new SQLException("Illegal argument : prepareStatement(String, String[]).");
    }
}

