/*
 * Decompiled with CFR 0.152.
 */
package gwe.sql;

import gwe.sql.gweMysqlException;
import gwe.sql.gweMysqlPacket;
import gwe.sql.gweMysqlStringBuffer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

class gweMysqlPacketNormal
implements gweMysqlPacket {
    DataInputStream sin;
    DataOutputStream sout;
    byte packetSequence;
    int bpos_w;
    int bpos_r;
    int packetLength_r;
    public boolean TRACING = false;
    byte[] buffer_w;
    byte[] buffer_r;
    String encoding;

    public gweMysqlPacketNormal(DataInputStream dataInputStream, DataOutputStream dataOutputStream, String string) {
        this.sin = dataInputStream;
        this.sout = dataOutputStream;
        this.encoding = string;
        this.buffer_w = new byte[65535];
        this.buffer_r = new byte[65535];
    }

    public void resetPacketSequence() {
        this.packetSequence = (byte)-1;
    }

    public void next() throws gweMysqlException {
        try {
            byte[] byArray = new byte[3];
            int n = 0;
            while (n < 3) {
                byArray[n] = this.sin.readByte();
                ++n;
            }
            this.packetLength_r = this.ub(byArray[0]) + 256 * this.ub(byArray[1]) + 65536 * this.ub(byArray[2]);
            this.packetSequence = this.sin.readByte();
            if (this.TRACING) {
                System.out.println("Packet length = " + this.packetLength_r);
                System.out.println("Packet sequence = " + this.packetSequence);
            }
            if (this.buffer_r.length < this.packetLength_r + 1) {
                this.buffer_r = new byte[this.packetLength_r + 1];
            }
            this.sin.readFully(this.buffer_r, 0, this.packetLength_r);
            this.buffer_r[this.packetLength_r] = 0;
            this.bpos_r = 0;
            if (this.TRACING) {
                int n2 = 0;
                while (n2 < this.packetLength_r) {
                    System.out.print(n2 + " : " + this.ub(this.buffer_r[n2]) + "  : ");
                    if (this.buffer_r[n2] > 30) {
                        System.out.println((char)this.buffer_r[n2]);
                    } else {
                        System.out.println("");
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            throw new gweMysqlException("gweMysql.Next: " + exception);
        }
    }

    public int ub(byte n) {
        return n < 0 ? 256 + n : n;
    }

    public int currentPos_r() {
        return this.bpos_r;
    }

    public void setPos_r(int n) {
        this.bpos_r = n;
    }

    public byte getCurDataPos_r() {
        return this.buffer_r[this.bpos_r];
    }

    public byte readByte() {
        return this.buffer_r[this.bpos_r++];
    }

    public byte[] readByteBlock(int n) {
        byte[] byArray = new byte[n];
        if (n > 0) {
            System.arraycopy(this.buffer_r, this.bpos_r, byArray, 0, n);
            this.bpos_r += n;
        }
        return byArray;
    }

    public int read2Bytes() {
        return this.ub(this.buffer_r[this.bpos_r++]) + 256 * this.ub(this.buffer_r[this.bpos_r++]);
    }

    public int read3Bytes() {
        return this.ub(this.buffer_r[this.bpos_r++]) + 256 * this.ub(this.buffer_r[this.bpos_r++]) + 65536 * this.ub(this.buffer_r[this.bpos_r++]);
    }

    public long read4Bytes() {
        return this.ub(this.buffer_r[this.bpos_r++]) + 256 * this.ub(this.buffer_r[this.bpos_r++]) + 65536 * this.ub(this.buffer_r[this.bpos_r++]) + 0x1000000 * this.ub(this.buffer_r[this.bpos_r++]);
    }

    public int readnBytes() {
        switch (this.ub(this.buffer_r[this.bpos_r++])) {
            case 1: {
                return this.ub(this.buffer_r[this.bpos_r++]);
            }
            case 2: {
                return this.read2Bytes();
            }
            case 3: {
                return this.read3Bytes();
            }
            case 4: {
                return (int)this.read4Bytes();
            }
        }
        return 255;
    }

    public long readLength() {
        switch (this.ub(this.buffer_r[this.bpos_r])) {
            case 251: {
                ++this.bpos_r;
                return -1L;
            }
            case 252: {
                ++this.bpos_r;
                return this.read2Bytes();
            }
            case 253: {
                ++this.bpos_r;
                return this.read3Bytes();
            }
            case 254: {
                ++this.bpos_r;
                return this.read4Bytes();
            }
        }
        return this.ub(this.buffer_r[this.bpos_r++]);
    }

    public String readString() {
        gweMysqlStringBuffer gweMysqlStringBuffer2 = new gweMysqlStringBuffer();
        int n = this.bpos_r;
        while (this.buffer_r[n] != 0) {
            gweMysqlStringBuffer2.append((char)this.buffer_r[n++]);
        }
        this.bpos_r = n + 1;
        return gweMysqlStringBuffer2.toString();
    }

    public String readLenString() {
        long l = this.readLength();
        if (l == -1L) {
            return null;
        }
        if (l == 0L) {
            return "";
        }
        gweMysqlStringBuffer gweMysqlStringBuffer2 = new gweMysqlStringBuffer((int)l);
        int n = 0;
        while ((long)n < l) {
            if (this.buffer_r[this.bpos_r] == 0) break;
            gweMysqlStringBuffer2.append((char)this.buffer_r[this.bpos_r++]);
            ++n;
        }
        return gweMysqlStringBuffer2.toString();
    }

    public boolean isLastDataPacket_r() {
        return this.packetLength_r == 1 && this.ub(this.buffer_r[0]) == 254;
    }

    public void clear_w() {
        this.bpos_w = 4;
    }

    public void send() {
        try {
            int n = this.bpos_w;
            this.bpos_w = 0;
            this.packetSequence = (byte)(this.packetSequence + 1);
            this.write3Bytes(n - 4);
            this.writeByte(this.packetSequence);
            if (this.TRACING) {
                int n2 = 0;
                while (n2 < n) {
                    System.out.print(n2 + " : " + this.ub(this.buffer_w[n2]) + "  : ");
                    if (this.buffer_w[n2] > 30) {
                        System.out.println((char)this.buffer_w[n2]);
                    } else {
                        System.out.println("");
                    }
                    ++n2;
                }
            }
            this.sout.write(this.buffer_w, 0, n);
            this.sout.flush();
        }
        catch (Exception exception) {
            System.out.println("send() Error : " + exception);
        }
    }

    public void writeByte(byte by) {
        this.buffer_w[this.bpos_w++] = by;
    }

    public void write2Bytes(int n) {
        int n2 = n % 256;
        this.buffer_w[this.bpos_w++] = (byte)n2;
        this.buffer_w[this.bpos_w++] = (byte)(n /= 256);
    }

    public void write3Bytes(int n) {
        int n2 = n % 256;
        this.buffer_w[this.bpos_w++] = (byte)n2;
        n2 = (n /= 256) % 256;
        this.buffer_w[this.bpos_w++] = (byte)n2;
        this.buffer_w[this.bpos_w++] = (byte)(n /= 256);
    }

    public void write4Bytes(long l) {
        long l2 = l % 256L;
        this.buffer_w[this.bpos_w++] = (byte)l2;
        l2 = (l /= 256L) % 256L;
        this.buffer_w[this.bpos_w++] = (byte)l2;
        l2 = (l /= 256L) % 256L;
        this.buffer_w[this.bpos_w++] = (byte)l2;
        this.buffer_w[this.bpos_w++] = (byte)(l /= 256L);
    }

    public void writeString(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.buffer_w[this.bpos_w++] = (byte)string.charAt(n2);
            ++n2;
        }
        this.buffer_w[this.bpos_w++] = 0;
    }

    /*
     * Unable to fully structure code
     */
    public void writeStringNoNull(String var1_1) {
        block3: {
            try {
                var2_2 = var1_1.getBytes(this.encoding);
                var3_4 = var2_2.length;
                System.arraycopy(var2_2, 0, this.buffer_w, this.bpos_w, var3_4);
                this.bpos_w += var3_4;
                break block3;
            }
            catch (UnsupportedEncodingException var2_3) {
                var3_5 = var1_1.length();
                var4_6 = 0;
                ** while (var4_6 < var3_5)
            }
lbl-1000:
            // 1 sources

            {
                this.buffer_w[this.bpos_w++] = (byte)var1_1.charAt(var4_6);
                ++var4_6;
                continue;
            }
        }
    }

    public void sendHeader(int n) throws gweMysqlException {
        this.bpos_w = 0;
        this.packetSequence = 0;
        this.write3Bytes(1 + n);
        this.writeByte(this.packetSequence);
        this.writeByte((byte)3);
        try {
            this.sout.write(this.buffer_w, 0, 5);
            this.sout.flush();
            this.bpos_w = 0;
        }
        catch (IOException iOException) {
            throw new gweMysqlException("gweMysqlPacket.sendHeader: " + iOException);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void writeStringNoNullandSendBuffer(String var1_1) throws gweMysqlException {
        block6: {
            try {
                var2_2 = var1_1.getBytes(this.encoding);
                var3_4 = var2_2.length;
                var4_6 = this.buffer_w.length;
                var5_8 = 0;
                while (var5_8 < var3_4) {
                    this.buffer_w[this.bpos_w++] = var2_2[var5_8];
                    if (this.bpos_w == var4_6) {
                        this.flushSendBuffer();
                    }
                    ++var5_8;
                }
                break block6;
            }
            catch (UnsupportedEncodingException var2_3) {
                var3_5 = var1_1.length();
                var4_7 = this.buffer_w.length;
                var5_9 = 0;
                ** while (var5_9 < var3_5)
            }
lbl-1000:
            // 1 sources

            {
                this.buffer_w[this.bpos_w++] = (byte)var1_1.charAt(var5_9);
                if (this.bpos_w == var4_7) {
                    this.flushSendBuffer();
                }
                ++var5_9;
                continue;
            }
        }
    }

    public void writeStringNoNullandSendBufferEx(String string) throws gweMysqlException {
        int n = string.length();
        int n2 = this.buffer_w.length;
        int n3 = 0;
        while (n3 < n) {
            this.buffer_w[this.bpos_w++] = (byte)string.charAt(n3);
            if (this.bpos_w == n2) {
                this.flushSendBuffer();
            }
            ++n3;
        }
    }

    public void flushSendBuffer() throws gweMysqlException {
        try {
            this.sout.write(this.buffer_w, 0, this.bpos_w);
            this.sout.flush();
            this.bpos_w = 0;
        }
        catch (IOException iOException) {
            throw new gweMysqlException("gweMysqlPacket.writeStringNoNullandSendBuffer: " + iOException);
        }
    }
}

