/*
 * Decompiled with CFR 0.152.
 */
package gwe.sql;

import gwe.sql.gweMysql;
import gwe.sql.gweMysqlColumn;
import gwe.sql.gweMysqlConnection;
import gwe.sql.gweMysqlResultSetBuffer;
import gwe.sql.gweMysqlResultSetCore;
import gwe.sql.gweMysqlVectorResultSet;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;

public class gweMysqlStatement
implements Statement {
    protected gweMysqlConnection connection;
    private gweMysqlResultSetBuffer result;
    private int max_field_size = 65535;
    private int max_rows = 50000000;
    private int timeout = 0;
    private int fetchDirection;
    private int fetchSize;
    private int resultSetType;
    private int resultSetConcurrency;
    private Vector batch = null;
    private boolean hasAutoIncrementValue;
    protected static final String defIncrementColName = "AUTO_INCREMENT";
    protected String autoIncrementColName;
    protected long autoIncrementValue;

    public gweMysqlStatement(gweMysqlConnection gweMysqlConnection2, int n, int n2, boolean bl) {
        this.connection = gweMysqlConnection2;
        this.resultSetType = n;
        this.resultSetConcurrency = n2;
        this.fetchDirection = 1002;
        this.fetchSize = 0;
        this.hasAutoIncrementValue = bl;
        this.autoIncrementColName = defIncrementColName;
        this.autoIncrementValue = -1L;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        this.result = null;
        this.connection.setCurResultSet(null);
        gweMysql gweMysql2 = this.connection.executeQuery(string);
        gweMysqlResultSetCore gweMysqlResultSetCore2 = new gweMysqlResultSetCore(gweMysql2, this, this.resultSetType, this.resultSetConcurrency);
        this.connection.setCurResultSet(gweMysqlResultSetCore2);
        return new gweMysqlResultSetBuffer(gweMysqlResultSetCore2);
    }

    public int executeUpdate(String string) throws SQLException {
        this.connection.setCurResultSet(null);
        long[] lArray = this.connection.executeUpdate(string);
        this.autoIncrementValue = lArray[1];
        return (int)lArray[0];
    }

    public boolean execute(String string) throws SQLException {
        this.connection.setCurResultSet(null);
        gweMysql gweMysql2 = this.connection.executeQuery(string);
        if (gweMysql2 == null) {
            this.result = null;
        } else {
            gweMysqlResultSetCore gweMysqlResultSetCore2 = new gweMysqlResultSetCore(gweMysql2, this, this.resultSetType, this.resultSetConcurrency);
            this.connection.setCurResultSet(gweMysqlResultSetCore2);
            this.result = new gweMysqlResultSetBuffer(gweMysqlResultSetCore2);
        }
        return this.result != null;
    }

    public void close() throws SQLException {
    }

    public ResultSet getResultSet() throws SQLException {
        gweMysqlResultSetBuffer gweMysqlResultSetBuffer2 = this.result;
        this.result = null;
        return gweMysqlResultSetBuffer2;
    }

    public int getUpdateCount() throws SQLException {
        return -1;
    }

    public boolean getMoreResults() throws SQLException {
        return this.result != null;
    }

    public int getMoreCounts() throws SQLException {
        return -1;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.max_field_size;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.max_field_size = n;
    }

    public int getMaxRows() throws SQLException {
        return this.max_rows;
    }

    public void setMaxRows(int n) throws SQLException {
        this.max_rows = n;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        throw new SQLException("mysql does not support escape processing.");
    }

    public int getQueryTimeout() throws SQLException {
        return this.timeout;
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.timeout = n;
    }

    public void cancel() {
    }

    public final SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public void setCursorName(String string) throws SQLException {
        throw new SQLException("mysql does not support cursors.");
    }

    public void setFetchDirection(int n) throws SQLException {
        this.fetchDirection = n;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public void setFetchSize(int n) throws SQLException {
        this.fetchSize = n;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    public int getResultSetType() throws SQLException {
        return this.resultSetType;
    }

    private void ensureBatch() {
        if (this.batch == null) {
            this.batch = new Vector();
        }
    }

    public void addBatch(String string) throws SQLException {
        this.ensureBatch();
        this.batch.addElement(string);
    }

    public void clearBatch() throws SQLException {
        this.ensureBatch();
        this.batch.removeAllElements();
    }

    public int[] executeBatch() throws SQLException {
        this.ensureBatch();
        int[] nArray = new int[this.batch.size()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = 0;
            ++n;
        }
        int n2 = 0;
        Enumeration enumeration = this.batch.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            try {
                nArray[n2] = this.executeUpdate(string);
            }
            catch (SQLException sQLException) {
                new BatchUpdateException(nArray);
            }
            ++n2;
        }
        return nArray;
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    boolean hasAutoGeneratedKey() {
        return this.hasAutoIncrementValue;
    }

    public boolean getMoreResults(int n) throws SQLException {
        throw new SQLException("mysql does not support getMoreResults(int).");
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        gweMysqlColumn[] gweMysqlColumnArray = new gweMysqlColumn[]{new gweMysqlColumn("", this.autoIncrementColName, -1, 3, -1, -1)};
        Vector vector = new Vector();
        if (this.hasAutoGeneratedKey()) {
            Vector<Long> vector2 = new Vector<Long>();
            vector2.add(new Long(this.autoIncrementValue));
            vector.add(vector2);
        }
        return new gweMysqlVectorResultSet(this.connection, gweMysqlColumnArray, vector);
    }

    public int executeUpdate(String string, int n) throws SQLException {
        this.autoIncrementColName = defIncrementColName;
        if (n == 1) {
            this.hasAutoIncrementValue = true;
        } else if (n == 2) {
            this.hasAutoIncrementValue = false;
        } else {
            throw new SQLException("Illegal argument at autoGeneratedKeys : executeUpdate(String, int).");
        }
        return this.executeUpdate(string);
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        if (nArray.length == 1 && nArray[0] == 1) {
            this.autoIncrementColName = defIncrementColName;
            this.hasAutoIncrementValue = true;
            return this.executeUpdate(string);
        }
        throw new SQLException("Illegal argument : executeUpdate(String, int[]).");
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        if (stringArray.length == 1 && stringArray[0] != null) {
            this.autoIncrementColName = stringArray[0];
            this.hasAutoIncrementValue = true;
            return this.executeUpdate(string);
        }
        throw new SQLException("Illegal argument : executeUpdate(String, String[]).");
    }

    public boolean execute(String string, int n) throws SQLException {
        this.autoIncrementColName = defIncrementColName;
        if (n == 1) {
            this.hasAutoIncrementValue = true;
            this.executeUpdate(string);
            return false;
        }
        this.hasAutoIncrementValue = false;
        return this.execute(string);
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        if (nArray.length == 1 && nArray[0] == 1) {
            this.autoIncrementColName = defIncrementColName;
            this.hasAutoIncrementValue = true;
            return this.execute(string);
        }
        throw new SQLException("Illegal argument : execute(String, int[]).");
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        if (stringArray.length == 1 && stringArray[0] != null) {
            this.autoIncrementColName = stringArray[0];
            this.hasAutoIncrementValue = true;
            return this.execute(string);
        }
        throw new SQLException("Illegal argument : execute(String, String[]).");
    }

    public int getResultSetHoldability() throws SQLException {
        throw new SQLException("mysql does not support getResultSetHoldability().");
    }
}

