/*
 * Decompiled with CFR 0.152.
 */
package gwe.sql;

import gwe.sql.gweMysqlDriver;
import gwe.sql.gweMysqlXAConnection;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class gweMysqlXADataSource
implements XADataSource,
Referenceable,
Serializable {
    private static gweMysqlDriver driver = null;
    private static final String factoryName = "gwe.sql.gweMysqlXADataSourceFactory";
    private int seconds = 0;
    private transient PrintWriter logger = null;
    private String networkProtocol = "jdbc:mysql:";
    private String serverName = "";
    private Integer portNumber = new Integer(3306);
    private String databaseName = "";
    private String dataSourceName = null;
    private String description = "";
    private String user = null;
    private String password = null;
    private String characterEncoding = "Shift_JIS";
    private Boolean add5CAfter5C = new Boolean(false);
    private Integer maxPoolSize = new Integer(0);
    private Boolean debugSQL = new Boolean(false);
    private LinkedList pool = new LinkedList();
    private ArrayList busy = new ArrayList();

    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(this.getUser(), this.getPassword());
    }

    public XAConnection getXAConnection(String string, String string2) throws SQLException {
        Properties properties = new Properties();
        properties.setProperty("user", string);
        properties.setProperty("password", string2);
        if (this.characterEncoding != null) {
            properties.setProperty("characterEncoding", this.characterEncoding);
        }
        properties.setProperty("add5CAfter5C", this.add5CAfter5C.toString());
        properties.setProperty("debugSQL", this.debugSQL.toString());
        String string3 = this.networkProtocol + "//" + this.serverName + ":" + this.portNumber + "/" + this.databaseName;
        return this.getXAConnectionSub(string3, properties);
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), factoryName, null);
        reference.add(new StringRefAddr("networkProtocol", this.getNetworkProtocol()));
        reference.add(new StringRefAddr("serverName", this.getServerName()));
        reference.add(new StringRefAddr("portNumber", this.getPortNumber().toString()));
        reference.add(new StringRefAddr("databaseName", this.getDatabaseName()));
        reference.add(new StringRefAddr("user", this.getUser()));
        reference.add(new StringRefAddr("password", this.getPassword()));
        reference.add(new StringRefAddr("characterEncoding", this.getCharacterEncoding()));
        reference.add(new StringRefAddr("add5CAfter5C", this.isAdd5CAfter5C().toString()));
        reference.add(new StringRefAddr("maxPoolSize", this.getMaxPoolSize().toString()));
        reference.add(new StringRefAddr("debugSQL", this.isDebugSQL().toString()));
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XAConnection getXAConnectionSub(String var1_1, Properties var2_2) throws SQLException {
        var3_3 = this.pool;
        synchronized (var3_3) {
            while (true) {
                block10: {
                    if (this.pool.size() > 0) break block10;
                    if (this.maxPoolSize > 0 && this.busy.size() >= this.maxPoolSize) ** GOTO lbl15
                    var4_4 = new gweMysqlXAConnection(this, gweMysqlXADataSource.driver.connect(var1_1, var2_2));
                    this.busy.add(var4_4);
                    return var4_4;
lbl-1000:
                    // 1 sources

                    {
                        try {
                            this.pool.wait();
                            continue;
                        }
                        catch (InterruptedException var4_5) {
                            throw new SQLException(var4_5.getMessage());
                        }
lbl15:
                        // 2 sources

                        ** while (this.pool.size() <= 0)
                    }
                }
                var4_4 = (gweMysqlXAConnection)this.pool.getFirst();
                this.pool.removeFirst();
                var5_6 = var4_4.getOrgConnection();
                try {
                    var5_6.setAutoCommit(false);
                    var5_6.setAutoCommit(true);
                    this.busy.add(var4_4);
                    return var4_4;
                }
                catch (SQLException var6_8) {
                    System.err.println(var6_8.getMessage());
                    try {
                        var5_6.close();
                    }
                    catch (SQLException var6_9) {
                    }
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPooledCount() {
        LinkedList linkedList = this.pool;
        synchronized (linkedList) {
            int n = this.pool.size();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sweepPooledConnections() {
        LinkedList linkedList = this.pool;
        synchronized (linkedList) {
            int n = 0;
            while (n < this.pool.size()) {
                gweMysqlXAConnection gweMysqlXAConnection2 = (gweMysqlXAConnection)this.pool.get(n);
                Connection connection = gweMysqlXAConnection2.getOrgConnection();
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ++n;
            }
            this.pool.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeConnection(gweMysqlXAConnection gweMysqlXAConnection2) {
        LinkedList linkedList = this.pool;
        synchronized (linkedList) {
            int n = this.busy.indexOf(gweMysqlXAConnection2);
            if (n >= 0) {
                this.busy.remove(n);
                this.pool.addLast(gweMysqlXAConnection2);
            }
            this.pool.notifyAll();
        }
    }

    public synchronized void println(String string) {
        if (this.logger != null) {
            this.logger.println(string);
            this.logger.flush();
        }
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.logger = printWriter;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logger;
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.seconds = n;
    }

    public int getLoginTimeout() throws SQLException {
        return this.seconds;
    }

    public void setNetworkProtocol(String string) {
        this.networkProtocol = string;
    }

    public String getNetworkProtocol() {
        return this.networkProtocol;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setPortNumber(Integer n) {
        this.portNumber = n;
    }

    public Integer getPortNumber() {
        return this.portNumber;
    }

    public void setDatabaseName(String string) {
        this.databaseName = string;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setCharacterEncoding(String string) {
        this.characterEncoding = string;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setAdd5CAfter5C(Boolean bl) {
        this.add5CAfter5C = bl;
    }

    public Boolean isAdd5CAfter5C() {
        return this.add5CAfter5C;
    }

    public void setMaxPoolSize(Integer n) {
        this.maxPoolSize = n;
    }

    public Integer getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setDebugSQL(Boolean bl) {
        this.debugSQL = bl;
    }

    public Boolean isDebugSQL() {
        return this.debugSQL;
    }

    static {
        try {
            driver = (gweMysqlDriver)Class.forName("gwe.sql.gweMysqlDriver").newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not Load Driver gwe.sql.gweMysqlDriver class");
        }
    }
}

