//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.action;

//===========================================================================
// import
//===========================================================================
import java.io.*;
import java.util.Locale;
import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.commons.logging.*;
import org.apache.struts.action.*;
import org.apache.struts.util.*;
import org.apache.struts.upload.FormFile;
import org.apache.commons.beanutils.*;

import java.util.*;
import jp.gr.java_conf.bugslife.selections.*;
import jp.gr.java_conf.bugslife.user.*;
import jp.gr.java_conf.bugslife.bug.*;
import jp.gr.java_conf.bugslife.form.*;
import jp.gr.java_conf.bugslife.util.Converter;
import jp.gr.java_conf.bugslife.system.*;
/**
 *<PRE>
 * 
 * BugDetail5ActionNX
 *
 *</PRE>
 * @version	0.0
 * @author	k 
 */
public final class BugAttachmentAction extends BaseAction 
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 * Form
	 */
	BugAttachmentForm m_form;
	/**
	 * session
	 */
	HttpSession m_session;
	/**
	 * Bug
	 */
	Bug m_bug = null;
	/**
	 * Bug
	 */
	UserInfo m_logonUser;
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//===========================================================================
// methods
//===========================================================================
	/**
	 * exevute
	 *
	 * @param mapping The ActionMapping used to select this instance
	 * @param actionForm The optional ActionForm bean for this request (if any)
	 * @param request The HTTP request we are processing
	 * @param response The HTTP response we are creating
	 *
	 * @exception Exception if business logic throws an exception
	 */
	public ActionForward doAction(ActionMapping mapping,
				 ActionForm form,
				 HttpServletRequest request,
				 HttpServletResponse response)
				throws Exception {
		
		ActionForward forward = null;
		/*
		 * 
		 */
		m_form = (BugAttachmentForm)form;	//form̎擾
		m_session = getSession(request);	//sessio̎擾
		m_logonUser = (UserInfo)getAttribute(m_session,"UserInfo");	//OC[U̎擾
		
		String action = m_form.getAction();
		//debug
		log.debug("action = " + action);
		
		//\̏ꍇ
		if (action.equals("show")){
			
			//ZbV擾
			m_bug = (Bug)m_session.getAttribute("bug");
			
			if (m_bug == null) {
				//oOCX^X̎擾
				m_bug = new Bug(m_form.getBno());
				//oOCX^X̃Zbg
				m_session.setAttribute("bug", m_bug);
			} else {
				//̏ԍvȂ
				if (m_bug.getBno() != m_form.getBno()) {
					//oOCX^X̎擾
					m_bug = new Bug(m_form.getBno());
					//oOCX^X̃Zbg
					m_session.setAttribute("bug", m_bug);
				}
			}
			
			//show֑J
			forward = mapping.findForward("show");
			
			
		//폜̏ꍇ
		} else if (action.equals("delete")) {
			
			Attachment at = Attachment.getAttachment(m_form.getAno());
			
			//t@C̍폜
			removeFile(at);
			
			at.delete(m_logonUser.getUno());		//폜
			
			m_form.setMessageKey("success.delete");
			
			//success֑J
			forward = mapping.findForward("success");
			
		//_E[h̏ꍇ
		} else if (action.equals("download")) {
			
			Attachment at = Attachment.getAttachment(m_form.getAno());
			
			//t@C̑M
			sendFile(at, response);
			
			//success֑J
			forward = mapping.findForward("success");
			
		//XV̏ꍇ
		} else {
			//ZbV擾
			m_bug = (Bug)m_session.getAttribute("bug");
			
			//`FbN
			ActionErrors errors = m_form.validate(mapping, request);
			if (!errors.empty()) {
				 saveErrors(request, errors);
				return (new ActionForward(mapping.getInput()));
			}
			
			//
			//Ytt@C̍쐬
			//
			Attachment at = new Attachment();
			
			//bno
			at.setBno(m_bug.getBno());
			
			//t@C擾B
			FormFile file = m_form.getFile();
			
			//t@C^Cv̌
			byte type = checkFileType(m_form.getFileType(), file.getFileName());
			at.setFileType(type);
			
			//mime type 
			//t@C^CvZbgmimetypeIɃZbg邪A
			//^Cv̑ł΁Aw肳ꂽMIME_TYPEZbg
			if (type == Attachment.TYPE_OTHER) {
				at.setMimeType(m_form.getMimeType());
			}
			//t@C
			at.setFileName(file.getFileName());
			//TCY
			at.setSize(file.getFileSize());
			//t
			at.setInfo(m_form.getInfo());
			
			at.insert(m_logonUser.getUno());		//ǉ
			
			//Ńt@Cԍm肷̂ŁAt@CۑB
			
			saveFile(at, file);
			
			//tH[̓eZbgB
			m_form.reset(mapping, request);
			
			m_form.setMessageKey("success.upload");
			
			//success֑J
			forward = mapping.findForward("success");
			
		}
		//oOCX^X̃Zbg
		m_session.setAttribute("bug", m_bug);
		
		// Forward control to the specified success URI
		return forward;
	}
	/**
	 * t@C̍폜
	 */
	private void removeFile(Attachment at) {
		
		//t@C
		Sysconf sysconf = Sysconf.getSysconf();
		String path = sysconf.getAttachPath() + "file" + at.getAnoString() + ".arc";
		
		//debug
		log.debug("path = " + path);
		
		File file = new File(path);
		if (! file.delete()) {
			throw new BLRuntimeException("attachment file delete error file = "+ file);
		}
	}
	/**
	 * t@C̕ۑ
	 */
	private void saveFile(Attachment at, FormFile file) {
		
		try {
			InputStream in = file.getInputStream();
			
			//t@C
			Sysconf sysconf = Sysconf.getSysconf();
			String path = sysconf.getAttachPath() + "file" + at.getAnoString() + ".arc";
			
			//debug
			log.debug("path = " + path);
			
			//write the file to the file specified
			OutputStream out = new FileOutputStream(path);
			int bytesRead = 0;
			byte[] buffer = new byte[8192];
			while ((bytesRead = in.read(buffer, 0, 8192)) != -1) {
				out.write(buffer, 0, bytesRead);
			}
			out.close();
			in.close();
		} catch (IOException ioe) {
			throw new BLRuntimeException("attachment file save error", ioe);
		}
	}
	/**
	 * t@C̓ǂݍ
	 *
	 * ȉURLQ
	 * http://www.rfs.jp/sitebuilder/perl/03/01_02.html
	 * http://www.studyinghttp.net/headers.html
	 */
	private void sendFile(Attachment at, HttpServletResponse response) {
		
		InputStream in = null;
		ServletOutputStream out =  null;
		try {
			
			response.setContentType(at.getMimeType());
			String fileName = new String(at.getFileName().getBytes(), "ISO-8859-1");
//			response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
			response.setHeader("Content-Disposition", "inline; filename=" + fileName);
			
			out = response.getOutputStream();
			
			//t@C
			Sysconf sysconf = Sysconf.getSysconf();
			String path = sysconf.getAttachPath() + "file" + at.getAnoString() + ".arc";
			
			//debug
			log.debug("path = " + path);
			
			//write the file to the file specified
			in = new FileInputStream(path);
			
			int bytesRead = 0;
			byte[] buffer = new byte[8192];
			while ((bytesRead = in.read(buffer, 0, 8192)) != -1) {
				out.write(buffer, 0, bytesRead);
			}
			out.flush();
			in.close();
		} catch (IOException ioe) {
			if (out != null) {
				try {
					out.close();
					response.resetBuffer();
				} catch (IOException ioee) {
					//
				}
			}
			throw new BLRuntimeException("attachment file read error", ioe);
		} finally {
			if (in != null) {
				try {
					in.close();
				} catch (IOException ioe) {
					//
				}
			}
		}
	}
	/**
	 * t@C^Cv̌
	 *
	 */
	private byte checkFileType(String typeString, String fileName) {
		
		byte type = Byte.parseByte(typeString);
		
		//oCȉꍇAt@C̊gqăt@C^Cv肷
		if (type == Attachment.TYPE_BINARY) {
			
			//gqT
			int extPos = fileName.lastIndexOf(".");
			//t@C̊gq
			if (extPos != -1) {
				String ext = fileName.substring(extPos + 1);
				if (ext.equalsIgnoreCase("doc")) {
					type = Attachment.TYPE_WORD;
				} else if (ext.equalsIgnoreCase("xls")) {
					type = Attachment.TYPE_EXEL;
				} else if (ext.equalsIgnoreCase("zip")) {
					type = Attachment.TYPE_ZIP;
				} else if (ext.equalsIgnoreCase("lzh")) {
					type = Attachment.TYPE_LZH;
				} else if (ext.equalsIgnoreCase("gif")) {
					type = Attachment.TYPE_GIF;
				} else if (ext.equalsIgnoreCase("jpg")) {
					type = Attachment.TYPE_JPEG;
				} else if (ext.equalsIgnoreCase("jpeg")) {
					type = Attachment.TYPE_JPEG;
				} else if (ext.equalsIgnoreCase("log")) {
					type = Attachment.TYPE_TEXT;
				} else if (ext.equalsIgnoreCase("csv")) {
					type = Attachment.TYPE_TEXT;
				} else if (ext.equalsIgnoreCase("txt")) {
					type = Attachment.TYPE_TEXT;
				}
			}
		}
		
		return type;
	}
}
