//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.action;

//===========================================================================
// import
//===========================================================================
import java.io.IOException;
import java.util.Locale;
import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.commons.logging.*;
import org.apache.struts.action.*;
import org.apache.struts.util.*;
import org.apache.commons.beanutils.*;

import java.util.*;

import jp.gr.java_conf.bugslife.user.*;
import jp.gr.java_conf.bugslife.selections.*;
import jp.gr.java_conf.bugslife.form.*;
/**
 *<PRE>
 * 
 * SelectionListActionNX
 *
 *</PRE>
 * @version	0.0
 * @author	k 
 */
public final class SelectionListAction extends BaseAction 
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//===========================================================================
// methods
//===========================================================================
	/**
	 * exevute
	 *
	 * @param mapping The ActionMapping used to select this instance
	 * @param actionForm The optional ActionForm bean for this request (if any)
	 * @param request The HTTP request we are processing
	 * @param response The HTTP response we are creating
	 *
	 * @exception Exception if business logic throws an exception
	 */
	public ActionForward doAction(ActionMapping mapping,
				 ActionForm form,
				 HttpServletRequest request,
				 HttpServletResponse response)
				throws Exception {
		
		/*  
		 */
		HttpSession session = getSession(request);	//sessio̎擾
		UserInfo user = (UserInfo)getAttribute(session,"UserInfo");	//OC[U̎擾
		ActionForward forward = null;
		SelectionListForm myForm = (SelectionListForm)form;
		
		//f[^`FbN
		ActionErrors errors = myForm.validate(mapping, request);
		if (!errors.empty()) {
			saveErrors(request, errors);
			return (new ActionForward(mapping.getInput()));
		}
		
		String action = myForm.getAction();
		
		//Xg\
		String tableName = myForm.getTableName();
		//e[umO
		SelectionControl sc = null;
		if ( tableName == null) {
			sc = new SelectionControl();
		//e[um
		} else {
			sc = new SelectionControl(tableName);
		}
		//ZNVZbVɃZbg
		session.setAttribute("selectionControl", sc);
		//ZNVXgZbVɃZbg
		request.setAttribute("selectionList", sc.getCollection());
		
		
		//forward
		return mapping.findForward("success");
	}
}
