//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.bug;

//===========================================================================
// import
//===========================================================================
// Java core API
import java.util.*;
import java.text.*;
import org.apache.commons.logging.*;

// DB API
import jp.gr.java_conf.bugslife.db.*;

// Util API
import jp.gr.java_conf.bugslife.util.*;
import jp.gr.java_conf.bugslife.user.*;
import jp.gr.java_conf.bugslife.system.*;


/**
 *<PRE>
 * 
 * AttachmentNX
 * 
 *</PRE>
 * @version	0.0, 2001/09/10
 * @author	k@
 */
//===========================================================================
public class Attachment implements IUpdatable, ILoadable
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 *	A^b`gԍ
	 */
	private int m_ano = 0;
	/**
	 *	oOԍ
	 */
	private int m_bno = 0;
	/**
	 *	t@C^Cv
	 */
	private byte m_fileType;
	public static final byte TYPE_TEXT = 1;		//TEXT
	public static final byte TYPE_WORD = 2;		//WORD
	public static final byte TYPE_EXEL = 3;		//EXEL
	public static final byte TYPE_ZIP = 4;		//ZIP
	public static final byte TYPE_LZH = 5;		//LZH
	public static final byte TYPE_GIF = 6;		//GIF
	public static final byte TYPE_JPEG = 7;		//JPEG
	public static final byte TYPE_BINARY = 8;	//oCi
	public static final byte TYPE_OTHER = 9;	//OTHER
	/**
	 *	t@C^Cv
	 */
	public static final String[] TYPE_NAMES = {
		"", "text", "Word", "Exel", "Zip","Lzh","Gif","Jpeg","oCi","̑"};
							
	/**
	 *	MIME^Cv
	 */
	private String m_mimeType = null;
	public static final String[] MIME_TYPES = {
										"", 
										"text/plain",
										"application/msword",
										"application/vnd.ms-excel",
										"application/x-zip-compress",
										"application/lzh",
										"image/gif",
										"image/jpeg",
//										"application/octet-stream",
										"application/unknown",
										"",
										};
	/**
	 *	t@C
	 */
	private String m_fileName = null;
	/**
	 *	t@CTCY
	 */
	private int m_size;
	/**
	 *	őt@CTCY
	 */
	public static final int MAX_SIZE = 3 * 1024 * 1024;		//3M
	/**
	 *	
	 */
	private String m_info = null;
	/**
	 *	XV
	 */
	private int m_updateUno = 0;
	/**
	 *	XVҖ
	 */
	private String m_updateUname;
	/**
	 *	XV
	 */
	private Date m_updateDate;
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//=====================================
// DBpڒ`
//=====================================
	/**
	 * r
	 */
	private static final boolean EXCLUSION = true;	//
	/**
	 * AutoIncrement
	 */
	private static final boolean ATOINCREMENT = true;	//Ȃ
	/**
	 * PK 
	 */
	private static final String[] PK = {"ano"};
	/**
	 * XVږ
	 */
	private static final String[] DB_ITEMS = {
									"bno","fileType",
									"mimeType","fileName","info","size",
									"updateUno" };
//===========================================================================
// methods
//===========================================================================
	/**
	 *	ftHgRXgN^
	 *
	 */
	public Attachment()
	{
		
	}
//======================================
// db access methods
//======================================
	/**
	 *	insertDB
	 *
	 * @return	
	 */
	public void insert(int updateUno)
	{
		setUpdateUno(updateUno);
		setUpdateDate(new Date());
		int ano = DAO.insert(this);
		setAno(ano);
	}
	/**
	 *	delete
	 *
	 * @return	
	 */
	public void delete(int updateUno)
	{
		setUpdateUno(updateUno);
		DAO.delete(this);
	}
	/**
	 *	load
	 *
	 * @return	
	 */
	public void load()
	{
		DAO.load(this);
	}
	/**
	 *	findAll
	 *
	 * @return	
	 */
	public static Collection findAll()
	{
		return DAO.findAll(new Attachment());
	}
	/**
	 *	Attachment̎擾ioOԍwj
	 *
	 * @return	
	 */
	public static Attachment getAttachment(int ano)
	{
		String sql = 
		"SELECT" +
		" A.ano as ano," +
		" A.bno as bno," +
		" A.fileType as fileType," +
		" A.fileName as fileName," +
		" A.mimeType as mimeType," +
		" A.info as info," +
		" A.size as size," +
		" A.updateUno as updateUno," +
		" A.updateDate as updateDate," +
		" B.nickname as updateUname" +
		" FROM Attachment AS A" +
		" LEFT JOIN UserInfo AS B ON A.updateUno = B.uno" +
		" WHERE A.ano = ?";
		
		ArrayList params = new ArrayList();
		params.add(new Integer(ano));
		
		Attachment at = null;
		Collection list = DAO.find(new Attachment(), sql, params);
		if ((list != null) && (list.size() != 0)) {
			at = (Attachment)list.iterator().next();
		}
		
		return at;
	}
	/**
	 *	Attachment̎擾ioOԍwj
	 *
	 * @return	
	 */
	public static Collection getAttachmentByBno(int bno)
	{
		String sql = 
		"SELECT" +
		" A.ano as ano," +
		" A.bno as bno," +
		" A.fileType as fileType," +
		" A.fileName as fileName," +
		" A.mimeType as mimeType," +
		" A.info as info," +
		" A.size as size," +
		" A.updateUno as updateUno," +
		" A.updateDate as updateDate," +
		" B.nickname as updateUname" +
		" FROM Attachment AS A" +
		" LEFT JOIN UserInfo AS B ON A.updateUno = B.uno" +
		" WHERE A.bno = ?" +
		" ORDER BY A.ano";
		
		ArrayList params = new ArrayList();
		params.add(new Integer(bno));
		
		return( DAO.find(new Attachment(), sql, params));
	}
	/**
	 *	Attachment̐
	 *
	 * @return	
	 */
/*-----------------------------------------
	public static Attachment createAttachment(int bno, int uno)
	{
		Attachment cc = new Attachment();
		cc.setBno(bno);
		cc.setUno(uno);
		UserInfo user = UserInfo.getUser(uno);
		cc.setNickname(user.getNickname());
		cc.setEmail(user.getEmail());
		
		return cc;
		
	}
-----------------------------------------*/
//======================================
// Db Interface
//======================================
	/**
	 * 
	 */
	public String[] getUpdateItemNames() {
		
		return DB_ITEMS;
		
	}
	/**
	 * PK items
	 */
	 public String[] getPKItems() {
		return PK;
	}
	/**
	 * r䂠Ȃ
	 */
	public boolean isExclusion() {
		return EXCLUSION;
	}
	/**
	 * AutoIncrementȂ
	 */
	public boolean isAutoIncrement() {
		return ATOINCREMENT;
	}
//======================================
// request param
//======================================
	/**
	 *	request parametor̐
	 */
	public Map getMapping() {
		HashMap map = new HashMap();
		map.put("ano", new Integer(m_ano));
		return map;
	}
//======================================
// Property
//======================================
	/**
	 * A^b`gԍ̎擾
	 * 
	 * @return A^b`gԍ
	 */
	public int getAno()
	{
		return m_ano;
	}
	/**
	 * A^b`gԍ̎擾()
	 * 
	 * @return A^b`gԍ
	 */
	public String getAnoString()
	{
		return Converter.getNumberString(m_ano, "0000");
	}
	/**
	 * A^b`gԍ̃Zbg
	 * 
	 * @param ano A^b`gԍ
	 */
	public void setAno(int ano)
	{
		m_ano = ano;
	}
	/**
	 * oOԍ̎擾
	 * 
	 * @return oOԍ
	 */
	public int getBno()
	{
		return m_bno;
	}
	/**
	 * oOԍ̃Zbg
	 * 
	 * @param bno oOԍ
	 */
	public void setBno(int bno)
	{
		m_bno = bno;
	}
	/**
	 * t@C^Cv̎擾
	 * 
	 * @return t@C^Cv
	 */
	public byte getFileType()
	{
		return m_fileType;
	}
	/**
	 * t@C^Cv̎擾()
	 * 
	 * @return t@C^Cv
	 */
	public String getFileTypeString()
	{
		return TYPE_NAMES[m_fileType];
	}
	/**
	 * t@C^CṽZbg
	 * 
	 * @param fileType t@C^Cv
	 */
	public void setFileType(byte fileType)
	{
		m_fileType = fileType;
		//̃^C~OMIME-TYPEݒ肷
		m_mimeType = MIME_TYPES[m_fileType];
	}
	/**
	 * MIME^Cv̎擾
	 * 
	 * @return MIME^Cv
	 */
	public String getMimeType()
	{
		return m_mimeType;
	}
	/**
	 * MIME^CṽZbg
	 * 
	 * @param mimeType MIME^Cv
	 */
	public void setMimeType(String mimeType)
	{
		m_mimeType = mimeType;
	}
	/**
	 * t@C̎擾
	 * 
	 * @return t@C
	 */
	public String getFileName()
	{
		return m_fileName;
	}
	/**
	 * t@C̃Zbg
	 * 
	 * @param fileName t@C
	 */
	public void setFileName(String fileName)
	{
		m_fileName = fileName;
	}
	/**
	 * t@CTCY̎擾
	 * 
	 * @return t@CTCY
	 */
	public int getSize()
	{
		return m_size;
	}
	/**
	 * t@CTCY̎擾()
	 * 
	 * @return t@CTCY
	 */
	public String getSizeString()
	{
		int Mbytes = 1024 * 1024;
		int Kbytes = 1024;
		
		String s = null;
		if (m_size > Mbytes) {
			s = (m_size / Mbytes) + "M";
		} else if (m_size > Kbytes) {
			s = (m_size / Kbytes) + "K";
		} else {
			s = m_size + "";
		}
		return s;
	}
	/**
	 * t@CTCỸZbg
	 * 
	 * @param size t@CTCY
	 */
	public void setSize(int size)
	{
		m_size = size;
	}
	/**
	 * ̎擾
	 * 
	 * @return 
	 */
	public String getInfo()
	{
		return m_info;
	}
	/**
	 * ̃Zbg
	 * 
	 * @param info 
	 */
	public void setInfo(String info)
	{
		m_info = info;
	}
	/**
	 * XV҂̎擾
	 * 
	 * @return XV
	 */
	public int getUpdateUno()
	{
		return m_updateUno;
	}
	/**
	 * XVҖ̎擾
	 * 
	 * @return XVҖ
	 */
	public String getUpdateUname()
	{
		return m_updateUname;
	}
	/**
	 * XVҖ̃Zbg
	 * 
	 * @param updateUname XVҖ
	 */
	public void setUpdateUname(String updateUname)
	{
		m_updateUname = updateUname;
	}
	/**
	 * XV҂̃Zbg
	 * 
	 * @param updateUno XV
	 */
	public void setUpdateUno(int updateUno)
	{
		m_updateUno = updateUno;
	}
	/**
	 *	XV̎擾
	 *
	 * @return	update		XV
	 */
	public Date getUpdateDate()
	{
		return m_updateDate;
	}
	/**
	 *	XV̎擾
	 *
	 * @return	update		XV
	 */
	public String getUpdateDateString()
	{
		return Converter.getDateString(m_updateDate, Converter.MMDDHHMM);
	}
	/**
	 *	XṼZbg
	 *
	 * @return	update		XV
	 */
	public void setUpdateDate(Date date)
	{
		m_updateDate = date;
	}
//===========================================================================
// methods
//===========================================================================
	/**
	 *	NX
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		sb.append("--- [Attachment] --- \n");
		sb.append("ano       : " + m_ano + "\n");
		sb.append("bno       : " + m_bno + "\n");
		sb.append("fileType  : " + m_fileType + "\n");
		sb.append("mimeType  : " + m_mimeType + "\n");
		sb.append("fileName  : " + m_fileName + "\n");
		sb.append("size      : " + m_size + "\n");
		sb.append("info      : " + m_info + "\n");
		sb.append("updateUno : " + m_updateUno + "\n");
		sb.append("updateUname : " + m_updateUname + "\n");
		sb.append("updateDate: " + getUpdateDateString() + "\n");
		sb.append("--- [Attachment] --- \n");
		return sb.toString();
	}
//===========================================================================
// test code
//===========================================================================
	/**
	 *	eXgC
	 */
	public static void main(String[] args)
	{
		System.out.println("------- << Attachment Test Start >> -----------");
		unitTest1();	//VK쐬eXg
		unitTest2();	//폜eXg
		unitTest3();	//R[hwRXgNgeXg
		
		System.out.println("------- << Attachment Test End >> -----------");
	}
	
	/**
	 *	unitTest1
	 *
	 * VK쐬eXg
	 *
	 */
	public static void unitTest1()
	{
		System.out.println("------- unitTest1 -----------");
		
		//l̃Zbg
		Attachment at = new Attachment();
		
		for (int i = 1; i < 10; i++) {
			at.setBno(1);
			at.setFileType((byte)i);
			at.setFileName(at.getFileTypeString() + " file" );
			at.setInfo(at.getFileTypeString() + " Info" );
			at.insert(1);					//ǉ
		}
		//\
		display(Attachment.getAttachmentByBno(1));
		
	}
	/**
	 *	unitTest2
	 *
	 * 폜eXg
	 *
	 */
	public static void unitTest2()
	{
		System.out.println("------- unitTest2 -----------");
		
		//݃`FbN
		Attachment at = Attachment.getAttachment(2);
		if (at == null) {
			//݂ĂȂeXg~
			throw new Error("target is nothing");
		}
		
		at.delete(2);		//폜
		
		//݃`FbN
		at = Attachment.getAttachment(2);
		if (at != null) {
			//݂ĂȂeXg~
			throw new Error("delete failer");
		}
	}
	/**
	 *	unitTest3
	 *
	 * t@Cԍw
	 *
	 */
	public static void unitTest3()
	{
		System.out.println("------- unitTest3 -----------");
		
		Attachment at = Attachment.getAttachment(1);
		
		System.out.println(at.toString());
		
		
	}
	/**
	 * Xg̕\
	 *
	 */
	private static void display(Collection list)
	{
		Iterator ite = list.iterator();
		
		while(ite.hasNext()) {
			Attachment at = (Attachment)ite.next();
			
			System.out.println(at.toString());
		}
	}
}