//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.bug;

//===========================================================================
// import
//===========================================================================
// Java core API
import java.util.*;
import java.text.*;
import org.apache.commons.logging.*;

// DB API
import jp.gr.java_conf.bugslife.db.*;

// Util API
import jp.gr.java_conf.bugslife.util.*;
import jp.gr.java_conf.bugslife.selections.*;
import jp.gr.java_conf.bugslife.user.*;
import jp.gr.java_conf.bugslife.system.*;


/**
 *<PRE>
 * 
 * BugNX
 * 
 *</PRE>
 * @version	0.0, 2001/09/10
 * @author	k@
 */
//===========================================================================
public class Bug implements IUpdatable, ILoadable
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 *	oOԍ
	 */
	private int m_bno = 0;
	/**
	 *	oOhc
	 */
	private String m_bid = null;
	/**
	 *	^Cg
	 */
	private String m_title = null;
	/**
	 *	
	 */
	private String m_location = null;
	/**
	 *	TuVXe
	 */
	private String m_subsystem = null;
	/**
	 *	@\
	 */
	private String m_functionName = null;
	/**
	 *	
	 */
	private String m_screen = null;
	/**
	 *	uEU
	 */
	private String m_browser = null;
	/**
	 *	nr
	 */
	private String m_os = null;
	/**
	 *	ID
	 */
	private String m_tid = null;
	/**
	 *	`oo[W
	 */
	private String m_appVersion = null;
	/**
	 *	cao[W
	 */
	private String m_dbVersion = null;
	/**
	 *	gslko[W
	 */
	private String m_htmlVersion = null;
	/**
	 *	dlo[W
	 */
	private String m_specVersion = null;
	/**
	 *	s
	 */
	private int m_issuer = 0;
	/**
	 *	sҖ
	 */
	private String m_issuerName = null;
	/**
	 *	
	 */
	private Date m_issuDate = null;
	/**
	 *	o^
	 */
	private Date m_registDate = null;
	/**
	 *	̏x
	 */
	private String m_severity = null;
	/**
	 *	̏x()
	 */
	private String m_severityString = null;
	/**
	 *	Dx
	 */
	private String m_priority = null;
	/**
	 *	Dx()
	 */
	private String m_priorityString = null;
	/**
	 *	Xe[^X
	 */
	private byte m_status = STS_UNCONFIRMED;	//mF
	/**
	 *	Xe[^X
	 */
	private String m_statusWhitebord = null;
	/**
	 *	Ώ@
	 */
	private String m_resolution = null;
	/**
	 *	Ώ@
	 */
	private String m_resolutionString = null;
	/**
	 *	}CXg[
	 */
	private String m_milestone = null;
	/**
	 *	}CXg[()
	 */
	private String m_milestoneString = null;
	/**
	 *	dlύXID
	 */
	private String m_scid = null;
	/**
	 *	L[[hP
	 */
	private String m_keyword1 = null;
	/**
	 *	L[[hQ
	 */
	private String m_keyword2 = null;
	/**
	 *	L[[hR
	 */
	private String m_keyword3 = null;
	/**
	 *	R|[lgP
	 */
	private String m_cpid1 = null;
	/**
	 *	R|[lgQ
	 */
	private String m_cpid2 = null;
	/**
	 *	R|[lgR
	 */
	private String m_cpid3 = null;
	/**
	 *	R|[lgS
	 */
	private String m_cpid4 = null;
	/**
	 *	R|[lgT
	 */
	private String m_cpid5 = null;
	/**
	 *	֘AhLg
	 */
	private String m_reletedDoc = null;
	/**
	 *	F
	 */
	private int m_auther = 0;
	/**
	 *	FҖ
	 */
	private String m_autherName = null;
	/**
	 *	F
	 */
	private Date m_authDate = null;
	/**
	 *	G[e
	 */
	private String m_errorType = null;
	/**
	 *	G[
	 */
	private String m_errorCause = null;
	/**
	 *	G[@\ӏ
	 */
	private String m_errorPoint = null;
	/**
	 *	G[EoH
	 */
	private String m_issuPno = null;
	/**
	 *	G[H
	 */
	private String m_trainPno = null;
	/**
	 *	EoׂH
	 */
	private String m_shouldFindPno = null;
	/**
	 *	EoxR
	 */
	private String m_errorDelayReason = null;
	/**
	 *	񋟗\
	 */
	private Date m_releaseSchDate = null;
	/**
	 *	͎
	 */
	private int m_analyst = 0;
	/**
	 *	͎Җ
	 */
	private String m_analystName = null;
	/**
	 *	͓
	 */
	private Date m_analizeDate = null;
	/**
	 *	C\[X
	 */
	private String m_updateSrc = null;
	/**
	 *	ChLg
	 */
	private String m_updateDoc = null;
	/**
	 *	Ώ
	 */
	private int m_updater = 0;
	/**
	 *	ΏҖ
	 */
	private String m_updaterName = null;
	/**
	 *	Ώ
	 */
	private Date m_bugUpdateDate = null;
	/**
	 *	
	 */
	private Date m_releaseDate = null;
	/**
	 *	mF
	 */
	private int m_comfirmer = 0;
	/**
	 *	mFҖ
	 */
	private String m_comfirmerName = null;
	/**
	 *	mF
	 */
	private Date m_comfirmDate = null;
	/**
	 *	bZ[WID(7/5)
	 */
	private String m_messageId = null;
	/**
	 *	ŏIXV
	 */
	private int m_updateUno = 0;
	/**
	 *	XV
	 */
	private Date m_updateDate = new Date();
	/**
	 *	ۑ
	 */
	private Date m_persistDate;
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//=====================================
// OTHER DB ITEMS
//=====================================
	/**
	 *	ǉ
	 */
//	private Collection m_allAddText = null;
	private ArrayList m_allAddText = null;
	/**
	 *	ǉ񂠂Ȃ(7/5)
	 */
	private boolean m_addTextEnable = false;
	/**
	 *	֘AoOԍRNV
	 */
	private Collection m_reletedBug = null;
	/**
	 *	CCRNV
	 */
	private Collection m_cc = null;
	/**
	 *	͏^Cv(7/5)
	 */
	private byte m_inputType = ITYPE_DETAIL0;
	/** VK */
	public static final byte ITYPE_DETAIL0 = 1;
	/** ̏ */
	public static final byte ITYPE_DETAIL1 = 2;
	/** j */
	public static final byte ITYPE_DETAIL2 = 3;
	/**  */
	public static final byte ITYPE_DETAIL3 = 4;
	/** u */
	public static final byte ITYPE_DETAIL4 = 5;
	/** mF */
	public static final byte ITYPE_DETAIL5 = 6;
	/**
	 *	SҔԍ(7/5)
	 */
	private int m_dispatch = 0;
	/**
	 *	SҖ(7/5)
	 */
	private UserInfo m_dispatchUser = null;
	/**
	 * Z^Cg
	 */
	public static final int SHORT_TITLE_LEN = 20;
	
//=====================================
// 萔`
//=====================================
	/** mF */
	public static final byte STS_UNCONFIRMED = 0;
	/** VK */
	public static final byte STS_NEW = 1;
	/** SҊ蓖 */
	public static final byte STS_DISPATCH = 2;
	/** ͒ */
	public static final byte STS_INVESTIGATION = 3;
	/** C */
	public static final byte STS_REPAIRED = 4;
	/** mF */
	public static final byte STS_RESOLVED = 5;
	/** ĊJ */
	public static final byte STS_REOPEN = 6;
	/** mFς */
	public static final byte STS_VERIFIED = 7;
	/**  */
	public static final byte STS_CLOSE = 8;
//=====================================
// ̑ڒ`
//=====================================
	/**
	 * activitys
	 */
	private Activitys m_activitys = null;
	/**
	 * activity
	 */
	private boolean m_activity = false;
//=====================================
// DBpڒ`
//=====================================
	/**
	 * r
	 */
	private boolean EXCLUSION = true;	//
	/**
	 * AutoIncrement
	 */
	private static final boolean ATOINCREMENT = true;	//
	/**
	 * PK 
	 */
	private static final String[] PK = {"bno"};
	/**
	 * XVږ
	 */
	private static final String[] DB_ITEMS = {
	"bid", "title","location","subsystem","functionName","screen",
	"browser","os","tid","appVersion","dbVersion",
	"htmlVersion","specVersion","issuer","issuDate","registDate",
	"severity","priority","status","statusWhitebord",
	"resolution","milestone","scid",
	"keyword1","keyword2","keyword3",
	"cpid1","cpid2","cpid3","cpid4","cpid5",
	"reletedDoc","auther","authDate",
	"errorType","errorCause","errorPoint",
	"issuPno","trainPno","shouldFindPno","errorDelayReason",
	"releaseSchDate","analyst","analizeDate","updateDoc","updateSrc",
	"updater","bugUpdateDate","releaseDate","comfirmer",
	"comfirmDate","messageId","updateUno", "persistDate",
	//8/30 ǉ
	"dispatch" 
	};
//===========================================================================
// methods
//===========================================================================
	/**
	 *	ftHgRXgN^
	 *
	 */
	public Bug()
	{
		
	}
	/**
	 *	RXgN^(R[hwj
	 *
	 * @param	 code		String^
	 */
	public Bug(int bno)
	{
		setBno(bno);
		
		load();
		
	}
//======================================
// db access methods
//======================================
	/**
	 *	insertDB
	 *
	 * @return	
	 */
	public void insert(int uno)
	{
		setUpdateUno(uno);
		setPersistDate(new Date());
		
		int bno = DAO.insert(this);
		setBno(bno);
		
		//ŏIXV̂ݍĎ擾
		m_updateDate = BugFinder.getUpdateDate(bno);
		
//		load();
	}
	/**
	 *	update(W)r䂠
	 *
	 * @return	
	 */
	public void update(int uno)
	{
		update(uno, true);
	}
	/**
	 *	update(rI)
	 *
	 * @return	
	 */
	public void update(int uno, boolean exclusion)
	{
		setUpdateUno(uno);
		setPersistDate(new Date());
		//debug
//		log.debug("bno = " + m_bno + " update = " + getUpdateDateString());
		EXCLUSION = exclusion;
		
		DAO.update(this);
		
		//ŏIXV̂ݍĎ擾
		m_updateDate = BugFinder.getUpdateDate(m_bno);
		//debug
//		log.debug("update:updateDate = " + m_updateDate);
		
//		load();
	}
	/**
	 *	delete
	 *
	 * @return	
	 */
	public void delete(int updateUno)
	{
		setUpdateUno(updateUno);
		DAO.delete(this);
	}
	/**
	 *	load
	 *
	 * @return	
	 */
	public void load()
	{
		DAO.load(this);
	}
	/**
	 *	findAll
	 *
	 * @return	
	 */
	public static Collection findAll()
	{
		return DAO.findAll(new Bug());
	}
	/**
	 *	Bug̎擾iR[hwj
	 *
	 * @return	
	 */
	public static Bug getBug(int bno)
	{
		String sql = "SELECT * FROM Bug WHERE bno = ?";
		ArrayList params = new ArrayList();
		params.add(new Integer(bno));
		
		ArrayList list = DAO.find(new Bug(), sql, params);
		
		Bug bug = null;
		if ((list != null) && (list.size() > 0)) {
			bug = (Bug)list.get(0);
		}
		return bug;
	}
//======================================
// Db Interface
//======================================
	/**
	 * 
	 */
	public String[] getUpdateItemNames() {
		
		return DB_ITEMS;
		
	}
	/**
	 * PK items
	 */
	 public String[] getPKItems() {
		return PK;
	}
	/**
	 * r䂠Ȃ
	 */
	public boolean isExclusion() {
		return EXCLUSION;
	}
	/**
	 * AutoIncrementȂ
	 */
	public boolean isAutoIncrement() {
		return ATOINCREMENT;
	}
//======================================
// request param
//======================================
	/**
	 *	request parametor̐
	 */
	public Map getMapping() {
		HashMap map = new HashMap();
		map.put("bno", new Integer(m_bno));
		return map;
	}
//======================================
// Property
//======================================
	/**
	 * oOԍ̎擾
	 * 
	 * @return oOԍ
	 */
	public int getBno()
	{
		return m_bno;
	}
	/**
	 * oOԍ̎擾()
	 * 
	 * @return oOԍ
	 */
	public String getBnoString()
	{
		String s = null;
		if (m_bno == 0) {
			s = "#";
		} else {
			s = Converter.getNumberString(m_bno, "0000");
		}
		return s;
	}
	/**
	 * oOԍ̃Zbg
	 * 
	 * @param bno oOԍ
	 */
	public void setBno(int bno)
	{
		m_bno = bno;
	}
	/**
	 * oOID̎擾
	 * 
	 * @return oOID
	 */
	public String getBid()
	{
		return m_bid;
	}
	/**
	 * oOID̃Zbg
	 * 
	 * @param bid oOID
	 */
	public void setBid(String bid)
	{
		//activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullString(m_bid);
			String newVal = nullString(bid);
			//vH
			if (! oldVal.equals(newVal)) {
				
				addActivity(BugItem.BID, oldVal, newVal);
			}
		}
		m_bid = bid;
	}
	/**
	 * oOID̐
	 * 
	 * @param sysid VXehc
	 */
	public void makeBid(String sysid)
	{
		StringBuffer sb = new StringBuffer();
		sb.append(sysid);
		sb.append("-");
		sb.append(ProcessName.getProcessName(m_issuPno).getShortName());
		sb.append("-");
		sb.append(getBnoString());
		setBid(new String(sb));
		
	}
	/**
	 * ^Cg̎擾
	 * 
	 * @return ^Cg
	 */
	public String getTitle()
	{
		return m_title;
	}
	/**
	 * ^Cg̎擾(Z)
	 * 
	 * @return ^Cg
	 */
	public String getShortTitle()
	{
	    String ret = m_title;
	    if (m_title != null) {
	        if (m_title.length() > SHORT_TITLE_LEN) {
	            ret = m_title.substring(0,SHORT_TITLE_LEN-3) + "...";
	        }
	    }
		return ret;
	}
	/**
	 * ^Cg̃Zbg
	 * 
	 * @param title ^Cg
	 */
	public void setTitle(String title)
	{
	    
		//VKȊO̎ɍ
		if (m_bno != 0) {
			//activity擾H
			if (isActivity()) {
				//nullϊ
				String oldVal = nullString(m_title);
				String newVal = nullString(title);
				//vH
				if (! oldVal.equals(newVal)) {
					
					addActivity(BugItem.TITLE, oldVal, newVal);
				}
			}
		}
		m_title = title;
	}
	/**
	 * ̎擾
	 * 
	 * @return 
	 */
	public String getLocation()
	{
		return m_location;
	}
	/**
	 * ̃Zbg
	 * 
	 * @param location 
	 */
	public void setLocation(String location)
	{
		//activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullCode(m_location);
			String newVal = nullCode(location);
			//vH
			if (! oldVal.equals(newVal)) {
				//ȂΗĂ
				String oldValString = new Location(oldVal).getShortName();
				String newValString = new Location(newVal).getShortName();
				//debug 
//				log.debug("old location = " + oldVal + ":" + oldValString );
//				log.debug("new location = " + newVal + ":" + newValString );
				
				addActivity(BugItem.LOCATION, oldValString, newValString);
			}
		}
		m_location = location;
	}
	/**
	 * TuVXe̎擾
	 * 
	 * @return TuVXe
	 */
	public String getSubsystem()
	{
		return m_subsystem;
	}
	/**
	 * TuVXẽZbg
	 * 
	 * @param subsystem TuVXe
	 */
	public void setSubsystem(String subsystem)
	{
		//activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullCode(m_subsystem);
			String newVal = nullCode(subsystem);
			//vH
			if (! oldVal.equals(newVal)) {
				//ȂΗĂ
				String oldValString = new Subsystem(oldVal).getShortName();
				String newValString = new Subsystem(newVal).getShortName();
				
				addActivity(BugItem.SUBSYSTEM, oldValString, newValString);
			}
		}
		m_subsystem = subsystem;
	}
	/**
	 * @\̎擾
	 * 
	 * @return @\
	 */
	public String getFunctionName()
	{
		return m_functionName;
	}
	/**
	 * @\̃Zbg
	 * 
	 * @param functionName @\
	 */
	public void setFunctionName(String functionName)
	{
		//activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullCode(m_functionName);
			String newVal = nullCode(functionName);
			//vH
			if (! oldVal.equals(newVal)) {
				//ȂΗĂ
				String oldValString = new FunctionName(oldVal).getShortName();
				String newValString = new FunctionName(newVal).getShortName();
				
				addActivity(BugItem.FUNCTIONNAME, oldValString, newValString);
			}
		}
		m_functionName = functionName;
	}
	/**
	 * ʂhc̎擾
	 * 
	 * @return ʂhc
	 */
	public String getScreen() {
		return m_screen;
	}
	/**
	 * ʂhc̃Zbg
	 * 
	 * @return ʂhcz
	 */
	public void setScreen(String screen) {
		//activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullString(m_screen);
			String newVal = nullString(screen);
			//vH
			if (! oldVal.equals(newVal)) {
				//Ȃ΍o
				addActivity(BugItem.SCREEN, oldVal, newVal);
			}
		}
		m_screen = screen;
	}
	/**
	 * uEU̎擾
	 * 
	 * @return uEU
	 */
	public String getBrowser()
	{
		return m_browser;
	}
	/**
	 * uEŨZbg
	 * 
	 * @param browser uEU
	 */
	public void setBrowser(String browser)
	{
		//activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullCode(m_browser);
			String newVal = nullCode(browser);
			//vH
			if (! oldVal.equals(newVal)) {
				//ȂΗĂ
				String oldValString = new Browser(oldVal).getShortName();
				String newValString = new Browser(newVal).getShortName();
				
				addActivity(BugItem.BROWSER, oldValString, newValString);
			}
		}
		m_browser = browser;
	}
	/**
	 * nr̎擾
	 * 
	 * @return nr
	 */
	public String getOs()
	{
		return m_os;
	}
	/**
	 * nr̃Zbg
	 * 
	 * @param os nr
	 */
	public void setOs(String os)
	{
		//activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullCode(m_os);
			String newVal = nullCode(os);
			//vH
			if (! oldVal.equals(newVal)) {
				//ȂΗĂ
				String oldValString = new Os(oldVal).getShortName();
				String newValString = new Os(newVal).getShortName();
				
				addActivity(BugItem.OS, oldValString, newValString);
			}
		}
		m_os = os;
	}
	/**
	 * ID̎擾
	 * 
	 * @return ID
	 */
	public String getTid()
	{
		return m_tid;
	}
	/**
	 * ID̃Zbg
	 * 
	 * @param tid ID
	 */
	public void setTid(String tid)
	{
		//(String)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullString(m_tid);
			String newVal = nullString(tid);
			//vH
			if (! oldVal.equals(newVal)) {
				//Ȃ΍o
				addActivity(BugItem.TID, oldVal, newVal);
			}
		}
		m_tid = tid;
	}
	/**
	 * `oo[W̎擾
	 * 
	 * @return `oo[W
	 */
	public String getAppVersion()
	{
		return m_appVersion;
	}
	/**
	 * `oo[W̃Zbg
	 * 
	 * @param appVersion `oo[W
	 */
	public void setAppVersion(String appVersion)
	{
		//activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullCode(m_appVersion);
			String newVal = nullCode(appVersion);
			//vH
			if (! oldVal.equals(newVal)) {
				//ȂΗĂ
				String oldValString = new AppVersion(oldVal).getShortName();
				String newValString = new AppVersion(newVal).getShortName();
				
				addActivity(BugItem.APPVERSION, oldValString, newValString);
			}
		}
		m_appVersion = appVersion;
	}
	/**
	 * cao[W̎擾
	 * 
	 * @return cao[W
	 */
	public String getDbVersion()
	{
		return m_dbVersion;
	}
	/**
	 * cao[W̃Zbg
	 * 
	 * @param dbVersion cao[W
	 */
	public void setDbVersion(String dbVersion)
	{
		//activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullCode(m_dbVersion);
			String newVal = nullCode(dbVersion);
			//vH
			if (! oldVal.equals(newVal)) {
				//ȂΗĂ
				String oldValString = new DbVersion(oldVal).getShortName();
				String newValString = new DbVersion(newVal).getShortName();
				
				addActivity(BugItem.DBVERSION, oldValString, newValString);
			}
		}
		m_dbVersion = dbVersion;
	}
	/**
	 * gslko[W̎擾
	 * 
	 * @return gslko[W
	 */
	public String getHtmlVersion()
	{
		return m_htmlVersion;
	}
	/**
	 * gslko[W̃Zbg
	 * 
	 * @param htmlVersion gslko[W
	 */
	public void setHtmlVersion(String htmlVersion)
	{
		//activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullCode(m_htmlVersion);
			String newVal = nullCode(htmlVersion);
			//vH
			if (! oldVal.equals(newVal)) {
				//ȂΗĂ
				String oldValString = new HtmlVersion(oldVal).getShortName();
				String newValString = new HtmlVersion(newVal).getShortName();
				
				addActivity(BugItem.HTMLVERSION, oldValString, newValString);
			}
		}
		m_htmlVersion = htmlVersion;
	}
	/**
	 * dlo[W̎擾
	 * 
	 * @return dlo[W
	 */
	public String getSpecVersion()
	{
		return m_specVersion;
	}
	/**
	 * dlo[W̃Zbg
	 * 
	 * @param specVersion dlo[W
	 */
	public void setSpecVersion(String specVersion)
	{
		//activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullCode(m_specVersion);
			String newVal = nullCode(specVersion);
			//vH
			if (! oldVal.equals(newVal)) {
				//ȂΗĂ
				String oldValString = new SpecVersion(oldVal).getShortName();
				String newValString = new SpecVersion(newVal).getShortName();
				
				addActivity(BugItem.SPECVERSION, oldValString, newValString);
			}
		}
		m_specVersion = specVersion;
	}
	/**
	 * s҂̎擾
	 * 
	 * @return s
	 */
	public int getIssuer()
	{
		return m_issuer;
	}
	/**
	 * sҖ̎擾
	 * 
	 * @return sҖ
	 */
	public String getIssuerName()
	{
		//OAS蓖ĂĂΎɍs
		if ((m_issuerName == null) && (m_issuer != 0)) {
			m_issuerName = UserInfo.getUser(m_issuer).getNickname();
		}
		return Converter.StringToHtml(m_issuerName);
	}
	/**
	 * s҂̃Zbg
	 * 
	 * @param issuer s
	 */
	public void setIssuer(int issuer)
	{
		
		//(int)activity擾H
		if (isActivity()) {
			//svH
			if (m_issuer != issuer) {
				//ȂΗĂ
				
				String oldValString = "";		//old
				if (m_issuer != 0) {
					oldValString = UserInfo.getUser(m_issuer).getNickname();
				}
				String newValString = "";		//new
				if (issuer != 0) {
					newValString = UserInfo.getUser(issuer).getNickname();
					m_issuerName = newValString;
				}
				addActivity(BugItem.ISSUER, oldValString, newValString);
			}
		}
		m_issuer = issuer;
		
		//fBXpb`XV(8/30)
		setDispatch();
		
	}
	/**
	 * ̎擾
	 * 
	 * @return 
	 */
	public Date getIssuDate()
	{
		return m_issuDate;
	}
	/**
	 * ̎擾ij
	 * 
	 * @return 
	 */
	public String getIssuDateString()
	{
		return (Converter.getDateString(m_issuDate, Converter.DATE));
	}
	/**
	 * ̎擾ij
	 * 
	 * @return 
	 */
	public String getIssuDateStringShort()
	{
		return (Converter.getDateString(m_issuDate, Converter.SHORT_DATE_TIME));
	}
	/**
	 * ̃Zbg
	 * 
	 * @param issuDate 
	 */
	public void setIssuDate(Date issuDate)
	{
		//(Date)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullDate(m_issuDate);
			String newVal = nullDate(issuDate);
			//vH
			if (! oldVal.equals(newVal)) {
				
				addActivity(BugItem.ISSUDATE, oldVal, newVal);
			}
		}
		
		m_issuDate = issuDate;
	}
	/**
	 * o^̎擾
	 * 
	 * @return o^
	 */
	public Date getRegistDate()
	{
		return m_registDate;
	}
	/**
	 * o^̎擾()
	 * 
	 * @return o^
	 */
	public String getRegistDateString()
	{
		return (Converter.getDateString(m_registDate, Converter.DATE));
	}
	/**
	 * o^̃Zbg
	 * 
	 * @param resistDate o^
	 */
	public void setRegistDate(Date registDate)
	{
		m_registDate = registDate;
	}
	/**
	 * ̏x̎擾
	 * 
	 * @return ̏x
	 */
	public String getSeverity()
	{
		return m_severity;
	}
	/**
	 * ̏x̃Zbg
	 * 
	 * @param severity ̏x
	 */
	public void setSeverity(String severity)
	{
		//(CODE)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullCode(m_severity);
			String newVal = nullCode(severity);
			//vH
			if (! oldVal.equals(newVal)) {
				//ȂΗĂ
				String oldValString = new Severity(oldVal).getShortName();
				String newValString = new Severity(newVal).getShortName();
				
				addActivity(BugItem.SEVERITY, oldValString, newValString);
			}
		}
		m_severity = severity;
	}
	/**
	 * Dx̎擾
	 * 
	 * @return Dx
	 */
	public String getPriority()
	{
		return m_priority;
	}
	/**
	 * Dx̎擾()
	 * 
	 * @return Dx
	 */
	public String getPriorityString()
	{
		
	    if (m_priorityString == null) {
	        Priority pri = Priority.getPriority(m_priority);
	        if (pri != null) {
	            m_priorityString = pri.getShortName();
	        }
	    }
		return m_priorityString;
		
	}
	/**
	 * Dx̃Zbg
	 * 
	 * @param priority Dx
	 */
	public void setPriority(String priority)
	{
		//(CODE)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullCode(m_priority);
			String newVal = nullCode(priority);
			//vH
			if (! oldVal.equals(newVal)) {
				//ȂΗĂ
				String oldValString = new Priority(oldVal).getShortName();
				String newValString = new Priority(newVal).getShortName();
				
				addActivity(BugItem.PRIORITY, oldValString, newValString);
			}
		}
		m_priority = priority;
	}
	/**
	 * Dx̃Zbg()
	 * 
	 * @param priority Dx
	 */
	public void setPriorityString(String priorityString)
	{
		m_priorityString = priorityString;
	}
	/**
	 * Xe[^X̎擾
	 * 
	 * @return Xe[^X
	 */
	public byte getStatus()
	{
		return m_status;
	}
	/**
	 * Xe[^X̎擾()
	 * 
	 * @return Xe[^X
	 */
	public String getStatusString()
	{
		return getStatusString(m_status);
		
	}
	/**
	 * Xe[^X̎擾()
	 * 
	 * @return Xe[^X
	 */
	public static String getStatusString(byte status)
	{
	    MessageString ms = new MessageString();
		String s = null;
		switch(status) {
		case STS_UNCONFIRMED :
//			s = "mF(unconfirmd)";
		    s = ms.get("status.name.unconfirmd");
			break;
		case STS_NEW :
//			s = "VK(new)";
		    s = ms.get("status.name.new");
			break;
		case STS_DISPATCH :
//			s = "SҊ(judge)";
		    s = ms.get("status.name.resolved");
			break;
		case STS_INVESTIGATION :
//			s = "͒(analyze)";
		    s = ms.get("status.name.analyze");
			break;
		case STS_REPAIRED :
//			s = "C(update)";
		    s = ms.get("status.name.update");
			break;
		case STS_RESOLVED :
//			s = "mF(resolved)";
		    s = ms.get("status.name.confirm");
			break;
		case STS_REOPEN :
//			s = "ĊJ(reopen)";
		    s = ms.get("status.name.reopen");
			break;
		case STS_VERIFIED :
//			s = "mFς(verified)";
		    s = ms.get("status.name.verified");
			break;
		case STS_CLOSE :
//			s = "(close)";
		    s = ms.get("status.name.close");
			break;
		}
		return s;
	}
	/**
	 * Xe[^X̃Zbg
	 * 
	 * @param status Xe[^X
	 */
	public void setStatus(byte status)
	{
		//VKȊO̎ɍ
		if (m_bno != 0) {
			//(byte)activity擾H
			if (isActivity()) {
				//svH
				if (m_status != status) {
					//ȂΗĂ
					String oldValString = getStatusString(m_status);
					String newValString = getStatusString(status);
					addActivity(BugItem.STATUS, oldValString, newValString);
				}
			}
		}
		m_status = status;
		//fBXpb`XV(8/30)
		setDispatch();
	}
	/**
	 * Xe[^X󋵂̎擾
	 * 
	 * @return Xe[^X
	 */
	public String getStatusWhitebord()
	{
		return m_statusWhitebord;
	}
	/**
	 * Xe[^X󋵂̎擾
	 * 
	 * @return Xe[^X
	 */
	public String getStatusWhitebordString()
	{
		return Converter.StringToHtml(m_statusWhitebord);
	}
	/**
	 * Xe[^X󋵂̃Zbg
	 * 
	 * @param statusWhitebord Xe[^X
	 */
	public void setStatusWhitebord(String statusWhitebord)
	{
		//(String)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullString(m_statusWhitebord);
			String newVal = nullString(statusWhitebord);
			//vH
			if (! oldVal.equals(newVal)) {
				//Ȃ΍o
				addActivity(BugItem.STATUSWHITEBORD, oldVal, newVal);
			}
		}
		m_statusWhitebord = statusWhitebord;
	}
	/**
	 * Ώ@̎擾
	 * 
	 * @return Ώ@
	 */
	public String getResolution()
	{
		return m_resolution;
	}
	/**
	 * Ώ@̎擾
	 * 08.02.08 ǉ
	 * @return Ώ@
	 */
	public String getResolutionString()
	{
	    if (m_resolutionString == null) {
	        Resolution res = Resolution.getResolution(m_resolution);
	        if (res != null) {
	            m_resolutionString = res.getShortName();
	        }
	    }
		return m_resolutionString;
	}
	/**
	 * Ώ@̃Zbg
	 * 
	 * @param resolution Ώ@
	 */
	public void setResolution(String resolution)
	{
		//(CODE)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullCode(m_resolution);
			String newVal = nullCode(resolution);
			//vH
			if (! oldVal.equals(newVal)) {
				//ȂΗĂ
				String oldValString = new Resolution(oldVal).getShortName();
				String newValString = new Resolution(newVal).getShortName();
				
				addActivity(BugItem.RESOLUTION, oldValString, newValString);
			}
		}
		m_resolution = resolution;
	}
	/**
	 * }CXg[̎擾
	 * 
	 * @return }CXg[
	 */
	public String getMilestone()
	{
		return m_milestone;
	}
	/**
	 * }CXg[̃Zbg
	 * 
	 * @param milestone }CXg[
	 */
	public void setMilestone(String milestone)
	{
		//(CODE)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullCode(m_milestone);
			String newVal = nullCode(milestone);
			//vH
			if (! oldVal.equals(newVal)) {
				//ȂΗĂ
				String oldValString = new Milestone(oldVal).getShortName();
				String newValString = new Milestone(newVal).getShortName();
				
				addActivity(BugItem.MILESTONE, oldValString, newValString);
			}
		}
		m_milestone = milestone;
	}
	/**
	 * dlύXID̎擾
	 * 
	 * @return dlύXID
	 */
	public String getScid()
	{
		return m_scid;
	}
	/**
	 * dlύXID̃Zbg
	 * 
	 * @param scid dlύXID
	 */
	public void setScid(String scid)
	{
		//(String)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullString(m_scid);
			String newVal = nullString(scid);
			//vH
			if (! oldVal.equals(newVal)) {
				//Ȃ΍o
				addActivity(BugItem.SCID, oldVal, newVal);
			}
		}
		m_scid = scid;
	}
	/**
	 * L[[hP̎擾
	 * 
	 * @return L[[hP
	 */
	public String getKeyword1()
	{
		return m_keyword1;
	}
	/**
	 * L[[hP̃Zbg
	 * 
	 * @param keyword1 L[[hP
	 */
	public void setKeyword1(String keyword1)
	{
		//(String)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullString(m_keyword1);
			String newVal = nullString(keyword1);
			//vH
			if (! oldVal.equals(newVal)) {
				//Ȃ΍o
				addActivity(BugItem.KEYWORD1, oldVal, newVal);
			}
		}
		m_keyword1 = keyword1;
	}
	/**
	 * L[[hQ̎擾
	 * 
	 * @return L[[hQ
	 */
	public String getKeyword2()
	{
		return m_keyword2;
	}
	/**
	 * L[[hQ̃Zbg
	 * 
	 * @param keyword2 L[[hQ
	 */
	public void setKeyword2(String keyword2)
	{
		//(String)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullString(m_keyword2);
			String newVal = nullString(keyword2);
			//vH
			if (! oldVal.equals(newVal)) {
				//Ȃ΍o
				addActivity(BugItem.KEYWORD2, oldVal, newVal);
			}
		}
		m_keyword2 = keyword2;
	}
	/**
	 * L[[hR̎擾
	 * 
	 * @return L[[hR
	 */
	public String getKeyword3()
	{
		return m_keyword3;
	}
	/**
	 * L[[hR̃Zbg
	 * 
	 * @param keyword3 L[[hR
	 */
	public void setKeyword3(String keyword3)
	{
		//(String)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullString(m_keyword3);
			String newVal = nullString(keyword3);
			//vH
			if (! oldVal.equals(newVal)) {
				//Ȃ΍o
				addActivity(BugItem.KEYWORD3, oldVal, newVal);
			}
		}
		m_keyword3 = keyword3;
	}
	/**
	 * L[[hPCQCR̎擾
	 * 
	 * @return L[[h
	 */
	public String getKeywordString() {
		StringBuffer sb = new StringBuffer();
		addKeyword(m_keyword1, sb);
		addKeyword(m_keyword2, sb);
		addKeyword(m_keyword3, sb);
		
		return new String(sb);
	}
	/**
	 * L[[ȟ
	 * 
	 */
	private void addKeyword(String keyword, StringBuffer sb) {
		
		if ((keyword != null) && (keyword.length() > 0)) {
			if (sb.length() > 0) {
				sb.append("/");
			}
			sb.append(keyword);
		}
	
	}
	/**
	 * R|[lg1̎擾
	 * 
	 * @return R|[lg1
	 */
	public String getCpid1()
	{
		return m_cpid1;
	}
	/**
	 * R|[lg1̃Zbg
	 * 
	 * @param cpid1 R|[lg1
	 */
	public void setCpid1(String cpid1)
	{
		//(CODE)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullCode(m_cpid1);
			String newVal = nullCode(cpid1);
			//vH
			if (! oldVal.equals(newVal)) {
				//ȂΗĂ
				String oldValString = new ComponentName(oldVal).getName();
				String newValString = new ComponentName(newVal).getName();
				
				addActivity(BugItem.CPID1, oldValString, newValString);
			}
		}
		m_cpid1 = cpid1;
	}
	/**
	 * R|[lg2̎擾
	 * 
	 * @return R|[lg2
	 */
	public String getCpid2()
	{
		return m_cpid2;
	}
	/**
	 * R|[lg2̃Zbg
	 * 
	 * @param cpid2 R|[lg2
	 */
	public void setCpid2(String cpid2)
	{
		//(CODE)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullCode(m_cpid2);
			String newVal = nullCode(cpid2);
			//vH
			if (! oldVal.equals(newVal)) {
				//ȂΗĂ
				String oldValString = new ComponentName(oldVal).getName();
				String newValString = new ComponentName(newVal).getName();
				
				addActivity(BugItem.CPID2, oldValString, newValString);
			}
		}
		m_cpid2 = cpid2;
	}
	/**
	 * R|[lg3̎擾
	 * 
	 * @return R|[lg3
	 */
	public String getCpid3()
	{
		return m_cpid3;
	}
	/**
	 * R|[lg3̃Zbg
	 * 
	 * @param cpid R|[lg3
	 */
	public void setCpid3(String cpid3)
	{
		//(CODE)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullCode(m_cpid3);
			String newVal = nullCode(cpid3);
			//vH
			if (! oldVal.equals(newVal)) {
				//ȂΗĂ
				String oldValString = new ComponentName(oldVal).getName();
				String newValString = new ComponentName(newVal).getName();
				
				addActivity(BugItem.CPID3, oldValString, newValString);
			}
		}
		m_cpid3 = cpid3;
	}
	/**
	 * R|[lg4̎擾
	 * 
	 * @return R|[lg4
	 */
	public String getCpid4()
	{
		return m_cpid4;
	}
	/**
	 * R|[lg4̃Zbg
	 * 
	 * @param cpid4 R|[lg4
	 */
	public void setCpid4(String cpid4)
	{
		//(CODE)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullCode(m_cpid4);
			String newVal = nullCode(cpid4);
			//vH
			if (! oldVal.equals(newVal)) {
				//ȂΗĂ
				String oldValString = new ComponentName(oldVal).getName();
				String newValString = new ComponentName(newVal).getName();
				
				addActivity(BugItem.CPID4, oldValString, newValString);
			}
		}
		m_cpid4 = cpid4;
	}
	/**
	 * R|[lg5̎擾
	 * 
	 * @return R|[lg5
	 */
	public String getCpid5()
	{
		return m_cpid5;
	}
	/**
	 * R|[lg5̃Zbg
	 * 
	 * @param cpid5 R|[lg5
	 */
	public void setCpid5(String cpid5)
	{
		//(CODE)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullCode(m_cpid5);
			String newVal = nullCode(cpid5);
			//vH
			if (! oldVal.equals(newVal)) {
				//ȂΗĂ
				String oldValString = new ComponentName(oldVal).getName();
				String newValString = new ComponentName(newVal).getName();
				
				addActivity(BugItem.CPID5, oldValString, newValString);
			}
		}
		m_cpid5 = cpid5;
	}
	public String getComponentString() {
		
		StringBuffer sb = new StringBuffer();
		
		addComponentString(m_cpid1, sb);
		addComponentString(m_cpid2, sb);
		addComponentString(m_cpid3, sb);
		addComponentString(m_cpid4, sb);
		addComponentString(m_cpid5, sb);
		return new String(sb);
		
	}
	/**
	 * R|[lgҏW
	 */
	private void addComponentString(String cpid, StringBuffer sb) {
		if ((cpid != null) && (! cpid.equals("00"))) {
			String cpName = ComponentName.getComponentName(cpid).getName();
			if (sb.length() != 0) {
				sb.append("->");
			}
			sb.append(cpName);
		}
	}
	/**
	 * ֘AhLg̎擾
	 * 
	 * @return ֘AhLg
	 */
	public String getReletedDoc()
	{
		return m_reletedDoc;
	}
	/**
	 * ֘AhLg̃Zbg
	 * 
	 * @param reletedDoc ֘AhLg
	 */
	public void setReletedDoc(String reletedDoc)
	{
		//(String)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullString(m_reletedDoc);
			String newVal = nullString(reletedDoc);
			//vH
			if (! oldVal.equals(newVal)) {
				//Ȃ΍o
				addActivity(BugItem.RELETEDDOC, oldVal, newVal);
			}
		}
		m_reletedDoc = reletedDoc;
	}
	/**
	 * F҂̎擾
	 * 
	 * @return F
	 */
	public int getAuther()
	{
		return m_auther;
	}
	/**
	 * FҖ̎擾
	 * 
	 * @return FҖ
	 */
	public String getAutherName()
	{
		//OAS蓖ĂĂΎɍs
		if ((m_autherName == null) && (m_auther != 0)) {
			m_autherName = UserInfo.getUser(m_auther).getNickname();
		}
		return Converter.StringToHtml(m_autherName);
	}
	/**
	 * F҂̃Zbg
	 * 
	 * @param auther F
	 */
	public void setAuther(int auther)
	{
		//(int)activity擾H
		if (isActivity()) {
			//svH
			if (m_auther != auther) {
				//ȂΗĂ
				
				String oldValString = "";		//old
				if (m_auther != 0) {
					oldValString = UserInfo.getUser(m_auther).getNickname();
				}
				String newValString = "";		//new
				if (auther != 0) {
					newValString = UserInfo.getUser(auther).getNickname();
					m_autherName = newValString;
				}
				addActivity(BugItem.AUTHER, oldValString, newValString);
			}
		}
		m_auther = auther;
		//fBXpb`XV(8/30)
		setDispatch();
		
	}
	/**
	 * F̎擾
	 * 
	 * @return F
	 */
	public Date getAuthDate()
	{
		return m_authDate;
	}
	/**
	 * F̎擾()
	 * 
	 * @return F
	 */
	public String getAuthDateString()
	{
		return (Converter.getDateString(m_authDate, Converter.DATE));
	}
	/**
	 * F̃Zbg
	 * 
	 * @param authDate F
	 */
	public void setAuthDate(Date authDate)
	{
		//(Date)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullDate(m_authDate);
			String newVal = nullDate(authDate);
			//vH
			if (! oldVal.equals(newVal)) {
				
				addActivity(BugItem.AUTHDATE, oldVal, newVal);
			}
		}
		m_authDate = authDate;
	}
	/**
	 * G[e̎擾
	 * 
	 * @return G[e
	 */
	public String getErrorType()
	{
		return m_errorType;
	}
	/**
	 * G[ẽZbg
	 * 
	 * @param errorType G[e
	 */
	public void setErrorType(String errorType)
	{
		//(CODE)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullCode(m_errorType);
			String newVal = nullCode(errorType);
			//vH
			if (! oldVal.equals(newVal)) {
				//ȂΗĂ
				String oldValString = new ErrorType(oldVal).getName();
				String newValString = new ErrorType(newVal).getName();
				
				addActivity(BugItem.ERRORTYPE, oldValString, newValString);
			}
		}
		m_errorType = errorType;
	}
	/**
	 * G[̎擾
	 * 
	 * @return G[
	 */
	public String getErrorCause()
	{
		return m_errorCause;
	}
	/**
	 * G[̃Zbg
	 * 
	 * @param errorCause G[
	 */
	public void setErrorCause(String errorCause)
	{
		//(CODE)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullCode(m_errorCause);
			String newVal = nullCode(errorCause);
			//vH
			if (! oldVal.equals(newVal)) {
				//ȂΗĂ
				String oldValString = new ErrorCause(oldVal).getName();
				String newValString = new ErrorCause(newVal).getName();
				
				addActivity(BugItem.ERRORCAUSE, oldValString, newValString);
			}
		}
		m_errorCause = errorCause;
	}
	/**
	 * G[@\ӏ̎擾
	 * 
	 * @return G[@\ӏ
	 */
	public String getErrorPoint()
	{
		return m_errorPoint;
	}
	/**
	 * G[@\ӏ̃Zbg
	 * 
	 * @param errorPoint G[@\ӏ
	 */
	public void setErrorPoint(String errorPoint)
	{
		//(CODE)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullCode(m_errorPoint);
			String newVal = nullCode(errorPoint);
			//vH
			if (! oldVal.equals(newVal)) {
				//ȂΗĂ
				String oldValString = new ErrorPoint(oldVal).getName();
				String newValString = new ErrorPoint(newVal).getName();
				
				addActivity(BugItem.ERRORPOINT, oldValString, newValString);
			}
		}
		m_errorPoint = errorPoint;
	}
	/**
	 * G[EoH̎擾
	 * 
	 * @return G[EoH
	 */
	public String getIssuPno()
	{
		return m_issuPno;
	}
	/**
	 * G[EoH̎擾
	 * 
	 * @return G[EoH
	 */
	public String getIssuPnoName()
	{
		String s = null;
		if ((m_issuPno == null) || (m_issuPno.equals("00"))) {
			s = new String();	//󕶎
		} else {
			s = ProcessName.getProcessName(m_issuPno).getShortName();
		}
		return s;
	}
	/**
	 * G[EoH̃Zbg
	 * 
	 * @param issuPno G[EoH
	 */
	public void setIssuPno(String issuPno)
	{
		//(CODE)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullCode(m_issuPno);
			String newVal = nullCode(issuPno);
			//vH
			if (! oldVal.equals(newVal)) {
				//ȂΗĂ
				String oldValString = new ProcessName(oldVal).getName();
				String newValString = new ProcessName(newVal).getName();
				
				addActivity(BugItem.ISSUPNO, oldValString, newValString);
			}
		}
		m_issuPno = issuPno;
	}
	/**
	 * G[H̎擾
	 * 
	 * @return G[H
	 */
	public String getTrainPno()
	{
		return m_trainPno;
	}
	/**
	 * G[H̎擾
	 * 
	 * @return G[H
	 */
	public String getTrainPnoName()
	{
		String s = null;
		if ((m_trainPno == null) || (m_trainPno.equals("00"))) {
			s = new String();	//󕶎
		} else {
			s = ProcessName.getProcessName(m_trainPno).getShortName();
		}
		return s;
	}
	/**
	 * G[H̃Zbg
	 * 
	 * @param trainPno G[H
	 */
	public void setTrainPno(String trainPno)
	{
		//(CODE)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullCode(m_trainPno);
			String newVal = nullCode(trainPno);
			//vH
			if (! oldVal.equals(newVal)) {
				//ȂΗĂ
				String oldValString = new ProcessName(oldVal).getName();
				String newValString = new ProcessName(newVal).getName();
				
				addActivity(BugItem.TRAINPNO, oldValString, newValString);
			}
		}
		m_trainPno = trainPno;
	}
	/**
	 * EoׂH̎擾
	 * 
	 * @return EoׂH
	 */
	public String getShouldFindPno()
	{
		return m_shouldFindPno;
	}
	/**
	 * EoׂH̎擾
	 * 
	 * @return EoׂH
	 */
	public String getShouldFindPnoName()
	{
		String s = null;
		if ((m_shouldFindPno == null) || (m_shouldFindPno.equals("00"))) {
			s = new String();	//󕶎
		} else {
			s = ProcessName.getProcessName(m_shouldFindPno).getShortName();
		}
		return s;
	}
	/**
	 * EoׂH̃Zbg
	 * 
	 * @param shouldFindPno EoׂH
	 */
	public void setShouldFindPno(String shouldFindPno)
	{
		//(CODE)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullCode(m_shouldFindPno);
			String newVal = nullCode(shouldFindPno);
			//vH
			if (! oldVal.equals(newVal)) {
				//ȂΗĂ
				String oldValString = new ProcessName(oldVal).getName();
				String newValString = new ProcessName(newVal).getName();
				
				addActivity(BugItem.SHOULDFINDPNO, oldValString, newValString);
			}
		}
		m_shouldFindPno = shouldFindPno;
	}
	/**
	 * EoxR̎擾
	 * 
	 * @return EoxR
	 */
	public String getErrorDelayReason()
	{
		return m_errorDelayReason;
	}
	/**
	 * EoxR̃Zbg
	 * 
	 * @param errorDelayReason EoxR
	 */
	public void setErrorDelayReason(String errorDelayReason)
	{
		//(CODE)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullCode(m_errorDelayReason);
			String newVal = nullCode(errorDelayReason);
			//vH
			if (! oldVal.equals(newVal)) {
				//ȂΗĂ
				String oldValString = new ErrorDelayReason(oldVal).getName();
				String newValString = new ErrorDelayReason(newVal).getName();
				
				addActivity(BugItem.ERRORDELAYREASON, oldValString, newValString);
			}
		}
		m_errorDelayReason = errorDelayReason;
	}
	/**
	 * 񋟗\̎擾
	 * 
	 * @return 񋟗\
	 */
	public Date getReleaseSchDate()
	{
		return m_releaseSchDate;
	}
	/**
	 * 񋟗\̎擾()
	 * 
	 * @return 񋟗\
	 */
	public String getReleaseSchDateString()
	{
		return (Converter.getDateString(m_releaseSchDate, Converter.DATE));
	}
	/**
	 * 񋟗\̃Zbg
	 * 
	 * @param releaseSchDate 񋟗\
	 */
	public void setReleaseSchDate(Date releaseSchDate)
	{
		//(Date)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullDate(m_releaseSchDate);
			String newVal = nullDate(releaseSchDate);
			//vH
			if (! oldVal.equals(newVal)) {
				
				addActivity(BugItem.RELEASESCHDATE, oldVal, newVal);
			}
		}
		m_releaseSchDate = releaseSchDate;
	}
	/**
	 * ͎҂̎擾
	 * 
	 * @return ͎
	 */
	public int getAnalyst()
	{
		return m_analyst;
	}
	/**
	 * ͎҂̎擾
	 * 
	 * @return ͎
	 */
	public String getAnalystName()
	{
		//OAS蓖ĂĂΎɍs
		if ((m_analystName == null) && (m_analyst != 0)) {
			m_analystName = UserInfo.getUser(m_analyst).getNickname();
		}
		return Converter.StringToHtml(m_analystName);
	}
	/**
	 * ͎҂̃Zbg
	 * 
	 * @param analyst ͎
	 */
	public void setAnalyst(int analyst)
	{
		//(int)activity擾H
		if (isActivity()) {
			//svH
			if (m_analyst != analyst) {
				//ȂΗĂ
				
				String oldValString = "";		//old
				if (m_analyst != 0) {
					oldValString = UserInfo.getUser(m_analyst).getNickname();
				}
				String newValString = "";		//new
				if (analyst != 0) {
					newValString = UserInfo.getUser(analyst).getNickname();
					m_analystName = newValString;
				}
				addActivity(BugItem.ANALYST, oldValString, newValString);
			}
		}
		m_analyst = analyst;
		//fBXpb`XV(8/30)
		setDispatch();
		
	}
	/**
	 * ͓̎擾
	 * 
	 * @return ͓
	 */
	public Date getAnalizeDate()
	{
		return m_analizeDate;
	}
	/**
	 * ͓̎擾()
	 * 
	 * @return ͓
	 */
	public String getAnalizeDateString()
	{
		return (Converter.getDateString(m_analizeDate, Converter.DATE));
	}
	/**
	 * ͓̃Zbg
	 * 
	 * @param analizeDate ͓
	 */
	public void setAnalizeDate(Date analizeDate)
	{
		//(Date)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullDate(m_analizeDate);
			String newVal = nullDate(analizeDate);
			//vH
			if (! oldVal.equals(newVal)) {
				
				addActivity(BugItem.ANALIZEDATE, oldVal, newVal);
			}
		}
		m_analizeDate = analizeDate;
	}
	/**
	 * C\[X̎擾
	 * 
	 * @return C\[X
	 */
	public String getUpdateSrc()
	{
		return m_updateSrc;
	}
	/**
	 * C\[X̃Zbg
	 * 
	 * @param updateSrc C\[X
	 */
	public void setUpdateSrc(String updateSrc)
	{
		//(String)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullString(m_updateSrc);
			String newVal = nullString(updateSrc);
			//vH
			if (! oldVal.equals(newVal)) {
				//Ȃ΍o
				addActivity(BugItem.UPDATESRC, oldVal, newVal);
			}
		}
		m_updateSrc = updateSrc;
	}
	/**
	 * ChLg̎擾
	 * 
	 * @return ChLg
	 */
	public String getUpdateDoc()
	{
		return m_updateDoc;
	}
	/**
	 * ChLg̃Zbg
	 * 
	 * @param updateDoc ChLg
	 */
	public void setUpdateDoc(String updateDoc)
	{
		//(String)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullString(m_updateDoc);
			String newVal = nullString(updateDoc);
			//vH
			if (! oldVal.equals(newVal)) {
				//Ȃ΍o
				addActivity(BugItem.UPDATEDOC, oldVal, newVal);
			}
		}
		m_updateDoc = updateDoc;
	}
	/**
	 * Ώ҂̎擾
	 * 
	 * @return Ώ
	 */
	public int getUpdater()
	{
		return m_updater;
	}
	/**
	 * ΏҖ̎擾
	 * 
	 * @return ΏҖ
	 */
	public String getUpdaterName()
	{
		//OAS蓖ĂĂΎɍs
		if ((m_updaterName == null) && (m_updater != 0)) {
			m_updaterName = UserInfo.getUser(m_updater).getNickname();
		}
		return Converter.StringToHtml(m_updaterName);
	}
	/**
	 * Ώ҂̃Zbg
	 * 
	 * @param updater Ώ
	 */
	public void setUpdater(int updater)
	{
		//(int)activity擾H
		if (isActivity()) {
			//svH
			if (m_updater != updater) {
				//ȂΗĂ
				
				String oldValString = "";		//old
				if (m_updater != 0) {
					oldValString = UserInfo.getUser(m_updater).getNickname();
				}
				String newValString = "";		//new
				if (updater != 0) {
					newValString = UserInfo.getUser(updater).getNickname();
					m_updaterName = newValString;
				}
				addActivity(BugItem.UPDATER, oldValString, newValString);
			}
		}
		m_updater = updater;
		//fBXpb`XV(8/30)
		setDispatch();
	}
	/**
	 * Ώ̎擾
	 * 
	 * @return Ώ
	 */
	public Date getBugUpdateDate()
	{
		return m_bugUpdateDate;
	}
	/**
	 * Ώ̎擾()
	 * 
	 * @return Ώ
	 */
	public String getBugUpdateDateString()
	{
		return (Converter.getDateString(m_bugUpdateDate, Converter.DATE));
	}
	/**
	 * Ώ̃Zbg
	 * 
	 * @param bugUpdateDate Ώ
	 */
	public void setBugUpdateDate(Date bugUpdateDate)
	{
		//(Date)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullDate(m_bugUpdateDate);
			String newVal = nullDate(bugUpdateDate);
			//vH
			if (! oldVal.equals(newVal)) {
				
				addActivity(BugItem.BUGUPDATEDATE, oldVal, newVal);
			}
		}
		m_bugUpdateDate = bugUpdateDate;
	}
	/**
	 * ̎擾
	 * 
	 * @return 
	 */
	public Date getReleaseDate()
	{
		return m_releaseDate;
	}
	/**
	 * ̎擾()
	 * 
	 * @return 
	 */
	public String getReleaseDateString()
	{
		return (Converter.getDateString(m_releaseDate, Converter.DATE));
	}
	/**
	 * ̃Zbg
	 * 
	 * @param releaseDate 
	 */
	public void setReleaseDate(Date releaseDate)
	{
		//(Date)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullDate(m_releaseDate);
			String newVal = nullDate(releaseDate);
			//vH
			if (! oldVal.equals(newVal)) {
				
				addActivity(BugItem.RELEASEDATE, oldVal, newVal);
			}
		}
		m_releaseDate = releaseDate;
	}
	/**
	 * mF҂̎擾
	 * 
	 * @return mF
	 */
	public int getComfirmer()
	{
		return m_comfirmer;
	}
	/**
	 * mF҂̎擾
	 * 
	 * @return mF
	 */
	public String getComfirmerName()
	{
		//OAS蓖ĂĂΎɍs
		if ((m_comfirmerName == null) && (m_comfirmer != 0)) {
			m_comfirmerName = UserInfo.getUser(m_comfirmer).getNickname();
		}
		return Converter.StringToHtml(m_comfirmerName);
	}
	/**
	 * mF҂̃Zbg
	 * 
	 * @param comfirmer mF
	 */
	public void setComfirmer(int comfirmer)
	{
		//(int)activity擾H
		if (isActivity()) {
			//svH
			if (m_comfirmer != comfirmer) {
				//ȂΗĂ
				
				String oldValString = "";		//old
				if (m_comfirmer != 0) {
					oldValString = UserInfo.getUser(m_comfirmer).getNickname();
				}
				String newValString = "";		//new
				if (comfirmer != 0) {
					newValString = UserInfo.getUser(comfirmer).getNickname();
					m_comfirmerName = newValString;
				}
				addActivity(BugItem.COMFIRMER, oldValString, newValString);
			}
		}
		m_comfirmer = comfirmer;
		//fBXpb`XV(8/30)
		setDispatch();
		
	}
	/**
	 * mF̎擾
	 * 
	 * @return mF
	 */
	public Date getComfirmDate()
	{
		return m_comfirmDate;
	}
	/**
	 * mF̎擾()
	 * 
	 * @return mF
	 */
	public String getComfirmDateString()
	{
		return (Converter.getDateString(m_comfirmDate, Converter.DATE));
	}
	/**
	 * mF̃Zbg
	 * 
	 * @param comfirmDate mF
	 */
	public void setComfirmDate(Date comfirmDate)
	{
		//(Date)activity擾H
		if (isActivity()) {
			//nullϊ
			String oldVal = nullDate(m_comfirmDate);
			String newVal = nullDate(comfirmDate);
			//vH
			if (! oldVal.equals(newVal)) {
				
				addActivity(BugItem.COMFIRMDATE, oldVal, newVal);
			}
		}
		m_comfirmDate = comfirmDate;
	}
	/**
	 * bZ[Wid̎擾
	 * 
	 * @return bZ[Wid
	 */
	public String getMessageId()
	{
		return m_messageId;
	}
	/**
	 * bZ[Wid̃Zbg
	 * 
	 * @param messageId bZ[Wid
	 */
	public void setMessageId(String messageId)
	{
		//͎Ȃ
		
		m_messageId = messageId;
	}
	
	/**
	 * XV҂̎擾
	 * 
	 * @return XV
	 */
	public int getUpdateUno()
	{
		return m_updateUno;
	}
	/**
	 * XV҂̃Zbg
	 * 
	 * @param updateUno XV
	 */
	public void setUpdateUno(int updateUno)
	{
		m_updateUno = updateUno;
	}
	/**
	 *	XV̎擾
	 *
	 * @return	update		XV
	 */
	public Date getUpdateDate()
	{
		return m_updateDate;
	}
	/**
	 *	XV̎擾ij
	 *
	 * @return	update		XV
	 */
	public String getUpdateDateString()
	{
		return (Converter.getDateString(m_updateDate, Converter.DATE_TIME));
	}
	/**
	 *	XṼZbg
	 *
	 * @return	update		XV
	 */
	public void setUpdateDate(Date date)
	{
		m_updateDate = date;
	}
	/**
	 * ۑ̎擾
	 * 
	 * @return ۑ
	 */
	public Date getPersistDate()
	{
		return m_persistDate;
	}
	/**
	 *	ۑ̎擾ij
	 *
	 * @return	persist		ۑ
	 */
	public String getPersistDateString()
	{
		return (Converter.getDateString(m_persistDate, Converter.DATE_TIME));
	}
	/**
	 * ۑ̃Zbg
	 * 
	 * @param persistDate ۑ
	 */
	public void setPersistDate(Date persistDate)
	{
		m_persistDate = persistDate;
	}
//===========================================================================
// adding methods
//===========================================================================
	/**
	 * ̏x()̎擾
	 * 
	 * @return ̏x()
	 */
	public String getSeverityString()
	{
		return (m_severityString == null ? "" : m_severityString);
	}
	/**
	 * ̏x()̃Zbg
	 * 
	 * @param severityString ̏x()
	 */
	public void setSeverityString(String severityString)
	{
		m_severityString = severityString;
	}
	/**
	 * }CXg[()̎擾
	 * 
	 * @return }CXg[()
	 */
	public String getMilestoneString()
	{
		return m_milestoneString;
	}
	/**
	 * }CXg[()̃Zbg
	 * 
	 * @param milestoneString }CXg[()
	 */
	public void setMilestoneString(String milestoneString)
	{
		m_milestoneString = milestoneString;
	}
	/**
	 * ̎擾
	 * 
	 * @return 
	 */
	 public String getRole(int uno) {
		 
		MessageString ms = new MessageString();
		 StringBuffer sb = new StringBuffer();
		 
		 if(m_issuer == uno) {
//			 sb.append("s(issue)\n");
		     sb.append(ms.get("bug.trouble.displayname"));
			 sb.append("\n");
		 }
		 if(m_auther == uno) {
//			 sb.append("F(judge)\n");
		     sb.append(ms.get("bug.judge.displayname"));
			 sb.append("\n");
		 }
		 if(m_analyst == uno) {
//			 sb.append("(analyze)\n");
		     sb.append(ms.get("bug.analyze.displayname"));
			 sb.append("\n");
		 }
		 if(m_updater == uno) {
//			 sb.append("C(update)\n");
		     sb.append(ms.get("bug.update.displayname"));
			 sb.append("\n");
		 }
		 if(m_comfirmer == uno) {
//			 sb.append("mF(confirm)\n");
		     sb.append(ms.get("bug.confirm.displayname"));
			 sb.append("\n");
		 }
		 
		 return Converter.StringToHtml(sb.toString());
	}
//=====================================
// status method
//=====================================
	/**
	 * ͏^Cv̎擾
	 * 
	 * @return ͏^Cv
	 */
	public byte getInputType()
	{
		return m_inputType;
	}
	/**
	 * ͏^Cv̎擾
	 * 
	 * @return ͏^Cv
	 */
	public String getInputTypeString()
	{
		String s = null;
		
		MessageString ms = new MessageString();
		switch(m_inputType) {		//type
		//VK
		case ITYPE_DETAIL0 :
//			s = "s(issue)";
			s = ms.get("buginput.type0.name");
			break;
		//̏
		case ITYPE_DETAIL1 :
//			s = "̏(trouble)";
			s = ms.get("buginput.type1.name");
			break;
		//j
		case ITYPE_DETAIL2 :
//			s = "j(judge)";
			s = ms.get("buginput.type2.name");
			break;
		//
		case ITYPE_DETAIL3 :
//			s = "(analyze)";
			s = ms.get("buginput.type3.name");
			break;
		//u
		case ITYPE_DETAIL4 :
//			s = "u(update)";
			s = ms.get("buginput.type4.name");
			break;
		//mF
		case ITYPE_DETAIL5 :
//			s = "mF(confirm)";
			s = ms.get("buginput.type5.name");
			break;
		}
		return s;
	}
	/**
	 * ͏^CṽZbg
	 * 
	 * @param inputType ͏^Cv
	 */
	public void setInputType(byte inputType)
	{
		m_inputType = inputType;
	}
	/*
	 * Xe[^XɒS҂肷
	 */
	public void setDispatch() {
		
		String s = null;
		int oldDispatch = m_dispatch;	//ύXO
		
		switch(m_status) {
		//mF
		case STS_UNCONFIRMED :
			m_dispatch = 0;				//
			break;
		//VK
		case STS_NEW :
			m_dispatch = m_auther;		//F҂
			break;
		//͒
		case STS_INVESTIGATION :
			m_dispatch = m_analyst;		//͎҂
			break;
		//C
		case STS_REPAIRED :
			m_dispatch = m_updater;		//C
			break;
		//mF
		case STS_RESOLVED :
			m_dispatch = m_comfirmer;	//mF҂
			break;
		//ĊJ
		case STS_REOPEN :
			m_dispatch = m_auther;		//͎҂
			break;
		//
		case STS_CLOSE :
			m_dispatch = 0;				//Ȃ
			break;
		}
		
		//fBXpb`悪ς
		if (oldDispatch != m_dispatch) {
			m_dispatchUser = null;			//[UNA
		}
		
	}
	/**
	 * fBXpb`̎擾
	 * 
	 * @return fBXpb`
	 */
	public int getDispatch()
	{
		//caڂɊ܂߂邽߁A擾ł͂Ȃݒ莞ɃZbg悤ɕύX(8/30)
/*------------------------------------------
		//fBXpb`XV
		setDispatch();
------------------------------------------*/
		return m_dispatch;
	}
	/**
	 * fBXpb`̎擾
	 * 
	 * @return fBXpb`
	 */
	public UserInfo getDispatchUser()
	{
		if (m_dispatchUser == null) {
			if (getDispatch() != 0) {
				m_dispatchUser = UserInfo.getUser(m_dispatch);
			}
		}
		return m_dispatchUser;
	}
	/**
	 * fBXpb`於̎擾
	 * 
	 * @return fBXpb`於
	 */
	public String getDispatchName()
	{
		String s = null;
		if (m_dispatchUser == null) {
			//SҖ
			if (getDispatch() == 0) {
				if (m_status == STS_CLOSE) {
					s = "";
				} else {
					//Ԃ
					s = "()";
				}
			} else {
				s = UserInfo.getUser(m_dispatch).getNickname();
				
			}
		} else {
			s = m_dispatchUser.getNickname();
		}
		return s;
	}
	//=====================================
	//	 ǉ method
	//====================================
	/**
	 * oߓ̎Zo
	 */
	public String getTat(){
	    
	    long ret = 0;
	    
	    if (m_issuDate != null) {
	        
	        ret = (new Date().getTime() - m_issuDate.getTime()) / (24*60*60*1000);
	    }
	    return Long.toString(ret);
	}
	//=====================================
	// AddText method
	//=====================================
	/**
	 * ǉ̎擾iS^Cvj
	 */
	public Collection getAllAddText() {
		
		if (m_allAddText == null) {
			//VKH
			if (m_bno == 0) {
				m_allAddText = new ArrayList();			//̃Xg𐶐
			} else {
				m_allAddText = (ArrayList)AddText.getAddText(m_bno);
				//O̎
				if (m_allAddText == null) {
					m_allAddText = new ArrayList();		//̃Xg𐶐
				}
			}
		}
		return m_allAddText;
	}
	/**
	 * ǉ̎擾ȉej
	 */
	public Collection getTroubleAddText() {
		
		return getAddText(AddText.TYPE_TROUBLE);
	}
	/**
	 * ǉ̎擾iΏj^SҘAj
	 */
	public Collection getPrincipalAddText() {
		
		return getAddText(AddText.TYPE_PRINCIPAL);
	}
	/**
	 * ǉ̎擾ȉጴj
	 */
	public Collection getCauseAddText() {
		
		return getAddText(AddText.TYPE_CAUSE);
	}
	/**
	 * ǉ̎擾iuej
	 */
	public Collection getUpdateAddText() {
		
		return getAddText(AddText.TYPE_UPDATE);
	}
	/**
	 * ǉ̎擾imFej
	 */
	public Collection getConfirmAddText() {
		
		return getAddText(AddText.TYPE_CONFIRM);
	}
	/**
	 * ǉ̃NA
	 */
	public void clearAddText() {
		
		m_allAddText = null;
	}
	/**
	 * ǉ̒ǉ
	 */
	public void addText(String text, UserInfo logonUser) {
		
		//ǉeLXg͂ꂽH
		if ((text != null) && (text.length() > 0)) {
			
			//ǉeLXg
			AddText addText = new AddText();
			
			addText.setBno(m_bno);		//bno
			
			switch(m_inputType) {		//type
			//VK
			case ITYPE_DETAIL0 :
				addText.setTextType(AddText.TYPE_TROUBLE);
				break;
			//̏
			case ITYPE_DETAIL1 :
				addText.setTextType(AddText.TYPE_TROUBLE);
				break;
			//j
			case ITYPE_DETAIL2 :
				addText.setTextType(AddText.TYPE_PRINCIPAL);
				break;
			//
			case ITYPE_DETAIL3 :
				addText.setTextType(AddText.TYPE_CAUSE);
				break;
			//u
			case ITYPE_DETAIL4 :
				addText.setTextType(AddText.TYPE_UPDATE);
				break;
			//mF
			case ITYPE_DETAIL5 :
				addText.setTextType(AddText.TYPE_CONFIRM);
				break;
			}
			addText.setEntryUname(logonUser.getNickname());	//Җ
			addText.setEntryUmail(logonUser.getEmail());	//҃[AhX
			addText.setContent(text);		//e
			
			addText.insert(logonUser.getUno());				//caɒǉ
			
			//܂ĂĂȂ
			if (m_allAddText == null) {
				//Ă
				getAllAddText();
			}
			m_allAddText.add(addText);		//Xgɒǉ
			m_addTextEnable = true;			//ǉeLXgB
		} else {
			
			m_addTextEnable = false;		//ǉeLXgȂB
			
		}
		
		
	}
	/**
	 * ǉ̂Ȃ
	 */
	public boolean isAddTextEnable() {
		return m_addTextEnable;
	}
	/**
	 * Ō̒ǉ
	 */
	public AddText getLastAddText() {
		
		if (m_allAddText == null) {
			getAllAddText();
		}
		
		if (m_allAddText.size() == 0) {
			return null;
		} else {
			return (AddText)m_allAddText.get(m_allAddText.size() - 1 );
		}
		
	}
	/**
	 * ǉ̎擾i^Cvwj
	 */
	private Collection getAddText(byte type) {
		
		ArrayList newList = new ArrayList();	//VXg
		
		//SĂ
		Collection list = getAllAddText();
		Iterator ite = list.iterator();
		
		while(ite.hasNext()) {
			AddText text = (AddText)ite.next();
			if(text.getTextType() == type) {
				newList.add(text);
			}
		}
		return newList;
	}
//=====================================
// ֘AoO method
//=====================================
	public Collection getReletedBug() {
		
		//ɎĂ邩H
		if (m_reletedBug == null) {
			//
			m_reletedBug = BugDepends.getBugDepends(m_bno);
			//0H
			if (m_reletedBug == null) {
				//̃Xg
				m_reletedBug = new ArrayList();
				
			}
		}
		return m_reletedBug;
	}
//=====================================
// CC method
//=====================================
	/**
	 * bb̎擾
	 */
	public Collection getCc() {
		//ĂȂ
		if (m_cc == null) {
			//VK
			if (m_bno == 0) {
				m_cc = new ArrayList();
			} else {
				//cč
				m_cc = Cc.getCc(m_bno);
				//Ȍꍇ
				if (m_cc == null) {
					m_cc = new ArrayList();
				}
			}
		}
		return m_cc;
	}
	/**
	 * bb̃Zbg
	 */
	public void setCc(Collection cc) {
		m_cc = cc;
	}
	/**
	 * bb̍XV
	 */
	public void updateCc(int uno) {
		
		//bb̍폜
		Collection oldCc = Cc.getCc(m_bno);
		if (oldCc != null) {
			Iterator ite = oldCc.iterator();
			while(ite.hasNext()) {
				Cc cc = (Cc)ite.next();
				cc.delete(uno);
			}
		}
		//Vbb̒ǉ
		if (m_cc != null) {
			Iterator ite = m_cc.iterator();
			while(ite.hasNext()) {
				Cc cc = (Cc)ite.next();
				cc.insert(uno);
			}
		}
		
	}
//=====================================
// Xe[^X method
//=====================================
	/**
	 * Xe[^XRNV̎擾
	 */
	public static Collection getStatusCollection() {
		
		ArrayList list = new ArrayList();
		// mF
		list.add(new BugStatus(STS_UNCONFIRMED, getStatusString(STS_UNCONFIRMED)));
		// VK
		list.add(new BugStatus(STS_NEW, getStatusString(STS_NEW)));
		// ͒
		list.add(new BugStatus(STS_INVESTIGATION, getStatusString(STS_INVESTIGATION)));
		// C
		list.add(new BugStatus(STS_REPAIRED, getStatusString(STS_REPAIRED)));
		// mF
		list.add(new BugStatus(STS_RESOLVED, getStatusString(STS_RESOLVED)));
		// ĊJ
		list.add(new BugStatus(STS_REOPEN, getStatusString(STS_REOPEN)));
		// 
		list.add(new BugStatus(STS_CLOSE, getStatusString(STS_CLOSE)));
		
		return list;
	 }
//=====================================
// Activitys method
//=====================================
	/**
	 * Activity擾Jn
	 */
	public void startActivity() {
		m_activity = true;
		m_activitys = new Activitys();
		
	}
	/**
	 * Activity擾I
	 */
	public void endActivity() {
		m_activity = false;
		
	}
	/**
	 * Activity擾H
	 */
	public boolean isActivity() {
		return m_activity;
		
	}
	/**
	 * Activity̒ǉ
	 */
	public void addActivity(String id, Object oldValue, Object newValue) {
		m_activitys.add(new Activity(id, oldValue, newValue));
	}
	/**
	 * Activitys̎擾
	 */
	public Activitys getActivitys() {
		if (m_activitys != null) {
			//bugg
			m_activitys.setBug(this);
		}
		return m_activitys;
	}
	/**
	 * null->stringϊ
	 */
	private String nullString(String s) {
		String ret = s;
		if ((s == null) || (s.length() == 0)) {
			s = new String();
		}
		return s;
	}
	/**
	 * null->stringϊ
	 */
	private String nullCode(String s) {
		String ret = s;
		if ((s == null) || (s.equals("00"))) {
			s = new String();
		}
		return s;
	}
	/**
	 * null->String and Date->Stringϊ
	 */
	private String nullDate(Date date) {
		String s;
		if (date == null) {
			s = new String();
		} else {
			s = Converter.getDateString(date, Converter.SHORT_DATE);
		}
		return s;
	}
	/**
	 * BugActivitys̎擾
	 */
	public Collection getBugActivitys() {
		
		Collection list = BugActivity.getBugActivity(m_bno);
		if (list == null) {
			list = new ArrayList();
		}
		return list;
	}
//=====================================
// Attachments method
//=====================================
	/**
	 * Attachments擾Jn
	 */
	public Collection getAttachments() {
		
		Collection attachs = Attachment.getAttachmentByBno(m_bno);
		if (attachs == null) {
			attachs = new ArrayList();
		}
		return attachs;
	}
//=====================================
// rp
//=====================================
	/**
	 * ŏIXV`FbN
	 */
	public boolean isChanged() {
		
		Date updateDate = BugFinder.getUpdateDate(m_bno);
		
		//{͂Ȕ肢ȂADAOdescribleɌĂԂ̂ő΍B
		if (updateDate != null) {
			return !(updateDate.equals(m_updateDate));
		} else {
			return false;
		}
		
	}
//===========================================================================
// debugging methods
//===========================================================================
	/**
	 *	NX
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		StringBuffer sb1 = new StringBuffer();
		
		sb.append("--- [BUG] --- \n");
		sb.append("bug #" + m_bno);
		appendDebug(sb, "bid" , m_bid);
		sb.append(" status:" + getStatusString());
		sb.append("(" + m_status + ")\n");
		
		sb.append("title:" + m_title + "\n");
		
		appendDebug(sb1, "statusWhitebord", m_statusWhitebord);
		if (sb1.length() > 0)  {
			sb.append(sb1 + "\n");
		}
		sb1.delete(0, sb1.length());
		
		appendDebug(sb1, "loc" ,m_location);
		appendDebug(sb1, "sub" ,m_subsystem);
		appendDebug(sb1, "fun" ,m_functionName);
		appendDebug(sb1, "scr" ,m_screen);
		appendDebug(sb1, "brw" ,m_browser);
		appendDebug(sb1, "os" ,m_os);
		appendDebug(sb1, "tid" ,m_tid);
		if (sb1.length() > 0)  {
			sb.append(sb1 + "\n");
		}
		sb1.delete(0, sb1.length());
		
		appendDebug(sb1, "app" ,m_appVersion);
		appendDebug(sb1, "db" ,m_dbVersion);
		appendDebug(sb1, "html" ,m_htmlVersion);
		appendDebug(sb1, "spec" ,m_specVersion);
		appendDebug(sb1, "sev" ,m_severity);
		appendDebug(sb1, "pri" ,m_priority);
		appendDebug(sb1, "res" ,m_resolution);
		appendDebug(sb1, "mil" ,m_milestone);
		appendDebug(sb1, "scid" ,m_scid);
		if (sb1.length() > 0)  {
			sb.append(sb1 + "\n");
		}
		sb1.delete(0, sb1.length());
		
		appendDebug(sb1, "kw1" ,m_keyword1);
		appendDebug(sb1, "kw2" ,m_keyword2);
		appendDebug(sb1, "kw3" ,m_keyword3);
		appendDebug(sb1, "relDoc" ,m_reletedDoc);
		if (sb1.length() > 0)  {
			sb.append(sb1 + "\n");
		}
		sb1.delete(0, sb1.length());
		
		appendDebug(sb1, "cp1" ,m_cpid1);
		appendDebug(sb1, "cp2" ,m_cpid2);
		appendDebug(sb1, "cp3" ,m_cpid3);
		appendDebug(sb1, "cp4" ,m_cpid4);
		appendDebug(sb1, "cp5" ,m_cpid5);
		if (sb1.length() > 0)  {
			sb.append(sb1 + "\n");
		}
		sb1.delete(0, sb1.length());
		
		appendDebug(sb1, "upDoc" ,m_updateDoc);
		if (sb1.length() > 0)  {
			sb.append(sb1 + "\n");
		}
		sb1.delete(0, sb1.length());
		
		appendDebug(sb1, "eType" ,m_errorType);
		appendDebug(sb1, "eCause" ,m_errorCause);
		appendDebug(sb1, "ePoint" ,m_errorPoint);
		appendDebug(sb1, "iPno" ,m_issuPno);
		appendDebug(sb1, "tPno" ,m_trainPno);
		appendDebug(sb1, "sPno" ,m_shouldFindPno);
		appendDebug(sb1, "eReason" ,m_errorDelayReason);
		if (sb1.length() > 0)  {
			sb.append(sb1 + "\n");
		}
		sb1.delete(0, sb1.length());

		appendDebug(sb1, "issuer" ,m_issuer);
		appendDebug(sb1, "auther" ,m_auther);
		appendDebug(sb1, "analyst" ,m_analyst);
		appendDebug(sb1, "updater" ,m_updater);
		appendDebug(sb1, "comfirmer" ,m_comfirmer);
		appendDebug(sb1, "dispatch" ,m_dispatch);
		appendDebug(sb1, "dispatchUser" ,m_dispatchUser);
		if (sb1.length() > 0)  {
			sb.append(sb1 + "\n");
		}
		sb1.delete(0, sb1.length());
		
		appendDebug(sb1, "issuDate " ,getIssuDateString());
		appendDebug(sb1, "regDate  " ,getRegistDateString());
		appendDebug(sb1, "authDate " ,getAuthDateString());
		appendDebug(sb1, "anaDate  " ,getAnalizeDateString());
		if (sb1.length() > 0)  {
			sb.append(sb1 + "\n");
		}
		sb1.delete(0, sb1.length());
		
		appendDebug(sb1, "upDate   " ,getBugUpdateDateString());
		appendDebug(sb1, "relShDate" ,getReleaseSchDateString());
		appendDebug(sb1, "relDate  " ,getReleaseDateString());
		appendDebug(sb1, "comlDate " ,getComfirmDateString());
		if (sb1.length() > 0)  {
			sb.append(sb1 + "\n");
		}
		sb1.delete(0, sb1.length());
		
		appendDebug(sb1, "msgId" ,m_messageId);
		appendDebug(sb1, "upUno" ,m_updateUno);
		appendDebug(sb1, "updateDate" ,getUpdateDateString());
		appendDebug(sb1, "persistDate" ,getPersistDateString());
		if (sb1.length() > 0)  {
			sb.append(sb1 + "\n");
		}
		sb1.delete(0, sb1.length());
		
		sb.append("--- [BUG] --- \n");
		return sb.toString();
	}
	/**
	 *
	 */
	private void appendDebug(StringBuffer sb, String key, int i) {
		if (i != 0) {
			if (sb.length() > 0) {
				sb.append(" ");
			}
			sb.append(key + ":" + i);
		}
	}
	/**
	 *
	 */
	private void appendDebug(StringBuffer sb, String key, Object o) {
		if (o != null) {
			if (sb.length() > 0) {
				sb.append(" ");
			}
			sb.append(key + ":" + o);
		}
	}
//===========================================================================
// test code
//===========================================================================
	/**
	 *	eXgC
	 */
	public static void main(String[] args)
	{
		System.out.println("------- << Bug Test Start >> -----------");
		
		unitTest1();	//VKoO쐬eXg()
		unitTest2();	//VKoO쐬eXg(Sڎw)
		unitTest3();	//oOXVeXg
		unitTest4();	//oO폜eXg
		unitTest5();	//S擾eXg
		unitTest6();	//oOIDeXg
		unitTest7();	//oOԍwRXgNgeXg
		
		System.out.println("------- << Bug Test End >> -----------");
	}
	
	/**
	 *	unitTest1
	 *
	 * VKoO쐬eXg()
	 *
	 */
	public static void unitTest1()
	{
		System.out.println("------- unitTest1 -----------");
		
		Bug bug = new Bug();
		//l̃Zbg
		bug.setIssuer(1);
		bug.setStatus(STS_NEW);
		bug.setRegistDate(new Date());
		//10ǉ
		for(int i = 0; i < 10; i++) {
			bug.setTitle("eXgoO" + i);
			bug.insert(i);
		}
		System.out.println("insert success");
	}
	/**
	 *	unitTest2
	 *
	 * VKoO쐬eXg(Sڎw)
	 *
	 */
	public static void unitTest2()
	{
		System.out.println("------- unitTest2 -----------");
		
		Bug bug = new Bug();
		//l̃Zbg
		bug.setBid("NWO1-SI1-000000");
		bug.setTitle("^Cg");
		bug.setLocation("01");
		bug.setSubsystem("01");
		bug.setBrowser("01");
		bug.setOs("01");
		bug.setTid("010101-001");
		bug.setAppVersion("01");
		bug.setDbVersion("01");
		bug.setHtmlVersion("01");
		bug.setIssuer(8);
		bug.setIssuDate(new Date());
		bug.setRegistDate(new Date());
		bug.setSeverity("01");
		bug.setPriority("01");
		bug.setStatus(STS_CLOSE);
		bug.setStatusWhitebord("Xe[^X");
		bug.setResolution("01");
		bug.setMilestone("01");
		bug.setScid("scid-0001");
		bug.setKeyword1("keyword1");
		bug.setKeyword2("keyword2");
		bug.setKeyword3("keyword3");
		bug.setReletedDoc("֘AhLg");
		bug.setAuther(9);
		bug.setAuthDate(new Date());
		bug.setErrorType("01");
		bug.setErrorCause("01");
		bug.setErrorPoint("01");
		bug.setIssuPno("01");
		bug.setTrainPno("01");
		bug.setShouldFindPno("01");
		bug.setErrorDelayReason("01");
		bug.setReleaseSchDate(new Date());
		bug.setAnalyst(8);
		bug.setAnalizeDate(new Date());
		bug.setUpdateDoc("ύXhLg");
		bug.setUpdater(9);
		bug.setBugUpdateDate(new Date());
		bug.setReleaseDate(new Date());
		bug.setComfirmer(3);
		bug.setComfirmDate(new Date());
		//ǉ
		bug.insert(0);
		
		System.out.println(bug.toString());
	}
	/**
	 *	unitTest3
	 *
	 * XVeXg
	 *
	 */
	public static void unitTest3()
	{
		System.out.println("------- unitTest3 -----------");
		
		//݃`FbN
		Bug bug = Bug.getBug(1);		//test 1 bug
		if (bug == null) {
			//݂ĂȂeXg~
			throw new Error("target is nothing");
		}
		
		System.out.println(bug.toString());
		
		bug.setBid("NWO1-SI1-000002");
		bug.setTitle("^Cg2");
		bug.setLocation("02");
		bug.setSubsystem("02");
		bug.setBrowser("02");
		bug.setOs("02");
		bug.setTid("010101-001");
		bug.setAppVersion("02");
		bug.setDbVersion("02");
		bug.setHtmlVersion("02");
		bug.setIssuer(1);
		bug.setIssuDate(new Date());
		bug.setRegistDate(new Date());
		bug.setSeverity("02");
		bug.setPriority("02");
		bug.setStatus(STS_CLOSE);
		bug.setStatusWhitebord("Xe[^X󋵂Q");
		bug.setResolution("02");
		bug.setMilestone("02");
		bug.setScid("SCID-0002");
		bug.setKeyword1("keyword1");
		bug.setKeyword2("keyword2");
		bug.setKeyword3("keyword3");
		bug.setReletedDoc("֘AhLg");
		bug.setAuther(2);
		bug.setAuthDate(new Date());
		bug.setErrorType("02");
		bug.setErrorCause("02");
		bug.setErrorPoint("02");
		bug.setIssuPno("02");
		bug.setTrainPno("02");
		bug.setShouldFindPno("02");
		bug.setErrorDelayReason("02");
		bug.setReleaseSchDate(new Date());
		bug.setAnalyst(3);
		bug.setAnalizeDate(new Date());
		bug.setUpdateDoc("ύXhLg");
		bug.setUpdater(4);
		bug.setBugUpdateDate(new Date());
		bug.setReleaseDate(new Date());
		bug.setComfirmer(5);
		bug.setComfirmDate(new Date());
		//XV
		bug.update(5);
		
		System.out.println(bug.toString());
	}
	/**
	 *	unitTest4
	 *
	 * oO폜eXg
	 *
	 */
	public static void unitTest4()
	{
		System.out.println("------- unitTest4 -----------");
		
		//݃`FbN
		Bug bug = Bug.getBug(1);
		if (bug == null) {
			//݂ĂȂeXg~
			throw new Error("target is nothing");
		}
		
		//폜
		bug.delete(2);
		
		//݃`FbN
		bug = Bug.getBug(1);
		if (bug != null) {
			//݂ĂȂeXg~
			throw new Error("delete failer");
		} else {
			System.out.println("delete success");
		}
	}
	/**
	 *	unitTest5
	 *
	 * S擾eXg
	 *
	 */
	public static void unitTest5()
	{
		System.out.println("------- unitTest5 -----------");
		
		Collection bugs = Bug.findAll();
		dispUser(bugs);
	}
	/**
	 *	unitTest6
	 *
	 * oOIDeXg
	 *
	 */
	public static void unitTest6()
	{
		System.out.println("------- unitTest6 -----------");
		
		Bug bug = Bug.getBug(6);
		
		System.out.println(bug.toString());
	}
	/**
	 *	unitTest7
	 *
	 * oOԍRXgNgeXg
	 *
	 */
	public static void unitTest7()
	{
		System.out.println("------- unitTest7 -----------");
		
		Bug bug = new Bug(7);
		
		System.out.println(bug.toString());
	}
	/**
	 * oOXg̕\
	 *
	 */
	private static void dispUser(Collection bugs)
	{
		Iterator ite = bugs.iterator();
		
		while(ite.hasNext()) {
			Bug bug = (Bug)ite.next();
			
			System.out.println(bug.getBno() + "-" + bug.getTitle());
		}
	}
}