//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.bug;

//===========================================================================
// import
//===========================================================================
// Java core API
import java.util.*;
import java.text.*;
import org.apache.commons.logging.*;

// DB API
import jp.gr.java_conf.bugslife.db.*;

// Util API
import jp.gr.java_conf.bugslife.util.*;
//import jp.gr.java_conf.bugslife.system.*;


/**
 *<PRE>
 * 
 * BugDependsNX
 * 
 *</PRE>
 * @version	0.0, 2001/09/10
 * @author	k@
 */
//===========================================================================
public class BugDepends implements IUpdatable, ILoadable
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 *	oOԍ
	 */
	private int m_bno = 0;
	/**
	 *	ˑoOԍ
	 */
	private int m_dependBno = 0;
	/**
	 *	ˑoO
	 */
	private Bug m_dependBug = new Bug();
	/**
	 *	XV
	 */
	private int m_updateUno = 0;
	/**
	 *	XV
	 */
	private Date m_updateDate = new Date();
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//=====================================
// DBpڒ`
//=====================================
	/**
	 * r
	 */
	private static final boolean EXCLUSION = true;	//
	/**
	 * AutoIncrement
	 */
	private static final boolean ATOINCREMENT = false;	//Ȃ
	/**
	 * PK 
	 */
	private static final String[] PK = {"bno", "dependBno"};
	/**
	 * XVږ
	 */
	private static final String[] DB_ITEMS = {
									"bno","dependBno",
									"updateUno" };
//===========================================================================
// methods
//===========================================================================
	/**
	 *	ftHgRXgN^
	 *
	 */
	public BugDepends()
	{
		
	}
//======================================
// db access methods
//======================================
	/**
	 *	insertDB
	 *
	 * @return	
	 */
	public void insert(int updateUno)
	{
		setUpdateUno(updateUno);
		setUpdateDate(Calendar.getInstance().getTime());
		DAO.insert(this);
//		load();		//ŏIXVق̂ōă[h
	}
	/**
	 *	delete
	 *
	 * @return	
	 */
	public void delete(int updateUno)
	{
		setUpdateUno(updateUno);
		delete();
	}
	/**
	 *	delete
	 *
	 * @return	
	 */
	public void delete()
	{
		DAO.delete(this);
	}
	/**
	 *	load
	 *
	 * @return	
	 */
	public void load()
	{
		DAO.load(this);
	}
	/**
	 *	findAll
	 *
	 * @return	
	 */
	public static Collection findAll()
	{
		return DAO.findAll(new BugDepends());
	}
	/**
	 *	BugDepends̎擾ioOԍwj
	 *
	 * @return	
	 */
	public static Collection getBugDepends(int bno)
	{
		String sql = 
		"SELECT" +
		" A.bno as bno," +
		" A.dependBno as dependBno," +
		" A.updateUno as updateUno," +
		" A.updateDate as updateDate," +
		" B.status as status," +
		" B.title as title" +
		" FROM BugDepends AS A" +
		" LEFT JOIN Bug AS B ON A.dependBno = B.bno" +
		" WHERE A.bno = ?" +
		" ORDER BY A.bno,A.dependBno";
		
		ArrayList params = new ArrayList();
		params.add(new Integer(bno));
		
		return( DAO.find(new BugDepends(), sql, params));
	}
	/**
	 *	BugDepends̎擾iˑoOԍwj
	 *
	 * @return	
	 */
	public static Collection getChildBugDepends(int bno)
	{
		String sql = 
		"SELECT" +
		" A.bno as bno," +
		" A.dependBno as dependBno," +
		" A.updateUno as updateUno," +
		" A.updateDate as updateDate," +
		" B.status as status," +
		" B.title as title" +
		" FROM BugDepends AS A" +
		" LEFT JOIN Bug AS B ON A.dependBno = B.bno" +
		" WHERE A.dependBno = ?" +
		" ORDER BY A.bno,A.dependBno";
		
		ArrayList params = new ArrayList();
		params.add(new Integer(bno));
		
		return( DAO.find(new BugDepends(), sql, params));
	}
	/**
	 *	eoOԍ̎擾ioOԍwj
	 *
	 * @return	
	 */
	public static String getParentsString(int bno)
	{
		StringBuffer ret = new StringBuffer();
		Collection collection = getChildBugDepends(bno);
		if (collection != null) {
			Iterator ite = collection.iterator();
			while (ite.hasNext()) {
				if (ret.length() != 0) {
					ret.append(",");
				}
				ret.append(String.valueOf(((BugDepends)ite.next()).getBno()));
			}
		}
		
		return ret.toString();
	}
	/**
	 *	qoOԍ̎擾ioOԍwj
	 *
	 * @return	
	 */
	public static String getChildsString(int bno)
	{
		StringBuffer ret = new StringBuffer();
		Collection collection = getBugDepends(bno);
		if (collection != null) {
			Iterator ite = collection.iterator();
			while (ite.hasNext()) {
				if (ret.length() != 0) {
					ret.append(",");
				}
				ret.append(String.valueOf(((BugDepends)ite.next()).getDependBno()));
			}
		}
		
		return ret.toString();
	}
//======================================
// Db Interface
//======================================
	/**
	 * 
	 */
	public String[] getUpdateItemNames() {
		
		return DB_ITEMS;
		
	}
	/**
	 * PK items
	 */
	 public String[] getPKItems() {
		return PK;
	}
	/**
	 * r䂠Ȃ
	 */
	public boolean isExclusion() {
		return EXCLUSION;
	}
	/**
	 * AutoIncrementȂ
	 */
	public boolean isAutoIncrement() {
		return ATOINCREMENT;
	}
//======================================
// request param
//======================================
	/**
	 *	request parametor̐
	 */
	public Map getMapping() {
		HashMap map = new HashMap();
		map.put("bno", new Integer(m_dependBno));
		return map;
	}
//======================================
// Property
//======================================
	/**
	 * oOԍ̎擾
	 * 
	 * @return oOԍ
	 */
	public int getBno()
	{
		return m_bno;
	}
	/**
	 * oOԍ̃Zbg
	 * 
	 * @param bno oOԍ
	 */
	public void setBno(int bno)
	{
		m_bno = bno;
	}
	/**
	 * ˑoOԍ̎擾
	 * 
	 * @return ˑoOԍ
	 */
	public int getDependBno()
	{
		return m_dependBno;
	}
	/**
	 * ˑoOԍ̎擾
	 * 
	 * @return ˑoOԍ
	 */
	public String getDependBnoString()
	{
		return m_dependBug.getBnoString();
	}
	/**
	 * ˑoOԍ̃Zbg
	 * 
	 * @param dependBno ˑoOԍ
	 */
	public void setDependBno(int dependBno)
	{
		m_dependBno = dependBno;
		
		//add
		m_dependBug.setBno(dependBno);
		
	}
	/**
	 * Xe[^X̎擾
	 * 
	 * @return Xe[^X
	 */
	public byte getStatus()
	{
		return m_dependBug.getStatus();
	}
	/**
	 * Xe[^X̎擾()
	 * 
	 * @return Xe[^X
	 */
	public String getStatusString()
	{
		return m_dependBug.getStatusString();
	}
	/**
	 * Xe[^X̃Zbg
	 * 
	 * @param status Xe[^X
	 */
	public void setStatus(byte status)
	{
		m_dependBug.setStatus(status);
	}
	/**
	 * ^Cg̎擾
	 * 
	 * @return ^Cg
	 */
	public String getTitle()
	{
		return m_dependBug.getTitle();
	}
	/**
	 * ^Cg̃Zbg
	 * 
	 * @param title ^Cg
	 */
	public void setTitle(String title)
	{
		m_dependBug.setTitle(title);
	}
	/**
	 * XV҂̎擾
	 * 
	 * @return XV
	 */
	public int getUpdateUno()
	{
		return m_updateUno;
	}
	/**
	 * XV҂̃Zbg
	 * 
	 * @param updateUno XV
	 */
	public void setUpdateUno(int updateUno)
	{
		m_updateUno = updateUno;
	}
	/**
	 *	XV̎擾
	 *
	 * @return	update		XV
	 */
	public Date getUpdateDate()
	{
		return m_updateDate;
	}
	/**
	 *	XV̎擾
	 *
	 * @return	update		XV
	 */
	public String getUpdateDateString()
	{
		return Converter.getDateString(m_updateDate, Converter.DATE_TIME);
	}
	/**
	 *	XṼZbg
	 *
	 * @return	update		XV
	 */
	public void setUpdateDate(Date date)
	{
		m_updateDate = date;
	}
//===========================================================================
// methods
//===========================================================================
	/**
	 *	NX
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		sb.append("--- [BugDepends] --- \n");
		sb.append("bno      : " + m_bno + "\n");
		sb.append("depBno   : " + m_dependBno + "\n");
		sb.append("status   : " + getStatusString() + "\n");
		sb.append("title    : " + getTitle() + "\n");
		sb.append("updateUno: " + m_updateUno + "\n");
		sb.append("updateDate: " + getUpdateDateString() + "\n");
		sb.append("--- [BugDepends] --- \n");
		return sb.toString();
	}
	/**
	 *	eXgC
	 */
	public static void main(String[] args)
	{
		System.out.println("------- << BugDepends Test Start >> -----------");
		unitTest1();	//VK쐬eXg
		unitTest2();	//폜eXg
//		unitTest3();	//R[hwRXgNgeXg
		
		System.out.println("------- << BugDepends Test End >> -----------");
	}
	
	/**
	 *	unitTest1
	 *
	 * VK쐬eXg
	 *
	 */
	public static void unitTest1()
	{
		System.out.println("------- unitTest1 -----------");
		
		//l̃Zbg
		BugDepends bugDepends = new BugDepends();
		
		for(int i = 0; i < 3; i++) {
			bugDepends.setBno(2);
			bugDepends.setDependBno(i+1);
			
			//ǉ
			bugDepends.insert(0);
			
			//\
			display(BugDepends.getBugDepends(2));
		}
		
	}
	/**
	 *	unitTest2
	 *
	 * [U폜eXg
	 *
	 */
	public static void unitTest2()
	{
		System.out.println("------- unitTest2 -----------");
		
		//݃`FbN
		Collection depends = BugDepends.getBugDepends(2);
		if (depends == null) {
			//݂ĂȂeXg~
			throw new Error("target is nothing");
		}
		
		Iterator ite = depends.iterator();
		while(ite.hasNext()) {
			BugDepends dep = (BugDepends)ite.next();
			dep.delete(0);		//폜
		}
		
		//݃`FbN
		depends = BugDepends.getBugDepends(2);
		if (depends != null) {
			//݂ĂȂeXg~
			throw new Error("delete failer");
		}
	}
	/**
	 *	unitTest3
	 *
	 * R[hw茟
	 *
	 */
	public static void unitTest3()
	{
		System.out.println("------- unitTest3 -----------");
		
		display(BugDepends.getBugDepends(1));
		
	}
	/**
	 * Xg̕\
	 *
	 */
	private static void display(Collection list)
	{
		Iterator ite = list.iterator();
		
		while(ite.hasNext()) {
			BugDepends BugDepends = (BugDepends)ite.next();
			
			System.out.println(BugDepends.toString());
		}
	}
}