//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.bug;

//===========================================================================
// import
//===========================================================================
// Java core API
import java.util.*;
import java.text.*;
import org.apache.commons.logging.*;

// DB API
import jp.gr.java_conf.bugslife.db.*;

// Util API
import jp.gr.java_conf.bugslife.util.*;
import jp.gr.java_conf.bugslife.user.*;
//import jp.gr.java_conf.bugslife.system.*;


/**
 *<PRE>
 * 
 * InfoBugNX
 * 
 *</PRE>
 * @version	0.0, 2001/09/10
 * @author	k@
 */
//===========================================================================
public class InfoBug extends Bug
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 *	@\
	 */
	private String m_functionLabel = null;
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//===========================================================================
// methods
//===========================================================================
	/**
	 *	ftHgRXgN^
	 *
	 */
	public InfoBug()
	{
		
	}
//======================================
// Property
//======================================
	/**
	 * ŏIXV̎擾
	 * 
	 * @return ŏIXV
	 */
	public String getUpdateDateString()
	{
		Date date = getUpdateDate();
		return Converter.getDateString(date, Converter.MMDDHHMM);
	}
	/**
	 * ŏIXṼZbg
	 * 
	 * @param date ŏIXV
	 */
	public void setUpdateDateString(String date)
	{
		//
	}
	/**
	 * @\̂̎擾
	 * 
	 * @return @\
	 */
	public String getFunctionLabel()
	{
		return m_functionLabel;
	}
	/**
	 * @\̂̃Zbg
	 * 
	 * @param functionLabel @\
	 */
	public void setFunctionLabel(String functionLabel)
	{
		m_functionLabel = functionLabel;
	}
//===========================================================================
// methods
//===========================================================================
	/**
	 *	NX
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		sb.append("--- [InfoBug] --- \n");
		sb.append("bno   : " + getBnoString() + "\n");
		sb.append("title : " + getTitle() + "\n");
		sb.append("status: " + getStatusString() + "\n");
		sb.append("update: " + getUpdateDateString() + "\n");
		sb.append("fucntion  : " + m_functionLabel + "\n");
		sb.append("Compo     : " + getComponentString() + "\n");
		sb.append("dispatch  : " + getDispatchName() + "\n");
		sb.append("--- [InfoBug] --- \n");
		return sb.toString();
	}
	/**
	 *	eXgC
	 */
	public static void main(String[] args)
	{
		System.out.println("------- << InfoBug Test Start >> -----------");
		unitTest1();	//eXg
		System.out.println("------- << InfoBug Test End >> -----------");
	}
	
	/**
	 *	unitTest1
	 *
	 * VK쐬eXg
	 *
	 */
	public static void unitTest1()
	{
		System.out.println("------- unitTest1 -----------");
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.DATE, -7);
		
		Collection list = BugFinder.findUpdateBug(cal.getTime());
		//\
		display(list);
		
	}
	/**
	 * Xg̕\
	 *
	 */
	private static void display(Collection list)
	{
		Iterator ite = list.iterator();
		
		while(ite.hasNext()) {
			InfoBug InfoBug = (InfoBug)ite.next();
			
			System.out.println(InfoBug.toString());
		}
	}
}