//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.util;

//===========================================================================
// import
//===========================================================================
import org.apache.commons.logging.*;
import java.util.*;

import jp.gr.java_conf.bugslife.user.*;
import jp.gr.java_conf.bugslife.bug.*;
/**
 *<PRE>
 * [GgNX
 *
 *
 *</PRE>
 * @version	0.1, 2000/11/30
 * @author	k 
 */
//===========================================================================
// version	0.0, 2000/11/30	VK쐬
//===========================================================================
public class MailElements {
//===========================================================================
// attributes
//===========================================================================
	/**
	 * smtp host
	 */
	private String m_smtphost = "mail29.silk.ntts.co.jp";
//	private String m_smtphost = "mail.asahi-net.or.jp";
	/**
	 * charset
	 */
	private String m_charset = "iso-2022-jp";
	/**
	 * mailer
	 */
	private String m_mailer = "Bugslife Mail Sending System";
	/**
	 * from
	 */
	private String m_from = "bugslife<wani-m@mail29.silk.ntts.co.jp>";
//	private String m_from = "bugslife<wakame@t.email.ne.jp>";
	/**
	 * to
	 */
	private Map m_to = new HashMap();
	/**
	 * cc
	 */
	private Map m_cc = new HashMap();
	/**
	 * subject
	 */
	private String m_subject = null;
	/**
	 * body
	 */
	private String m_body = new String();
	/**
	 * messageId
	 */
	private String m_messageId = null;
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//===========================================================================
// methods
//===========================================================================
	public void setSmtphost(String smtphost) {
		m_smtphost = smtphost;
	}
	
	public String getSmtphost() {
		return m_smtphost;
	}
	
	public void setCharset(String charset) {
		m_charset = charset;
	}
	
	public String getCharset() {
		return m_charset;
	}
	
	public String getMailer() {
		return m_mailer;
	}
	
	public void addTo(UserInfo to) {
		if (to != null) {
			//change wani 03/01/05
			putEmails(m_to, to.getEmail(), to.getNickname());
		}
	}

	public String[] getTo() {
		
		String[] to = new String[m_to.size()];
		Iterator ite =  m_to.keySet().iterator();
		int i = 0;
		while(ite.hasNext()) {
			String email = (String)ite.next();
			to[i++] = email;
		}
		return to;
	}
	
	public void addCc(Cc cc) {
		//change wani 03/01/05
		putEmails(m_cc, cc.getEmail(), cc.getNickname());
//		m_cc.put(cc.getEmail().trim(), cc.getNickname());
	}
	public void addCc(UserInfo cc) {
		//change wani 03/01/05
		putEmails(m_cc, cc.getEmail(), cc.getNickname());
//		m_cc.put(cc.getEmail().trim(), cc.getNickname());
	}
	
	public String[] getCc() {
		String[] cc = new String[m_cc.size()];
		Iterator ite =  m_cc.keySet().iterator();
		int i = 0;
		while(ite.hasNext()) {
			cc[i++] = (String)ite.next();
		}
		return cc;
	}
	public String[] getCcName() {
		String[] ccName = new String[m_cc.size()];
		Iterator ite =  m_cc.keySet().iterator();
		int i = 0;
		while(ite.hasNext()) {
			String email = (String)ite.next();
			ccName[i++] = (String)m_cc.get(email);
			
		}
		return ccName;
	}
	public void setFrom(String from) {
		m_from = from;
	}

	public String getFrom() {
		return m_from;
	}

	public void setSubject(String subject) {
		m_subject = subject;
	}

	public String getSubject() {
		return m_subject;
	}

	public void setBody(String body) {
		m_body = body;
	}

	public String getBody() {
		return m_body;
	}

	public void setMessageId(String messageId) {
		m_messageId = messageId;
	}

	public String getMessageId() {
		return m_messageId;
	}
	
	/**
	 * emailwΉ wani 03/01/05
	 */
	private void putEmails(Map map, String eMail, String nickName) {
		
		StringTokenizer st = new StringTokenizer(eMail, ",");
		while (st.hasMoreTokens()) {
			map.put(st.nextToken().trim(), nickName);
		}
	}
//===========================================================================
// debugging method
//===========================================================================
	/**
	 *	NX
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		sb.append("--- [MAIL ELEMENT] --- \n");
		sb.append("smtphost: " + m_smtphost + "\n");
		sb.append("charset : " + m_charset + "\n");
		sb.append("to      : " + toStrigArray(getTo()) + "\n");
		sb.append("cc      : " + toStrigArray(getCc()) + "\n");
		sb.append("from    : " + m_from + "\n");
		sb.append("subject : " + m_subject + "\n");
		sb.append("body    : " + m_body + "\n");
		sb.append("msgId   : " + m_messageId + "\n");
		sb.append("--- [MAIL ELEMENT] --- \n");
		return sb.toString();
	}
	private String toStrigArray(String[] array) {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < array.length; i++) {
			sb.append( sb.length() > 0 ? "," : "");
			sb.append(array[i]);
		}
		return new String(sb);
	}
	/**
	 * debug
	 */
	private void debug(String s) {
		 
		 System.out.println("[MailElement]" + s);
		 
	}
//===========================================================================
// test code
//===========================================================================
	/**
	 *	eXgC
	 */
	public static void main(String[] args)
	{
		System.out.println("------- << MailElement Test Start >> -----------");
		unitTest1();		//
		
		System.out.println("------- << MailElement Test End >> -----------");
	}
	
	/**
	 *	unitTest1
	 *
	 * eXgP
	 *
	 */
	public static void unitTest1()
	{
		System.out.println("------- unitTest1 -----------");
		
		String body = "\n" +
					"̏#0001XV܂B\n" +
					"\n" +
					"^CgFXVȂ\n" +
					"dvx@F_E\n" +
					"e@@Fwwwwwwwwł܂B\n" +
					"\n";
					
		
		MailElements me = new MailElements();
		me.setFrom("bugslife<wani-m@mail29.silk.ntts.co.jp>");
		me.setSubject("[̏#0001]ʌoHIȂ");
		me.setBody(body);
		
		UserInfo user = new UserInfo(7);
		
		me.addTo(user);
		me.addCc(user);
		
		System.out.println(me.toString());
	}
}
