/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ConnectionWatchdog {
    private static final Log LOG;
    private static final ConnectionWatchdog INSTANCE;
    private static final int EVALUATE_TIME = 30000;
    private static final int REEVALUATE_TIME = 15000;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.ConnectionWatchdog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        INSTANCE = new ConnectionWatchdog();
    }

    public static ConnectionWatchdog instance() {
        return INSTANCE;
    }

    private ConnectionWatchdog() {
    }

    public void start() {
        this.findDuds();
    }

    private void findDuds() {
        HashMap<ManagedConnection, ConnectionState> hashMap = new HashMap<ManagedConnection, ConnectionState>();
        Iterator iterator = this.allConnections();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            if (!managedConnection.isKillable()) continue;
            hashMap.put(managedConnection, new ConnectionState(managedConnection));
        }
        RouterService.schedule(new DudChecker(hashMap, false), 30000L, 0L);
    }

    private void killIfStillDud(List list) {
        HashMap<ManagedConnection, ConnectionState> hashMap = new HashMap<ManagedConnection, ConnectionState>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            if (!managedConnection.isKillable()) continue;
            hashMap.put(managedConnection, new ConnectionState(managedConnection));
            RouterService.getMessageRouter().sendPingRequest(new PingRequest(1), managedConnection);
        }
        RouterService.schedule(new DudChecker(hashMap, true), 15000L, 0L);
    }

    private Iterator allConnections() {
        List list = RouterService.getConnectionManager().getInitializedConnections();
        List list2 = RouterService.getConnectionManager().getInitializedClientConnections();
        ArrayList arrayList = new ArrayList(list.size() + list2.size());
        arrayList.addAll(list);
        arrayList.addAll(list2);
        return arrayList.iterator();
    }

    private static class ConnectionState {
        final long sentDropped;
        final long sent;
        final long received;

        ConnectionState(ManagedConnection managedConnection) {
            this.sentDropped = managedConnection.getNumSentMessagesDropped();
            this.sent = managedConnection.getNumMessagesSent();
            this.received = managedConnection.getNumMessagesReceived();
        }

        boolean notProgressedSince(ConnectionState connectionState) {
            long l = this.sent - connectionState.sent;
            long l2 = this.sentDropped - connectionState.sentDropped;
            long l3 = this.received - connectionState.received;
            if (l == l2 && l != 0L) {
                return true;
            }
            return l3 == 0L;
        }

        public String toString() {
            return "{sent: " + this.sent + ", sdropped: " + this.sentDropped + "}";
        }
    }

    private class DudChecker
    implements Runnable {
        private Map snapshots;
        private boolean kill;

        DudChecker(Map map, boolean bl) {
            this.snapshots = map;
            this.kill = bl;
        }

        public void run() {
            List list = this.kill ? Collections.EMPTY_LIST : new ArrayList();
            Iterator iterator = ConnectionWatchdog.this.allConnections();
            while (iterator.hasNext()) {
                ConnectionState connectionState;
                ConnectionState connectionState2;
                Object v;
                ManagedConnection managedConnection = (ManagedConnection)iterator.next();
                if (!managedConnection.isKillable() || (v = this.snapshots.get(managedConnection)) == null || !(connectionState2 = new ConnectionState(managedConnection)).notProgressedSince(connectionState = (ConnectionState)v)) continue;
                if (this.kill) {
                    if (!ConnectionSettings.WATCHDOG_ACTIVE.getValue()) continue;
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)("Killing connection: " + managedConnection));
                    }
                    RouterService.removeConnection(managedConnection);
                    continue;
                }
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Potential dud: " + managedConnection));
                }
                list.add(managedConnection);
            }
            if (list.isEmpty()) {
                ConnectionWatchdog.this.findDuds();
            } else {
                ConnectionWatchdog.this.killIfStillDud(list);
            }
        }
    }
}

