/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.FileDetails;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.TigerTreeCache;
import com.limegroup.gnutella.util.CoWList;
import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class FileDesc
implements FileDetails {
    private final int _index;
    private final String _path;
    private final String _name;
    private final long _size;
    private long _modTime;
    private final Set URNS;
    private final File FILE;
    private final URN SHA1_URN;
    private License _license;
    private final List _limeXMLDocs = new CoWList(CoWList.ARRAY_LIST);
    private int _hits;
    private int _attemptedUploads;
    private int _completedUploads;

    public FileDesc(File file, Set set, int n) {
        if (file == null) {
            throw new NullPointerException("cannot create a FileDesc with a null File");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("negative index (" + n + ") not permitted in FileDesc");
        }
        if (set == null) {
            throw new NullPointerException("cannot create a FileDesc with a null URN Set");
        }
        this.FILE = file;
        this._index = n;
        this._name = I18NConvert.instance().compose(this.FILE.getName());
        this._path = this.FILE.getAbsolutePath();
        this._size = this.FILE.length();
        this._modTime = this.FILE.lastModified();
        this.URNS = Collections.unmodifiableSet(set);
        this.SHA1_URN = this.extractSHA1();
        if (this.SHA1_URN == null) {
            throw new IllegalArgumentException("no SHA1 URN");
        }
        this._hits = 0;
    }

    public boolean hasUrns() {
        return !this.URNS.isEmpty();
    }

    public int getIndex() {
        return this._index;
    }

    public long getFileSize() {
        return this._size;
    }

    public String getFileName() {
        return this._name;
    }

    public long lastModified() {
        return this._modTime;
    }

    private URN extractSHA1() {
        Iterator iterator = this.URNS.iterator();
        while (iterator.hasNext()) {
            URN uRN = (URN)iterator.next();
            if (!uRN.isSHA1()) continue;
            return uRN;
        }
        return null;
    }

    public File getFile() {
        return this.FILE;
    }

    public URN getSHA1Urn() {
        return this.SHA1_URN;
    }

    public Set getUrns() {
        return this.URNS;
    }

    public String getPath() {
        return this.FILE.getAbsolutePath();
    }

    public void addLimeXMLDocument(LimeXMLDocument limeXMLDocument) {
        this._limeXMLDocs.add(limeXMLDocument);
        limeXMLDocument.setIdentifier(this.FILE);
        if (limeXMLDocument.isLicenseAvailable()) {
            this._license = limeXMLDocument.getLicense();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceLimeXMLDocument(LimeXMLDocument limeXMLDocument, LimeXMLDocument limeXMLDocument2) {
        List list = this._limeXMLDocs;
        synchronized (list) {
            int n;
            block7: {
                n = this._limeXMLDocs.indexOf(limeXMLDocument);
                if (n != -1) break block7;
                return false;
            }
            this._limeXMLDocs.set(n, limeXMLDocument2);
        }
        limeXMLDocument2.setIdentifier(this.FILE);
        if (limeXMLDocument2.isLicenseAvailable()) {
            this._license = limeXMLDocument2.getLicense();
        } else if (this._license != null && limeXMLDocument.isLicenseAvailable()) {
            this._license = null;
        }
        return true;
    }

    public boolean removeLimeXMLDocument(LimeXMLDocument limeXMLDocument) {
        if (!this._limeXMLDocs.remove(limeXMLDocument)) {
            return false;
        }
        if (this._license != null && limeXMLDocument.isLicenseAvailable()) {
            this._license = null;
        }
        return true;
    }

    public List getLimeXMLDocuments() {
        return this._limeXMLDocs;
    }

    public LimeXMLDocument getXMLDocument() {
        List list = this.getLimeXMLDocuments();
        return list.isEmpty() ? null : (LimeXMLDocument)list.get(0);
    }

    public boolean isLicensed() {
        return this._license != null;
    }

    public License getLicense() {
        return this._license;
    }

    public boolean containsUrn(URN uRN) {
        return this.URNS.contains(uRN);
    }

    public HashTree getHashTree() {
        return TigerTreeCache.instance().getHashTree(this);
    }

    public int incrementHitCount() {
        return ++this._hits;
    }

    public int getHitCount() {
        return this._hits;
    }

    public int incrementAttemptedUploads() {
        return ++this._attemptedUploads;
    }

    public int getAttemptedUploads() {
        return this._attemptedUploads;
    }

    public int incrementCompletedUploads() {
        return ++this._completedUploads;
    }

    public int getCompletedUploads() {
        return this._completedUploads;
    }

    public InputStream createInputStream() throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(this.FILE));
    }

    private String listInformation(Iterator iterator) {
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return "FileDesc:\r\nname:     " + this._name + "\r\n" + "index:    " + this._index + "\r\n" + "path:     " + this._path + "\r\n" + "size:     " + this._size + "\r\n" + "modTime:  " + this._modTime + "\r\n" + "File:     " + this.FILE + "\r\n" + "urns:     " + this.URNS + "\r\n" + "docs:     " + this._limeXMLDocs;
    }

    public InetSocketAddress getSocketAddress() {
        try {
            return new InetSocketAddress(InetAddress.getByAddress(RouterService.getAcceptor().getAddress(true)), RouterService.getAcceptor().getPort(true));
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public boolean isFirewalled() {
        return !RouterService.acceptedIncomingConnection();
    }
}

