/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointForSelf;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import com.limegroup.gnutella.downloader.CantConnectException;
import com.limegroup.gnutella.downloader.ConnectionStatus;
import com.limegroup.gnutella.downloader.ContentUrnMismatchException;
import com.limegroup.gnutella.downloader.DiskException;
import com.limegroup.gnutella.downloader.FileNotFoundException;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.NoHTTPOKException;
import com.limegroup.gnutella.downloader.NotSharingException;
import com.limegroup.gnutella.downloader.QueuedException;
import com.limegroup.gnutella.downloader.RangeNotAvailableException;
import com.limegroup.gnutella.downloader.ReaderIsNullException;
import com.limegroup.gnutella.downloader.TryAgainLaterException;
import com.limegroup.gnutella.downloader.UnknownCodeException;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderValueCollection;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.settings.ChatSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.statistics.BandwidthStat;
import com.limegroup.gnutella.statistics.DownloadStat;
import com.limegroup.gnutella.statistics.NumericalDownloadStat;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.util.BandwidthThrottle;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.CountingInputStream;
import com.limegroup.gnutella.util.IntervalSet;
import com.limegroup.gnutella.util.IpPortImpl;
import com.limegroup.gnutella.util.NPECatchingInputStream;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Sockets;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HTTPDownloader
implements BandwidthTracker {
    private static final Log LOG;
    public static final int BUF_LENGTH = 1024;
    private static final int MIN_RETRY_AFTER = 60;
    private static final int MAX_RETRY_AFTER = 3600;
    static int MIN_PARTIAL_FILE_BYTES;
    private static final BandwidthThrottle THROTTLE;
    private static final BandwidthThrottle UDP_THROTTLE;
    private RemoteFileDesc _rfd;
    private boolean _isPush;
    private long _index;
    private String _filename;
    private byte[] _guid;
    private int _totalAmountRead;
    private int _amountRead;
    private int _amountToRead;
    private volatile boolean _disconnect;
    private int _initialReadingPoint;
    private int _initialWritingPoint;
    private int _contentLength;
    private boolean _bodyConsumed = true;
    private ByteReader _byteReader;
    private Socket _socket;
    private OutputStream _output;
    private InputStream _input;
    private final VerifyingFile _incompleteFile;
    private HashSet _locationsReceived;
    private Set _goodLocs;
    private Set _goodPushLocs;
    private Set _badPushLocs;
    private Set _badLocs;
    private Set _writtenGoodLocs;
    private Set _writtenBadLocs;
    private Set _writtenPushLocs;
    private Set _writtenBadPushLocs;
    private int _port;
    private String _host;
    private boolean _chatEnabled = false;
    private boolean _browseEnabled = false;
    private String _server = "";
    private String _thexUri = null;
    private String _root32 = null;
    private boolean _thexSucceeded = false;
    private BandwidthTrackerImpl bandwidthTracker = new BandwidthTrackerImpl();
    private boolean _isActive = false;
    private Interval _requestedInterval = null;
    private boolean _wantsFalts = false;
    private final boolean _inNetwork;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.downloader.HTTPDownloader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        MIN_PARTIAL_FILE_BYTES = 0x100000;
        THROTTLE = new BandwidthThrottle(Float.MAX_VALUE, false);
        UDP_THROTTLE = new BandwidthThrottle(Float.MAX_VALUE, false);
    }

    public HTTPDownloader(RemoteFileDesc remoteFileDesc, VerifyingFile verifyingFile, boolean bl) {
        this(null, remoteFileDesc, verifyingFile, bl);
        this._isPush = false;
    }

    public HTTPDownloader(Socket socket, RemoteFileDesc remoteFileDesc, VerifyingFile verifyingFile, boolean bl) {
        if (remoteFileDesc == null) {
            throw new NullPointerException("null rfd");
        }
        this._isPush = true;
        this._rfd = remoteFileDesc;
        this._socket = socket;
        this._incompleteFile = verifyingFile;
        this._filename = remoteFileDesc.getFileName();
        this._index = remoteFileDesc.getIndex();
        this._guid = remoteFileDesc.getClientGUID();
        this._amountToRead = 0;
        this._port = remoteFileDesc.getPort();
        this._host = remoteFileDesc.getHost();
        this._chatEnabled = remoteFileDesc.chatEnabled();
        this._browseEnabled = remoteFileDesc.browseHostEnabled();
        remoteFileDesc.getSHA1Urn();
        this._locationsReceived = new HashSet();
        this._goodLocs = new HashSet();
        this._badLocs = new HashSet();
        this._goodPushLocs = new HashSet();
        this._badPushLocs = new HashSet();
        this._writtenGoodLocs = new HashSet();
        this._writtenBadLocs = new HashSet();
        this._writtenPushLocs = new HashSet();
        this._writtenBadPushLocs = new HashSet();
        this._amountRead = 0;
        this._totalAmountRead = 0;
        this._inNetwork = bl;
        HTTPDownloader.applyRate();
    }

    Collection getLocationsReceived() {
        return this._locationsReceived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSuccessfulAltLoc(AlternateLocation alternateLocation) {
        if (alternateLocation instanceof DirectAltLoc) {
            Set set = this._badLocs;
            synchronized (set) {
                this._writtenBadLocs.remove(alternateLocation);
                this._badLocs.remove(alternateLocation);
            }
            set = this._goodLocs;
            synchronized (set) {
                if (!this._writtenGoodLocs.contains(alternateLocation)) {
                    this._goodLocs.add(alternateLocation);
                }
            }
        }
        Set set = this._badPushLocs;
        synchronized (set) {
            this._writtenBadPushLocs.remove(alternateLocation);
            this._badPushLocs.remove(alternateLocation);
        }
        set = this._goodPushLocs;
        synchronized (set) {
            if (!this._writtenPushLocs.contains(alternateLocation)) {
                this._goodPushLocs.add(alternateLocation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFailedAltLoc(AlternateLocation alternateLocation) {
        if (alternateLocation instanceof DirectAltLoc) {
            Set set = this._goodLocs;
            synchronized (set) {
                this._writtenGoodLocs.remove(alternateLocation);
                this._goodLocs.remove(alternateLocation);
            }
            set = this._badLocs;
            synchronized (set) {
                if (!this._writtenBadLocs.contains(alternateLocation)) {
                    this._badLocs.add(alternateLocation);
                }
            }
        }
        Set set = this._goodPushLocs;
        synchronized (set) {
            this._writtenPushLocs.remove(alternateLocation);
            this._goodPushLocs.remove(alternateLocation);
        }
        set = this._badPushLocs;
        synchronized (set) {
            if (!this._writtenBadPushLocs.contains(alternateLocation)) {
                this._badPushLocs.add(alternateLocation);
            }
        }
    }

    public void connectTCP(int n) throws IOException {
        try {
            if (this._socket == null) {
                long l = System.currentTimeMillis();
                this._socket = Sockets.connect(this._host, this._port, n);
                NumericalDownloadStat.TCP_CONNECT_TIME.addData((int)(System.currentTimeMillis() - l));
            }
            Sockets.setKeepAlive(this._socket, true);
            this._input = new NPECatchingInputStream(new BufferedInputStream(this._socket.getInputStream()));
            this._output = new BufferedOutputStream(this._socket.getOutputStream());
        }
        catch (IOException iOException) {
            throw new CantConnectException();
        }
        this._socket.setSoTimeout(8000);
        this._byteReader = new ByteReader(this._input);
    }

    public void connectHTTP(int n, int n2, boolean bl) throws IOException, TryAgainLaterException, FileNotFoundException, NotSharingException, QueuedException, RangeNotAvailableException, ProblemReadingHeaderException, UnknownCodeException {
        this.connectHTTP(n, n2, bl, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectHTTP(int n, int n2, boolean bl, int n3) throws IOException, TryAgainLaterException, FileNotFoundException, NotSharingException, QueuedException, RangeNotAvailableException, ProblemReadingHeaderException, UnknownCodeException {
        Object object;
        Object object2;
        HTTPHeaderValue hTTPHeaderValue;
        if (n < 0) {
            throw new IllegalArgumentException("invalid start: " + n);
        }
        if (n2 <= n) {
            throw new IllegalArgumentException("stop(" + n2 + ") <= start(" + n + ")");
        }
        Object object3 = this;
        synchronized (object3) {
            this._isActive = true;
            this._amountToRead = n2 - n;
            this._amountRead = 0;
            this._initialReadingPoint = n;
            this._initialWritingPoint = n;
            this._bodyConsumed = false;
            this._contentLength = 0;
        }
        object3 = new HashSet();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this._output);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        String string = String.valueOf(this._initialReadingPoint);
        bufferedWriter.write("GET " + this._rfd.getUrl().getFile() + " HTTP/1.1\r\n");
        bufferedWriter.write("HOST: " + this._host + ":" + this._port + "\r\n");
        bufferedWriter.write("User-Agent: " + CommonUtils.getHttpServer() + "\r\n");
        if (bl) {
            bufferedWriter.write("X-Queue: 0.1\r\n");
            object3.add(ConstantHTTPHeaderValue.QUEUE_FEATURE);
        }
        if (RouterService.acceptedIncomingConnection() || UDPService.instance().canDoFWT()) {
            object3.add(ConstantHTTPHeaderValue.PUSH_LOCS_FEATURE);
            if (!RouterService.acceptedIncomingConnection()) {
                object3.add(ConstantHTTPHeaderValue.FWT_PUSH_LOCS_FEATURE);
            }
        }
        if (this.isPartialFileValid() && (RouterService.acceptedIncomingConnection() || this._wantsFalts) && (hTTPHeaderValue = AlternateLocation.create(this._rfd.getSHA1Urn())) != null) {
            this.addSuccessfulAltLoc((AlternateLocation)hTTPHeaderValue);
        }
        if ((hTTPHeaderValue = this._rfd.getSHA1Urn()) != null) {
            HTTPUtils.writeHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN, hTTPHeaderValue, (Writer)bufferedWriter);
        }
        HashSet<Object> hashSet = null;
        Object object4 = this._goodLocs;
        synchronized (object4) {
            if (this._goodLocs.size() > 0) {
                hashSet = new HashSet<Object>();
                object2 = this._goodLocs.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    hashSet.add(object);
                    this._writtenGoodLocs.add(object);
                }
                this._goodLocs.clear();
            }
        }
        if (hashSet != null) {
            HTTPUtils.writeHeader(HTTPHeaderName.ALT_LOCATION, (HTTPHeaderValue)new HTTPHeaderValueCollection(hashSet), (Writer)bufferedWriter);
        }
        hashSet = null;
        object4 = this._badLocs;
        synchronized (object4) {
            if (this._badLocs.size() > 0) {
                hashSet = new HashSet();
                object2 = this._badLocs.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    hashSet.add(object);
                    this._writtenBadLocs.add(object);
                }
                this._badLocs.clear();
            }
        }
        if (hashSet != null) {
            HTTPUtils.writeHeader(HTTPHeaderName.NALTS, (HTTPHeaderValue)new HTTPHeaderValueCollection(hashSet), (Writer)bufferedWriter);
        }
        if (this._wantsFalts) {
            hashSet = null;
            object4 = this._goodPushLocs;
            synchronized (object4) {
                if (this._goodPushLocs.size() > 0) {
                    hashSet = new HashSet();
                    object2 = this._goodPushLocs.iterator();
                    while (object2.hasNext()) {
                        object = (PushAltLoc)object2.next();
                        if (((PushAltLoc)object).getPushAddress().getProxies().isEmpty()) {
                            if (((PushAltLoc)object).getPushAddress() instanceof PushEndpointForSelf) continue;
                            Assert.that(false, "empty pushloc in downloader");
                        }
                        hashSet.add(object);
                        this._writtenPushLocs.add(object);
                    }
                    this._goodPushLocs.clear();
                }
            }
            if (hashSet != null) {
                HTTPUtils.writeHeader(HTTPHeaderName.FALT_LOCATION, (HTTPHeaderValue)new HTTPHeaderValueCollection(hashSet), (Writer)bufferedWriter);
            }
            hashSet = null;
            object4 = this._badPushLocs;
            synchronized (object4) {
                if (this._badPushLocs.size() > 0) {
                    hashSet = new HashSet();
                    object2 = this._badPushLocs.iterator();
                    while (object2.hasNext()) {
                        object = (PushAltLoc)object2.next();
                        Assert.that(!((PushAltLoc)object).getPushAddress().getProxies().isEmpty());
                        hashSet.add(object);
                        this._writtenBadPushLocs.add(object);
                    }
                    this._badPushLocs.clear();
                }
            }
            if (hashSet != null) {
                HTTPUtils.writeHeader(HTTPHeaderName.BFALT_LOCATION, (HTTPHeaderValue)new HTTPHeaderValueCollection(hashSet), (Writer)bufferedWriter);
            }
        }
        bufferedWriter.write("Range: bytes=" + string + "-" + (n2 - 1) + "\r\n");
        object4 = this;
        synchronized (object4) {
            this._requestedInterval = new Interval(this._initialReadingPoint, n2 - 1);
        }
        if (RouterService.acceptedIncomingConnection() && !NetworkUtils.isPrivateAddress(RouterService.getAddress())) {
            int n4 = RouterService.getPort();
            object2 = NetworkUtils.ip2string(RouterService.getAddress());
            bufferedWriter.write("X-Node: " + (String)object2 + ":" + n4 + "\r\n");
            object3.add(ConstantHTTPHeaderValue.BROWSE_FEATURE);
            if (ChatSettings.CHAT_ENABLED.getValue()) {
                bufferedWriter.write("Chat: " + (String)object2 + ":" + n4 + "\r\n");
                object3.add(ConstantHTTPHeaderValue.CHAT_FEATURE);
            }
        }
        if (object3.size() > 0) {
            HTTPUtils.writeHeader(HTTPHeaderName.FEATURES, (HTTPHeaderValue)new HTTPHeaderValueCollection((Collection)object3), (Writer)bufferedWriter);
        }
        if (n3 > 0) {
            HTTPUtils.writeHeader(HTTPHeaderName.DOWNLOADED, String.valueOf(n3), (Writer)bufferedWriter);
        }
        bufferedWriter.write("\r\n");
        bufferedWriter.flush();
        this.readHeaders();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this + " completed connectHTTP"));
        }
    }

    public void consumeBodyIfNecessary() {
        LOG.trace((Object)"enter consumeBodyIfNecessary");
        try {
            if (!this._bodyConsumed) {
                this.consumeBody(this._contentLength);
            }
        }
        catch (IOException iOException) {}
        this._bodyConsumed = true;
    }

    public ConnectionStatus requestHashTree(URN uRN) {
        String string;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("requesting HashTree for " + this._thexUri + " from " + this._host + ":" + this._port));
        }
        try {
            string = "GET " + this._thexUri + " HTTP/1.1\r\n";
            this._output.write(string.getBytes());
            string = "HOST: " + this._host + ":" + this._port + "\r\n";
            this._output.write(string.getBytes());
            string = "User-Agent: " + CommonUtils.getHttpServer() + "\r\n";
            this._output.write(string.getBytes());
            string = "\r\n";
            this._output.write(string.getBytes());
            this._output.flush();
        }
        catch (IOException iOException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"connection failed during sending hashtree request");
            }
            return ConnectionStatus.getConnected();
        }
        try {
            string = this._byteReader.readLine();
            if (string == null) {
                throw new IOException("disconnected");
            }
            int n = HTTPDownloader.parseHTTPCode(string, this._rfd);
            if (n < 200 || n >= 300) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("invalid HTTP code: " + n));
                }
                this._rfd.setTHEXFailed();
                return this.consumeResponse(n);
            }
            int n2 = this.consumeHeaders(null);
            InputStream inputStream = this._input;
            if (n2 != -1) {
                inputStream = new CountingInputStream(this._input);
            }
            try {
                HashTree hashTree = HashTree.createHashTree(inputStream, uRN.toString(), this._root32, this._rfd.getFileSize());
                this._thexSucceeded = true;
                return ConnectionStatus.getThexResponse(hashTree);
            }
            catch (IOException iOException) {
                if (inputStream instanceof CountingInputStream) {
                    LOG.debug((Object)"failed with contentLength", (Throwable)iOException);
                    this._rfd.setTHEXFailed();
                    int n3 = ((CountingInputStream)inputStream).getAmountRead();
                    return this.consumeBody(n2 - n3);
                }
                throw iOException;
            }
        }
        catch (IOException iOException) {
            LOG.debug((Object)"failed without contentLength", (Throwable)iOException);
            this._rfd.setTHEXFailed();
            return ConnectionStatus.getConnected();
        }
    }

    private int consumeHeaders(int[] nArray) throws IOException {
        String string;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this._rfd + " consuming headers"));
        }
        int n = -1;
        while ((string = this._byteReader.readLine()) != null && !string.equals("")) {
            if (HTTPHeaderName.CONTENT_LENGTH.matchesStartOfString(string)) {
                String string2 = HTTPUtils.extractHeaderValue(string);
                if (string2 == null) continue;
                try {
                    n = Integer.parseInt(string2.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
                continue;
            }
            if (nArray == null || !HTTPHeaderName.QUEUE.matchesStartOfString(string)) continue;
            this.parseQueueHeaders(string, nArray);
        }
        return n;
    }

    private ConnectionStatus consumeResponse(int n) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this._rfd + " consuming response, code: " + n));
        }
        int[] nArray = new int[]{-1, -1, -1};
        int n2 = this.consumeHeaders(nArray);
        if (n == 503) {
            int n3 = nArray[0];
            int n4 = nArray[1];
            int n5 = nArray[2];
            if (n3 != -1 && n4 != -1 && n5 != -1) {
                return ConnectionStatus.getQueued(n5, n3);
            }
        }
        return this.consumeBody(n2);
    }

    private ConnectionStatus consumeBody(int n) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("enter consumeBody(" + n + ")"));
        }
        if (n < 0) {
            throw new IOException("unknown content-length, can't consume");
        }
        byte[] byArray = new byte[1024];
        while (n > 0) {
            int n2 = Math.min(byArray.length, n);
            int n3 = this._input.read(byArray, 0, n2);
            if (n3 == -1) break;
            n -= n3;
        }
        return ConnectionStatus.getConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeaders() throws IOException {
        int n;
        int n2;
        Object object;
        if (this._byteReader == null) {
            throw new ReaderIsNullException();
        }
        String string = this._byteReader.readLine();
        if (string == null || string.equals("")) {
            throw new IOException();
        }
        if (this._inNetwork) {
            BandwidthStat.HTTP_HEADER_DOWNSTREAM_INNETWORK_BANDWIDTH.addData(string.length());
        } else {
            BandwidthStat.HTTP_HEADER_DOWNSTREAM_BANDWIDTH.addData(string.length());
        }
        int n3 = HTTPDownloader.parseHTTPCode(string, this._rfd);
        int[] nArray = new int[]{-1, -1, -1};
        while ((string = this._byteReader.readLine()) != null && !string.equals("")) {
            if (this._inNetwork) {
                BandwidthStat.HTTP_HEADER_DOWNSTREAM_INNETWORK_BANDWIDTH.addData(string.length());
            } else {
                BandwidthStat.HTTP_HEADER_DOWNSTREAM_BANDWIDTH.addData(string.length());
            }
            if (string.toUpperCase().startsWith("CONTENT-RANGE:")) {
                object = this.parseContentRange(string);
                n2 = ((Interval)object).low;
                n = ((Interval)object).high + 1;
                HTTPDownloader hTTPDownloader = this;
                synchronized (hTTPDownloader) {
                    if (this._disconnect) {
                        throw new IOException("stolen from");
                    }
                    if (n2 < this._initialReadingPoint || n > this._initialReadingPoint + this._amountToRead) {
                        throw new ProblemReadingHeaderException("invalid subrange given.  wanted low: " + this._initialReadingPoint + ", high: " + (this._initialReadingPoint + this._amountToRead - 1) + "... given low: " + n2 + ", high: " + n);
                    }
                    this._initialReadingPoint = n2;
                    this._amountToRead = n - n2;
                    continue;
                }
            }
            if (HTTPHeaderName.CONTENT_LENGTH.matchesStartOfString(string)) {
                this._contentLength = HTTPDownloader.readContentLength(string);
                continue;
            }
            if (HTTPHeaderName.CONTENT_URN.matchesStartOfString(string)) {
                this.checkContentUrnHeader(string, this._rfd.getSHA1Urn());
                continue;
            }
            if (HTTPHeaderName.GNUTELLA_CONTENT_URN.matchesStartOfString(string)) {
                this.checkContentUrnHeader(string, this._rfd.getSHA1Urn());
                continue;
            }
            if (HTTPHeaderName.ALT_LOCATION.matchesStartOfString(string)) {
                this.readAlternateLocations(string);
                continue;
            }
            if (HTTPHeaderName.QUEUE.matchesStartOfString(string)) {
                this.parseQueueHeaders(string, nArray);
                continue;
            }
            if (HTTPHeaderName.SERVER.matchesStartOfString(string)) {
                this._server = HTTPDownloader.readServer(string);
                continue;
            }
            if (HTTPHeaderName.AVAILABLE_RANGES.matchesStartOfString(string)) {
                this.parseAvailableRangesHeader(string, this._rfd);
                continue;
            }
            if (HTTPHeaderName.RETRY_AFTER.matchesStartOfString(string)) {
                HTTPDownloader.parseRetryAfterHeader(string, this._rfd);
                continue;
            }
            if (HTTPHeaderName.CREATION_TIME.matchesStartOfString(string)) {
                HTTPDownloader.parseCreationTimeHeader(string, this._rfd);
                continue;
            }
            if (HTTPHeaderName.FEATURES.matchesStartOfString(string)) {
                this.parseFeatureHeader(string);
                continue;
            }
            if (HTTPHeaderName.THEX_URI.matchesStartOfString(string)) {
                this.parseTHEXHeader(string);
                continue;
            }
            if (HTTPHeaderName.FALT_LOCATION.matchesStartOfString(string)) {
                this.parseFALTHeader(string);
                continue;
            }
            if (!HTTPHeaderName.PROXIES.matchesStartOfString(string)) continue;
            this.parseProxiesHeader(string);
        }
        if (n3 < 200 || n3 >= 300) {
            if (n3 == 404) {
                throw new FileNotFoundException();
            }
            if (n3 == 410) {
                throw new NotSharingException();
            }
            if (n3 == 416) {
                if (this._rfd.isPartialSource()) {
                    object = this._rfd.getAvailableRanges().getAllIntervals();
                    while (object.hasNext()) {
                        Interval interval = (Interval)object.next();
                        if (!this._requestedInterval.isSubrange(interval)) continue;
                        throw new ProblemReadingHeaderException("Bad ranges sent");
                    }
                } else {
                    throw new ProblemReadingHeaderException("no ranges sent");
                }
                throw new RangeNotAvailableException();
            }
            if (n3 == 503) {
                int n4 = nArray[0];
                n2 = nArray[1];
                n = nArray[2];
                if (n4 != -1 && n2 != -1 && n != -1) {
                    throw new QueuedException(n4, n2, n);
                }
                throw new TryAgainLaterException();
            }
            throw new UnknownCodeException(n3);
        }
    }

    private void checkContentUrnHeader(String string, URN uRN) throws ContentUrnMismatchException {
        String string2 = HTTPUtils.extractHeaderValue(string);
        if (this._root32 == null && string2.indexOf("urn:bitprint:") > -1) {
            this._root32 = string2.substring(string2.lastIndexOf(".") + 1).trim();
        }
        if (uRN == null) {
            return;
        }
        URN uRN2 = null;
        try {
            uRN2 = URN.createSHA1Urn(string2);
        }
        catch (IOException iOException) {
            return;
        }
        if (!uRN.equals(uRN2)) {
            throw new ContentUrnMismatchException();
        }
    }

    private void readAlternateLocations(String string) {
        String string2 = HTTPUtils.extractHeaderValue(string);
        if (string2 == null) {
            return;
        }
        URN uRN = this._rfd.getSHA1Urn();
        if (uRN == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                RemoteFileDesc remoteFileDesc;
                AlternateLocation alternateLocation = AlternateLocation.create(stringTokenizer.nextToken().trim(), uRN);
                Assert.that(alternateLocation.getSHA1Urn().equals(uRN));
                if (alternateLocation.isMe() || !this._locationsReceived.add(remoteFileDesc = alternateLocation.createRemoteFileDesc(this._rfd.getSize()))) continue;
                if (alternateLocation instanceof DirectAltLoc) {
                    DownloadStat.ALTERNATE_COLLECTED.incrementStat();
                    continue;
                }
                DownloadStat.PUSH_ALTERNATE_COLLECTED.incrementStat();
            }
            catch (IOException iOException) {}
        }
    }

    private boolean isPartialFileValid() {
        return this._rfd.getSHA1Urn() != null && this._incompleteFile.getVerifiedBlockSize() > MIN_PARTIAL_FILE_BYTES && UploadSettings.ALLOW_PARTIAL_SHARING.getValue() && NetworkUtils.isValidPort(RouterService.getPort()) && NetworkUtils.isValidAddress(RouterService.getAddress());
    }

    public static String readServer(String string) {
        int n = string.indexOf(58);
        if (n != -1 && n < string.length() - 1) {
            return string.substring(n + 1).trim();
        }
        return "";
    }

    public static int readContentLength(String string) {
        String string2 = HTTPUtils.extractHeaderValue(string);
        if (string2 == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string2.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private static int parseHTTPCode(String string, RemoteFileDesc remoteFileDesc) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (!stringTokenizer.hasMoreTokens()) {
            throw new NoHTTPOKException();
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.toUpperCase().indexOf("HTTP") < 0) {
            throw new NoHTTPOKException("got: " + string);
        }
        remoteFileDesc.setHTTP11(string2.indexOf("1.1") > 0);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new NoHTTPOKException();
        }
        string2 = stringTokenizer.nextToken();
        String string3 = string2.trim();
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProblemReadingHeaderException(numberFormatException);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseQueueHeaders(String var1_1, int[] var2_2) {
        if (var1_1 == null) {
            return;
        }
        var3_3 = new StringTokenizer(var1_1, " ,:=");
        if (!var3_3.hasMoreTokens()) {
            return;
        }
        var4_4 = var3_3.nextToken();
        if (var4_4.equalsIgnoreCase("X-Queue")) ** GOTO lbl28
        return;
lbl-1000:
        // 1 sources

        {
            var4_4 = var3_3.nextToken();
            try {
                if (var4_4.equalsIgnoreCase("pollMin")) {
                    var5_5 = var3_3.nextToken();
                    var2_2[0] = Integer.parseInt(var5_5);
                    continue;
                }
                if (var4_4.equalsIgnoreCase("pollMax")) {
                    var5_5 = var3_3.nextToken();
                    var2_2[1] = Integer.parseInt(var5_5);
                    continue;
                }
                if (!var4_4.equalsIgnoreCase("position")) continue;
                var5_5 = var3_3.nextToken();
                var2_2[2] = Integer.parseInt(var5_5);
                continue;
            }
            catch (NumberFormatException v0) {
                Arrays.fill(var2_2, -1);
                continue;
            }
            catch (NoSuchElementException v1) {
                Arrays.fill(var2_2, -1);
            }
lbl28:
            // 7 sources

            ** while (var3_3.hasMoreTokens())
        }
lbl29:
        // 1 sources

    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Interval parseContentRange(String string) throws IOException {
        int n;
        int n2;
        int n3;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("reading content range: " + string));
        }
        try {
            int n4 = string.indexOf("bytes") + 6;
            int n5 = string.indexOf(47);
            if (string.substring(n4, n5).equals("*")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this._rfd + " Content-Range like */?, " + string));
                }
                HTTPDownloader hTTPDownloader = this;
                synchronized (hTTPDownloader) {
                    return new Interval(0L, this._amountToRead - 1);
                }
            }
            int n6 = string.lastIndexOf("-");
            n3 = Integer.parseInt(string.substring(n4, n6));
            n2 = Integer.parseInt(string.substring(n6 + 1, n5));
            if (n2 < n3) {
                throw new ProblemReadingHeaderException("invalid range, high (" + n2 + ") less than low (" + n3 + ")");
            }
            if (string.substring(n5 + 1).equals("*")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this._rfd + " Content-Range like #-#/*, " + string));
                }
                return new Interval(n3, n2);
            }
            n = Integer.parseInt(string.substring(n5 + 1));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ProblemReadingHeaderException(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProblemReadingHeaderException(string);
        }
        if (n2 == n) {
            --n3;
            --n2;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this._rfd + " Content-Range like #-#/#, " + string));
        }
        return new Interval(n3, n2);
    }

    private void parseAvailableRangesHeader(String string, RemoteFileDesc remoteFileDesc) throws IOException {
        IntervalSet intervalSet = new IntervalSet();
        string = string.toLowerCase();
        int n = string.indexOf("bytes") + 6;
        while (n != -1 && n < string.length()) {
            int n2 = string.indexOf(45, n);
            if (n2 == -1) break;
            Interval interval = null;
            try {
                int n3 = Integer.parseInt(string.substring(n, n2).trim());
                n = n2 + 1;
                n2 = string.indexOf(44, n);
                if (n2 == -1) {
                    n2 = string.length();
                }
                int n4 = Integer.parseInt(string.substring(n, n2).trim());
                n = n2 + 1;
                if (n4 >= remoteFileDesc.getSize()) {
                    n4 = remoteFileDesc.getSize() - 1;
                }
                if (n3 > n4) continue;
                interval = new Interval(n3, n4);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProblemReadingHeaderException(numberFormatException);
            }
            intervalSet.add(interval);
        }
        remoteFileDesc.setAvailableRanges(intervalSet);
    }

    private static void parseRetryAfterHeader(String string, RemoteFileDesc remoteFileDesc) throws IOException {
        string = HTTPUtils.extractHeaderValue(string);
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProblemReadingHeaderException(numberFormatException);
        }
        n = Math.max(n, 60);
        n = Math.min(n, 3600);
        remoteFileDesc.setRetryAfter(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseCreationTimeHeader(String string, RemoteFileDesc remoteFileDesc) throws IOException {
        string = HTTPUtils.extractHeaderValue(string);
        long l = 0L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProblemReadingHeaderException(numberFormatException);
        }
        if (remoteFileDesc.getSHA1Urn() != null) {
            CreationTimeCache creationTimeCache;
            CreationTimeCache creationTimeCache2 = creationTimeCache = CreationTimeCache.instance();
            synchronized (creationTimeCache2) {
                Long l2 = creationTimeCache.getCreationTime(remoteFileDesc.getSHA1Urn());
                if (l2 == null || l2 > l) {
                    creationTimeCache.addTime(remoteFileDesc.getSHA1Urn(), l);
                }
            }
        }
    }

    private void parseFeatureHeader(String string) {
        string = HTTPUtils.extractHeaderValue(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = "";
            int n = string2.indexOf("/");
            string3 = n == -1 ? string2.toLowerCase().trim() : string2.substring(0, n).toLowerCase().trim();
            if (string3.equals("chat")) {
                this._chatEnabled = true;
                continue;
            }
            if (string3.equals("browse")) {
                this._browseEnabled = true;
                continue;
            }
            if (string3.equals("fwalt")) {
                this._wantsFalts = true;
                continue;
            }
            if (!string3.equals("fwt")) continue;
            int n2 = 0;
            try {
                n2 = (int)HTTPUtils.parseFeatureToken(string2);
                this._wantsFalts = true;
            }
            catch (ProblemReadingHeaderException problemReadingHeaderException) {
                continue;
            }
            try {
                this.updatePEAddress();
                PushEndpoint.setFWTVersionSupported(this._rfd.getClientGUID(), n2);
            }
            catch (IOException iOException) {}
        }
    }

    private void parseTHEXHeader(String string) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(String.valueOf(this._host) + ":" + this._port + ">" + string));
        }
        if ((string = HTTPUtils.extractHeaderValue(string)).indexOf(";") > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            this._thexUri = stringTokenizer.nextToken();
            this._root32 = stringTokenizer.nextToken();
        } else {
            this._thexUri = string;
        }
    }

    private void parseFALTHeader(String string) {
        this._wantsFalts = true;
        this.readAlternateLocations(string);
    }

    private void parseProxiesHeader(String string) {
        string = HTTPUtils.extractHeaderValue(string);
        if (this._rfd.getPushAddr() == null || string == null || string.length() < 12) {
            return;
        }
        try {
            PushEndpoint.overwriteProxies(this._rfd.getClientGUID(), string);
            this.updatePEAddress();
        }
        catch (IOException iOException) {}
    }

    private void updatePEAddress() throws IOException {
        IpPortImpl ipPortImpl = new IpPortImpl(this._socket.getInetAddress().getHostAddress(), this._socket.getPort());
        if (NetworkUtils.isValidExternalIpPort(ipPortImpl)) {
            PushEndpoint.setAddr(this._rfd.getClientGUID(), ipPortImpl);
        }
    }

    /*
     * Exception decompiling
     */
    public void doDownload() throws DiskException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [12 : 620->624)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        HTTPDownloader hTTPDownloader = this;
        synchronized (hTTPDownloader) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("WORKER:" + this + " signaled to stop at " + (this._initialReadingPoint + this._amountRead)));
            }
            this._isActive = false;
        }
        if (this._byteReader != null) {
            this._byteReader.close();
        }
        try {
            if (this._socket != null) {
                this._socket.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (this._input != null) {
                this._input.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (this._output != null) {
                this._output.close();
            }
        }
        catch (IOException iOException) {}
    }

    public synchronized void stopAt(int n) {
        this._disconnect = true;
        this._amountToRead = Math.min(this._amountToRead, n - this._initialReadingPoint);
    }

    public synchronized void startAt(int n) {
        this._initialWritingPoint = n;
    }

    synchronized void forgetRanges() {
        this._initialWritingPoint = 0;
        this._initialReadingPoint = 0;
        this._amountToRead = 0;
        this._totalAmountRead += this._amountRead;
        this._amountRead = 0;
    }

    public synchronized int getInitialReadingPoint() {
        return this._initialReadingPoint;
    }

    public synchronized int getInitialWritingPoint() {
        return this._initialWritingPoint;
    }

    public synchronized int getAmountRead() {
        return this._amountRead;
    }

    public synchronized int getTotalAmountRead() {
        return this._totalAmountRead + this._amountRead;
    }

    public synchronized int getAmountToRead() {
        return this._amountToRead;
    }

    public synchronized boolean isActive() {
        return this._isActive;
    }

    synchronized boolean isVictim() {
        return this._disconnect;
    }

    public InetAddress getInetAddress() {
        return this._socket.getInetAddress();
    }

    public boolean chatEnabled() {
        return this._chatEnabled;
    }

    public boolean browseEnabled() {
        return this._browseEnabled;
    }

    public boolean wantsFalts() {
        return this._wantsFalts;
    }

    public String getVendor() {
        return this._server;
    }

    public long getIndex() {
        return this._index;
    }

    public String getFileName() {
        return this._filename;
    }

    public byte[] getGUID() {
        return this._guid;
    }

    public int getPort() {
        return this._port;
    }

    public RemoteFileDesc getRemoteFileDesc() {
        return this._rfd;
    }

    public boolean isPush() {
        return this._isPush;
    }

    public boolean isHTTP11() {
        return this._rfd.isHTTP11();
    }

    public boolean hasHashTree() {
        return this._thexUri != null && this._root32 != null && !this._rfd.hasTHEXFailed() && !this._thexSucceeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void measureBandwidth() {
        int n = 0;
        HTTPDownloader hTTPDownloader = this;
        synchronized (hTTPDownloader) {
            if (!this._isActive) {
                return;
            }
            n = this.getTotalAmountRead();
        }
        this.bandwidthTracker.measureBandwidth(n);
    }

    public float getMeasuredBandwidth() throws InsufficientDataException {
        return this.bandwidthTracker.getMeasuredBandwidth();
    }

    public float getAverageBandwidth() {
        return this.bandwidthTracker.getAverageBandwidth();
    }

    public static void setRate(float f) {
        THROTTLE.setRate(f);
        UDP_THROTTLE.setRate(f);
    }

    public static void applyRate() {
        float f = Float.MAX_VALUE;
        int n = DownloadSettings.DOWNLOAD_SPEED.getValue();
        if (n < 100) {
            f = (float)n / 100.0f * ((float)ConnectionSettings.CONNECTION_SPEED.getValue() / 8.0f) * 1024.0f;
        }
        HTTPDownloader.setRate(f);
    }

    public String toString() {
        return "<" + this._host + ":" + this._port + ", " + this.getFileName() + ">";
    }

    public static void setThrottleSwitching(boolean bl) {
        THROTTLE.setSwitching(bl);
    }

    private HTTPDownloader(String string) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        this._byteReader = new ByteReader(byteArrayInputStream);
        this._locationsReceived = null;
        this._goodLocs = null;
        this._badLocs = null;
        this._writtenGoodLocs = null;
        this._writtenBadLocs = null;
        this._rfd = new RemoteFileDesc("127.0.0.1", 1, 0L, "a", 0, new byte[16], 0, false, 0, false, null, null, false, false, "", 0L, null, -1L, 0);
        this._incompleteFile = null;
        this._inNetwork = false;
    }
}

