/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.licenses;

import com.limegroup.gnutella.http.HttpClientManager;
import com.limegroup.gnutella.licenses.LicenseCache;
import com.limegroup.gnutella.licenses.NamedLicense;
import com.limegroup.gnutella.licenses.VerificationListener;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StringReader;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

abstract class AbstractLicense
implements NamedLicense,
Serializable,
Cloneable {
    private static final Log LOG;
    private static final ProcessingQueue VQUEUE;
    private static final long serialVersionUID = 6508972367931096578L;
    protected transient int verified = 0;
    protected transient URI licenseLocation;
    private transient String licenseName;
    private long lastVerifiedTime;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.licenses.AbstractLicense");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        VQUEUE = new ProcessingQueue("LicenseVerifier");
    }

    AbstractLicense(URI uRI) {
        this.licenseLocation = uRI;
    }

    public void setLicenseName(String string) {
        this.licenseName = string;
    }

    public boolean isVerifying() {
        return this.verified == 1;
    }

    public boolean isVerified() {
        return this.verified == 2;
    }

    public String getLicenseName() {
        return this.licenseName;
    }

    public URI getLicenseURI() {
        return this.licenseLocation;
    }

    public long getLastVerifiedTime() {
        return this.lastVerifiedTime;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.verified = 2;
    }

    protected abstract void clear();

    public void verify(VerificationListener verificationListener) {
        this.verified = 1;
        this.clear();
        VQUEUE.add(new Verifier(verificationListener));
    }

    protected String getBody(String string) {
        return this.getBodyFromURL(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getBodyFromURL(String string) {
        String string2;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Contacting: " + string));
        }
        HttpClient httpClient = HttpClientManager.getNewClient();
        GetMethod getMethod = new GetMethod(string);
        getMethod.addRequestHeader("User-Agent", CommonUtils.getHttpServer());
        try {
            try {
                HttpClientManager.executeMethodRedirecting(httpClient, (HttpMethod)getMethod);
                string2 = getMethod.getResponseBodyAsString();
                Object var5_6 = null;
            }
            catch (IOException iOException) {
                LOG.warn((Object)("Can't contact license server: " + string), (Throwable)iOException);
                String string3 = null;
                Object var5_7 = null;
                getMethod.releaseConnection();
                return string3;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            getMethod.releaseConnection();
            throw throwable;
        }
        getMethod.releaseConnection();
        return string2;
    }

    protected abstract void parseDocumentNode(Node var1, boolean var2);

    protected void parseXML(String string, boolean bl) {
        if (string == null) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Attempting to parse: " + string));
        }
        DOMParser dOMParser = new DOMParser();
        InputSource inputSource = new InputSource(new StringReader(string));
        try {
            dOMParser.parse(inputSource);
        }
        catch (IOException iOException) {
            LOG.debug((Object)("IOX parsing XML\n" + string), (Throwable)iOException);
            return;
        }
        catch (SAXException sAXException) {
            LOG.debug((Object)("SAX parsing XML\n" + string), (Throwable)sAXException);
            return;
        }
        this.parseDocumentNode(dOMParser.getDocument().getDocumentElement(), bl);
    }

    private class Verifier
    implements Runnable {
        private final VerificationListener vc;

        Verifier(VerificationListener verificationListener) {
            this.vc = verificationListener;
        }

        public void run() {
            String string = AbstractLicense.this.getBody(AbstractLicense.this.getLicenseURI().toString());
            AbstractLicense.this.parseXML(string, true);
            AbstractLicense.this.lastVerifiedTime = System.currentTimeMillis();
            AbstractLicense.this.verified = 2;
            LicenseCache.instance().addVerifiedLicense(AbstractLicense.this);
            if (this.vc != null) {
                this.vc.licenseVerified(AbstractLicense.this);
            }
        }
    }
}

