/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import java.io.IOException;
import java.io.OutputStream;

public final class ReplyNumberVendorMessage
extends VendorMessage {
    public static final int VERSION = 2;
    private static final byte UNSOLICITED = 1;

    ReplyNumberVendorMessage(byte[] byArray, byte by, byte by2, int n, byte[] byArray2) throws BadPacketException {
        super(byArray, by, by2, F_LIME_VENDOR_ID, 12, n, byArray2);
        if (this.getPayload().length < 1) {
            throw new BadPacketException("UNSUPPORTED PAYLOAD LENGTH: " + this.getPayload().length);
        }
        if (this.getVersion() == 1 && this.getPayload().length != 1) {
            throw new BadPacketException("VERSION 1 UNSUPPORTED PAYLOAD LEN: " + this.getPayload().length);
        }
        if (this.getVersion() == 2 && this.getPayload().length != 2) {
            throw new BadPacketException("VERSION 2 UNSUPPORTED PAYLOAD LEN: " + this.getPayload().length);
        }
    }

    public ReplyNumberVendorMessage(GUID gUID, int n) {
        super(F_LIME_VENDOR_ID, 12, 2, ReplyNumberVendorMessage.derivePayload(n));
        this.setGUID(gUID);
    }

    public int getNumResults() {
        return ByteOrder.ubyte2int(this.getPayload()[0]);
    }

    public boolean canReceiveUnsolicited() {
        if (this.getVersion() == 1) {
            return true;
        }
        return (this.getPayload()[1] & 1) == 1;
    }

    private static byte[] derivePayload(int n) {
        if (n < 1 || n > 255) {
            throw new IllegalArgumentException("Number of results too big: " + n);
        }
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[2];
        ByteOrder.short2leb((short)n, byArray2, 0);
        byArray[0] = byArray2[0];
        byArray[1] = RouterService.canReceiveUnsolicited() ? (byte)1 : 0;
        return byArray;
    }

    public boolean equals(Object object) {
        if (object instanceof ReplyNumberVendorMessage) {
            GUID gUID = new GUID(this.getGUID());
            GUID gUID2 = new GUID(((VendorMessage)object).getGUID());
            int n = ((ReplyNumberVendorMessage)object).getNumResults();
            return gUID.equals(gUID2) && this.getNumResults() == n && super.equals(object);
        }
        return false;
    }

    protected void writePayload(OutputStream outputStream) throws IOException {
        super.writePayload(outputStream);
        SentMessageStatHandler.UDP_REPLY_NUMBER.addMessage(this);
    }

    public void recordDrop() {
        super.recordDrop();
    }
}

