/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.limegroup.gnutella.metadata.FLACMetaData;
import com.limegroup.gnutella.metadata.M4AMetaData;
import com.limegroup.gnutella.metadata.MP3MetaData;
import com.limegroup.gnutella.metadata.MetaData;
import com.limegroup.gnutella.metadata.OGGMetaData;
import com.limegroup.gnutella.metadata.WMAMetaData;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AudioMetaData
extends MetaData {
    private String title;
    private String artist;
    private String album;
    private String year;
    private String comment;
    private short track = (short)-1;
    private String genre;
    private int bitrate = -1;
    private int length = -1;
    private short totalTracks = (short)-1;
    private short disk = (short)-1;
    private short totalDisks = (short)-1;
    private String license;
    private String price;
    private String licensetype;
    public static final String ISO_LATIN_1 = "8859_1";
    public static final String UNICODE = "Unicode";
    public static String schemaURI = "http://www.limewire.com/schemas/audio.xsd";
    private static final String DLM = "__";
    private static final String KPX = "audios__audio__";
    public static final String TRACK_KEY = "audios__audio__track__";
    public static final String ARTIST_KEY = "audios__audio__artist__";
    public static final String ALBUM_KEY = "audios__audio__album__";
    public static final String TITLE_KEY = "audios__audio__title__";
    public static final String GENRE_KEY = "audios__audio__genre__";
    public static final String YEAR_KEY = "audios__audio__year__";
    public static final String COMMENTS_KEY = "audios__audio__comments__";
    public static final String BITRATE_KEY = "audios__audio__bitrate__";
    public static final String SECONDS_KEY = "audios__audio__seconds__";
    public static final String LICENSE_KEY = "audios__audio__license__";
    public static final String PRICE_KEY = "audios__audio__price__";
    public static final String LICENSE_TYPE_KEY = "audios__audio__licensetype__";

    protected AudioMetaData() throws IOException {
    }

    public AudioMetaData(File file) throws IOException {
        this.parseFile(file);
    }

    public static AudioMetaData parseAudioFile(File file) throws IOException {
        if (LimeXMLUtils.isMP3File(file)) {
            return new MP3MetaData(file);
        }
        if (LimeXMLUtils.isOGGFile(file)) {
            return new OGGMetaData(file);
        }
        if (LimeXMLUtils.isFLACFile(file)) {
            return new FLACMetaData(file);
        }
        if (LimeXMLUtils.isM4AFile(file)) {
            return new M4AMetaData(file);
        }
        if (LimeXMLUtils.isWMAFile(file)) {
            return new WMAMetaData(file);
        }
        return null;
    }

    public String getSchemaURI() {
        return schemaURI;
    }

    public String toString() {
        return "ID3Data: title[" + this.title + "], artist[" + this.artist + "], album[" + this.album + "], year[" + this.year + "], comment[" + this.comment + "], track[" + this.track + "], genre[" + this.genre + "], bitrate[" + this.bitrate + "], length[" + this.length + "], license[" + this.license + "], price[" + this.price + "], licensetype[" + this.licensetype + "]";
    }

    public String getTitle() {
        return this.title;
    }

    public String getArtist() {
        return this.artist;
    }

    public String getAlbum() {
        return this.album;
    }

    public String getYear() {
        return this.year;
    }

    public String getComment() {
        return this.comment;
    }

    public short getTrack() {
        return this.track;
    }

    public short getTotalTracks() {
        return this.totalTracks;
    }

    public short getDisk() {
        return this.disk;
    }

    public short getTotalDisks() {
        return this.totalDisks;
    }

    public String getGenre() {
        return this.genre;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public int getLength() {
        return this.length;
    }

    public String getLicense() {
        return this.license;
    }

    public String getLicenseType() {
        return this.licensetype;
    }

    void setPrice(String string) {
        this.price = string;
    }

    void setTitle(String string) {
        this.title = string;
    }

    void setArtist(String string) {
        this.artist = string;
    }

    void setAlbum(String string) {
        this.album = string;
    }

    void setYear(String string) {
        this.year = string;
    }

    void setComment(String string) {
        this.comment = string;
    }

    void setTrack(short s) {
        this.track = s;
    }

    void setTotalTracks(short s) {
        this.totalTracks = s;
    }

    void setDisk(short s) {
        this.disk = s;
    }

    void setTotalDisks(short s) {
        this.totalDisks = s;
    }

    void setGenre(String string) {
        this.genre = string;
    }

    void setBitrate(int n) {
        this.bitrate = n;
    }

    void setLength(int n) {
        this.length = n;
    }

    void setLicense(String string) {
        this.license = string;
    }

    void setLicenseType(String string) {
        this.licensetype = string;
    }

    public boolean isComplete() {
        return this.isValid(this.title) && this.isValid(this.artist) && this.isValid(this.album) && this.isValid(this.year) && this.isValid(this.comment) && this.isValid(this.track) && this.isValid(this.genre) && this.isValid(this.bitrate) && this.isValid(this.length) && this.isValid(this.license) && this.isValid(this.licensetype);
    }

    public List toNameValueList() {
        ArrayList arrayList = new ArrayList();
        this.add(arrayList, this.title, TITLE_KEY);
        this.add(arrayList, this.artist, ARTIST_KEY);
        this.add(arrayList, this.album, ALBUM_KEY);
        this.add(arrayList, this.year, YEAR_KEY);
        this.add(arrayList, this.comment, COMMENTS_KEY);
        this.add(arrayList, this.track, TRACK_KEY);
        this.add(arrayList, this.genre, GENRE_KEY);
        this.add(arrayList, this.bitrate, BITRATE_KEY);
        this.add(arrayList, this.length, SECONDS_KEY);
        this.add(arrayList, this.license, LICENSE_KEY);
        this.add(arrayList, this.licensetype, LICENSE_TYPE_KEY);
        return arrayList;
    }

    private void add(List list, String string, String string2) {
        if (this.isValid(string)) {
            list.add(new NameValue(string2, string.trim()));
        }
    }

    private void add(List list, int n, String string) {
        if (this.isValid(n)) {
            list.add(new NameValue(string, "" + n));
        }
    }

    private boolean isValid(String string) {
        return string != null && !string.trim().equals("");
    }

    private boolean isValid(int n) {
        return n >= 0;
    }

    protected void appendStrings(String string, String string2, StringBuffer stringBuffer) {
        stringBuffer.append(string);
        stringBuffer.append(string2);
        stringBuffer.append("\"");
    }

    protected int getTrimmedLength(byte[] byArray, int n) {
        int n2 = n - 1;
        while (n2 >= 0 && (byArray[n2] == 0 || byArray[n2] == 32)) {
            --n2;
        }
        int n3 = 0;
        while (n3 <= n2) {
            if (byArray[n3] == 0) {
                byArray[n3] = 32;
            }
            ++n3;
        }
        return n2 + 1;
    }

    public static boolean isCorrupted(LimeXMLDocument limeXMLDocument) {
        if (!schemaURI.equals(limeXMLDocument.getSchemaURI())) {
            return false;
        }
        Set set = limeXMLDocument.getNameValueSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if (!string.equals(ALBUM_KEY) && !string.equals(ARTIST_KEY) || string2.length() != 30 || string2.charAt(29) == ' ' || string2.charAt(28) != ' ') continue;
            return true;
        }
        return false;
    }

    public static LimeXMLDocument fixCorruption(LimeXMLDocument limeXMLDocument) {
        Set set = limeXMLDocument.getNameValueSet();
        ArrayList<NameValue> arrayList = new ArrayList<NameValue>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if ((string.equals(ALBUM_KEY) || string.equals(ARTIST_KEY)) && string2.length() == 30 && string2.charAt(29) != ' ' && string2.charAt(28) == ' ') {
                string2 = string2.substring(0, 29).trim();
            }
            arrayList.add(new NameValue(string, string2));
        }
        return new LimeXMLDocument(arrayList, limeXMLDocument.getSchemaURI());
    }

    public static boolean isNonLimeAudioField(String string) {
        return !string.equals(TRACK_KEY) && !string.equals(ARTIST_KEY) && !string.equals(ALBUM_KEY) && !string.equals(TITLE_KEY) && !string.equals(GENRE_KEY) && !string.equals(YEAR_KEY) && !string.equals(COMMENTS_KEY) && !string.equals(BITRATE_KEY) && !string.equals(SECONDS_KEY) && !string.equals(LICENSE_KEY) && !string.equals(PRICE_KEY) && !string.equals(LICENSE_TYPE_KEY);
    }
}

