/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.limegroup.gnutella.metadata.AudioMetaDataEditor;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import de.vdheide.mp3.ID3v2;
import de.vdheide.mp3.ID3v2DecompressionException;
import de.vdheide.mp3.ID3v2Exception;
import de.vdheide.mp3.ID3v2Frame;
import de.vdheide.mp3.NoID3v2TagException;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MP3DataEditor
extends AudioMetaDataEditor {
    private static final Log LOG;
    private static final String ISO_LATIN_1 = "8859_1";
    private static final String UNICODE = "Unicode";
    static final String TITLE_ID = "TIT2";
    static final String ARTIST_ID = "TPE1";
    static final String ALBUM_ID = "TALB";
    static final String YEAR_ID = "TYER";
    static final String TRACK_ID = "TRCK";
    static final String COMMENT_ID = "COMM";
    static final String GENRE_ID = "TCON";
    static final String LICENSE_ID = "TCOP";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.metadata.MP3DataEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    private int writeID3V2DataToDisk(File file) throws IOException, ID3v2Exception {
        ID3v2Frame iD3v2Frame;
        Iterator iterator;
        ID3v2 iD3v2 = new ID3v2(file);
        Vector vector = null;
        try {
            vector = (Vector)iD3v2.getFrames().clone();
        }
        catch (NoID3v2TagException noID3v2TagException) {}
        ArrayList arrayList = new ArrayList();
        this.addAllNeededFrames(arrayList);
        if (arrayList.size() == 0) {
            return 0;
        }
        if (vector != null) {
            iterator = vector.iterator();
            while (iterator.hasNext()) {
                iD3v2Frame = (ID3v2Frame)iterator.next();
                int n = arrayList.indexOf(iD3v2Frame);
                ID3v2Frame iD3v2Frame2 = null;
                if (n >= 0) {
                    iD3v2Frame2 = (ID3v2Frame)arrayList.remove(n);
                    if (Arrays.equals(iD3v2Frame.getContent(), iD3v2Frame2.getContent())) continue;
                }
                iD3v2.removeFrame(iD3v2Frame);
                if (iD3v2Frame2 == null) continue;
                iD3v2.addFrame(iD3v2Frame2);
            }
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            iD3v2Frame = (ID3v2Frame)iterator.next();
            iD3v2.addFrame(iD3v2Frame);
        }
        iD3v2.update();
        return 0;
    }

    private void addAllNeededFrames(List list) {
        this.add(list, this.title_, TITLE_ID);
        this.add(list, this.artist_, ARTIST_ID);
        this.add(list, this.album_, ALBUM_ID);
        this.add(list, this.year_, YEAR_ID);
        this.add(list, this.track_, TRACK_ID);
        this.add(list, this.comment_, COMMENT_ID);
        this.add(list, this.genre_, GENRE_ID);
        this.add(list, this.license_, LICENSE_ID);
    }

    private void add(List list, String string, String string2) {
        if (string != null && !string.equals("")) {
            ID3v2Frame iD3v2Frame;
            if (string2 == GENRE_ID && this.getGenreByte() > -1) {
                string = "(" + this.getGenreByte() + ")" + string;
            }
            if ((iD3v2Frame = this.makeFrame(string2, string)) != null) {
                list.add(iD3v2Frame);
            }
        }
    }

    private ID3v2Frame makeFrame(String string, String string2) {
        boolean bl = true;
        int n = 0;
        while (n < string2.length()) {
            if (string2.charAt(n) > '\u00ff') {
                bl = false;
                break;
            }
            ++n;
        }
        try {
            return new ID3v2Frame(string, string2.getBytes(bl ? ISO_LATIN_1 : UNICODE), true, true, false, 0, 0, 0, bl);
        }
        catch (ID3v2DecompressionException iD3v2DecompressionException) {
            return null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private int writeID3V1DataToDisk(RandomAccessFile randomAccessFile) {
        byte[] byArray = new byte[30];
        String string = "";
        try {
            randomAccessFile.readFully(byArray, 0, 3);
            string = new String(byArray, 0, 3);
        }
        catch (EOFException eOFException) {
            return 2;
        }
        catch (IOException iOException) {
            return 2;
        }
        if (!string.equals("TAG")) {
            try {
                byte[] byArray2 = "TAG".getBytes();
                randomAccessFile.seek(randomAccessFile.length() - 128L);
                randomAccessFile.write(byArray2, 0, 3);
            }
            catch (IOException iOException) {
                return 3;
            }
        }
        LOG.debug((Object)"about to start writing to file");
        boolean bl = this.toFile(this.title_, 30, randomAccessFile, byArray);
        if (!bl) {
            return 4;
        }
        bl = this.toFile(this.artist_, 30, randomAccessFile, byArray);
        if (!bl) {
            return 5;
        }
        bl = this.toFile(this.album_, 30, randomAccessFile, byArray);
        if (!bl) {
            return 6;
        }
        bl = this.toFile(this.year_, 4, randomAccessFile, byArray);
        if (!bl) {
            return 7;
        }
        bl = this.toFile(this.comment_, 28, randomAccessFile, byArray);
        if (!bl) {
            return 8;
        }
        int n = -1;
        try {
            n = this.track_ == null || this.track_.equals("") ? 0 : (int)Byte.parseByte(this.track_);
        }
        catch (NumberFormatException numberFormatException) {
            return 9;
        }
        try {
            randomAccessFile.write(0);
            randomAccessFile.write(n);
        }
        catch (IOException iOException) {
            return 9;
        }
        byte by = this.getGenreByte();
        try {
            randomAccessFile.write(by);
        }
        catch (IOException iOException) {
            return 10;
        }
        return 0;
    }

    private boolean toFile(String string, int n, RandomAccessFile randomAccessFile, byte[] byArray) {
        byte[] byArray2;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("writing value to file " + string));
        }
        if (string == null || string.equals("")) {
            byArray2 = new byte[n];
            Arrays.fill(byArray2, 0, n, (byte)0);
        } else {
            try {
                byArray2 = string.getBytes(ISO_LATIN_1);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return false;
            }
        }
        int n2 = byArray2.length;
        if (n2 < n) {
            System.arraycopy(byArray2, 0, byArray, 0, n2);
            Arrays.fill(byArray, n2, n, (byte)0);
        } else {
            System.arraycopy(byArray2, 0, byArray, 0, n);
        }
        try {
            randomAccessFile.write(byArray, 0, n);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private byte getGenreByte() {
        if (this.genre_ == null) {
            return -1;
        }
        if (this.genre_.equals("Blues")) {
            return 0;
        }
        if (this.genre_.equals("Classic Rock")) {
            return 1;
        }
        if (this.genre_.equals("Country")) {
            return 2;
        }
        if (this.genre_.equals("Dance")) {
            return 3;
        }
        if (this.genre_.equals("Disco")) {
            return 4;
        }
        if (this.genre_.equals("Funk")) {
            return 5;
        }
        if (this.genre_.equals("Grunge")) {
            return 6;
        }
        if (this.genre_.equals("Hop")) {
            return 7;
        }
        if (this.genre_.equals("Jazz")) {
            return 8;
        }
        if (this.genre_.equals("Metal")) {
            return 9;
        }
        if (this.genre_.equals("New Age")) {
            return 10;
        }
        if (this.genre_.equals("Oldies")) {
            return 11;
        }
        if (this.genre_.equals("Other")) {
            return 12;
        }
        if (this.genre_.equals("Pop")) {
            return 13;
        }
        if (this.genre_.equals("R &amp; B")) {
            return 14;
        }
        if (this.genre_.equals("Rap")) {
            return 15;
        }
        if (this.genre_.equals("Reggae")) {
            return 16;
        }
        if (this.genre_.equals("Rock")) {
            return 17;
        }
        if (this.genre_.equals("Techno")) {
            return 17;
        }
        if (this.genre_.equals("Industrial")) {
            return 19;
        }
        if (this.genre_.equals("Alternative")) {
            return 20;
        }
        if (this.genre_.equals("Ska")) {
            return 21;
        }
        if (this.genre_.equals("Metal")) {
            return 22;
        }
        if (this.genre_.equals("Pranks")) {
            return 23;
        }
        if (this.genre_.equals("Soundtrack")) {
            return 24;
        }
        if (this.genre_.equals("Euro-Techno")) {
            return 25;
        }
        if (this.genre_.equals("Ambient")) {
            return 26;
        }
        if (this.genre_.equals("Trip-Hop")) {
            return 27;
        }
        if (this.genre_.equals("Vocal")) {
            return 28;
        }
        if (this.genre_.equals("Jazz+Funk")) {
            return 29;
        }
        if (this.genre_.equals("Fusion")) {
            return 30;
        }
        if (this.genre_.equals("Trance")) {
            return 31;
        }
        if (this.genre_.equals("Classical")) {
            return 32;
        }
        if (this.genre_.equals("Instrumental")) {
            return 33;
        }
        if (this.genre_.equals("Acid")) {
            return 34;
        }
        if (this.genre_.equals("House")) {
            return 35;
        }
        if (this.genre_.equals("Game")) {
            return 36;
        }
        if (this.genre_.equals("Sound Clip")) {
            return 37;
        }
        if (this.genre_.equals("Gospel")) {
            return 38;
        }
        if (this.genre_.equals("Noise")) {
            return 39;
        }
        if (this.genre_.equals("AlternRock")) {
            return 40;
        }
        if (this.genre_.equals("Bass")) {
            return 41;
        }
        if (this.genre_.equals("Soul")) {
            return 42;
        }
        if (this.genre_.equals("Punk")) {
            return 43;
        }
        if (this.genre_.equals("Space")) {
            return 44;
        }
        if (this.genre_.equals("Meditative")) {
            return 45;
        }
        if (this.genre_.equals("Instrumental Pop")) {
            return 46;
        }
        if (this.genre_.equals("Instrumental Rock")) {
            return 47;
        }
        if (this.genre_.equals("Ethnic")) {
            return 48;
        }
        if (this.genre_.equals("Gothic")) {
            return 49;
        }
        if (this.genre_.equals("Darkwave")) {
            return 50;
        }
        if (this.genre_.equals("Techno-Industrial")) {
            return 51;
        }
        if (this.genre_.equals("Electronic")) {
            return 52;
        }
        if (this.genre_.equals("Pop-Folk")) {
            return 53;
        }
        if (this.genre_.equals("Eurodance")) {
            return 54;
        }
        if (this.genre_.equals("Dream")) {
            return 55;
        }
        if (this.genre_.equals("Southern Rock")) {
            return 56;
        }
        if (this.genre_.equals("Comedy")) {
            return 57;
        }
        if (this.genre_.equals("Cult")) {
            return 58;
        }
        if (this.genre_.equals("Gangsta")) {
            return 59;
        }
        if (this.genre_.equals("Top 40")) {
            return 60;
        }
        if (this.genre_.equals("Christian Rap")) {
            return 61;
        }
        if (this.genre_.equals("Pop/Funk")) {
            return 62;
        }
        if (this.genre_.equals("Jungle")) {
            return 63;
        }
        if (this.genre_.equals("Native American")) {
            return 64;
        }
        if (this.genre_.equals("Cabaret")) {
            return 65;
        }
        if (this.genre_.equals("New Wave")) {
            return 66;
        }
        if (this.genre_.equals("Psychadelic")) {
            return 67;
        }
        if (this.genre_.equals("Rave")) {
            return 68;
        }
        if (this.genre_.equals("Showtunes")) {
            return 69;
        }
        if (this.genre_.equals("Trailer")) {
            return 70;
        }
        if (this.genre_.equals("Lo-Fi")) {
            return 71;
        }
        if (this.genre_.equals("Tribal")) {
            return 72;
        }
        if (this.genre_.equals("Acid Punk")) {
            return 73;
        }
        if (this.genre_.equals("Acid Jazz")) {
            return 74;
        }
        if (this.genre_.equals("Polka")) {
            return 75;
        }
        if (this.genre_.equals("Retro")) {
            return 76;
        }
        if (this.genre_.equals("Musical")) {
            return 77;
        }
        if (this.genre_.equals("Rock &amp; Roll")) {
            return 78;
        }
        if (this.genre_.equals("Hard Rock")) {
            return 79;
        }
        if (this.genre_.equals("Folk")) {
            return 80;
        }
        if (this.genre_.equals("Folk-Rock")) {
            return 81;
        }
        if (this.genre_.equals("National Folk")) {
            return 82;
        }
        if (this.genre_.equals("Swing")) {
            return 83;
        }
        if (this.genre_.equals("Fast Fusion")) {
            return 84;
        }
        if (this.genre_.equals("Bebob")) {
            return 85;
        }
        if (this.genre_.equals("Latin")) {
            return 86;
        }
        if (this.genre_.equals("Revival")) {
            return 87;
        }
        if (this.genre_.equals("Celtic")) {
            return 88;
        }
        if (this.genre_.equals("Bluegrass")) {
            return 89;
        }
        if (this.genre_.equals("Avantgarde")) {
            return 90;
        }
        if (this.genre_.equals("Gothic Rock")) {
            return 91;
        }
        if (this.genre_.equals("Progressive Rock")) {
            return 92;
        }
        if (this.genre_.equals("Psychedelic Rock")) {
            return 93;
        }
        if (this.genre_.equals("Symphonic Rock")) {
            return 94;
        }
        if (this.genre_.equals("Slow Rock")) {
            return 95;
        }
        if (this.genre_.equals("Big Band")) {
            return 96;
        }
        if (this.genre_.equals("Chorus")) {
            return 97;
        }
        if (this.genre_.equals("Easy Listening")) {
            return 98;
        }
        if (this.genre_.equals("Acoustic")) {
            return 99;
        }
        if (this.genre_.equals("Humour")) {
            return 100;
        }
        if (this.genre_.equals("Speech")) {
            return 101;
        }
        if (this.genre_.equals("Chanson")) {
            return 102;
        }
        if (this.genre_.equals("Opera")) {
            return 103;
        }
        if (this.genre_.equals("Chamber Music")) {
            return 104;
        }
        if (this.genre_.equals("Sonata")) {
            return 105;
        }
        if (this.genre_.equals("Symphony")) {
            return 106;
        }
        if (this.genre_.equals("Booty Bass")) {
            return 107;
        }
        if (this.genre_.equals("Primus")) {
            return 108;
        }
        if (this.genre_.equals("Porn Groove")) {
            return 109;
        }
        if (this.genre_.equals("Satire")) {
            return 110;
        }
        if (this.genre_.equals("Slow Jam")) {
            return 111;
        }
        if (this.genre_.equals("Club")) {
            return 112;
        }
        if (this.genre_.equals("Tango")) {
            return 113;
        }
        if (this.genre_.equals("Samba")) {
            return 114;
        }
        if (this.genre_.equals("Folklore")) {
            return 115;
        }
        if (this.genre_.equals("Ballad")) {
            return 116;
        }
        if (this.genre_.equals("Power Ballad")) {
            return 117;
        }
        if (this.genre_.equals("Rhythmic Soul")) {
            return 118;
        }
        if (this.genre_.equals("Freestyle")) {
            return 119;
        }
        if (this.genre_.equals("Duet")) {
            return 120;
        }
        if (this.genre_.equals("Punk Rock")) {
            return 121;
        }
        if (this.genre_.equals("Drum Solo")) {
            return 122;
        }
        if (this.genre_.equals("A capella")) {
            return 123;
        }
        if (this.genre_.equals("Euro-House")) {
            return 124;
        }
        if (this.genre_.equals("Dance Hall")) {
            return 125;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int commitMetaData(String string) {
        int n;
        RandomAccessFile randomAccessFile;
        block20: {
            block19: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"committing mp3 file");
                }
                if (!LimeXMLUtils.isMP3File(string)) {
                    return 12;
                }
                File file = null;
                randomAccessFile = null;
                try {
                    try {
                        file = new File(string);
                        FileUtils.setWriteable(file);
                        randomAccessFile = new RandomAccessFile(file, "rw");
                    }
                    catch (IOException iOException) {
                        Object var7_4 = null;
                        if (randomAccessFile == null) return 1;
                        try {
                            randomAccessFile.close();
                            return 1;
                        }
                        catch (IOException iOException2) {}
                        return 1;
                    }
                    long l = 0L;
                    try {
                        l = randomAccessFile.length();
                        if (l < 128L) {
                            Object var7_5 = null;
                            if (randomAccessFile == null) return 1;
                            break block19;
                        }
                        randomAccessFile.seek(l - 128L);
                    }
                    catch (IOException iOException) {
                        Object var7_6 = null;
                        if (randomAccessFile == null) return 2;
                        try {}
                        catch (IOException iOException3) {}
                        randomAccessFile.close();
                        return 2;
                    }
                    int n2 = -1;
                    try {
                        n2 = this.writeID3V2DataToDisk(file);
                    }
                    catch (IOException iOException) {
                        Object var7_7 = null;
                        if (randomAccessFile == null) return 2;
                        try {}
                        catch (IOException iOException4) {}
                        randomAccessFile.close();
                        return 2;
                    }
                    catch (ID3v2Exception iD3v2Exception) {
                        n2 = this.writeID3V1DataToDisk(randomAccessFile);
                    }
                    n = n2;
                    break block20;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (randomAccessFile == null) throw throwable;
                    try {}
                    catch (IOException iOException) {
                        throw throwable;
                    }
                    randomAccessFile.close();
                    throw throwable;
                }
            }
            try {}
            catch (IOException iOException) {}
            randomAccessFile.close();
            return 1;
        }
        Object var7_8 = null;
        if (randomAccessFile == null) return n;
        try {}
        catch (IOException iOException) {}
        randomAccessFile.close();
        return n;
    }
}

