/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.settings.LimeProps;
import com.limegroup.gnutella.settings.Setting;
import com.limegroup.gnutella.simpp.SimppManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimppSettingsManager {
    private static final Log LOG;
    private Properties _simppProps;
    private final HashMap _userPrefs;
    private final HashMap _remainderSimppSettings;
    private boolean _usingUserPrefs = true;
    private static SimppSettingsManager INSTANCE;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.settings.SimppSettingsManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    private SimppSettingsManager() {
        String string = SimppManager.instance().getPropsString();
        if (string == null) {
            throw new IllegalArgumentException("SimppManager unexpected state");
        }
        this._userPrefs = new HashMap();
        this._remainderSimppSettings = new HashMap();
        this.updateSimppSettings(string);
    }

    public static synchronized SimppSettingsManager instance() {
        if (INSTANCE == null) {
            INSTANCE = new SimppSettingsManager();
        }
        return INSTANCE;
    }

    public void updateSimppSettings(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ErrorService.error(unsupportedEncodingException);
            return;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this._simppProps = new Properties();
        try {
            this._simppProps.load(byteArrayInputStream);
        }
        catch (IOException iOException) {
            LOG.error((Object)"IOX reading simpp properties", (Throwable)iOException);
            return;
        }
        this.activateSimppSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateSimppSettings() {
        LOG.debug((Object)"activating new settings");
        Properties properties = this._simppProps;
        synchronized (properties) {
            Set<Map.Entry<Object, Object>> set = this._simppProps.entrySet();
            Iterator<Map.Entry<Object, Object>> iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                String string = (String)entry.getKey();
                Setting setting = this.getSimppSettingForKey(string);
                String string2 = (String)entry.getValue();
                if (setting == null) {
                    this._remainderSimppSettings.put(string, string2);
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("setting:" + setting));
                    LOG.debug((Object)("simpp value:" + string2));
                }
                if (!setting.isSimppEnabled()) continue;
                String string3 = setting.getValueAsString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("current value:" + string3));
                }
                this._userPrefs.put(setting, string3);
                setting.setValue(string2);
            }
        }
        this._usingUserPrefs = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revertToUserPrefs() {
        if (this._usingUserPrefs) {
            return;
        }
        Properties properties = this._simppProps;
        synchronized (properties) {
            Set<Object> set = this._simppProps.keySet();
            Iterator<Object> iterator = set.iterator();
            while (iterator.hasNext()) {
                Setting setting = (Setting)iterator.next();
                String string = (String)this._userPrefs.get(setting);
                setting.loadValue(string);
            }
        }
        this._usingUserPrefs = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getRemanentSimppValue(String string) {
        Properties properties = this._simppProps;
        synchronized (properties) {
            return (String)this._remainderSimppSettings.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheUserPref(Setting setting, String string) {
        Properties properties = this._simppProps;
        synchronized (properties) {
            this._userPrefs.put(setting, string);
        }
    }

    private Setting getSimppSettingForKey(String string) {
        LimeProps limeProps = LimeProps.instance();
        return limeProps.getSimppSetting(string);
    }
}

