/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.spam;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.filters.IP;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.spam.AbstractToken;

public class AddressToken
extends AbstractToken {
    private static final long serialVersionUID = 3257568416670824244L;
    private static final int TYPE = 4;
    private static final byte INITIAL_GOOD = 20;
    private static final int MAX = 50;
    private final byte[] _address;
    private final short _port;
    private boolean ratingInitialized;
    private byte _good;
    private byte _bad;
    private final int _hashCode;

    public AddressToken(byte[] byArray, int n) {
        Assert.that(byArray.length == 4);
        this._address = byArray;
        this._port = (short)n;
        this._hashCode = this.getHashCode();
        this.ratingInitialized = false;
    }

    private synchronized void initializeRating() {
        if (this.ratingInitialized) {
            return;
        }
        this._good = (byte)20;
        IP iP = new IP(this._address);
        int n = IPFilter.instance().getBadHosts().logMinDistanceTo(iP);
        int n2 = (int)(1600.0 * Math.pow(1 + n, -3.3));
        while (n2 > 50) {
            n2 /= 2;
            this._good = (byte)(this._good / 2);
        }
        this._bad = (byte)n2;
        this.ratingInitialized = true;
    }

    private int getHashCode() {
        int n = 4;
        n = 4 * n + this._address[0];
        n = 4 * n + this._address[1];
        n = 4 * n + this._address[2];
        n = 4 * n + this._address[3];
        n = 4 * n + this._port;
        return n;
    }

    public float getRating() {
        if (!this.ratingInitialized) {
            this.initializeRating();
        }
        return (float)this._bad / (float)(this._good + this._bad + 1);
    }

    public double getImportance() {
        return Double.NEGATIVE_INFINITY;
    }

    public void rate(int n) {
        if (!this.ratingInitialized) {
            this.initializeRating();
        }
        this._age = 0;
        switch (n) {
            case 4: {
                this._good = (byte)(this._good + 1);
                break;
            }
            case 2: {
                this._bad = (byte)(this._bad + 1);
                break;
            }
            case 3: {
                this._bad = 0;
                break;
            }
            case 1: {
                this._bad = (byte)Math.min(this._bad + 10, 50);
                break;
            }
            case 5: {
                this._bad = 0;
                this._good = (byte)20;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type of rating");
            }
        }
        if (this._good >= 50 || this._bad >= 50) {
            this._good = (byte)(this._good * 9 / 10);
            this._bad = (byte)(this._bad * 9 / 10);
        }
    }

    public int getType() {
        return 4;
    }

    public final int hashCode() {
        return this._hashCode;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof AddressToken)) {
            return false;
        }
        return this._hashCode == object.hashCode();
    }

    public String toString() {
        return (0xFF & this._address[0]) + "." + (0xFF & this._address[1]) + "." + (0xFF & this._address[2]) + "." + (0xFF & this._address[3]) + ":" + (0xFFFF & this._port) + " " + this._bad;
    }
}

