/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.spam;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.spam.RatingTable;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SpamManager {
    private static final Log LOG;
    public static final float MAX_THRESHOLD = 0.995f;
    private static final float NO_SHA1_URN_RATING = 0.5f;
    private static final float INCOMPLETE_FILE_RATING = 0.2f;
    private static final SpamManager INSTANCE;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.spam.SpamManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        INSTANCE = new SpamManager();
    }

    public static SpamManager instance() {
        return INSTANCE;
    }

    private SpamManager() {
    }

    public void startedQuery(QueryRequest queryRequest) {
        if (SearchSettings.ENABLE_SPAM_FILTER.getValue()) {
            RatingTable.instance().mark(queryRequest, 5);
        }
    }

    public boolean isSpam(RemoteFileDesc remoteFileDesc) {
        if (!SearchSettings.ENABLE_SPAM_FILTER.getValue()) {
            return false;
        }
        float f = 0.0f;
        if (remoteFileDesc.getSHA1Urn() == null && remoteFileDesc.getXMLDocument() != null && remoteFileDesc.getXMLDocument().getAction().length() == 0) {
            f = 1.0f - (1.0f - f) * 0.5f;
        }
        if (this.isIncompleteFile(remoteFileDesc.getFileName().toLowerCase(Locale.US))) {
            f = 1.0f - (1.0f - f) * 0.2f;
        }
        f = 1.0f - (1.0f - f) * (1.0f - RatingTable.instance().getRating(remoteFileDesc));
        remoteFileDesc.setSpamRating(f);
        return f >= Math.max(SearchSettings.FILTER_SPAM_RESULTS.getValue(), SearchSettings.QUERY_SPAM_CUTOFF.getValue());
    }

    public void handleUserMarkedSpam(RemoteFileDesc[] remoteFileDescArray) {
        int n = 0;
        while (n < remoteFileDescArray.length) {
            remoteFileDescArray[n].setSpamRating(1.0f);
            ++n;
        }
        RatingTable.instance().mark(remoteFileDescArray, 1);
    }

    public void handleUserMarkedGood(RemoteFileDesc[] remoteFileDescArray) {
        int n = 0;
        while (n < remoteFileDescArray.length) {
            remoteFileDescArray[n].setSpamRating(0.0f);
            ++n;
        }
        RatingTable.instance().mark(remoteFileDescArray, 3);
    }

    public void clearFilterData() {
        RatingTable.instance().clear();
    }

    private boolean isIncompleteFile(String string) {
        int n;
        if (string.startsWith("__incomplete")) {
            return true;
        }
        if (string.startsWith("___incompleted")) {
            return true;
        }
        if (string.startsWith("___arestra")) {
            return true;
        }
        if (string.startsWith("preview-t-")) {
            return true;
        }
        if (string.startsWith("t-")) {
            n = 2;
            while (n < string.length()) {
                if (!Character.isDigit(string.charAt(n))) {
                    return string.charAt(n) == '-';
                }
                ++n;
            }
        }
        if (string.startsWith("corrupt-")) {
            n = 8;
            while (n < string.length()) {
                if (!Character.isDigit(string.charAt(n))) {
                    return string.charAt(n) == '-';
                }
                ++n;
            }
        }
        return false;
    }
}

