/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderValueCollection;
import com.limegroup.gnutella.http.HTTPMessage;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.util.IpPort;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;
import java.util.Set;

public abstract class UploadState
implements HTTPMessage {
    protected final HTTPUploader UPLOADER;
    protected final FileDesc FILE_DESC;

    public UploadState() {
        this(null);
    }

    public UploadState(HTTPUploader hTTPUploader) {
        this.UPLOADER = hTTPUploader;
        this.FILE_DESC = hTTPUploader != null ? hTTPUploader.getFileDesc() : null;
    }

    protected void writeAlts(Writer writer) throws IOException {
        URN uRN;
        if (this.FILE_DESC != null && (uRN = this.FILE_DESC.getSHA1Urn()) != null) {
            HTTPUtils.writeHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN, (HTTPHeaderValue)uRN, writer);
            Set set = this.UPLOADER.getNextSetOfAltsToSend();
            if (set.size() > 0) {
                HTTPUtils.writeHeader(HTTPHeaderName.ALT_LOCATION, (HTTPHeaderValue)new HTTPHeaderValueCollection(set), writer);
            }
            if (this.UPLOADER.wantsFAlts() && (set = this.UPLOADER.getNextSetOfPushAltsToSend()).size() > 0) {
                HTTPUtils.writeHeader(HTTPHeaderName.FALT_LOCATION, (HTTPHeaderValue)new HTTPHeaderValueCollection(set), writer);
            }
        }
    }

    protected void writeAlts(OutputStream outputStream) throws IOException {
        URN uRN;
        if (this.FILE_DESC != null && (uRN = this.FILE_DESC.getSHA1Urn()) != null) {
            HTTPUtils.writeHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN, (HTTPHeaderValue)uRN, outputStream);
            Set set = this.UPLOADER.getNextSetOfAltsToSend();
            if (set.size() > 0) {
                HTTPUtils.writeHeader(HTTPHeaderName.ALT_LOCATION, (HTTPHeaderValue)new HTTPHeaderValueCollection(set), outputStream);
            }
            if (this.UPLOADER.wantsFAlts() && (set = this.UPLOADER.getNextSetOfPushAltsToSend()).size() > 0) {
                HTTPUtils.writeHeader(HTTPHeaderName.FALT_LOCATION, (HTTPHeaderValue)new HTTPHeaderValueCollection(set), outputStream);
            }
        }
    }

    protected void writeRanges(Writer writer) throws IOException {
        URN uRN;
        if (this.FILE_DESC != null && this.FILE_DESC instanceof IncompleteFileDesc && (uRN = this.FILE_DESC.getSHA1Urn()) != null) {
            IncompleteFileDesc incompleteFileDesc = (IncompleteFileDesc)this.FILE_DESC;
            HTTPUtils.writeHeader(HTTPHeaderName.AVAILABLE_RANGES, (HTTPHeaderValue)incompleteFileDesc, writer);
        }
    }

    protected void writeRanges(OutputStream outputStream) throws IOException {
        URN uRN;
        if (this.FILE_DESC != null && this.FILE_DESC instanceof IncompleteFileDesc && (uRN = this.FILE_DESC.getSHA1Urn()) != null) {
            IncompleteFileDesc incompleteFileDesc = (IncompleteFileDesc)this.FILE_DESC;
            HTTPUtils.writeHeader(HTTPHeaderName.AVAILABLE_RANGES, (HTTPHeaderValue)incompleteFileDesc, outputStream);
        }
    }

    protected void writeProxies(Writer writer) throws IOException {
        if (RouterService.acceptedIncomingConnection()) {
            return;
        }
        Set set = RouterService.getConnectionManager().getPushProxies();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && n < 4) {
            IpPort ipPort = (IpPort)iterator.next();
            stringBuffer.append(ipPort.getAddress()).append(":").append(ipPort.getPort()).append(",");
            ++n;
        }
        if (n <= 0) {
            return;
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        HTTPUtils.writeHeader(HTTPHeaderName.PROXIES, stringBuffer.toString(), writer);
    }

    protected void writeProxies(OutputStream outputStream) throws IOException {
        if (RouterService.acceptedIncomingConnection()) {
            return;
        }
        Set set = RouterService.getConnectionManager().getPushProxies();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && n < 4) {
            IpPort ipPort = (IpPort)iterator.next();
            stringBuffer.append(ipPort.getAddress()).append(":").append(ipPort.getPort()).append(",");
            ++n;
        }
        if (n <= 0) {
            return;
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        HTTPUtils.writeHeader(HTTPHeaderName.PROXIES, stringBuffer.toString(), outputStream);
    }
}

