/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.util.UnmodifiableIterator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Buffer
implements Cloneable {
    private final int size;
    private Object[] buf;
    private int head;
    private int tail;

    public Buffer(int n) {
        Assert.that(n >= 1);
        this.size = n + 1;
        this.head = 0;
        this.tail = 0;
    }

    public Buffer(Buffer buffer) {
        this.size = buffer.size;
        this.head = buffer.head;
        this.tail = buffer.tail;
        if (buffer.buf != null) {
            this.buf = new Object[buffer.buf.length];
            System.arraycopy(buffer.buf, 0, this.buf, 0, buffer.buf.length);
        }
    }

    private void initialize() {
        if (this.buf == null) {
            this.buf = new Object[this.size + 1];
        }
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public boolean isFull() {
        return this.increment(this.tail) == this.head;
    }

    public final int size() {
        return this.getSize();
    }

    public int getSize() {
        if (this.head <= this.tail) {
            return this.tail - this.head;
        }
        return this.size - this.head + this.tail;
    }

    public int getCapacity() {
        return this.size - 1;
    }

    private int decrement(int n) {
        if (n == 0) {
            return this.size - 1;
        }
        return n - 1;
    }

    private int increment(int n) {
        if (n == this.size - 1) {
            return 0;
        }
        return n + 1;
    }

    private int index(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.getSize()) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        return (n + this.head) % this.size;
    }

    public Object get(int n) throws IndexOutOfBoundsException {
        this.initialize();
        return this.buf[this.index(n)];
    }

    public void set(int n, Object object) throws IndexOutOfBoundsException {
        this.initialize();
        this.buf[this.index((int)n)] = object;
    }

    public Object add(Object object) {
        return this.addFirst(object);
    }

    public Object addFirst(Object object) {
        this.initialize();
        Object object2 = null;
        if (this.isFull()) {
            object2 = this.removeLast();
        }
        this.head = this.decrement(this.head);
        this.buf[this.head] = object;
        return object2;
    }

    public Object addLast(Object object) {
        this.initialize();
        Object object2 = null;
        if (this.isFull()) {
            object2 = this.removeFirst();
        }
        this.buf[this.tail] = object;
        this.tail = this.increment(this.tail);
        return object2;
    }

    public boolean contains(Object object) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(object)) continue;
            return true;
        }
        return false;
    }

    public Object first() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.buf[this.head];
    }

    public Object last() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.buf[this.decrement(this.tail)];
    }

    public Object removeFirst() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object object = this.buf[this.head];
        this.buf[this.head] = null;
        this.head = this.increment(this.head);
        return object;
    }

    public Object removeLast() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        this.tail = this.decrement(this.tail);
        Object object = this.buf[this.tail];
        this.buf[this.tail] = null;
        return object;
    }

    public Object remove(int n) throws IndexOutOfBoundsException {
        Object object = this.get(n);
        int n2 = this.index(n);
        while (n2 != this.tail) {
            this.buf[n2] = this.buf[this.increment(n2)];
            n2 = this.increment(n2);
        }
        this.tail = this.decrement(this.tail);
        this.buf[this.tail] = null;
        return object;
    }

    public boolean remove(Object object) {
        int n = 0;
        while (n < this.getSize()) {
            if (object.equals(this.get(n))) {
                this.remove(n);
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean removeAll(Object object) {
        boolean bl = false;
        int n = 0;
        while (n < this.getSize()) {
            if (object.equals(this.get(n))) {
                this.remove(n);
                --n;
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public void clear() {
        while (!this.isEmpty()) {
            this.removeFirst();
        }
    }

    public Iterator iterator() {
        return new BufferIterator();
    }

    public Object clone() {
        return new Buffer(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        boolean bl = true;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            stringBuffer.append(iterator.next().toString());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private class BufferIterator
    extends UnmodifiableIterator {
        int i;
        int oldHead;
        int oldTail;

        BufferIterator() {
            this.i = Buffer.this.head;
            this.oldHead = Buffer.this.head;
            this.oldTail = Buffer.this.tail;
        }

        public boolean hasNext() {
            this.ensureNoModifications();
            return this.i != Buffer.this.tail;
        }

        public Object next() throws NoSuchElementException {
            this.ensureNoModifications();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object object = Buffer.this.buf[this.i];
            this.i = Buffer.this.increment(this.i);
            return object;
        }

        private void ensureNoModifications() {
            if (this.oldHead != Buffer.this.head || this.oldTail != Buffer.this.tail) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

