/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class MultiIterator
implements Iterator {
    protected final Iterator[] iterators;
    protected int current;

    public MultiIterator(Iterator[] iteratorArray) {
        this.iterators = iteratorArray;
    }

    public void remove() {
        if (this.iterators.length == 0) {
            throw new IllegalStateException();
        }
        this.iterators[this.current].remove();
    }

    public boolean hasNext() {
        int n = 0;
        while (n < this.iterators.length) {
            if (this.iterators[n].hasNext()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Object next() {
        if (this.iterators.length == 0) {
            throw new NoSuchElementException();
        }
        this.positionCurrent();
        return this.iterators[this.current].next();
    }

    protected void positionCurrent() {
        while (!this.iterators[this.current].hasNext() && this.current < this.iterators.length) {
            ++this.current;
        }
    }
}

