/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.version;

import com.limegroup.gnutella.util.CommonUtils;
import java.util.StringTokenizer;

class OS {
    private final String os;
    private final boolean acceptable;

    OS(String string) {
        this.os = string;
        this.acceptable = this.accept(string.toLowerCase());
    }

    public String toString() {
        return this.os;
    }

    public boolean isAcceptable() {
        return this.acceptable;
    }

    static OS[] createFromList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        OS[] oSArray = new OS[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            oSArray[n] = new OS(stringTokenizer.nextToken().trim());
            ++n;
        }
        return oSArray;
    }

    static boolean hasAcceptableOS(OS[] oSArray) {
        int n = 0;
        while (n < oSArray.length) {
            if (oSArray[n].isAcceptable()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static String toString(OS[] oSArray) {
        if (oSArray == null) {
            return "";
        }
        String string = "";
        int n = 0;
        while (n < oSArray.length) {
            string = String.valueOf(string) + oSArray[n].toString();
            if (n < oSArray.length - 2) {
                string = String.valueOf(string) + ", ";
            }
            ++n;
        }
        return string;
    }

    private boolean accept(String string) {
        String string2 = CommonUtils.getOS().toLowerCase();
        if (string.equals(string2)) {
            return true;
        }
        if ("windows".equals(string)) {
            return CommonUtils.isWindows();
        }
        if ("mac".equals(string)) {
            return CommonUtils.isAnyMac();
        }
        if ("linux".equals(string)) {
            return CommonUtils.isLinux();
        }
        if ("unix".equals(string)) {
            return CommonUtils.isUnix() && !CommonUtils.isLinux();
        }
        if ("other".equals(string)) {
            return !CommonUtils.isWindows() && !CommonUtils.isAnyMac() && !CommonUtils.isUnix() && !CommonUtils.isLinux();
        }
        return "*".equals(string);
    }
}

