/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.version;

import com.limegroup.gnutella.version.VersionFormatException;

public class Version
implements Comparable {
    private final String v;
    private final int major;
    private final int minor;
    private final int service;
    private final int revision;

    public Version(String string) throws VersionFormatException {
        this.v = string;
        int[] nArray = this.parse(string);
        this.major = nArray[0];
        this.minor = nArray[1];
        this.service = nArray[2];
        this.revision = nArray[3];
    }

    public String getVersion() {
        return this.v;
    }

    public String toString() {
        return this.getVersion();
    }

    public int compareTo(Object object) {
        Version version = (Version)object;
        int n = this.major == version.major ? (this.minor == version.minor ? (this.service == version.service ? this.revision - version.revision : this.service - version.service) : this.minor - version.minor) : this.major - version.major;
        return n;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    private int[] parse(String string) throws VersionFormatException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = string.indexOf(".");
        if (n6 == -1) {
            throw new VersionFormatException(string);
        }
        int n7 = string.indexOf(".", n6 + 1);
        if (n7 == -1) {
            throw new VersionFormatException(string);
        }
        try {
            n5 = Integer.parseInt(string.substring(0, n6));
        }
        catch (NumberFormatException numberFormatException) {
            throw new VersionFormatException(string);
        }
        try {
            n4 = Integer.parseInt(string.substring(n6 + 1, n7));
        }
        catch (NumberFormatException numberFormatException) {
            throw new VersionFormatException(string);
        }
        try {
            n3 = n7 + 1;
            while (n3 < string.length() && Character.isDigit(string.charAt(n3))) {
                ++n3;
            }
            n2 = n3;
            n = Integer.parseInt(string.substring(n7 + 1, n3));
        }
        catch (NumberFormatException numberFormatException) {
            throw new VersionFormatException(string);
        }
        int n8 = 0;
        try {
            n3 = n2 + 1;
            while (n3 < string.length() && !Character.isDigit(string.charAt(n3))) {
                ++n3;
            }
            if (n3 < string.length()) {
                n8 = Integer.parseInt(string.substring(n3));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return new int[]{n5, n4, n, n8};
    }
}

