/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.XMLParsingUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public final class LimeXMLDocumentHelper {
    private static final Log LOG;
    public static final String XML_HEADER = "<?xml version=\"1.0\"?>";
    public static final String XML_NAMESPACE = "xsi:noNamespaceSchemaLocation=\"";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.xml.LimeXMLDocumentHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    private LimeXMLDocumentHelper() {
    }

    public static List getDocuments(String string, int n) {
        if (string == null || string.equals("") || n <= 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<LimeXMLDocument[]> arrayList = new ArrayList<LimeXMLDocument[]>();
        Iterator iterator = XMLParsingUtils.split(string).iterator();
        while (iterator.hasNext()) {
            XMLParsingUtils.ParseResult parseResult;
            String string2 = (String)iterator.next();
            try {
                parseResult = XMLParsingUtils.parse(string2, n);
            }
            catch (SAXException sAXException) {
                LOG.warn((Object)("SAX while parsing: " + string2), (Throwable)sAXException);
                continue;
            }
            catch (IOException iOException) {
                LOG.warn((Object)("IOX while parsing: " + string), (Throwable)iOException);
                return Collections.EMPTY_LIST;
            }
            String string3 = String.valueOf(parseResult.canonicalKeyPrefix) + "index__";
            LimeXMLDocument[] limeXMLDocumentArray = new LimeXMLDocument[n];
            Iterator iterator2 = parseResult.iterator();
            while (iterator2.hasNext()) {
                Map map = (Map)iterator2.next();
                String string4 = (String)map.remove(string3);
                if (string4 == null) {
                    return Collections.EMPTY_LIST;
                }
                int n2 = -1;
                try {
                    n2 = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    LOG.warn((Object)"NFE while parsing", (Throwable)numberFormatException);
                    return Collections.EMPTY_LIST;
                }
                if (n2 >= limeXMLDocumentArray.length || n2 < 0) {
                    return Collections.EMPTY_LIST;
                }
                if (map.isEmpty()) continue;
                try {
                    limeXMLDocumentArray[n2] = new LimeXMLDocument(map, parseResult.schemaURI, parseResult.canonicalKeyPrefix);
                }
                catch (IOException iOException) {
                    LOG.debug((Object)"", (Throwable)iOException);
                }
            }
            arrayList.add(limeXMLDocumentArray);
        }
        return arrayList;
    }

    public static String getAggregateString(Response[] responseArray) {
        Object object;
        Object object2;
        Object object3;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        int n = 0;
        while (n < responseArray.length) {
            object3 = responseArray[n].getDocument();
            if (object3 != null) {
                object2 = ((LimeXMLDocument)object3).getSchema();
                object = (StringBuffer)hashMap.get(object2);
                if (object == null) {
                    object = new StringBuffer();
                    hashMap.put(object2, object);
                }
                ((StringBuffer)object).append(((LimeXMLDocument)object3).getAttributeStringWithIndex(n));
            }
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        object3 = hashMap.entrySet().iterator();
        while (object3.hasNext()) {
            object2 = (Map.Entry)object3.next();
            object = (LimeXMLSchema)object2.getKey();
            StringBuffer stringBuffer2 = (StringBuffer)object2.getValue();
            LimeXMLDocumentHelper.buildXML(stringBuffer, (LimeXMLSchema)object, stringBuffer2.toString());
        }
        return stringBuffer.toString();
    }

    public static void buildXML(StringBuffer stringBuffer, LimeXMLSchema limeXMLSchema, String string) {
        stringBuffer.append(XML_HEADER);
        stringBuffer.append("<");
        stringBuffer.append(limeXMLSchema.getRootXMLName());
        stringBuffer.append(" ");
        stringBuffer.append(XML_NAMESPACE);
        stringBuffer.append(limeXMLSchema.getSchemaURI());
        stringBuffer.append("\">");
        stringBuffer.append(string);
        stringBuffer.append("</");
        stringBuffer.append(limeXMLSchema.getRootXMLName());
        stringBuffer.append(">");
    }
}

