/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SavedFileManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.Comparators;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.Function;
import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.util.IntSet;
import com.limegroup.gnutella.util.KeyValue;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.util.Trie;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.TreeMap;
import com.sun.java.util.collections.TreeSet;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

public abstract class FileManager {
    public static final String INDEXING_QUERY = "    ";
    public static final String BROWSE_QUERY = "*.*";
    private long _size;
    private int _numFiles;
    private int _numPendingFiles;
    private int _numIncompleteFiles;
    private List _files;
    private Map _fileToFileDesc;
    private Trie _index;
    private Map _urnIndex;
    private static Set _extensions;
    private Map _sharedDirectories;
    private IntSet _incompletesShared;
    private Thread _loadThread;
    private boolean _loadThreadInterrupted = false;
    private Object _loadThreadLock = new Object();
    private boolean _loadFinished = false;
    public static FilenameFilter SHAREABLE_FILE_FILTER;
    public static FilenameFilter DIRECTORY_FILTER;
    protected static QueryRouteTable _queryRouteTable;
    protected static volatile boolean _needRebuild;
    public static final String DELIMETERS = " -._+/*()\\";
    private static boolean debugOn;
    private static final Response[] EMPTY_RESPONSES;
    private boolean DEBUG = false;

    static {
        SHAREABLE_FILE_FILTER = new ShareableFileFilter();
        DIRECTORY_FILTER = new DirectoryFilter();
        _needRebuild = true;
        debugOn = false;
        EMPTY_RESPONSES = new Response[0];
    }

    private static final boolean isDelimeter(char c) {
        switch (c) {
            case ' ': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '/': 
            case '\\': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    public FileManager() {
        this.resetVariables();
    }

    private void resetVariables() {
        this._size = 0L;
        this._numFiles = 0;
        this._numIncompleteFiles = 0;
        this._numPendingFiles = 0;
        this._files = new ArrayList();
        this._index = new Trie(true);
        this._urnIndex = new HashMap();
        _extensions = new TreeSet(Comparators.stringComparator());
        this._sharedDirectories = new TreeMap(Comparators.fileComparator());
        this._incompletesShared = new IntSet();
        this._fileToFileDesc = new HashMap();
    }

    public void start() {
        this.loadSettings(false);
    }

    public int getSize() {
        return ByteOrder.long2int(this._size);
    }

    public int getNumFiles() {
        return this._numFiles;
    }

    public int getNumIncompleteFiles() {
        return this._numIncompleteFiles;
    }

    public int getNumPendingFiles() {
        return this._numPendingFiles;
    }

    public synchronized FileDesc get(int n) {
        return (FileDesc)this._files.get(n);
    }

    public synchronized boolean isValidIndex(int n) {
        return n >= 0 && n < this._files.size();
    }

    public synchronized URN getURNForFile(File file) {
        FileDesc fileDesc = this.getFileDescForFile(file);
        if (fileDesc != null) {
            return fileDesc.getSHA1Urn();
        }
        return null;
    }

    public synchronized FileDesc getFileDescForFile(File file) {
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            return null;
        }
        return (FileDesc)this._fileToFileDesc.get((Object)file);
    }

    public synchronized boolean isUrnShared(URN uRN) {
        FileDesc fileDesc = this.getFileDescForUrn(uRN);
        return fileDesc != null && !(fileDesc instanceof IncompleteFileDesc);
    }

    public synchronized FileDesc getFileDescForUrn(URN uRN) {
        IntSet intSet = (IntSet)this._urnIndex.get((Object)uRN);
        if (intSet == null) {
            return null;
        }
        IntSet.IntSetIterator intSetIterator = intSet.iterator();
        FileDesc fileDesc = null;
        while (intSetIterator.hasNext() && (fileDesc == null || fileDesc instanceof IncompleteFileDesc)) {
            int n = intSetIterator.next();
            fileDesc = (FileDesc)this._files.get(n);
        }
        return fileDesc;
    }

    public synchronized FileDesc[] getIncompleteFileDescriptors() {
        if (this._incompletesShared == null) {
            return null;
        }
        FileDesc[] fileDescArray = new FileDesc[this._incompletesShared.size()];
        IntSet.IntSetIterator intSetIterator = this._incompletesShared.iterator();
        int n = 0;
        while (intSetIterator.hasNext()) {
            FileDesc fileDesc = (FileDesc)this._files.get(intSetIterator.next());
            Assert.that(fileDesc != null, "Directory has null entry");
            fileDescArray[n] = fileDesc;
            ++n;
        }
        return fileDescArray;
    }

    public synchronized FileDesc[] getAllSharedFileDescriptors() {
        Object[] objectArray = new FileDesc[this._fileToFileDesc.size()];
        objectArray = (FileDesc[])this._fileToFileDesc.values().toArray(objectArray);
        return objectArray;
    }

    public synchronized FileDesc[] getSharedFileDescriptors(File file) {
        if (file == null) {
            throw new NullPointerException("null directory");
        }
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            return null;
        }
        IntSet intSet = (IntSet)this._sharedDirectories.get((Object)file);
        if (intSet == null) {
            return null;
        }
        FileDesc[] fileDescArray = new FileDesc[intSet.size()];
        IntSet.IntSetIterator intSetIterator = intSet.iterator();
        int n = 0;
        while (intSetIterator.hasNext()) {
            FileDesc fileDesc = (FileDesc)this._files.get(intSetIterator.next());
            Assert.that(fileDesc != null, "Directory has null entry");
            fileDescArray[n] = fileDesc;
            ++n;
        }
        return fileDescArray;
    }

    public static File[] getFilesRecursive(File file, String[] stringArray) {
        FileManager.debug("FileManager.getFilesRecursive(): entered.");
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        File[] fileArray = null;
        if (file.exists() && file.isDirectory()) {
            arrayList.add((Object)file);
        }
        while (arrayList.size() > 0) {
            File file2 = (File)arrayList.remove(0);
            FileManager.debug("FileManager.getFilesRecursive(): currDir = " + file2);
            String[] stringArray2 = file2.list();
            int n = 0;
            while (stringArray2 != null && n < stringArray2.length) {
                File file3 = new File(file2, stringArray2[n]);
                if (file3.isDirectory()) {
                    arrayList.add((Object)file3);
                } else if (file3.isFile()) {
                    boolean bl = false;
                    if (stringArray == null) {
                        bl = true;
                    } else {
                        String string = FileUtils.getFileExtension(file3);
                        int n2 = 0;
                        while (n2 < stringArray.length && string != null) {
                            if (string.equalsIgnoreCase(stringArray[n2])) {
                                bl = true;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (bl) {
                        arrayList2.add((Object)file3);
                    }
                }
                ++n;
            }
        }
        if (!arrayList2.isEmpty()) {
            fileArray = new File[arrayList2.size()];
            int n = 0;
            while (n < fileArray.length) {
                fileArray[n] = (File)arrayList2.get(n);
                ++n;
            }
        }
        FileManager.debug("FileManager.getFilesRecursive(): returning.");
        return fileArray;
    }

    public static void debug(String string) {
        if (debugOn) {
            System.out.println(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSettings(boolean bl) {
        Object object = this._loadThreadLock;
        synchronized (object) {
            if (this._loadThread != null) {
                this._loadThreadInterrupted = true;
                this._loadThread.interrupt();
                try {
                    this._loadThread.join();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            final boolean bl2 = bl;
            this._loadThreadInterrupted = false;
            this._loadFinished = false;
            this._loadThread = new ManagedThread("FileManager.loadSettingsBlocking"){

                public void managedRun() {
                    try {
                        FileManager.this.loadSettingsBlocking(bl2);
                        RouterService.getCallback().fileManagerLoaded();
                    }
                    catch (Throwable throwable) {
                        ErrorService.error(throwable);
                    }
                    FileManager.this._loadFinished = true;
                    SavedFileManager.instance().run();
                }
            };
            this._loadThread.start();
        }
    }

    protected boolean loadThreadInterrupted() {
        return this._loadThreadInterrupted;
    }

    public boolean isLoadFinished() {
        return this._loadFinished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSettingsBlocking(boolean bl) {
        Object[] objectArray = this;
        synchronized (this) {
            this.resetVariables();
            LinkedList linkedList = StringUtils.split(SharingSettings.EXTENSIONS_TO_SHARE.getValue(), ";");
            int n = 0;
            while (n < ((String[])linkedList).length && !this.loadThreadInterrupted()) {
                _extensions.add((Object)linkedList[n].toLowerCase());
                ++n;
            }
            Object[] objectArray2 = SharingSettings.DIRECTORIES_TO_SHARE.getValue();
            Arrays.sort((Object[])objectArray2, (Comparator)new Comparator(){

                public int compare(Object object, Object object2) {
                    return object.toString().length() - object2.toString().length();
                }
            });
            Object[] objectArray3 = objectArray2;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            objectArray = objectArray3;
            if (bl) {
                RouterService.getCallback().clearSharedFiles();
            }
            linkedList = new LinkedList();
            int n2 = 0;
            while (n2 < objectArray.length && !this.loadThreadInterrupted()) {
                linkedList.addAll((Collection)super.updateDirectories((File)objectArray[n2], null));
                ++n2;
            }
            if (!this.loadThreadInterrupted()) {
                super.updateSharedFiles((List)linkedList);
            }
            if (!this.loadThreadInterrupted()) {
                super.trim();
            }
            if (!this.loadThreadInterrupted()) {
                RouterService.getDownloadManager().getIncompleteFileManager().registerAllIncompleteFiles();
            }
            CreationTimeCache.instance().pruneTimes();
            UrnCache.instance().persistCache();
            CreationTimeCache.instance().persistCache();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List updateDirectories(File file, File file2) {
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            return DataUtils.EMPTY_LIST;
        }
        if (file.equals(SharingSettings.INCOMPLETE_DIRECTORY.getValue())) {
            return DataUtils.EMPTY_LIST;
        }
        File[] fileArray = FileUtils.listFiles(file, DIRECTORY_FILTER);
        File[] fileArray2 = FileUtils.listFiles(file, SHAREABLE_FILE_FILTER);
        if (fileArray == null && fileArray2 == null) {
            return DataUtils.EMPTY_LIST;
        }
        int n = fileArray2.length;
        int n2 = fileArray.length;
        FileManager fileManager = this;
        synchronized (fileManager) {
            if (this._sharedDirectories.get((Object)file) != null) {
                return DataUtils.EMPTY_LIST;
            }
            this._sharedDirectories.put((Object)file, (Object)new IntSet());
            RouterService.getCallback().addSharedDirectory(file, file2);
            this._numPendingFiles += n;
        }
        fileManager = new LinkedList();
        fileManager.add(new KeyValue(file, fileArray2));
        int n3 = 0;
        while (n3 < n2 && !this.loadThreadInterrupted()) {
            fileManager.addAll((Collection)this.updateDirectories(fileArray[n3], file));
            ++n3;
        }
        return fileManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSharedFiles(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && !this.loadThreadInterrupted()) {
            KeyValue keyValue = (KeyValue)iterator.next();
            File[] fileArray = (File[])keyValue.getValue();
            int n = 0;
            while (n < fileArray.length && !this.loadThreadInterrupted()) {
                this.addFile(fileArray[n]);
                FileManager fileManager = this;
                synchronized (fileManager) {
                    --this._numPendingFiles;
                }
                ++n;
            }
            keyValue.setValue(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileDesc addFileIfShared(File file) {
        boolean bl;
        File file2 = null;
        try {
            file2 = FileUtils.getCanonicalFile(file);
            if (!file2.exists()) {
                return null;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        File file3 = FileUtils.getParentFile(file2);
        if (file3 == null) {
            return null;
        }
        Object object = this;
        synchronized (object) {
            bl = this._sharedDirectories.containsKey((Object)file3);
            if (bl) {
                ++this._numPendingFiles;
            }
        }
        if (bl) {
            object = this.addFile(file2);
            FileManager fileManager = this;
            synchronized (fileManager) {
                --this._numPendingFiles;
            }
            _needRebuild = true;
        } else {
            object = null;
        }
        return object;
    }

    public abstract FileDesc addFileIfShared(File var1, List var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileDesc addFile(File file) {
        this.repOk();
        long l = file.length();
        if (!FileManager.isFileShareable(file, l)) {
            return null;
        }
        Set set = null;
        try {
            set = FileDesc.calculateAndCacheURN(file);
        }
        catch (IOException iOException) {
            return null;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        if (this.loadThreadInterrupted()) {
            return null;
        }
        if (set.size() == 0) {
            return null;
        }
        FileManager fileManager = this;
        synchronized (fileManager) {
            Object object;
            Object object2;
            this._size += l;
            int n = this._files.size();
            FileDesc fileDesc = new FileDesc(file, set, n);
            this._files.add((Object)fileDesc);
            this._fileToFileDesc.put((Object)file, (Object)fileDesc);
            ++this._numFiles;
            File file2 = FileUtils.getParentFile(file);
            Assert.that(file2 != null, "Null parent to \"" + file + "\"");
            IntSet intSet = (IntSet)this._sharedDirectories.get((Object)file2);
            Assert.that(intSet != null, "Add directory \"" + file2 + "\" not in " + this._sharedDirectories);
            boolean bl = intSet.add(n);
            Assert.that(bl, "File " + n + " already found in " + intSet);
            RouterService.getCallback().addSharedFile(fileDesc, file2);
            String[] stringArray = FileManager.extractKeywords(fileDesc);
            int n2 = 0;
            while (n2 < stringArray.length) {
                object2 = stringArray[n2];
                object = (IntSet)this._index.get((String)object2);
                if (object == null) {
                    object = new IntSet();
                    this._index.add((String)object2, object);
                }
                ((IntSet)object).add(n);
                ++n2;
            }
            if (!this.isInstallerFile(file)) {
                URN uRN = fileDesc.getSHA1Urn();
                object = object2 = CreationTimeCache.instance();
                synchronized (object) {
                    Long l2 = ((CreationTimeCache)object2).getCreationTime(uRN);
                    if (l2 == null) {
                        l2 = new Long(file.lastModified());
                    }
                    if (l2 > 0L) {
                        ((CreationTimeCache)object2).addTime(uRN, l2);
                        ((CreationTimeCache)object2).commitTime(uRN);
                    }
                }
            }
            this.updateUrnIndex(fileDesc);
            _needRebuild = true;
            this.repOk();
            return fileDesc;
        }
    }

    protected boolean isInstallerFile(File file) {
        String string = file.getName().toLowerCase();
        if (string.length() < 12) {
            return false;
        }
        String string2 = string.substring(0, 8);
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return false;
        }
        String string3 = string.substring(n);
        return string2.equals("limewire") && (string3.equals(".dmg") || string3.equals(".bin") || string3.equals(".zip") || string3.equals(".exe") || string3.equals(".tgz"));
    }

    public synchronized void addIncompleteFile(File file, Set set, String string, int n, VerifyingFile verifyingFile) {
        Object object;
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            IntSet intSet = (IntSet)this._urnIndex.get(iterator.next());
            if (intSet == null) continue;
            object = intSet.iterator();
            while (((IntSet.IntSetIterator)object).hasNext()) {
                String string2;
                String string3;
                int n2 = ((IntSet.IntSetIterator)object).next();
                FileDesc fileDesc = (FileDesc)this._files.get(n2);
                if (fileDesc == null || !(string3 = file.getAbsolutePath()).equals(string2 = fileDesc.getFile().getAbsolutePath())) continue;
                return;
            }
        }
        int n3 = this._files.size();
        this._incompletesShared.add(n3);
        object = new IncompleteFileDesc(file, set, n3, string, n, verifyingFile);
        this._files.add(object);
        this._fileToFileDesc.put((Object)file, object);
        this.updateUrnIndex((FileDesc)object);
        ++this._numIncompleteFiles;
        _needRebuild = true;
        File file2 = FileUtils.getParentFile(file);
        RouterService.getCallback().addSharedFile((FileDesc)object, file2);
    }

    private synchronized void updateUrnIndex(FileDesc fileDesc) {
        Iterator iterator = fileDesc.getUrns().iterator();
        while (iterator.hasNext()) {
            URN uRN = (URN)iterator.next();
            IntSet intSet = (IntSet)this._urnIndex.get((Object)uRN);
            if (intSet == null) {
                intSet = new IntSet();
                this._urnIndex.put((Object)uRN, (Object)intSet);
            }
            intSet.add(fileDesc.getIndex());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileDesc fileChanged(File file) {
        URN uRN = this.getURNForFile(file);
        CreationTimeCache creationTimeCache = CreationTimeCache.instance();
        Long l = creationTimeCache.getCreationTime(uRN);
        FileDesc fileDesc = this.removeFileIfShared(file);
        if (fileDesc == null) {
            return null;
        }
        FileDesc fileDesc2 = this.addFileIfShared(file);
        if (fileDesc2 != null && l != null) {
            CreationTimeCache creationTimeCache2 = creationTimeCache;
            synchronized (creationTimeCache2) {
                creationTimeCache.removeTime(fileDesc2.getSHA1Urn());
                creationTimeCache.addTime(fileDesc2.getSHA1Urn(), l);
                creationTimeCache.commitTime(fileDesc2.getSHA1Urn());
            }
        }
        return fileDesc2;
    }

    public synchronized FileDesc removeFileIfShared(File file) {
        this.repOk();
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            this.repOk();
            return null;
        }
        FileDesc fileDesc = (FileDesc)this._fileToFileDesc.get((Object)file);
        if (fileDesc == null) {
            return null;
        }
        int n = fileDesc.getIndex();
        Assert.that(((FileDesc)this._files.get(n)).getFile().equals(file), "invariant broken!");
        this._files.set(n, null);
        this._fileToFileDesc.remove((Object)file);
        _needRebuild = true;
        if (fileDesc instanceof IncompleteFileDesc) {
            this.removeUrnIndex(fileDesc);
            --this._numIncompleteFiles;
            boolean bl = this._incompletesShared.remove(n);
            Assert.that(bl, "File " + n + " not found in " + this._incompletesShared);
            this.repOk();
            return null;
        }
        --this._numFiles;
        this._size -= fileDesc.getSize();
        File file2 = FileUtils.getParentFile(file);
        IntSet intSet = (IntSet)this._sharedDirectories.get((Object)file2);
        Assert.that(intSet != null, "Rem directory \"" + file2 + "\" not in " + this._sharedDirectories);
        boolean bl = intSet.remove(n);
        Assert.that(bl, "File " + n + " not found in " + intSet);
        String[] stringArray = FileManager.extractKeywords(fileDesc);
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            IntSet intSet2 = (IntSet)this._index.get(string);
            if (intSet2 != null) {
                intSet2.remove(n);
            }
            ++n2;
        }
        this.removeUrnIndex(fileDesc);
        if (this._urnIndex.get((Object)fileDesc.getSHA1Urn()) == null) {
            CreationTimeCache.instance().removeTime(fileDesc.getSHA1Urn());
        }
        this.repOk();
        return fileDesc;
    }

    private static String[] extractKeywords(FileDesc fileDesc) {
        return StringUtils.split(I18NConvert.instance().getNorm(fileDesc.getPath()), DELIMETERS);
    }

    private synchronized void removeUrnIndex(FileDesc fileDesc) {
        Iterator iterator = fileDesc.getUrns().iterator();
        while (iterator.hasNext()) {
            URN uRN = (URN)iterator.next();
            IntSet intSet = (IntSet)this._urnIndex.get((Object)uRN);
            Assert.that(intSet != null, "Invariant broken");
            intSet.remove(fileDesc.getIndex());
            if (intSet.size() != 0) continue;
            this._urnIndex.remove((Object)uRN);
        }
    }

    public synchronized boolean renameFileIfShared(File file, File file2) {
        FileDesc fileDesc = this.getFileDescForFile(file);
        if (fileDesc == null) {
            return false;
        }
        LinkedList linkedList = new LinkedList();
        linkedList.addAll((Collection)fileDesc.getLimeXMLDocuments());
        fileDesc = this.removeFileIfShared(file);
        Assert.that(fileDesc != null, "invariant broken.");
        fileDesc = this.addFileIfShared(file2, (List)linkedList);
        return fileDesc != null;
    }

    private synchronized void trim() {
        this._index.trim(new Function(){

            public Object apply(Object object) {
                ((IntSet)object).trim();
                return object;
            }
        });
    }

    private static boolean hasExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n + 1).toLowerCase();
        return _extensions.contains((Object)string2);
    }

    public synchronized boolean isFileInSharedDirectories(File file) {
        File file2 = FileUtils.getParentFile(file);
        if (file2 == null) {
            return false;
        }
        return this._sharedDirectories.containsKey((Object)file2);
    }

    public static boolean isFileShareable(File file, long l) {
        if (l > Integer.MAX_VALUE || l <= 0L) {
            return false;
        }
        if (file.isDirectory() || !file.canRead()) {
            return false;
        }
        return file.getName().toUpperCase().startsWith("LIMEWIRE") || FileManager.hasExtension(file.getName());
    }

    public synchronized QueryRouteTable getQRT() {
        if (_needRebuild) {
            this.buildQRT();
            _needRebuild = false;
        }
        QueryRouteTable queryRouteTable = new QueryRouteTable(_queryRouteTable.getSize());
        queryRouteTable.addAll(_queryRouteTable);
        return queryRouteTable;
    }

    protected synchronized void buildQRT() {
        _queryRouteTable = new QueryRouteTable();
        FileDesc[] fileDescArray = this.getAllSharedFileDescriptors();
        int n = 0;
        while (n < fileDescArray.length) {
            this.addToQRT(fileDescArray[n]);
            ++n;
        }
    }

    protected void addToQRT(FileDesc fileDesc) {
        if (fileDesc instanceof IncompleteFileDesc) {
            return;
        }
        _queryRouteTable.add(fileDesc.getPath());
        Set set = fileDesc.getUrns();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            _queryRouteTable.addIndivisible(((URN)iterator.next()).httpStringValue());
        }
    }

    public synchronized Response[] query(QueryRequest queryRequest) {
        String string = queryRequest.getQuery();
        boolean bl = this.shouldIncludeXMLInResponse(queryRequest);
        if (queryRequest.isWhatIsNewRequest()) {
            return this.respondToWhatIsNewRequest(queryRequest, bl);
        }
        if (string.equals(INDEXING_QUERY) || string.equals(BROWSE_QUERY)) {
            return this.respondToIndexingQuery(bl);
        }
        IntSet intSet = null;
        string = this._index.canonicalCase(string);
        intSet = this.search(string, intSet);
        if (queryRequest.getQueryUrns().size() > 0) {
            intSet = this.urnSearch(queryRequest.getQueryUrns().iterator(), intSet);
        }
        if (intSet == null) {
            return EMPTY_RESPONSES;
        }
        LinkedList linkedList = new LinkedList();
        MediaType.Aggregator aggregator = MediaType.getAggregator(queryRequest);
        IntSet.IntSetIterator intSetIterator = intSet.iterator();
        while (intSetIterator.hasNext()) {
            int n = intSetIterator.next();
            FileDesc fileDesc = (FileDesc)this._files.get(n);
            if (fileDesc == null) {
                Assert.that(false, "unexpected null in FileManager for query:\n" + queryRequest);
            }
            if (aggregator != null && !aggregator.allow(fileDesc.getName())) continue;
            fileDesc.incrementHitCount();
            RouterService.getCallback().handleSharedFileUpdate(fileDesc.getFile());
            Response response = new Response(fileDesc);
            if (bl) {
                this.addXMLToResponse(response, fileDesc);
            }
            linkedList.add((Object)response);
        }
        if (linkedList.size() == 0) {
            return EMPTY_RESPONSES;
        }
        return (Response[])linkedList.toArray((Object[])new Response[linkedList.size()]);
    }

    private Response[] respondToWhatIsNewRequest(QueryRequest queryRequest, boolean bl) {
        List list = CreationTimeCache.instance().getFiles(queryRequest, 3);
        if (list.size() == 0) {
            return EMPTY_RESPONSES;
        }
        Response[] responseArray = new Response[list.size()];
        int n = 0;
        while (n < list.size()) {
            URN uRN = (URN)list.get(n);
            FileDesc fileDesc = this.getFileDescForUrn(uRN);
            if (fileDesc == null || fileDesc instanceof IncompleteFileDesc) {
                throw new RuntimeException("Bad Rep - No IFDs allowed!");
            }
            Response response = new Response(fileDesc);
            if (bl) {
                this.addXMLToResponse(response, fileDesc);
            }
            responseArray[n] = response;
            ++n;
        }
        return responseArray;
    }

    private Response[] respondToIndexingQuery(boolean bl) {
        if (this._numFiles == 0) {
            return EMPTY_RESPONSES;
        }
        Response[] responseArray = new Response[this._numFiles];
        int n = 0;
        int n2 = 0;
        while (n2 < this._files.size()) {
            FileDesc fileDesc = (FileDesc)this._files.get(n2);
            if (fileDesc != null && !(fileDesc instanceof IncompleteFileDesc)) {
                Assert.that(n < responseArray.length, "_numFiles is too small");
                responseArray[n] = new Response(fileDesc);
                if (bl) {
                    this.addXMLToResponse(responseArray[n], fileDesc);
                }
                ++n;
            }
            ++n2;
        }
        Assert.that(n == responseArray.length, "_numFiles is too large");
        return responseArray;
    }

    protected abstract boolean shouldIncludeXMLInResponse(QueryRequest var1);

    protected abstract void addXMLToResponse(Response var1, FileDesc var2);

    protected IntSet search(String string, IntSet intSet) {
        IntSet intSet2 = intSet;
        int n = 0;
        while (n < string.length()) {
            if (FileManager.isDelimeter(string.charAt(n))) {
                ++n;
                continue;
            }
            int n2 = n + 1;
            while (n2 < string.length()) {
                if (FileManager.isDelimeter(string.charAt(n2))) break;
                ++n2;
            }
            Iterator iterator = this._index.getPrefixedBy(string, n, n2);
            if (iterator.hasNext()) {
                IntSet intSet3 = null;
                while (iterator.hasNext()) {
                    IntSet intSet4 = (IntSet)iterator.next();
                    if (intSet3 == null) {
                        if (n == 0 && n2 == string.length() && !iterator.hasNext()) {
                            return intSet4;
                        }
                        intSet3 = new IntSet();
                    }
                    intSet3.addAll(intSet4);
                }
                if (intSet2 == null) {
                    intSet2 = intSet3;
                } else {
                    intSet2.retainAll(intSet3);
                }
            } else {
                return null;
            }
            if (intSet2.size() == 0) {
                return null;
            }
            n = n2;
        }
        if (intSet2 == null || intSet2.size() == 0) {
            return null;
        }
        return intSet2;
    }

    private synchronized IntSet urnSearch(Iterator iterator, IntSet intSet) {
        IntSet intSet2 = intSet;
        while (iterator.hasNext()) {
            URN uRN = (URN)iterator.next();
            IntSet intSet3 = (IntSet)this._urnIndex.get((Object)uRN);
            if (intSet3 == null) continue;
            IntSet.IntSetIterator intSetIterator = intSet3.iterator();
            while (intSetIterator.hasNext()) {
                FileDesc fileDesc = (FileDesc)this._files.get(intSetIterator.next());
                if (fileDesc == null || fileDesc instanceof IncompleteFileDesc || !fileDesc.containsUrn(uRN)) continue;
                if (intSet2 == null) {
                    intSet2 = new IntSet();
                }
                intSet2.add(fileDesc.getIndex());
            }
        }
        return intSet2;
    }

    protected synchronized void repOk() {
        Object object;
        int n;
        IntSet.IntSetIterator intSetIterator;
        Object object2;
        Object object3;
        if (!this.DEBUG) {
            return;
        }
        System.err.println("WARNING: running repOk()");
        IntSet intSet = new IntSet();
        Object object4 = this._index.getPrefixedBy("");
        while (object4.hasNext()) {
            object3 = (IntSet)object4.next();
            intSet.addAll((IntSet)object3);
        }
        object4 = intSet.iterator();
        while (((IntSet.IntSetIterator)object4).hasNext()) {
            int n2 = ((IntSet.IntSetIterator)object4).next();
            object2 = (FileDesc)this._files.get(n2);
            Assert.that(object2 != null, "Null entry for index value " + n2);
        }
        object4 = this._urnIndex.keySet().iterator();
        while (object4.hasNext()) {
            object3 = (URN)object4.next();
            object2 = (IntSet)this._urnIndex.get(object3);
            intSetIterator = ((IntSet)object2).iterator();
            while (intSetIterator.hasNext()) {
                n = intSetIterator.next();
                object = (FileDesc)this._files.get(n);
                Assert.that(object != null, "Missing file for urn");
                Assert.that(((FileDesc)object).containsUrn((URN)object3), "URN mismatch");
            }
        }
        object4 = this._sharedDirectories.keySet().iterator();
        while (object4.hasNext()) {
            object3 = (File)object4.next();
            object2 = (IntSet)this._sharedDirectories.get(object3);
            intSetIterator = ((IntSet)object2).iterator();
            while (intSetIterator.hasNext()) {
                n = intSetIterator.next();
                Assert.that(n >= 0 && n < this._files.size(), "Bad index " + n + " in directory");
                object = (FileDesc)this._files.get(n);
                Assert.that(object != null, "Directory listing points to empty file");
            }
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this._files.size()) {
            if (this._files.get(n5) != null) {
                FileDesc fileDesc = (FileDesc)this._files.get(n5);
                ++n3;
                n4 = (int)((long)n4 + fileDesc.getSize());
                Assert.that(fileDesc.getIndex() == n5, "Bad index value.  Got " + fileDesc.getIndex() + " not " + n5);
                Assert.that(intSet.contains(n5), "Index does not contain entry for " + n5);
                try {
                    object = (IntSet)this._sharedDirectories.get((Object)FileUtils.getCanonicalFile(FileUtils.getParentFile(fileDesc.getFile())));
                    Assert.that(object != null, "Directory for " + fileDesc.getPath() + " isn't shared");
                    Assert.that(((IntSet)object).contains(n5), "Index " + n5 + " not in directory");
                }
                catch (IOException iOException) {
                    Assert.that(false);
                }
                object4 = fileDesc.getUrns().iterator();
                while (object4.hasNext()) {
                    object = (URN)object4.next();
                    IntSet intSet2 = (IntSet)this._urnIndex.get(object);
                    Assert.that(intSet2 != null, "Urn not found");
                    Assert.that(intSet2.contains(fileDesc.getIndex()));
                }
            }
            ++n5;
        }
        Assert.that(this._numFiles == n3, String.valueOf(this._numFiles) + " should be " + n3);
        Assert.that(this._size == (long)n4, String.valueOf(this._size) + " should be " + n4);
    }

    private static class ShareableFileFilter
    implements FilenameFilter {
        private ShareableFileFilter() {
        }

        public boolean accept(File file, String string) {
            File file2 = new File(file, string);
            return FileManager.isFileShareable(file2, file2.length());
        }
    }

    private static class DirectoryFilter
    implements FilenameFilter {
        private DirectoryFilter() {
        }

        public boolean accept(File file, String string) {
            File file2 = new File(file, string);
            return file2.isDirectory();
        }
    }
}

