/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.tigertree.HashTree;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Set;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class IncompleteFileDesc
extends FileDesc
implements HTTPHeaderValue {
    private static final int MIN_CHUNK_SIZE = 102400;
    private VerifyingFile _verifyingFile;
    private final String _name;
    private final int _size;

    public IncompleteFileDesc(File file, Set set, int n, String string, int n2, VerifyingFile verifyingFile) {
        super(file, set, n);
        this._name = string;
        this._size = n2;
        this._verifyingFile = verifyingFile;
    }

    public long getSize() {
        return this._size;
    }

    public String getName() {
        return this._name;
    }

    public InputStream createInputStream() throws FileNotFoundException {
        if (this.getFile().length() == 0L) {
            throw new FileNotFoundException("nothing downloaded");
        }
        if (this._verifyingFile.isCorrupted()) {
            throw new FileNotFoundException("data is corrupt");
        }
        return new FileInputStream(this.getFile());
    }

    public boolean add(AlternateLocation alternateLocation) {
        ManagedDownloader managedDownloader;
        boolean bl = super.add(alternateLocation);
        if (bl && (managedDownloader = this._verifyingFile.getManagedDownloader()) != null) {
            managedDownloader.addDownload(alternateLocation.createRemoteFileDesc((int)this.getSize()), false);
        }
        return bl;
    }

    public boolean addVerified(AlternateLocation alternateLocation) {
        return super.add(alternateLocation);
    }

    public HashTree getHashTree() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAll(AlternateLocationCollection alternateLocationCollection) {
        ManagedDownloader managedDownloader = this._verifyingFile.getManagedDownloader();
        if (managedDownloader == null) {
            return super.addAll(alternateLocationCollection);
        }
        int n = 0;
        AlternateLocationCollection alternateLocationCollection2 = alternateLocationCollection;
        synchronized (alternateLocationCollection2) {
            Iterator iterator = alternateLocationCollection.iterator();
            while (iterator.hasNext()) {
                AlternateLocation alternateLocation = (AlternateLocation)iterator.next();
                if (!super.add(alternateLocation)) continue;
                managedDownloader.addDownload(alternateLocation.createRemoteFileDesc((int)this.getSize()), false);
                ++n;
            }
        }
        return n;
    }

    public boolean isActivelyDownloading() {
        ManagedDownloader managedDownloader = this._verifyingFile.getManagedDownloader();
        if (managedDownloader == null) {
            return false;
        }
        switch (managedDownloader.getState()) {
            case 0: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAvailableRanges() {
        StringBuffer stringBuffer = new StringBuffer("bytes");
        boolean bl = false;
        VerifyingFile verifyingFile = this._verifyingFile;
        synchronized (verifyingFile) {
            Iterator iterator = this._verifyingFile.getBlocks();
            while (iterator.hasNext()) {
                Interval interval = (Interval)iterator.next();
                if (interval.high - interval.low + 1 < 102400) continue;
                bl = true;
                stringBuffer.append(" " + interval.low + "-" + (interval.high - 1) + ",");
            }
        }
        if (bl) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isRangeSatisfiable(int n, int n2) {
        VerifyingFile verifyingFile = this._verifyingFile;
        synchronized (verifyingFile) {
            Interval interval;
            Iterator iterator = this._verifyingFile.getBlocks();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                interval = (Interval)iterator.next();
            } while (n < interval.low || n2 > interval.high);
            return true;
        }
    }

    public boolean isRangeSatisfiable(Interval interval) {
        return this.isRangeSatisfiable(interval.low, interval.high);
    }

    public String httpStringValue() {
        return this.getAvailableRanges();
    }

    public String toString() {
        return "IncompleteFileDesc:\r\nname:     " + this._name + "\r\n" + "index:    " + this.getIndex() + "\r\n";
    }
}

