/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.guess.QueryKey;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.util.Buffer;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Hashtable;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.Vector;
import java.net.InetAddress;

public final class QueryUnicaster {
    public static final int ITERATION_TIME = 100;
    public static final int MIN_ENDPOINTS = 25;
    public static final int MAX_ENDPOINTS = 30;
    public static final long ONE_HOUR = 3600000L;
    private static final QueryUnicaster _instance = new QueryUnicaster();
    private Thread _querier = null;
    private boolean _shouldRun = true;
    private Map _queries;
    private Map _querySets;
    private LinkedList _queryHosts;
    private Map _queryKeys;
    private Buffer _pingList;
    private List _qGuidsToRemove;
    private long _lastPingTime = 0L;
    private int _testUDPPingsSent = 0;
    private final boolean RECORD_STATS = !CommonUtils.isJava118();
    private boolean _initialized = false;
    private static final boolean debugOn = false;

    public static QueryUnicaster instance() {
        return _instance;
    }

    int getQueryNumber() {
        return this._queries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getUnicastEndpoints() {
        ArrayList arrayList = new ArrayList();
        LinkedList linkedList = this._queryHosts;
        synchronized (linkedList) {
            QueryUnicaster.debug("QueryUnicaster.getUnicastEndpoints(): obtained lock.");
            int n = this._queryHosts.size();
            if (n > 0) {
                int n2 = n > 10 ? 10 : n;
                int n3 = 0;
                while (n3 < n2) {
                    arrayList.add(this._queryHosts.get(n3));
                    ++n3;
                }
            }
            QueryUnicaster.debug("QueryUnicaster.getUnicastEndpoints(): releasing lock.");
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GUESSEndpoint getUnicastEndpoint() {
        LinkedList linkedList = this._queryHosts;
        synchronized (linkedList) {
            block4: {
                if (!this._queryHosts.isEmpty()) break block4;
                return null;
            }
            return (GUESSEndpoint)this._queryHosts.getFirst();
        }
    }

    private QueryUnicaster() {
        this._queries = new Hashtable();
        this._queryHosts = new LinkedList();
        this._queryKeys = new Hashtable();
        this._pingList = new Buffer(25);
        this._querySets = new Hashtable();
        this._qGuidsToRemove = new Vector();
        this._querier = new ManagedThread(){

            public void managedRun() {
                try {
                    QueryUnicaster.this.queryLoop();
                }
                catch (Throwable throwable) {
                    ErrorService.error(throwable);
                }
            }
        };
        this._querier.setName("QueryUnicaster");
        this._querier.setDaemon(true);
    }

    public synchronized void start() {
        if (!this._initialized) {
            this._querier.start();
            QueryKeyExpirer queryKeyExpirer = new QueryKeyExpirer();
            RouterService.schedule(queryKeyExpirer, 0L, 10800000L);
            this._initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryLoop() {
        UDPService uDPService = UDPService.instance();
        while (this._shouldRun) {
            try {
                Object object;
                this.waitForQueries();
                GUESSEndpoint gUESSEndpoint = this.getUnicastHost();
                if (!this._queryKeys.containsKey((Object)gUESSEndpoint)) {
                    object = PingRequest.createQueryKeyRequest();
                    uDPService.send((Message)object, gUESSEndpoint.getAddress(), gUESSEndpoint.getPort());
                    if (!this.RECORD_STATS) continue;
                    SentMessageStatHandler.UDP_PING_REQUESTS.addMessage((Message)object);
                    continue;
                }
                object = ((QueryKeyBundle)this._queryKeys.get((Object)gUESSEndpoint))._queryKey;
                this.purgeGuidsInternal();
                boolean bl = false;
                Map map = this._queries;
                synchronized (map) {
                    Iterator iterator = this._queries.values().iterator();
                    while (iterator.hasNext()) {
                        QueryBundle queryBundle = (QueryBundle)iterator.next();
                        if (queryBundle._numResults > 250 || queryBundle._hostsQueried.size() > 1000) {
                            this._qGuidsToRemove.add((Object)new GUID(queryBundle._qr.getGUID()));
                            continue;
                        }
                        if (queryBundle._hostsQueried.contains((Object)gUESSEndpoint)) continue;
                        InetAddress inetAddress = gUESSEndpoint.getAddress();
                        QueryRequest queryRequest = QueryRequest.createQueryKeyQuery(queryBundle._qr, (QueryKey)object);
                        uDPService.send(queryRequest, inetAddress, gUESSEndpoint.getPort());
                        bl = true;
                        if (this.RECORD_STATS) {
                            SentMessageStatHandler.UDP_QUERY_REQUESTS.addMessage(queryRequest);
                        }
                        queryBundle._hostsQueried.add((Object)gUESSEndpoint);
                    }
                }
                if (!bl) {
                    this.addUnicastEndpoint(gUESSEndpoint);
                }
                map = this._qGuidsToRemove;
                synchronized (map) {
                    this.purgeGuidsInternal();
                    this._qGuidsToRemove.clear();
                }
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeGuidsInternal() {
        List list = this._qGuidsToRemove;
        synchronized (list) {
            Iterator iterator = this._qGuidsToRemove.iterator();
            while (iterator.hasNext()) {
                GUID gUID = (GUID)iterator.next();
                this._queries.remove((Object)gUID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForQueries() throws InterruptedException {
        QueryUnicaster.debug("QueryUnicaster.waitForQueries(): waiting for Queries.");
        Map map = this._queries;
        synchronized (map) {
            if (this._queries.isEmpty()) {
                this._queries.wait();
            }
        }
        QueryUnicaster.debug("QueryUnicaster.waitForQueries(): numQueries = " + this._queries.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addQuery(QueryRequest queryRequest, ReplyHandler replyHandler) {
        QueryBundle queryBundle;
        QueryUnicaster.debug("QueryUnicaster.addQuery(): entered.");
        boolean bl = false;
        GUID gUID = new GUID(queryRequest.getGUID());
        Map map = this._queries;
        synchronized (map) {
            if (!this._queries.containsKey((Object)gUID)) {
                queryBundle = new QueryBundle(queryRequest);
                this._queries.put((Object)gUID, (Object)queryBundle);
                bl = true;
            }
            if (bl) {
                this._queries.notifyAll();
            }
        }
        if (replyHandler == null) {
            return bl;
        }
        map = this._querySets;
        synchronized (map) {
            queryBundle = (Set)this._querySets.get((Object)replyHandler);
            if (queryBundle == null) {
                queryBundle = new HashSet();
                this._querySets.put((Object)replyHandler, (Object)queryBundle);
            }
            queryBundle.add(gUID);
        }
        QueryUnicaster.debug("QueryUnicaster.addQuery(): returning " + bl);
        return bl;
    }

    public void addUnicastEndpoint(InetAddress inetAddress, int n) {
        if (!SearchSettings.GUESS_ENABLED.getValue()) {
            return;
        }
        if (this.notMe(inetAddress, n) && NetworkUtils.isValidPort(n) && NetworkUtils.isValidAddress(inetAddress)) {
            GUESSEndpoint gUESSEndpoint = new GUESSEndpoint(inetAddress, n);
            this.addUnicastEndpoint(gUESSEndpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUnicastEndpoint(GUESSEndpoint gUESSEndpoint) {
        LinkedList linkedList = this._queryHosts;
        synchronized (linkedList) {
            QueryUnicaster.debug("QueryUnicaster.addUnicastEndpoint(): obtained lock.");
            if (this._queryHosts.size() == 30) {
                this._queryHosts.removeLast();
            }
            this._queryHosts.addFirst((Object)gUESSEndpoint);
            this._queryHosts.notify();
            if (!(!UDPService.instance().isListening() || RouterService.isGUESSCapable() || this._testUDPPingsSent >= 10 || ConnectionSettings.LOCAL_IS_PRIVATE.getValue() && NetworkUtils.isCloseIP(RouterService.getAddress(), gUESSEndpoint.getAddress().getAddress()))) {
                PingRequest pingRequest = new PingRequest(UDPService.instance().getSolicitedGUID().bytes(), 1, 0);
                UDPService.instance().send(pingRequest, gUESSEndpoint.getAddress(), gUESSEndpoint.getPort());
                if (this.RECORD_STATS) {
                    SentMessageStatHandler.UDP_PING_REQUESTS.addMessage(pingRequest);
                }
                ++this._testUDPPingsSent;
            }
            QueryUnicaster.debug("QueryUnicaster.addUnicastEndpoint(): released lock.");
        }
    }

    private boolean notMe(InetAddress inetAddress, int n) {
        boolean bl = true;
        if (n == RouterService.getPort() && Arrays.equals((byte[])inetAddress.getAddress(), (byte[])RouterService.getAddress())) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void purgeQuery(ReplyHandler replyHandler) {
        QueryUnicaster.debug("QueryUnicaster.purgeQuery(RH): entered.");
        if (replyHandler == null) {
            return;
        }
        Map map = this._querySets;
        synchronized (map) {
            Set set = (Set)this._querySets.remove((Object)replyHandler);
            if (set == null) {
                return;
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.purgeQuery((GUID)iterator.next());
            }
        }
        QueryUnicaster.debug("QueryUnicaster.purgeQuery(RH): returning.");
    }

    void purgeQuery(GUID gUID) {
        QueryUnicaster.debug("QueryUnicaster.purgeQuery(GUID): entered.");
        this._qGuidsToRemove.add((Object)gUID);
        QueryUnicaster.debug("QueryUnicaster.purgeQuery(GUID): returning.");
    }

    public void handleQueryReply(QueryReply queryReply) {
        this.addResults(new GUID(queryReply.getGUID()), queryReply.getResultCount());
    }

    public void handleQueryKeyPong(PingReply pingReply) {
        if (pingReply == null) {
            throw new NullPointerException("null pong");
        }
        QueryKey queryKey = pingReply.getQueryKey();
        if (queryKey == null) {
            throw new IllegalArgumentException("no key in pong");
        }
        InetAddress inetAddress = pingReply.getInetAddress();
        Assert.that(queryKey != null);
        int n = pingReply.getPort();
        GUESSEndpoint gUESSEndpoint = new GUESSEndpoint(inetAddress, n);
        this._queryKeys.put((Object)gUESSEndpoint, (Object)new QueryKeyBundle(queryKey));
        this.addUnicastEndpoint(gUESSEndpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResults(GUID gUID, int n) {
        Map map = this._queries;
        synchronized (map) {
            QueryBundle queryBundle = (QueryBundle)this._queries.get((Object)gUID);
            if (queryBundle != null) {
                queryBundle._numResults += n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GUESSEndpoint getUnicastHost() throws InterruptedException {
        Object object;
        QueryUnicaster.debug("QueryUnicaster.getUnicastHost(): waiting for hosts.");
        Object object2 = this._queryHosts;
        synchronized (object2) {
            QueryUnicaster.debug("QueryUnicaster.getUnicastHost(): obtained lock.");
            while (this._queryHosts.isEmpty()) {
                if (System.currentTimeMillis() - this._lastPingTime > 20000L) {
                    object = new PingRequest(ConnectionSettings.TTL.getValue());
                    RouterService.getMessageRouter().broadcastPingRequest((PingRequest)object);
                    this._lastPingTime = System.currentTimeMillis();
                }
                this._queryHosts.wait();
            }
            QueryUnicaster.debug("QueryUnicaster.getUnicastHost(): got a host, let go lock!");
        }
        if (this._queryHosts.size() < 25) {
            object2 = (GUESSEndpoint)this._queryHosts.removeLast();
            object = this._pingList;
            synchronized (object) {
                if (!this._pingList.contains(object2)) {
                    PingRequest pingRequest = new PingRequest(1);
                    InetAddress inetAddress = ((GUESSEndpoint)object2).getAddress();
                    UDPService.instance().send(pingRequest, inetAddress, ((GUESSEndpoint)object2).getPort());
                    this._pingList.add(object2);
                    if (this.RECORD_STATS) {
                        SentMessageStatHandler.UDP_PING_REQUESTS.addMessage(pingRequest);
                    }
                }
            }
            return object2;
        }
        return (GUESSEndpoint)this._queryHosts.removeLast();
    }

    private static final void debug(String string) {
    }

    private static final void debug(Exception exception) {
    }

    private static class QueryBundle {
        public static final int MAX_RESULTS = 250;
        public static final int MAX_QUERIES = 1000;
        final QueryRequest _qr;
        int _numResults = 0;
        final Set _hostsQueried = new HashSet();

        public QueryBundle(QueryRequest queryRequest) {
            this._qr = queryRequest;
        }

        public String toString() {
            return "QueryBundle: " + this._qr;
        }
    }

    private static class QueryKeyBundle {
        public static final long QUERY_KEY_LIFETIME = 0x6DDD00L;
        final long _birthTime;
        final QueryKey _queryKey;

        public QueryKeyBundle(QueryKey queryKey) {
            this._queryKey = queryKey;
            this._birthTime = System.currentTimeMillis();
        }

        public boolean shouldExpire() {
            return System.currentTimeMillis() - this._birthTime >= 0x6DDD00L;
        }

        public String toString() {
            return "{QueryKeyBundle: " + this._queryKey + " BirthTime = " + this._birthTime;
        }
    }

    private class QueryKeyExpirer
    implements Runnable {
        private QueryKeyExpirer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map map = QueryUnicaster.this._queryKeys;
            synchronized (map) {
                Set set = QueryUnicaster.this._queryKeys.entrySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    QueryKeyBundle queryKeyBundle = (QueryKeyBundle)iterator.next();
                    if (!queryKeyBundle.shouldExpire()) continue;
                    set.remove((Object)queryKeyBundle);
                }
            }
        }
    }
}

