/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.PongCacher;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.Statistics;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessage;
import com.limegroup.gnutella.settings.ChatSettings;
import com.limegroup.gnutella.statistics.RoutedQueryStat;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.xml.LimeXMLDocumentHelper;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class StandardMessageRouter
extends MessageRouter {
    private final boolean RECORD_STATS = !CommonUtils.isJava118();

    protected void respondToPingRequest(PingRequest pingRequest, ReplyHandler replyHandler) {
        Object object;
        byte by;
        byte by2 = pingRequest.getHops();
        if (by2 + (by = pingRequest.getTTL()) > 2 && !MessageRouter._manager.allowAnyConnection()) {
            return;
        }
        if (NetworkUtils.isValidAddress(RouterService.getAddress()) && NetworkUtils.isValidPort(RouterService.getPort())) {
            if (by2 == 1 && by == 1) {
                this.handleCrawlerPing(pingRequest, replyHandler);
                return;
            }
            if (pingRequest.isHeartbeat()) {
                this.sendPingReply(PingReply.create(pingRequest.getGUID(), (byte)1), replyHandler);
                return;
            }
            int n = by2 + 1;
            if (by2 + by <= 2) {
                n = 1;
            }
            if (RouterService.getConnectionManager().hasFreeSlots() || Statistics.instance().calculateDailyUptime() > 1800) {
                object = PingReply.create(pingRequest.getGUID(), (byte)n);
                this.sendPingReply((PingReply)object, replyHandler);
            }
        }
        List list = PongCacher.instance().getBestPongs(pingRequest.getLocale());
        object = list.iterator();
        byte[] byArray = pingRequest.getGUID();
        InetAddress inetAddress = replyHandler.getInetAddress();
        while (object.hasNext()) {
            PingReply pingReply = (PingReply)object.next();
            if (pingReply.getInetAddress().equals(inetAddress)) continue;
            this.sendPingReply(pingReply.mutateGUID(byArray), replyHandler);
        }
    }

    protected void respondToUDPPingRequest(PingRequest pingRequest, DatagramPacket datagramPacket, ReplyHandler replyHandler) {
        byte[] byArray = RouterService.getAddress();
        int n = RouterService.getPort();
        if (NetworkUtils.isValidAddress(byArray) && NetworkUtils.isValidPort(n)) {
            this.sendPingReply(PingReply.create(pingRequest.getGUID(), (byte)1), replyHandler);
        }
    }

    private void handleCrawlerPing(PingRequest pingRequest, ReplyHandler replyHandler) {
        List list = MessageRouter._manager.getInitializedClientConnections();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            PingReply pingReply = PingReply.createExternal(pingRequest.getGUID(), (byte)2, managedConnection.getPort(), managedConnection.getInetAddress().getAddress(), false);
            pingReply.hop();
            this.sendPingReply(pingReply, replyHandler);
        }
    }

    protected void handlePingReply(PingReply pingReply, ReplyHandler replyHandler) {
        if (replyHandler instanceof ManagedConnection) {
            ManagedConnection managedConnection = (ManagedConnection)replyHandler;
            managedConnection.updateHorizonStats(pingReply);
        }
        super.handlePingReply(pingReply, replyHandler);
    }

    protected boolean respondToQueryRequest(QueryRequest queryRequest, byte[] byArray, ReplyHandler replyHandler) {
        if (queryRequest.getCapabilitySelector() > 0 && queryRequest.getCapabilitySelector() > 1) {
            return false;
        }
        if (RouterService.getUploadManager().isBusy()) {
            return false;
        }
        if (!NetworkUtils.isValidPort(RouterService.getPort()) || !NetworkUtils.isValidAddress(RouterService.getAddress())) {
            return false;
        }
        Response[] responseArray = RouterService.getFileManager().query(queryRequest);
        if (RouterService.isShieldedLeaf() && queryRequest.isTCP() && this.RECORD_STATS) {
            if (responseArray != null && responseArray.length > 0) {
                RoutedQueryStat.LEAF_HIT.incrementStat();
            } else {
                RoutedQueryStat.LEAF_FALSE_POSITIVE.incrementStat();
            }
        }
        return this.sendResponses(responseArray, queryRequest, replyHandler);
    }

    public boolean sendResponses(Response[] responseArray, QueryRequest queryRequest, ReplyHandler replyHandler) {
        if (responseArray == null || responseArray.length < 1) {
            return false;
        }
        if (queryRequest.desiresOutOfBandReplies() && !this.isConnectedTo(queryRequest, replyHandler) && RouterService.isGUESSCapable() && RouterService.acceptedIncomingConnection() && !RouterService.getUploadManager().isBusy()) {
            if (this.bufferResponsesForLaterDelivery(queryRequest, responseArray)) {
                InetAddress inetAddress = null;
                try {
                    inetAddress = InetAddress.getByName(queryRequest.getReplyAddress());
                }
                catch (UnknownHostException unknownHostException) {
                    return false;
                }
                int n = queryRequest.getReplyPort();
                int n2 = responseArray.length > 255 ? 255 : responseArray.length;
                ReplyNumberVendorMessage replyNumberVendorMessage = new ReplyNumberVendorMessage(new GUID(queryRequest.getGUID()), n2);
                UDPService.instance().send(replyNumberVendorMessage, inetAddress, n);
                return true;
            }
            return false;
        }
        Iterator iterator = this.responsesToQueryReplies(responseArray, queryRequest);
        try {
            while (iterator.hasNext()) {
                QueryReply queryReply = (QueryReply)iterator.next();
                this.sendQueryReply(queryReply);
            }
        }
        catch (IOException iOException) {}
        return true;
    }

    private final boolean isConnectedTo(QueryRequest queryRequest, ReplyHandler replyHandler) {
        return queryRequest.matchesReplyAddress(replyHandler.getInetAddress().getAddress());
    }

    protected List createQueryReply(byte[] byArray, byte by, long l, Response[] responseArray, byte[] byArray2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Set set;
        ArrayList arrayList = new ArrayList();
        QueryReply queryReply = null;
        int n = bl4 ? RouterService.getNonForcedPort() : RouterService.getPort();
        byte[] byArray3 = bl4 ? RouterService.getNonForcedAddress() : RouterService.getAddress();
        String string = LimeXMLDocumentHelper.getAggregateString(responseArray);
        if (string == null) {
            string = "";
        }
        byte[] byArray4 = null;
        try {
            byArray4 = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ErrorService.error(unsupportedEncodingException, "encountered UnsupportedEncodingException in creation of QueryReply : xmlCollectionString : " + string);
        }
        boolean bl5 = !RouterService.acceptedIncomingConnection();
        Set set2 = set = bl5 ? MessageRouter._manager.getPushProxies() : null;
        if (byArray4.length > 32768) {
            LinkedList linkedList = new LinkedList();
            this.splitAndAddResponses((List)linkedList, responseArray);
            while (!linkedList.isEmpty()) {
                Response[] responseArray2 = (Response[])linkedList.remove(0);
                String string2 = LimeXMLDocumentHelper.getAggregateString(responseArray2);
                byte[] byArray5 = null;
                try {
                    byArray5 = string2.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    ErrorService.error(unsupportedEncodingException, "encountered UnsupportedEncodingException : currXML " + string2);
                    byArray5 = "".getBytes();
                }
                if (byArray5.length > 32768 && responseArray2.length > 1) {
                    this.splitAndAddResponses((List)linkedList, responseArray2);
                    continue;
                }
                byte[] byArray6 = null;
                byArray6 = string2 != null && !string2.equals("") ? LimeXMLUtils.compress(byArray5) : DataUtils.EMPTY_BYTE_ARRAY;
                queryReply = new QueryReply(byArray, by, n, byArray3, l, responseArray2, this._clientGUID, byArray6, bl5, bl, bl2, bl3, ChatSettings.CHAT_ENABLED.getValue(), bl4, set);
                arrayList.add((Object)queryReply);
            }
        } else {
            byte[] byArray7 = null;
            byArray7 = string != null && !string.equals("") ? LimeXMLUtils.compress(byArray4) : DataUtils.EMPTY_BYTE_ARRAY;
            queryReply = new QueryReply(byArray, by, n, byArray3, l, responseArray, this._clientGUID, byArray7, bl5, bl, bl2, bl3, ChatSettings.CHAT_ENABLED.getValue(), bl4, set);
            arrayList.add((Object)queryReply);
        }
        return arrayList;
    }

    private Response[][] splitResponses(Response[] responseArray) {
        int n = responseArray.length / 2;
        Response[][] responseArray2 = new Response[][]{new Response[n], new Response[responseArray.length - n]};
        int n2 = 0;
        while (n2 < n) {
            responseArray2[0][n2] = responseArray[n2];
            ++n2;
        }
        n2 = 0;
        while (n2 < responseArray.length - n) {
            responseArray2[1][n2] = responseArray[n2 + n];
            ++n2;
        }
        return responseArray2;
    }

    private void splitAndAddResponses(List list, Response[] responseArray) {
        Response[][] responseArray2 = this.splitResponses(responseArray);
        list.add((Object)responseArray2[0]);
        list.add((Object)responseArray2[1]);
    }
}

