/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.settings.ApplicationSettings;

public class Statistics {
    private static Statistics _instance = new Statistics();
    private static final int SECONDS_PER_DAY = 86400;
    private static final int WINDOW_MILLISECONDS = 604800000;
    private long startTime = this.now();

    protected Statistics() {
    }

    public static Statistics instance() {
        return _instance;
    }

    public long getUptime() {
        return this.now() - this.startTime;
    }

    public int calculateDailyUptime() {
        return (int)(this.calculateFractionalUptime() * 86400.0f);
    }

    public float calculateFractionalUptime() {
        float f = Math.min(6.048E8f, (float)(this.now() - ApplicationSettings.LAST_SHUTDOWN_TIME.getValue()));
        float f2 = Math.min(6.048E8f, (float)this.getUptime());
        float f3 = ApplicationSettings.FRACTIONAL_UPTIME.getValue();
        if (f2 < 0.0f || f < 0.0f || f2 > f) {
            return f3;
        }
        return f2 / 6.048E8f + (6.048E8f - f) / 6.048E8f * f3;
    }

    public void shutdown() {
        ApplicationSettings.FRACTIONAL_UPTIME.setValue(this.calculateFractionalUptime());
        ApplicationSettings.LAST_SHUTDOWN_TIME.setValue(this.now());
        int n = ApplicationSettings.SESSIONS.getValue();
        ApplicationSettings.SESSIONS.setValue(n + 1);
    }

    protected long now() {
        return System.currentTimeMillis();
    }
}

