/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.filters.IP;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.sun.java.util.collections.Comparable;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

public final class AlternateLocation
implements HTTPHeaderValue,
Comparable {
    public static final String ALT_VENDOR = "ALT";
    private final URL URL;
    private final URN SHA1_URN;
    private final String DISPLAY_STRING;
    private volatile int hashCode = 0;
    private volatile int _count = 0;
    private volatile boolean _demoted = false;

    public static AlternateLocation create(String string) throws IOException {
        if (string == null || string.equals("")) {
            throw new IOException("null or empty location");
        }
        URL uRL = AlternateLocation.createUrl(string);
        URN uRN = URN.createSHA1UrnFromURL(uRL);
        return new AlternateLocation(uRL, uRN);
    }

    public static AlternateLocation create(String string, URN uRN) throws IOException {
        if (string == null || string.equals("")) {
            throw new IOException("null or empty location");
        }
        if (uRN == null) {
            throw new IOException("null URN.");
        }
        if (string.toLowerCase().startsWith("http")) {
            AlternateLocation alternateLocation = AlternateLocation.create(string);
            if (!alternateLocation.SHA1_URN.equals(uRN)) {
                throw new IOException("mismatched URN");
            }
            return alternateLocation;
        }
        URL uRL = AlternateLocation.createUrlFromMini(string, uRN);
        return new AlternateLocation(uRL, uRN);
    }

    public static AlternateLocation create(URL uRL) throws MalformedURLException, IOException {
        if (uRL == null) {
            throw new NullPointerException("cannot accept null URL");
        }
        URL uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getFile());
        URN uRN = URN.createSHA1UrnFromURL(uRL2);
        return new AlternateLocation(uRL2, uRN);
    }

    public static AlternateLocation create(RemoteFileDesc remoteFileDesc) throws IOException {
        if (remoteFileDesc == null) {
            throw new NullPointerException("cannot accept null RFD");
        }
        URN uRN = remoteFileDesc.getSHA1Urn();
        if (uRN == null) {
            throw new NullPointerException("cannot accept null URN");
        }
        int n = remoteFileDesc.getPort();
        URL uRL = new URL("http", remoteFileDesc.getHost(), n, "/uri-res/N2R?" + uRN.httpStringValue());
        return new AlternateLocation(uRL, uRN);
    }

    public static AlternateLocation create(URN uRN) {
        if (uRN == null) {
            throw new NullPointerException("null sha1");
        }
        URL uRL = null;
        try {
            int n = RouterService.getPort();
            String string = NetworkUtils.ip2string(RouterService.getAddress());
            uRL = new URL("http", string, n, "/uri-res/N2R?" + uRN.httpStringValue());
        }
        catch (MalformedURLException malformedURLException) {
            ErrorService.error(malformedURLException);
        }
        try {
            return new AlternateLocation(uRL, uRN);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage());
        }
    }

    private AlternateLocation(URL uRL, URN uRN) throws IOException {
        if (!NetworkUtils.isValidPort(uRL.getPort())) {
            throw new IOException("invalid port: " + uRL.getPort());
        }
        if (!NetworkUtils.isValidAddress(uRL.getHost())) {
            throw new IOException("invalid address: " + uRL.getHost());
        }
        if (NetworkUtils.isPrivateAddress(uRL.getHost())) {
            throw new IOException("invalid address: " + uRL.getHost());
        }
        if (uRN == null) {
            throw new IOException("null sha1");
        }
        this.URL = uRL;
        this.SHA1_URN = uRN;
        InetAddress inetAddress = InetAddress.getByName(this.URL.getHost());
        String string = NetworkUtils.ip2string(inetAddress.getAddress());
        this.DISPLAY_STRING = this.URL.getPort() == 6346 ? string : String.valueOf(string) + ":" + this.URL.getPort();
        this._count = 1;
        this._demoted = false;
    }

    public URL getUrl() {
        try {
            return new URL(this.URL.getProtocol(), this.URL.getHost(), this.URL.getPort(), this.URL.getFile());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public Endpoint getHost() {
        return new Endpoint(this.URL.getHost(), this.URL.getPort());
    }

    public URN getSHA1Urn() {
        return this.SHA1_URN;
    }

    public synchronized int getCount() {
        return this._count;
    }

    public synchronized boolean getDemoted() {
        return this._demoted;
    }

    public String httpStringValue() {
        return this.DISPLAY_STRING;
    }

    public RemoteFileDesc createRemoteFileDesc(int n) {
        HashSet hashSet = new HashSet();
        hashSet.add((Object)this.getSHA1Urn());
        int n2 = 3;
        return new RemoteFileDesc(this.URL.getHost(), this.URL.getPort(), 0L, this.URL.getFile(), n, DataUtils.EMPTY_GUID, 1000, true, n2, false, null, (Set)hashSet, false, false, ALT_VENDOR, System.currentTimeMillis(), null);
    }

    public synchronized void increment() {
        ++this._count;
    }

    synchronized void demote() {
        this._demoted = true;
    }

    synchronized void promote() {
        this._demoted = false;
    }

    public synchronized AlternateLocation createClone() {
        AlternateLocation alternateLocation = null;
        try {
            alternateLocation = new AlternateLocation(this.URL, this.SHA1_URN);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
            return null;
        }
        alternateLocation._demoted = this._demoted;
        alternateLocation._count = this._count;
        return alternateLocation;
    }

    private static URL createUrl(String string) throws IOException {
        String string2 = string.toLowerCase();
        if (!string2.startsWith("http")) {
            throw new IOException("invalid location: " + string);
        }
        if (string2.lastIndexOf("http://") > 4) {
            throw new IOException("invalid location: " + string);
        }
        String string3 = AlternateLocation.removeTimestamp(string2);
        URL uRL = new URL(string3);
        String string4 = uRL.getHost();
        if (string4 == null || string4.equals("")) {
            throw new IOException("invalid location: " + string);
        }
        if (uRL.getPort() == -1) {
            uRL = new URL("http", uRL.getHost(), 80, uRL.getFile());
        }
        return uRL;
    }

    private static URL createUrlFromMini(String string, URN uRN) throws IOException {
        int n = string.indexOf(58);
        String string2 = n == -1 ? string : string.substring(0, n);
        try {
            new IP(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("invalid location: " + string);
        }
        if (string2.indexOf(47) != -1) {
            throw new IOException("invalid location: " + string);
        }
        if (n == -1) {
            n = 6346;
        } else {
            if (string.length() < n + 1) {
                throw new IOException("invalid location: " + string);
            }
            try {
                n = Short.parseShort(string.substring(n + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("invalid location: " + string);
            }
        }
        return new URL("http", string2, n, "/uri-res/N2R?" + uRN.httpStringValue());
    }

    private static String removeTimestamp(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        if (n == 1) {
            return string;
        }
        String string2 = null;
        int n2 = 0;
        while (n2 < n) {
            string2 = stringTokenizer.nextToken();
            ++n2;
        }
        n2 = string.indexOf(string2);
        if (n2 == -1) {
            return null;
        }
        return string.substring(0, n2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AlternateLocation)) {
            return false;
        }
        AlternateLocation alternateLocation = (AlternateLocation)object;
        return this.URL.getHost().equals(alternateLocation.URL.getHost()) && this.URL.getPort() == alternateLocation.URL.getPort() && this.SHA1_URN.equals(alternateLocation.SHA1_URN) && this.URL.getProtocol().equals(alternateLocation.URL.getProtocol());
    }

    public int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        if (object == null) {
            return 1;
        }
        if (!(object instanceof AlternateLocation)) {
            return 1;
        }
        AlternateLocation alternateLocation = (AlternateLocation)object;
        if (this._demoted != alternateLocation._demoted) {
            if (this._demoted) {
                return 1;
            }
            return -1;
        }
        int n = this._count - alternateLocation._count;
        if (n != 0) {
            return n;
        }
        n = this.URL.getHost().compareTo(alternateLocation.URL.getHost());
        if (n != 0) {
            return n;
        }
        n = this.URL.getPort() - alternateLocation.URL.getPort();
        if (n != 0) {
            return n;
        }
        n = this.SHA1_URN.httpStringValue().compareTo(alternateLocation.SHA1_URN.httpStringValue());
        if (n != 0) {
            return n;
        }
        return this.URL.getProtocol().hashCode() - alternateLocation.URL.getProtocol().hashCode();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int n = 17;
            n = 37 * n + this.URL.getHost().hashCode();
            n = 37 * n + this.URL.getPort();
            n = 37 * n + this.SHA1_URN.hashCode();
            this.hashCode = n = 37 * n + this.URL.getProtocol().hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return String.valueOf(this.URL.toExternalForm()) + "," + this._count + "," + this._demoted;
    }
}

