/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationCollector;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.util.FixedSizeSortedSet;
import com.sun.java.util.collections.Iterator;
import java.io.IOException;
import java.util.StringTokenizer;

public final class AlternateLocationCollection
implements HTTPHeaderValue,
AlternateLocationCollector {
    private static final int MAX_SIZE = 100;
    private final FixedSizeSortedSet LOCATIONS = new FixedSizeSortedSet(100);
    private final URN SHA1;
    static /* synthetic */ Class class$0;

    public static AlternateLocationCollection create(URN uRN) {
        return new AlternateLocationCollection(uRN);
    }

    public static AlternateLocationCollection createCollectionFromHttpValue(String string) {
        if (string == null) {
            throw new NullPointerException("cannot create an AlternateLocationCollection from a null value");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        AlternateLocationCollection alternateLocationCollection = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                AlternateLocation alternateLocation = AlternateLocation.create(string2);
                if (alternateLocationCollection == null) {
                    alternateLocationCollection = new AlternateLocationCollection(alternateLocation.getSHA1Urn());
                }
                if (!alternateLocation.getSHA1Urn().equals(alternateLocationCollection.getSHA1Urn())) continue;
                alternateLocationCollection.add(alternateLocation);
            }
            catch (IOException iOException) {}
        }
        return alternateLocationCollection;
    }

    private AlternateLocationCollection(URN uRN) {
        if (uRN == null) {
            throw new NullPointerException("null URN");
        }
        if (uRN != null && !uRN.isSHA1()) {
            throw new IllegalArgumentException("URN must be a SHA1");
        }
        this.SHA1 = uRN;
    }

    public URN getSHA1Urn() {
        return this.SHA1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(AlternateLocation alternateLocation) {
        URN uRN = alternateLocation.getSHA1Urn();
        if (!uRN.equals(this.SHA1)) {
            throw new IllegalArgumentException("SHA1 does not match");
        }
        AlternateLocationCollection alternateLocationCollection = this;
        synchronized (alternateLocationCollection) {
            AlternateLocation alternateLocation2 = (AlternateLocation)this.LOCATIONS.get(alternateLocation);
            boolean bl = false;
            if (alternateLocation2 == null) {
                bl = true;
                this.LOCATIONS.add(alternateLocation);
            } else {
                this.LOCATIONS.remove(alternateLocation2);
                alternateLocation2.increment();
                alternateLocation2.promote();
                bl = false;
                this.LOCATIONS.add(alternateLocation2);
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(AlternateLocation alternateLocation) {
        URN uRN = alternateLocation.getSHA1Urn();
        if (!uRN.equals(this.SHA1)) {
            return false;
        }
        AlternateLocationCollection alternateLocationCollection = this;
        synchronized (alternateLocationCollection) {
            AlternateLocation alternateLocation2;
            block7: {
                block6: {
                    alternateLocation2 = (AlternateLocation)this.LOCATIONS.get(alternateLocation);
                    if (alternateLocation2 != null) break block6;
                    return false;
                }
                if (!alternateLocation2.getDemoted()) break block7;
                this.LOCATIONS.remove(alternateLocation2);
                return true;
            }
            this.LOCATIONS.remove(alternateLocation2);
            alternateLocation2.demote();
            this.LOCATIONS.add(alternateLocation2);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public int addAll(AlternateLocationCollection var1_1) {
        if (var1_1 == null) {
            throw new NullPointerException("ALC is null");
        }
        if (!var1_1.getSHA1Urn().equals(this.SHA1)) {
            throw new IllegalArgumentException("SHA1 does not match");
        }
        var2_2 = 0;
        var3_3 = null;
        var4_4 /* !! */  = var1_1;
        synchronized (var4_4 /* !! */ ) {
            var3_3 = ((FixedSizeSortedSet)var1_1.LOCATIONS.clone()).iterator();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl11 : MonitorExitStatement: MONITOREXIT : var4_4 /* !! */ 
            if (true) ** GOTO lbl18
        }
        do {
            if (!this.add((AlternateLocation)(var4_4 /* !! */  = (AlternateLocation)var3_3.next()))) continue;
            ++var2_2;
lbl18:
            // 3 sources

        } while (var3_3.hasNext());
        return var2_2;
    }

    public synchronized void clear() {
        this.LOCATIONS.clear();
    }

    public synchronized boolean hasAlternateLocations() {
        return !this.LOCATIONS.isEmpty();
    }

    public synchronized boolean contains(AlternateLocation alternateLocation) {
        return this.LOCATIONS.contains(alternateLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String httpStringValue() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        AlternateLocationCollection alternateLocationCollection = this;
        synchronized (alternateLocationCollection) {
            Iterator iterator = this.LOCATIONS.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(((HTTPHeaderValue)iterator.next()).httpStringValue());
                stringBuffer.append(", ");
                bl = true;
            }
        }
        if (bl) {
            stringBuffer.setLength(stringBuffer.length() - 2);
        }
        return stringBuffer.toString();
    }

    public synchronized int getAltLocsSize() {
        return this.LOCATIONS.size();
    }

    public Iterator iterator() {
        return this.LOCATIONS.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Alternate Locations: ");
        AlternateLocationCollection alternateLocationCollection = this;
        synchronized (alternateLocationCollection) {
            Iterator iterator = this.LOCATIONS.iterator();
            while (iterator.hasNext()) {
                AlternateLocation alternateLocation = (AlternateLocation)iterator.next();
                stringBuffer.append(alternateLocation.toString());
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AlternateLocationCollection)) {
            return false;
        }
        AlternateLocationCollection alternateLocationCollection = (AlternateLocationCollection)object;
        boolean bl = this.SHA1.equals(alternateLocationCollection.SHA1);
        if (!bl) {
            return false;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.altlocs.AlternateLocationCollection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            AlternateLocationCollection alternateLocationCollection2 = this;
            synchronized (alternateLocationCollection2) {
                AlternateLocationCollection alternateLocationCollection3 = alternateLocationCollection;
                synchronized (alternateLocationCollection3) {
                    bl = this.LOCATIONS.equals(alternateLocationCollection.LOCATIONS);
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return bl;
        }
    }
}

