/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.filters.GUIDPair;
import com.limegroup.gnutella.filters.QueryPair;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.util.Buffer;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Set;

public class DuplicateFilter
extends SpamFilter {
    private static final int BUF_SIZE = 20;
    private Buffer guids = new Buffer(20);
    private static final int GUID_LAG = 500;
    private static final int TOLERANCE = 2;
    private static final int QUERY_LAG = 1500;
    private long querySwapTime = 0L;
    private long queryClearTime = 1500L;
    private Set youngQueries = new HashSet();
    private Set oldQueries = new HashSet();

    private static long getTime() {
        return System.currentTimeMillis();
    }

    public boolean allow(Message message) {
        if (!this.allowGUID(message)) {
            return false;
        }
        if (message instanceof QueryRequest) {
            return this.allowQuery((QueryRequest)message);
        }
        return true;
    }

    public boolean allowGUID(Message message) {
        if (!(message instanceof QueryRequest) && !(message instanceof PingRequest)) {
            return true;
        }
        GUIDPair gUIDPair = new GUIDPair(message.getGUID(), DuplicateFilter.getTime(), message.getHops());
        int n = this.guids.getSize();
        int n2 = 0;
        while (n2 < n) {
            GUIDPair gUIDPair2 = (GUIDPair)this.guids.get(n2);
            if (gUIDPair.time - gUIDPair2.time > 500L) break;
            if (gUIDPair2.hops == gUIDPair.hops) {
                int n3 = 0;
                int n4 = 0;
                while (n4 < gUIDPair.guid.length && n3 <= 2) {
                    if (gUIDPair.guid[n4] != gUIDPair2.guid[n4]) {
                        ++n3;
                    }
                    ++n4;
                }
                if (n3 <= 2) {
                    this.guids.add(gUIDPair);
                    return false;
                }
            }
            ++n2;
        }
        this.guids.add(gUIDPair);
        return true;
    }

    public boolean allowQuery(QueryRequest queryRequest) {
        Object object;
        long l = DuplicateFilter.getTime();
        if (l > this.querySwapTime) {
            if (l <= this.queryClearTime) {
                object = this.oldQueries;
                this.oldQueries = this.youngQueries;
                this.youngQueries = object;
                this.youngQueries.clear();
            } else {
                this.youngQueries.clear();
                this.oldQueries.clear();
            }
            this.querySwapTime = l + 1500L;
            this.queryClearTime = this.querySwapTime + 1500L;
        }
        if (this.oldQueries.contains(object = new QueryPair(queryRequest.getQuery(), queryRequest.getHops(), queryRequest.getRichQuery(), queryRequest.getQueryUrns()))) {
            return false;
        }
        boolean bl = this.youngQueries.add(object);
        return bl;
    }
}

